--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.hudPosX = 0.63;    
    self.hudPosY = 0.3;
	self.hudWidth = 0.4;
    self.hudHeight = 0.55;
	
	self.hudPomocy = Utils.getFilename("Tekstury/hud.dds", self.baseDirectory);
	self.hudPomocyOverlay = Overlay:new("allrad_symb_yes", self.hudPomocy, self.hudPosX, self.hudPosY, self.hudWidth, self.hudHeight);

	self.showHelp = false;
end;

function ShowHelp:delete()
	if self.hudPomocyOverlay ~= nil then
		self.hudPomocyOverlay:delete();	
	end;
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self.isEntered then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;

function ShowHelp:updateTick(dt)
end;

function ShowHelp:draw()
	if not self.showHelp then
		renderText(0.72, 0.20, 0.02, "Wcisnij Numpad 0: Info");
	else
		self.hudPomocyOverlay:render();
		--[[ Koordinaten sind aus der F930.lua - Author leider unbekannt
		renderText(0.72, 0.86, 0.022, "-> -U-R-S-U-S- 1224 by LECHU & SPINAH <-");			
		renderText(0.72, 0.81, 0.02, "Wcisnij Numpad 4: Lewa szyba");
		renderText(0.72, 0.79, 0.02, "Wcisnij Numpad 6: Prawa szyba");			
		renderText(0.72, 0.75, 0.02, "Wcisnij Numpad 8: Szyba tyl");
		renderText(0.72, 0.77, 0.02, "Wcisnij Numpad 7: Drzwi lewe");
		renderText(0.72, 0.73, 0.02, "Wcisnij Numpad 9: Drzwi prawe");
		renderText(0.72, 0.71, 0.02, "Wcisnij Numpad 5: Dach");
		renderText(0.72, 0.69, 0.02, "Wcisnij F: Swiatla");
		renderText(0.72, 0.67, 0.02, "Wcisnij 5: Halogeny przod");
		renderText(0.72, 0.65, 0.02, "Wcisnij 6: Halogeny tyl");
		renderText(0.72, 0.63, 0.02, "Wcisnij Numpad 1: Lewy kierunkowsakz");
		renderText(0.72, 0.61, 0.02, "Wcisnij Numpad 2: Swiatla awaryjne");
		renderText(0.72, 0.59, 0.02, "Wcisnij Numpad 3: Prawy kierunkowskaz");
		renderText(0.72, 0.57, 0.02, "Wcisnij Num ENTER: Odpalanie silnika");
		renderText(0.72, 0.55, 0.02, "Wcisnij 0: Chlodzenie wiatrak");
	    renderText(0.72, 0.53, 0.02, "Wcisnij T: Przedni naped");
	    renderText(0.72, 0.51, 0.02, "Wcisnij Z: Blizniaki");
	    renderText(0.72, 0.49, 0.02, "Wcisnij N-M: Obciaznik");]]
	end;
end;

function ShowHelp:onLeave()
	self.showHelp = false;
end;