
ShiftableMass = {};

function ShiftableMass.prerequisitesPresent(specializations)
    return true;
end;

function ShiftableMass:load(xmlFile)
	self.massNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.shiftableMass#massNode"));
	self.massPerDisc = getXMLFloat(xmlFile, "vehicle.shiftableMass#massPerDisc");
	self.setActiveDisks = SpecializationUtil.callSpecializationsFunction("setActiveDisks");
	self.shiftableMasses = {}
	self.numActiveDiscs = 0;
	self.massBackup = getXMLFloat(xmlFile, "vehicle.shiftableMass#defaultMass");
	
	local num = 0;
	while true do
		num = num + 1;
		local path = "vehicle.shiftableMass.disc"..tostring(num).."#index";
		local index = getXMLString(xmlFile, path);
		if index == nil then
			break;
		else
			local discId = Utils.indexToObject(self.components, index);
			setVisibility(discId, false);
			table.insert(self.shiftableMasses, discId);
		end;	
	end;
	self.maxNumDiscs = num;
end;

function ShiftableMass:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local numDiscs = getXMLInt(xmlFile, key.."#numDiscs");
	self:setActiveDisks(numDiscs);
end;

function ShiftableMass:getSaveAttributesAndNodes(nodeIdent)
	local savestr = tostring(self.numActiveDiscs);
	local attributes = 'numDiscs="'..savestr..'"';
	return attributes, nil;
end;

function ShiftableMass:delete()
  
end;

function ShiftableMass:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShiftableMass:keyEvent(unicode, sym, modifier, isDown)
end;

function ShiftableMass:update(dt)
	if self.isEntered then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRAn) then
			self:setActiveDisks(self.numActiveDiscs + 1);
		end;
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRAm) then
			self:setActiveDisks(self.numActiveDiscs - 1);
		end;
	end;
end;

function ShiftableMass:draw()
	if self.maxNumDiscs > self.numActiveDiscs then
		g_currentMission:addHelpButtonText(g_i18n:getText("addDisc"), InputBinding.IMPLEMENT_EXTRAn);
	end;
	if self.numActiveDiscs > 0 then
		g_currentMission:addHelpButtonText(g_i18n:getText("takeAwayDisc"), InputBinding.IMPLEMENT_EXTRAm);
	end;
end;

function ShiftableMass:setActiveDisks(numDiscs, noEventSend)
	if self.shiftableMasses[numDiscs] ~= nil or numDiscs == 0 then
		self.numActiveDiscs = numDiscs;
		local mass = (numDiscs*self.massPerDisc) + self.massBackup;
		if mass > 0 then
			setMass(self.massNode, mass);
		end;
		for a=1, table.getn(self.shiftableMasses) do
			if a < numDiscs or a == numDiscs then
				local object = self.shiftableMasses[a];
				local visibility = getVisibility(object);
				if visibility ~= true then
					setVisibility(object, true);
				end;
			else
				local object = self.shiftableMasses[a];
				local visibility = getVisibility(object);
				if visibility ~= false then
					setVisibility(object, false);
				end;
			end;
		end;
		if not noEventSend then
			ShiftableMassEvent.sendEvent(self, self.numActiveDiscs, noEventSend);
		end;
	end;
end;

function ShiftableMass:readStream(streamId, connection)   
	local numDiscs = streamReadInt8(streamId);
	self:setActiveDisks(numDiscs);
end;

function ShiftableMass:writeStream(streamId, connection) 
	streamWriteInt8(streamId, self.numActiveDiscs);
end;