wheelextra = {};

function wheelextra.prerequisitesPresent(specializations)
    return true;
end;

function wheelextra:load(xmlFile)
	self.ugniatanie = false;

	local numWheelAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.wheelAreas#count"), 0);
    self.wheelAreas = {}
    for i=1, numWheelAreas do
        self.wheelAreas[i] = {};
        local areanamei = string.format("vehicle.wheelAreas.wheelArea%d", i);
        self.wheelAreas[i].point = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#pointIndex"));
        self.wheelAreas[i].width = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#width"), 0.5)
        self.wheelAreas[i].height = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#height"), 0.25)
    end;
end;

function wheelextra:delete()
end;

function wheelextra:mouseEvent(posX, posY, isDown, isUp, button)
end;

function wheelextra:keyEvent(unicode, sym, modifier, isDown)
end;

function wheelextra:update(dt)
			if self.attacherVehicle and self:getIsActiveForInput() then
				if InputBinding.hasEvent(InputBinding.ugn)then
					self.ugniatanie = not self.ugniatanie;
				end;
				if self.ugniatanie then
					g_currentMission:addHelpButtonText(g_i18n:getText("sciezkiON"), InputBinding.ugn);
				else
					g_currentMission:addHelpButtonText(g_i18n:getText("sciezkiOFF"), InputBinding.ugn);
				end;
			end;
			if self.ugniatanie and self.isTurnedOn then
				for k, wheelArea in pairs(self.wheelAreas) do
					local x,y,z = getWorldTranslation(wheelArea.point);
					local w = wheelArea.width;
					local h = wheelArea.height;
					local x1 = x + h/2
					local x2 = x - h/2
					local z1 = z + w/2
					local z2 = z - w/2
								
					Utils.updateCultivatorArea(x1, z2, x1, z1, x2, z2, not limitToField);
					--[[Utils.updateCultivatorArea( 2, x1, z2, x1, z1, x2, z2, not limitToField);
					Utils.updateCultivatorArea( 3, x1, z2, x1, z1, x2, z2, not limitToField);
					Utils.updateCultivatorArea( 4, x1, z2, x1, z1, x2, z2, not limitToField);
					Utils.updateCultivatorArea( 8, x1, z2, x1, z1, x2, z2, not limitToField);
					Utils.updateCultivatorArea( 9, x1, z2, x1, z1, x2, z2, not limitToField);]]
				end;
			end;
end;

function wheelextra:draw()
end;

