     putrefactionEvent = {};
     putrefactionEvent_mt = Class(putrefactionEvent, Event);
     
    InitEventClass(putrefactionEvent, "putrefactionEvent");
     
     function putrefactionEvent:emptyNew()
         local self = Event:new(putrefactionEvent_mt);
         self.className="putrefactionEvent";
         return self;
    end;
    
    function putrefactionEvent:new(cuttingAreas, limitToField)
        local self = putrefactionEvent:emptyNew()
        assert(table.getn(cuttingAreas) > 0);
        self.cuttingAreas = cuttingAreas;
        self.limitToField = limitToField;
        return self;
    end;
    
    function putrefactionEvent:readStream(streamId, connection)
        local limitToField = streamReadBool(streamId);
        local numAreas = streamReadUIntN(streamId, 8);
        
        local refX = streamReadFloat32(streamId);
        local refY = streamReadFloat32(streamId);
        local values = Utils.readCompressed2DVectors(streamId, refX, refY, numAreas*3-1, 0.01, true);
        for i=1,numAreas do
            local vi = i-1;
           local x = values[vi*3+1].x;
            local z = values[vi*3+1].y;
            local x1 = values[vi*3+2].x;
            local z1 = values[vi*3+2].y;
            local x2 = values[vi*3+3].x;
            local z2 = values[vi*3+3].y;
   	local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(id, x, z, x1, z1, x2, z2);
   	setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_WHEAT].id, x, z, widthX, widthZ, heightX, heightZ, 0, 7, g_currentMission.fruits[FruitUtil.FRUITTYPE_WHEAT].id, 0, 7, 6.0);
   	setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_BARLEY].id, x, z, widthX, widthZ, heightX, heightZ, 0, 7, g_currentMission.fruits[FruitUtil.FRUITTYPE_BARLEY].id, 0, 7, 6.0);
	setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_MAIZE].id, x, z, widthX, widthZ, heightX, heightZ, 0, 7, g_currentMission.fruits[FruitUtil.FRUITTYPE_MAIZE].id, 0, 7, 6.0);
	setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_RAPE].id, x, z, widthX, widthZ, heightX, heightZ, 0, 7, g_currentMission.fruits[FruitUtil.FRUITTYPE_RAPE].id, 0, 7, 6.0);
	end;
    end;
    
    
    function putrefactionEvent:writeStream(streamId, connection)
        local numAreas = table.getn(self.cuttingAreas);
        streamWriteBool(streamId, self.limitToField);
        streamWriteUIntN(streamId, numAreas, 8);
        
        local refX, refY;
        local values = {};
        for i=1, numAreas do
            local d = self.cuttingAreas[i];
            if i==1 then
                refX = d[1];
                refY = d[2];
                streamWriteFloat32(streamId, d[1]);
                streamWriteFloat32(streamId, d[2]);
           else
                table.insert(values, {x=d[1], y=d[2]});
           end;
           table.insert(values, {x=d[3], y=d[4]});
            table.insert(values, {x=d[5], y=d[6]});
       end;
        assert(table.getn(values) == numAreas*3 - 1);
        Utils.writeCompressed2DVectors(streamId, refX, refY, values, 0.01);
    end;
    
    function putrefactionEvent:run(connection)
        print("Error: Do not run putrefactionEvent locally");
    end;
    
    function putrefactionEvent.runLocally(cuttingAreas, limitToField)
        
        local numAreas = table.getn(cuttingAreas);
    
        local refX, refY;
        local values = {};
        for i=1, numAreas do
            local d = cuttingAreas[i];
           if i==1 then
                refX = d[1];
               refY = d[2];
            else
                table.insert(values, {x=d[1], y=d[2]});
            end;
            table.insert(values, {x=d[3], y=d[4]});
            table.insert(values, {x=d[5], y=d[6]});
        end;
        assert(table.getn(values) == numAreas*3 - 1);
    
        local values = Utils.simWriteCompressed2DVectors(refX, refY, values, 0.01, true);
    
        for i=1, numAreas do
            local vi = i-1;
            local x = values[vi*3+1].x;
            local z = values[vi*3+1].y;
            local x1 = values[vi*3+2].x;
            local z1 = values[vi*3+2].y;
           local x2 = values[vi*3+3].x;
            local z2 = values[vi*3+3].y;
   	local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(id, x, z, x1, z1, x2, z2);
   	setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_WHEAT].id, x, z, widthX, widthZ, heightX, heightZ, 0, 7, g_currentMission.fruits[FruitUtil.FRUITTYPE_WHEAT].id, 0, 7, 6.0);
   	setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_BARLEY].id, x, z, widthX, widthZ, heightX, heightZ, 0, 7, g_currentMission.fruits[FruitUtil.FRUITTYPE_BARLEY].id, 0, 7, 6.0);
	setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_MAIZE].id, x, z, widthX, widthZ, heightX, heightZ, 0, 7, g_currentMission.fruits[FruitUtil.FRUITTYPE_MAIZE].id, 0, 7, 6.0);
	setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_RAPE].id, x, z, widthX, widthZ, heightX, heightZ, 0, 7, g_currentMission.fruits[FruitUtil.FRUITTYPE_RAPE].id, 0, 7, 6.0);
        end;
   end;