--
-- Specialization for Goosneck
-- 
--
-- @author:		Marcu Hedblom a.k.a Xentro (www.ls-uk.info)
-- @version:	v2.0
-- @date:		11/09/11
-- @history:	v1.0 - inital implementation
-- 				v2.0 - Re made script and made it mp ready
--
-- Do not edit without my permission

goosneck = {};

function goosneck.prerequisitesPresent(specializations)
	Vehicle.registerJointType("Goosneck");
	return SpecializationUtil.hasSpecialization(Cylindered, specializations);
	--return true;
end;

function goosneck:load(xmlFile)
	print("goosneck.lua by Xentro have been loaded" );
	
	self.GetRotationOf = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.GetRotationOf#index"));	
	
	self.setLockLowboy = SpecializationUtil.callSpecializationsFunction("setLockLowboy");
	self.lockAnimation = getXMLString(xmlFile, "vehicle.lockLowboy#animationName");
	self.lockNew = false;
	
	self.reverseLights = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.reverseLights#index"));	
	setVisibility(self.reverseLights, false);
	
	self.helpHud 					= false;
	self.loadspace 					= false;
	self.speedViolationMaxTime 		= 2500;
	self.speedViolationTimer 		= self.speedViolationMaxTime;
	self.liftGranted				= false;
	self.lockGranted				= false;
	self.keysActivated				= false;
	self.keysActivated2				= false;
	self.warning1 					= false;
	self.warning2					= false;
	self.warning3					= false;
	self.warning4					= false;
	self.lockAttacherJointTrigger	= false;
	self.lockAttacherJoint			= false;
	self.lockHud					= false;
	-- delay light on attach
	self.delayLightMaxTime 		= 2000;
	self.lightTimer 			= self.delayLightMaxTime;
	
	self.helpHudPosX			= 0.833;
    self.helpHudPosY 			= 0.1725;
    self.helpHudWidth			= 0.17;
    self.helpHudHeight 			= 0.55;
    self.helpHudImg = Utils.getFilename("textures/Info_hud_goos.png", self.baseDirectory);
	self.helpHudOverlay = Overlay:new("helpHudOverlay", self.helpHudImg, self.helpHudPosX, self.helpHudPosY, self.helpHudWidth, self.helpHudHeight);
	
	self.greenButton1PosX		= 0.72; 	-- button 1
    self.greenButton1PosY 		= 0.013; 	-- button 1
	self.greenButton2PosX		= 0.72; 	-- button 2
    self.greenButton2PosY 		= 0.041;	-- button 2
	self.greenButton3PosX		= 0.72; 	-- button 3
    self.greenButton3PosY 		= 0.069; 	-- button 3
    self.greenButtonWidth		= 0.018;
    self.greenButtonHeight 		= 0.025;
    self.greenButtonImg = Utils.getFilename("textures/green_button.png", self.baseDirectory);
	self.greenButton1Overlay = Overlay:new("greenButton1Overlay", self.greenButtonImg, self.greenButton1PosX, self.greenButton1PosY, self.greenButtonWidth, self.greenButtonHeight);
	self.greenButton2Overlay = Overlay:new("greenButton2Overlay", self.greenButtonImg, self.greenButton2PosX, self.greenButton2PosY, self.greenButtonWidth, self.greenButtonHeight);
	self.greenButton3Overlay = Overlay:new("greenButton3Overlay", self.greenButtonImg, self.greenButton3PosX, self.greenButton3PosY, self.greenButtonWidth, self.greenButtonHeight);
	
	self.redButton1PosX			= 0.72; 	-- button 1
    self.redButton1PosY 		= 0.013; 	-- button 1
	self.redButton2PosX			= 0.72; 	-- button 2
    self.redButton2PosY 		= 0.041;	-- button 2
	self.redButton3PosX			= 0.72; 	-- button 3
    self.redButton3PosY 		= 0.069; 	-- button 3
    self.redButtonWidth			= 0.018;
    self.redButtonHeight 		= 0.025;
    self.redButtonImg = Utils.getFilename("textures/red_button.png", self.baseDirectory);
	self.redButton1Overlay = Overlay:new("redButton1Overlay", self.redButtonImg, self.redButton1PosX, self.redButton1PosY, self.redButtonWidth, self.redButtonHeight);
	self.redButton2Overlay = Overlay:new("redButton2Overlay", self.redButtonImg, self.redButton2PosX, self.redButton2PosY, self.redButtonWidth, self.redButtonHeight);
	self.redButton3Overlay = Overlay:new("redButton3Overlay", self.redButtonImg, self.redButton3PosX, self.redButton3PosY, self.redButtonWidth, self.redButtonHeight);
	
	self.mesPosX				= 0.613;
    self.mesPosY 				= 0;
    self.mesWidth				= 0.112;
    self.mesHeight 				= 0.1215;
    self.mesImg = Utils.getFilename("textures/text_mes.png", self.baseDirectory);
	self.mesOverlay = Overlay:new("mesOverlay", self.mesImg, self.mesPosX, self.mesPosY, self.mesWidth, self.mesHeight);
	
	self.vehicleType = getXMLString(xmlFile, "vehicle#type");
end;

function goosneck:delete()
end;

function goosneck:mouseEvent(posX, posY, isDown, isUp, button)
end;

function goosneck:keyEvent(unicode, sym, modifier, isDown)
end;

function goosneck:readStream(streamId, connection)
    self:setLockLowboy(streamReadBool(streamId), true);
	self.lockAttacherJointTrigger = streamReadBool(streamId);
	self.lockAttacherJoint = streamReadBool(streamId);
end;

function goosneck:writeStream(streamId, connection)
    streamWriteBool(streamId, self.lockNew);
	streamWriteBool(streamId, self.lockAttacherJointTrigger);
	streamWriteBool(streamId, self.lockAttacherJoint);
end;

function goosneck:update(dt)
	if self:getIsActive() then 
		if self:getIsActiveForInput() then
			if self.keysActivatedOnLock then
				if InputBinding.hasEvent(InputBinding.LOCK_CLOSE_OPEN) then
					self:setLockLowboy(not self.lockNew);
				end;
			end;
			if InputBinding.hasEvent(InputBinding.LOCK_GOOS_MOVE) then
				self.lockAttacherJointTrigger = not self.lockAttacherJointTrigger;
			end;
			if InputBinding.hasEvent(InputBinding.HELP_HUD) then
				self.helpHud = not self.helpHud;
			end;
		end;
		if table.getn(self.attachedImplements) > 0 then
			if self.lockNew and self:doCheckSpeedLimit() and self.attacherVehicle.lastSpeed*3600 > 5 then
				g_currentMission:addWarning(g_i18n:getText("Lock_Lowboy"), 0.018, 0.033);
					
				self.speedViolationTimer = self.speedViolationTimer - dt;
				--if self.speedViolationTimer < 0 then
					--aGoosneck 	= 88;
					--self.attacherVehicle:detachImplementByObject(self);
				--end;
			else
				self.speedViolationTimer = self.speedViolationMaxTime;
			end;
			local x, y, z = getRotation(self.GetRotationOf);
			if x< Utils.degToRad(3) and self:doCheckSpeedLimit() and self.lastSpeed*3600 > 5 then
				g_currentMission:addWarning(g_i18n:getText("Lift_Lowboy"), 0.018, 0.033);
			end;
		end;
		if self.lightsA then
			self.lightTimer = self.lightTimer - dt;
			if self.lightTimer < 0 then
				self.lightCanBeActivated = true;
			end;
		else
			self.lightTimer = self.delayLightMaxTime;
		end;
	end;
end;

function goosneck:updateTick(dt)
	if self:getIsActive() then
		if self.keysActivated2 then
			self.keysActivatedOnLock = false;
			if self.lockGranted then
				self.keysActivatedOnLock = true;
			end;
		else
			self.keysActivatedOnLock = true;
		end;
		if self.keysActivated then
			self.keysActivatedOnLift = false;
			if self.liftGranted then
				self.keysActivatedOnLift = true;
			end;
		else
			self.keysActivatedOnLift = true;
		end;
		
		if table.getn(self.attachedImplements) > 0 then
			self.keysActivated 				= true;
			self.keysActivated2 			= true;
			self.lockAttacherJointTrigger 	= false;
			self.warning3					= false;

			if self.lockNew then
				self.warning1 		= true;
				self.liftGranted 	= false
				for k,implement in pairs(self.attachedImplements) do
					implement.object.allowsDetaching = true;
				end;
			else
				self.warning1		= false;
				self.liftGranted 	= true;
				for k,implement in pairs(self.attachedImplements) do
					implement.object.allowsDetaching = false;
				end;
			end;
			
			local x, y, z = getRotation(self.GetRotationOf);
			if x< Utils.degToRad(9) then
				self.warning2 		= false;
				self.warning4 		= true;
				self.lockGranted 	= true;
				self.liftHud 		= false;
			else
				self.warning2 		= true;
				self.warning4 		= false;
				self.lockGranted 	= false;
				self.liftHud 		= true;
			end;
		else
			self.warning1			= false;
			self.keysActivated 		= false;
			self.warning2			= false;
			self.warning4			= false;
			self.keysActivated2		= false;
			self.lockGranted 		= false
			self.warning3			= true;
		end;
		
		--- Hud icon ---
		if self.lockNew then
			self.lockHud = false;
		else
			self.lockHud = true;
		end;
		
		if self.lockAttacherJoint then
			for k,v in pairs(self.attacherVehicle.attachedImplements) do
				if v.object == self then
					local joint = self.attacherVehicle.attacherJoints[v.jointDescIndex];
					self.vehicleJoint = joint;					
					setJointFrame(joint.jointIndex, 0, self.attacherPoint);
					if self.lockAttacherJointTrigger then
						setJointRotationLimit(joint.jointIndex, 1, true, math.rad(-0.5), math.rad(0.5));
					else
						setJointRotationLimit(joint.jointIndex, 1, true, math.rad(-110), math.rad(110));
					end;
				end;
			end;
		end;
		-- timer for reverse light when attach
		if self.movingDirection == -1 and self:doCheckSpeedLimit() and self.attacherVehicle.lastSpeed*3600 > 0.27 and self.lightCanBeActivated then
			setVisibility(self.reverseLights, true);
		elseif self.movingDirection ~= -1  then 
			setVisibility(self.reverseLights, false);
		end;
		
	end;
end;

function goosneck:draw()
	
	if not self.helpHud then
		g_currentMission:addHelpButtonText(g_i18n:getText("Help_on_goos"), InputBinding.HELP_HUD);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("Help_off_goos"), InputBinding.HELP_HUD);
		self.helpHudOverlay:render();
		setOverlayColor(overlayId, 44, 69, 56, 1);
		if self.warning1 then
			renderText(0.842, 0.320, 0.016, string.format("Press B to lock "));
			renderText(0.842, 0.300, 0.016, string.format("Goosneck to Lowboy."));
			renderText(0.842, 0.280, 0.016, string.format("Lift/Lower is inactive"));
			renderText(0.842, 0.260, 0.016, string.format("when unlocked."));
		end;
		if self.warning4 and not self.warning3 and not self.warning1 then
			setOverlayColor(overlayId, 100, 100, 4, 1);
			renderText(0.842, 0.320, 0.016, string.format("Press J to Lift"));
			renderText(0.842, 0.300, 0.016, string.format("Press N to Lower"));
		end;
		if self.warning3 then
			setOverlayColor(overlayId, 100, 100, 4, 1);
			renderText(0.842, 0.320, 0.016, string.format("Press O to lock Goosneck"));
			renderText(0.842, 0.300, 0.016, string.format("to Truck, lock will deactivate"));
			renderText(0.842, 0.280, 0.016, string.format("once attach to lowboy."));
		end;
		if self.warning2 then
			renderText(0.842, 0.320, 0.016, string.format("Wheels must be center"));
			renderText(0.842, 0.300, 0.016, string.format("to change steering mode."));
		end;
	end;
	if self.lockHud then
		self.greenButton1Overlay:render();
	else
		self.redButton1Overlay:render();
	end;
	
	if self.liftHud then
		self.greenButton2Overlay:render();
	else
		self.redButton2Overlay:render();
	end;
	
	if self.lockAttacherJointTrigger then
		self.greenButton3Overlay:render();
	else
		self.redButton3Overlay:render();
	end;
	
	self.mesOverlay:render();
end;

function goosneck:setLockLowboy(isLockState,noEventSend)
	if isLockState then
		if self.lockAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.lockAnimation, -1, nil, true);
			self.lockNew = true;
		end;
	else
		if self.lockAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.lockAnimation, 1, nil, true);
			self.lockNew = false;
		end;
	end;
	SetLockEvent.sendEvent(self, isLockState, noEventSend);
end;

function goosneck:onAttach()
	self.lockAttacherJoint = true;
	self.lightsA = true;
end;

function goosneck:onDetach()
	self.helpHud = false;
	setVisibility(self.reverseLights, false);
	
	self.lightCanBeActivated = false;
	self.lightsA = false;
end;

function goosneck:onLeave()
	setVisibility(self.reverseLights, false);
end;

function goosneck:validateAttacherJoint(Goosneck, jointDesc, dt)
    return true;
end;

function goosneck:attachImplement(implement)
end