--
-- Specialization for Lowboy
-- 
--
-- @author:		Marcu Hedblom a.k.a Xentro (www.ls-uk.info)
-- @version:	v2.0
-- @date:		11/09/11
-- @history:	v1.0 - inital implementation
-- 				v2.0 - Re made script and made it mp ready
--
-- Do not edit without my permission

Lowboy = {};

function Lowboy.prerequisitesPresent(specializations)
	Vehicle.registerJointType("Goosneck");
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
	--return true;
end;

function Lowboy:load(xmlFile)
	print("Lowboy.lua by Xentro have been loaded" );
	
	self.GetRotationOfL = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.GetRotationOfL#index"));	
	self.setAxlelift = SpecializationUtil.callSpecializationsFunction("setAxlelift");
	self.axlekAnimation = getXMLString(xmlFile, "vehicle.liftAxles#animationName");
	self.axleActive = false;
	

	local airSound = getXMLString(xmlFile, "vehicle.airSound#file");
    if airSound ~= nil and airSound ~= "" then
     	airSound = Utils.getFilename(airSound, self.baseDirectory); 
     	self.airSound = createSample("airSound");
      	self.airSoundEnabled = false;
      	loadSample(self.airSound, airSound, false);
		setSamplePitch(self.airSound,1);
    end;
	
	local airSoundComp = getXMLString(xmlFile, "vehicle.airSoundComp#file");
    if airSoundComp ~= nil and airSoundComp ~= "" then
     	airSoundComp = Utils.getFilename(airSoundComp, self.baseDirectory); 
     	self.airSoundComp = createSample("airSoundComp");
      	self.airSoundCompEnabled = false;
      	loadSample(self.airSoundComp, airSoundComp, false);
		setSamplePitch(self.airSoundComp,1);
    end;
	
	self.reverseLights = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.reverseLights#index"));	
	setVisibility(self.reverseLights, false);
	
	self.helpHudPosX = 0.833;
    self.helpHudPosY = 0.1725;
    self.helpHudWidth = 0.17;
    self.helpHudHeight = 0.55;
    self.helpHudImg = Utils.getFilename("textures/Info_hud_lowboy.png", self.baseDirectory);
	self.helpHudOverlay = Overlay:new("helpHudOverlay", self.helpHudImg, self.helpHudPosX, self.helpHudPosY, self.helpHudWidth, self.helpHudHeight);

	self.greenButton4PosX		= 0.72; 	-- button 4
    self.greenButton4PosY 		= 0.097; 	-- button 4
	self.greenButton5PosX		= 0.72; 	-- button 5
    self.greenButton5PosY 		= 0.125; 	-- button 5
    self.greenButtonWidth		= 0.018;
    self.greenButtonHeight 		= 0.025;
    self.greenButtonImg = Utils.getFilename("textures/green_button.png", self.baseDirectory);
	self.greenButton4Overlay = Overlay:new("greenButton4Overlay", self.greenButtonImg, self.greenButton4PosX, self.greenButton4PosY, self.greenButtonWidth, self.greenButtonHeight);
	self.greenButton5Overlay = Overlay:new("greenButton5Overlay", self.greenButtonImg, self.greenButton5PosX, self.greenButton5PosY, self.greenButtonWidth, self.greenButtonHeight);

	self.redButton4PosX			= 0.72; 	-- button 4
    self.redButton4PosY 		= 0.097; 	-- button 4
	self.redButton5PosX			= 0.72; 	-- button 5
    self.redButton5PosY 		= 0.125; 	-- button 5
    self.redButtonWidth			= 0.018;
    self.redButtonHeight 		= 0.025;
    self.redButtonImg = Utils.getFilename("textures/red_button.png", self.baseDirectory);
	self.redButton4Overlay = Overlay:new("redButton4Overlay", self.redButtonImg, self.redButton4PosX, self.redButton4PosY, self.redButtonWidth, self.redButtonHeight);
	self.redButton5Overlay = Overlay:new("redButton5Overlay", self.redButtonImg, self.redButton5PosX, self.redButton5PosY, self.redButtonWidth, self.redButtonHeight);
	
	self.mesPosX				= 0.613;
    self.mesPosY 				= 0.055;
    self.mesWidth				= 0.112;
    self.mesHeight 				= 0.1215;
    self.mesImg = Utils.getFilename("textures/text_mes_lowboy.png", self.baseDirectory);
	self.mesOverlay = Overlay:new("mesOverlay", self.mesImg, self.mesPosX, self.mesPosY, self.mesWidth, self.mesHeight);
	
    self.helpHud 		= false;
	self.hudButton 		= false;
	self.wheelsCenter	= false;
	-- delay light on attach
	self.delayLightMaxTime 	= 5000;
	self.lightTimer 		= self.delayLightMaxTime;
	
	self.steeringModeCount	= 0;
	self.autoSteering 		= false;
	self.manualSteering		= false;
	self.liftingAxle 		= true;
	
	self.vehicleType = getXMLString(xmlFile, "vehicle#type");
end;

function Lowboy:delete()
	if self.airSoundCompEnabled  then
		stopSample(self.airSoundComp); self.airSoundCompEnabled = false;
	end;
	if self.airSoundEnabled  then
		stopSample(self.airSound); self.airSoundEnabled = false;
	end;
end;

function Lowboy:readStream(streamId, connection)
	self:setAxlelift(streamReadBool(streamId), true);
	self.steeringModeCount = streamReadInt32(streamId);
	self.autoSteering = streamReadBool(streamId);
	self.manualSteering = streamReadBool(streamId);
	self.liftingAxle = streamReadBool(streamId);
end;

function Lowboy:writeStream(streamId, connection)
	streamWriteBool(streamId, self.axleActive);
	streamWriteInt32(streamId, self.steeringModeCount);
	streamWriteBool(streamId, self.autoSteering);
	streamWriteBool(streamId, self.manualSteering);
	streamWriteBool(streamId, self.liftingAxle);
end;

function Lowboy:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Lowboy:keyEvent(unicode, sym, modifier, isDown)
end;

function Lowboy:update(dt)
	if self:getIsActive() then 
		if self:getIsActiveForInput() then
			if self.liftingAxle then
				if InputBinding.hasEvent(InputBinding.AXLE_LIFT_LOWER) then
					self:setAxlelift(not self.axleActive);
				end;
			end;
			if InputBinding.hasEvent(InputBinding.HELP_HUD2) then
				self.helpHud = not self.helpHud;
			end;
			if self.steeringModeActive then
				if InputBinding.hasEvent(InputBinding.STEERING_MODE) then
					self.steeringModeCount = self.steeringModeCount +1;
				end;
			end;
		end;
		for i=1, table.getn(self.wheels) do
			local wheel = self.wheels[i];
			local x2,y2,z2 = getRotation(wheel.repr);
			local x, y, z = getRotation(self.GetRotationOfL);
			if self.steeringModeCount == 0 then
				self.steeringModeActive = true;
				self.wheelsCenter		= true;
			elseif y2< Utils.degToRad(3) and y2> Utils.degToRad(-3) and self.steeringModeCount == 1 then
				self.steeringModeActive = true;
				self.wheelsCenter		= true;
			elseif y< Utils.degToRad(1.5) and y> Utils.degToRad(-1.5) and self.steeringModeCount == 2 then
				self.steeringModeActive = true;
				self.wheelsCenter 		= true;
			elseif self.steeringModeCount == 3 then
				self.steeringModeCount = 0;
			else
				self.steeringModeActive = false;
				self.wheelsCenter		= false;
			end;
		end;
		
	end;
	if self.lightsA then
		self.lightTimer = self.lightTimer - dt;
		if self.lightTimer < 0 then
			self.lightCanBeActivated = true;
		end;
	else
		self.lightTimer = self.delayLightMaxTime;
	end;
	for i, jointDesc in pairs(self.componentJoints) do
	   setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
	end;
end;

function Lowboy:updateTick(dt)
	if self:getIsActive() then
		if self.steeringModeCount == 0 then 
			self.autoSteering 	= false;
			self.manualSteering = false;
			self.liftingAxle 	= true;
		elseif self.steeringModeCount == 1 then
			self.autoSteering 	= true;
			self.manualSteering = false;
			self.liftingAxle 	= false;	
			if self.axleActive then
				self:setAxlelift(false);
			end
		elseif self.steeringModeCount == 2 then
			self.autoSteering 	= false;
			self.manualSteering = true;
			self.liftingAxle 	= false;
		end;
		-- reverse light
		if self.movingDirection == -1 and self:doCheckSpeedLimit() and self.lastSpeed*3600 > 0.27  and self.lightCanBeActivated then
			setVisibility(self.reverseLights, true);
		elseif self.movingDirection ~=-1  then 
			setVisibility(self.reverseLights, false);
		end;
		-- sound
		if self:getIsAnimationPlaying("liftWheelAxles") then
			if self.axleActive then
				if not self.airSoundCompEnabled then
					if self:getIsActiveForSound() and self.attacherVehicle ~= nil then
						playSample(self.airSoundComp, 0, 0.5, 2); self.airSoundCompEnabled = true;
					end;
				end;
			else
				if not self.airSoundEnabled then
					if self:getIsActiveForSound() and self.attacherVehicle ~= nil then
						playSample(self.airSound, 0, 0.5, 2); self.airSoundEnabled = true;
					end;
				end;
			end;
		else
			stopSample(self.airSoundComp); self.airSoundCompEnabled = false;
			stopSample(self.airSound); self.airSoundEnabled = false;
		end;
	end;
end;

function Lowboy:draw()
	if not self.helpHud then
		g_currentMission:addHelpButtonText(g_i18n:getText("Help_on"), InputBinding.HELP_HUD2);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("Help_off"), InputBinding.HELP_HUD2);
		self.helpHudOverlay:render();
	end;
	
	if self.wheelsCenter then
		self.greenButton5Overlay:render();
	else
		self.redButton5Overlay:render();
	end;
	
	if self.axleActive then
		self.greenButton4Overlay:render();
	else
		self.redButton4Overlay:render();
	end;
	self.mesOverlay:render();
	
	if self.steeringModeCount == 0 then
		self.steeringModeName = "None";
	elseif self.steeringModeCount == 1 then
		self.steeringModeName = "Auto";
	elseif self.steeringModeCount == 2 then
		self.steeringModeName = "Manual";
	end;
	g_currentMission:addHelpButtonText("Steering Mode: " .. self.steeringModeName, InputBinding.STEERING_MODE);
end;

function Lowboy:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.steeringModeCount =  Utils.getNoNil(getXMLInt(xmlFile, key.."#steeringModeCount"),0);
	end; 
	return BaseMission.VEHICLE_LOAD_OK;
end;

function Lowboy:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'steeringModeCount="'..self.steeringModeCount..'"';
    return attributes, nil;
end;

function Lowboy:onAttach()
--	if (attacherVehicle.aGoosneck ~= nil and attacherVehicle.aGoosneck == 88) then
--		self.attacherVehicle:detachImplementByObject(self);
--	end;
	self.lightsA = true;
end;

function Lowboy:onDetach()
	self.helpHud = false;
	setVisibility(self.reverseLights, false);
	if self.airSoundCompEnabled  then
		stopSample(self.airSoundComp); self.airSoundCompEnabled = false;
	end;
	if self.airSoundEnabled  then
		stopSample(self.airSound); self.airSoundEnabled = false;
	end;
	if self.axleActive then
		self:setAxlelift(false);
	end
	self.lightCanBeActivated = false;
	self.lightsA = false;
end;

function Lowboy:onLeave()
	setVisibility(self.reverseLights, false);
end;

function Lowboy:setAxlelift(isLiftState,noEventSend)
	if isLiftState then
		if self.axlekAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.axlekAnimation, -1, nil, true);
			self.axleActive = true;
		end;
	else
		if self.axlekAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.axlekAnimation, 1, nil, true);
			self.axleActive = false;
		end;
	end;
	SetLiftEvent.sendEvent(self, isLiftState, noEventSend);
end;