--
-- superflow
-- Specialization for superflow superflow.
--
-- @author  	PeterJ - LS_UK modteam
-- @version 	v1.0
-- @date  		07/11/2011
--

superflow = {};

function superflow.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function superflow:load(xmlFile)

	self.setLoweredMax = SpecializationUtil.callSpecializationsFunction("setLoweredMax");
	self.LoweredMaxAnimation = getXMLString(xmlFile, "vehicle.loweredMax#animationName");
	self.LoweredMaxOn = false;
	self.firstTime = true;
	
end;

function superflow:readStream(streamId, connection)
    self:setLoweredMax(streamReadBool(streamId), true);
end;

function superflow:writeStream(streamId, connection)
	streamWriteBool(streamId, self.LoweredMax);
end;

function superflow:delete()
end;

function superflow:mouseEvent(posX, posY, isDown, isUp, button)
end;

function superflow:keyEvent(unicode, sym, modifier, isDown)
end;

function superflow:update(dt)
end;

function superflow:updateTick(dt)
	if self:getIsActive() then
		if self:isLowered(false) then
			if self.lastMovedDistance > 0.1 then
				if self.movingDirection == -1 then
					if self.isLoweredMaxOn then
						self:setLoweredMax(not self.isLoweredMaxOn);
					end;
				else
					self:setLoweredMax(true);
				end;
			end;
		else
			if self.isLoweredMaxOn then
				self:setLoweredMax(not self.isLoweredMaxOn);	
			end;
		end;
	end;
end;

function superflow:draw()
end;

function superflow:onAttach(attacherVehicle)

	if self.firstTime then
		self:setLoweredMax(false);
		self.firstTime = false;
	end;
end;
 
function superflow:onDetach()
end;

function superflow:setLoweredMax(isLoweredMax,noEventSend)
	SetLoweredMaxEvent.sendEvent(self, isLoweredMax, noEventSend);
	-- Play LoweredMax animation --
	self.isLoweredMaxOn = isLoweredMax;
	if self.isLoweredMaxOn then
		if self.LoweredMaxAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.LoweredMaxAnimation, -1, nil, true);
			self.LoweredMax = true;
		end;
	else
		if self.LoweredMaxAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.LoweredMaxAnimation, 1, nil, true);
			self.LoweredMax = false;
		end;
	end;	
end;

SetLoweredMaxEvent = {};
SetLoweredMaxEvent_mt = Class(SetLoweredMaxEvent, Event);

InitEventClass(SetLoweredMaxEvent, "SetLoweredMaxEvent");

function SetLoweredMaxEvent:emptyNew()
    local self = Event:new(SetLoweredMaxEvent_mt);
    self.className="SetLoweredMaxEvent";
    return self;
end;

function SetLoweredMaxEvent:new(vehicle, isLoweredMax)
    local self = SetLoweredMaxEvent:emptyNew()
    self.vehicle = vehicle;
	self.isLoweredMax = isLoweredMax;
    return self;
end;

function SetLoweredMaxEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isLoweredMax = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetLoweredMaxEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isLoweredMax);
end;

function SetLoweredMaxEvent:run(connection)   
	self.vehicle:setLoweredMax(self.isLoweredMax, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetLoweredMaxEvent:new(self.vehicle, self.isLoweredMax), nil, connection, self.vehicle);
    end;
end;

function SetLoweredMaxEvent.sendEvent(vehicle, isLoweredMax, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetLoweredMaxEvent:new(vehicle, isLoweredMax), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetLoweredMaxEvent:new(vehicle, isLoweredMax));
		end;
	end;
end;
