
LEJ = {};

function LEJ.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Sprayer, specializations);
end;

function LEJ:load(xmlFile)
	self.talerz = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.talerz#index"));
	self.wom1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wom1#index"));
	self.wom2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wom2#index"));
	self.wom3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wom3#index"));
end;

function LEJ:delete()
end;

function LEJ:mouseEvent(posX, posY, isDown, isUp, button)
end;

function LEJ:keyEvent(unicode, sym, modifier, isDown)
end;

function LEJ:update(dt)
end;

function LEJ:updateTick(dt)
	if self:getIsActive() then
		if self.isTurnedOn then
			rotate(self.talerz, 0, 1.6, 0);
		end;
		if self.isTurnedOn then
			rotate(self.wom1, 0, 1.6, 0);
		end;
		if self.isTurnedOn then
			rotate(self.wom2, 0, 0, 1.6);
		end;
		if self.isTurnedOn then
			rotate(self.wom3, 0, 0, 1.6);
		end;
	end;
end;

function LEJ:draw()
end;

function LEJ:onDetach()
end;

function LEJ:onLeave()
end;

function LEJ:onDeactivate()
end;