--
-- JD1760
-- Specialization for farmer car mod
--
-- @author  Stefan Geiger
-- @date  10/01/09
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

JD1760 = {};

function JD1760.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function JD1760:load(xmlFile)

    self.findTrailerRaycastCallback = Combine.findTrailerRaycastCallback;
    self.trailerPosition = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.trailerPosition#index"));
    self.grainUnloading = 100;

    self.setFillLevel = SpecializationUtil.callSpecializationsFunction("setFillLevel");
    self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
    self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));

    self.speedViolationMaxTime = 2500;
    self.speedViolationTimer = self.speedViolationMaxTime;

    self.seeds = {};
    for k, fruitType in pairs(FruitUtil.fruitTypes) do
        if fruitType.allowsSeeding then
            self.seeds[fruitType.index] = fruitType.index;
        end;
    end;

    self.isTurnedOn = false;

    self.aiTerrainDetailChannel1 = g_currentMission.cultivatorChannel;
    self.aiTerrainDetailChannel2 = g_currentMission.ploughChannel;

    local sowingSound = getXMLString(xmlFile, "vehicle.sowingSound#file");
    if sowingSound ~= nil and sowingSound ~= "" then
        sowingSound = Utils.getFilename(sowingSound, self.baseDirectory);
        self.sowingSound = createSample("sowingSound");
        loadSample(self.sowingSound, sowingSound, false);
        self.sowingSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sowingSound#pitchOffset"), 0);
        self.sowingSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sowingSound#volume"), 1.0);
        self.sowingSoundEnabled = false;
    end;

    self.lastFillDelta = 0;
    self.capacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.capacity"), 0.0);
    self.minThreshold = 0.05;
    self.fillTypes = {};

    local fruitTypes = getXMLString(xmlFile, "vehicle.fillTypes#fruitTypes");
    if fruitTypes ~= nil then
        local types = Utils.splitString(" ", fruitTypes);
        for k,v in pairs(types) do
            local desc = FruitUtil.fruitTypes[v];
            if desc ~= nil then
                self.fillTypes[desc.index] = true;
            end;
        end;
    end;

    self.groundParticleSystems = {};
    local psName = "vehicle.groundParticleSystem";
    Utils.loadParticleSystem(xmlFile, self.groundParticleSystems, psName, self.components, false, nil, self.baseDirectory)

    self.aiaktiv = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiLeftMarker#index"));

    self.wheel1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.wheel1#index"));
    self.wheel2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.wheel2#index"));
    self.wheel3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.wheel3#index"));
    self.wheel4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.wheel4#index"));
    self.wheel5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.wheel5#index"));
    self.wheel6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.wheel6#index"));

    self.fertilizerDiscLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.fertilizerDiscLeft#index"));
    self.fertilizerDiscMiddle = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.fertilizerDiscMiddle#index"));
    self.fertilizerDiscRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.fertilizerDiscRight#index"));

    self.seedDiscLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedDiscLeft#index"));
    self.seedDiscMiddle = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedDiscMiddle#index"));
    self.seedDiscRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedDiscRight#index"));

    self.levelWheelLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.levelWheelLeft#index"));
    self.levelWheelMiddle = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.levelWheelMiddle#index"));
    self.levelWheelRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.levelWheelRight#index"));

    self.frontSeederDiscLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.frontSeederDiscLeft#index"));
    self.frontSeederDiscMiddle = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.frontSeederDiscMiddle#index"));
    self.frontSeederDiscRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.frontSeederDiscRight#index"));

    self.seedCowerDiscLeft1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedCowerDiscLeft1#index"));
    self.seedCowerDiscLeft2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedCowerDiscLeft2#index"));
    self.seedCowerDiscLeft3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedCowerDiscLeft3#index"));
    self.seedCowerDiscLeft4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedCowerDiscLeft4#index"));
    self.seedCowerDiscLeft5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedCowerDiscLeft5#index"));
    self.seedCowerDiscLeft6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedCowerDiscLeft6#index"));

    self.seedCowerDiscMiddle1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedCowerDiscMiddle1#index"));
    self.seedCowerDiscMiddle2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedCowerDiscMiddle2#index"));
    self.seedCowerDiscMiddle3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedCowerDiscMiddle3#index"));
    self.seedCowerDiscMiddle4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedCowerDiscMiddle4#index"));
    self.seedCowerDiscMiddle5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedCowerDiscMiddle5#index"));
    self.seedCowerDiscMiddle6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedCowerDiscMiddle6#index"));
    self.seedCowerDiscMiddle7 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedCowerDiscMiddle7#index"));
    self.seedCowerDiscMiddle8 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedCowerDiscMiddle8#index"));
    self.seedCowerDiscMiddle9 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedCowerDiscMiddle9#index"));
    self.seedCowerDiscMiddle10 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedCowerDiscMiddle10#index"));
    self.seedCowerDiscMiddle11 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedCowerDiscMiddle11#index"));
    self.seedCowerDiscMiddle12 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedCowerDiscMiddle12#index"));

    self.seedCowerDiscRight1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedCowerDiscRight1#index"));
    self.seedCowerDiscRight2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedCowerDiscRight2#index"));
    self.seedCowerDiscRight3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedCowerDiscRight3#index"));
    self.seedCowerDiscRight4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedCowerDiscRight4#index"));
    self.seedCowerDiscRight5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedCowerDiscRight5#index"));
    self.seedCowerDiscRight6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seedCowerDiscRight6#index"));

    self.markerDiscLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.markerDiscLeft#index"));
    self.markerDiscRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.markerDiscRight#index"));

    local rotationPartNodeMainBody = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartMainBody#index"));
    if rotationPartNodeMainBody ~= nil then
        self.rotationPartMainBody = {};
        self.rotationPartMainBody.node = rotationPartNodeMainBody;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMainBody#minRot"));
        self.rotationPartMainBody.minRot = {};
        self.rotationPartMainBody.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMainBody.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMainBody.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMainBody#maxRot"));
        self.rotationPartMainBody.maxRot = {};
        self.rotationPartMainBody.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMainBody.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMainBody.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMainBody.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMainBody#rotTime"), 2)*1000;
        self.rotationPartMainBody.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMainBody#touchRotLimit"), 10));
    end;

	local rotationPartNodeLeftExtension = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeftExtension#index"));
    if rotationPartNodeLeftExtension ~= nil then
        self.rotationPartLeftExtension = {};
        self.rotationPartLeftExtension.node = rotationPartNodeLeftExtension;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeftExtension#minRot"));
        self.rotationPartLeftExtension.minRot = {};
        self.rotationPartLeftExtension.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeftExtension.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeftExtension.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeftExtension#maxRot"));
        self.rotationPartLeftExtension.maxRot = {};
        self.rotationPartLeftExtension.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeftExtension.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeftExtension.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeftExtension.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeftExtension#rotTime"), 2)*1000;
        self.rotationPartLeftExtension.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeftExtension#touchRotLimit"), 10));
    end;

	local rotationPartNodeRightExtension = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRightExtension#index"));
    if rotationPartNodeRightExtension ~= nil then
        self.rotationPartRightExtension = {};
        self.rotationPartRightExtension.node = rotationPartNodeRightExtension;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRightExtension#minRot"));
        self.rotationPartRightExtension.minRot = {};
        self.rotationPartRightExtension.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRightExtension.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRightExtension.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRightExtension#maxRot"));
        self.rotationPartRightExtension.maxRot = {};
        self.rotationPartRightExtension.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRightExtension.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRightExtension.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRightExtension.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRightExtension#rotTime"), 2)*1000;
        self.rotationPartRightExtension.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRightExtension#touchRotLimit"), 10));
    end;

	local rotationPartNodeMainBodyLifters = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartMainBodyLifters#index"));
    if rotationPartNodeMainBodyLifters ~= nil then
        self.rotationPartMainBodyLifters = {};
        self.rotationPartMainBodyLifters.node = rotationPartNodeMainBodyLifters;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMainBodyLifters#minRot"));
        self.rotationPartMainBodyLifters.minRot = {};
        self.rotationPartMainBodyLifters.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMainBodyLifters.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMainBodyLifters.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMainBodyLifters#maxRot"));
        self.rotationPartMainBodyLifters.maxRot = {};
        self.rotationPartMainBodyLifters.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMainBodyLifters.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMainBodyLifters.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMainBodyLifters.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMainBodyLifters#rotTime"), 2)*1000;
        self.rotationPartMainBodyLifters.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMainBodyLifters#touchRotLimit"), 10));
    end;

	local rotationPartNodeLeftExtLifter = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeftExtLifter#index"));
    if rotationPartNodeLeftExtLifter ~= nil then
        self.rotationPartLeftExtLifter = {};
        self.rotationPartLeftExtLifter.node = rotationPartNodeLeftExtLifter;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeftExtLifter#minRot"));
        self.rotationPartLeftExtLifter.minRot = {};
        self.rotationPartLeftExtLifter.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeftExtLifter.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeftExtLifter.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeftExtLifter#maxRot"));
        self.rotationPartLeftExtLifter.maxRot = {};
        self.rotationPartLeftExtLifter.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeftExtLifter.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeftExtLifter.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeftExtLifter.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeftExtLifter#rotTime"), 2)*1000;
        self.rotationPartLeftExtLifter.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeftExtLifter#touchRotLimit"), 10));
    end;

	local rotationPartNodeRightExtLifter = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRightExtLifter#index"));
    if rotationPartNodeRightExtLifter ~= nil then
        self.rotationPartRightExtLifter = {};
        self.rotationPartRightExtLifter.node = rotationPartNodeRightExtLifter;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRightExtLifter#minRot"));
        self.rotationPartRightExtLifter.minRot = {};
        self.rotationPartRightExtLifter.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRightExtLifter.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRightExtLifter.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRightExtLifter#maxRot"));
        self.rotationPartRightExtLifter.maxRot = {};
        self.rotationPartRightExtLifter.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRightExtLifter.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRightExtLifter.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRightExtLifter.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRightExtLifter#rotTime"), 2)*1000;
        self.rotationPartRightExtLifter.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRightExtLifter#touchRotLimit"), 10));
    end;

	local rotationPartNodeRightExtLifter = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRightExtLifter#index"));
    if rotationPartNodeRightExtLifter ~= nil then
        self.rotationPartRightExtLifter = {};
        self.rotationPartRightExtLifter.node = rotationPartNodeRightExtLifter;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRightExtLifter#minRot"));
        self.rotationPartRightExtLifter.minRot = {};
        self.rotationPartRightExtLifter.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRightExtLifter.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRightExtLifter.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRightExtLifter#maxRot"));
        self.rotationPartRightExtLifter.maxRot = {};
        self.rotationPartRightExtLifter.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRightExtLifter.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRightExtLifter.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRightExtLifter.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRightExtLifter#rotTime"), 2)*1000;
        self.rotationPartRightExtLifter.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRightExtLifter#touchRotLimit"), 10));
    end;

	local rotationPartNodeMarkerLeftInner = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftInner#index"));
    if rotationPartNodeMarkerLeftInner ~= nil then
        self.rotationPartMarkerLeftInner = {};
        self.rotationPartMarkerLeftInner.node = rotationPartNodeMarkerLeftInner;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftInner#minRot"));
        self.rotationPartMarkerLeftInner.minRot = {};
        self.rotationPartMarkerLeftInner.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerLeftInner.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerLeftInner.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftInner#maxRot"));
        self.rotationPartMarkerLeftInner.maxRot = {};
        self.rotationPartMarkerLeftInner.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerLeftInner.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerLeftInner.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMarkerLeftInner.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftInner#rotTime"), 2)*1000;
        self.rotationPartMarkerLeftInner.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftInner#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeMarkerRightInner = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartMarkerRightInner#index"));
    if rotationPartNodeMarkerRightInner ~= nil then
        self.rotationPartMarkerRightInner = {};
        self.rotationPartMarkerRightInner.node = rotationPartNodeMarkerRightInner;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightInner#minRot"));
        self.rotationPartMarkerRightInner.minRot = {};
        self.rotationPartMarkerRightInner.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerRightInner.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerRightInner.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightInner#maxRot"));
        self.rotationPartMarkerRightInner.maxRot = {};
        self.rotationPartMarkerRightInner.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerRightInner.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerRightInner.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMarkerRightInner.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightInner#rotTime"), 2)*1000;
        self.rotationPartMarkerRightInner.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightInner#touchRotLimit"), 10));
    end;

    local rotationPartNodeMarkerLeftMiddle = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftMiddle#index"));
    if rotationPartNodeMarkerLeftMiddle ~= nil then
        self.rotationPartMarkerLeftMiddle = {};
        self.rotationPartMarkerLeftMiddle.node = rotationPartNodeMarkerLeftMiddle;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftMiddle#minRot"));
        self.rotationPartMarkerLeftMiddle.minRot = {};
        self.rotationPartMarkerLeftMiddle.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerLeftMiddle.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerLeftMiddle.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftMiddle#maxRot"));
        self.rotationPartMarkerLeftMiddle.maxRot = {};
        self.rotationPartMarkerLeftMiddle.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerLeftMiddle.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerLeftMiddle.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMarkerLeftMiddle.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftMiddle#rotTime"), 2)*1000;
        self.rotationPartMarkerLeftMiddle.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftMiddle#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeMarkerRightMiddle = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartMarkerRightMiddle#index"));
    if rotationPartNodeMarkerRightMiddle ~= nil then
        self.rotationPartMarkerRightMiddle = {};
        self.rotationPartMarkerRightMiddle.node = rotationPartNodeMarkerRightMiddle;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightMiddle#minRot"));
        self.rotationPartMarkerRightMiddle.minRot = {};
        self.rotationPartMarkerRightMiddle.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerRightMiddle.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerRightMiddle.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightMiddle#maxRot"));
        self.rotationPartMarkerRightMiddle.maxRot = {};
        self.rotationPartMarkerRightMiddle.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerRightMiddle.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerRightMiddle.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMarkerRightMiddle.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightMiddle#rotTime"), 2)*1000;
        self.rotationPartMarkerRightMiddle.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightMiddle#touchRotLimit"), 10));
    end;

	local rotationPartNodeMarkerLeftOuter = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftOuter#index"));
    if rotationPartNodeMarkerLeftOuter ~= nil then
        self.rotationPartMarkerLeftOuter = {};
        self.rotationPartMarkerLeftOuter.node = rotationPartNodeMarkerLeftOuter;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftOuter#minRot"));
        self.rotationPartMarkerLeftOuter.minRot = {};
        self.rotationPartMarkerLeftOuter.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerLeftOuter.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerLeftOuter.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftOuter#maxRot"));
        self.rotationPartMarkerLeftOuter.maxRot = {};
        self.rotationPartMarkerLeftOuter.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerLeftOuter.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerLeftOuter.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMarkerLeftOuter.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftOuter#rotTime"), 2)*1000;
        self.rotationPartMarkerLeftOuter.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftOuter#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeMarkerRightOuter = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartMarkerRightOuter#index"));
    if rotationPartNodeMarkerRightOuter ~= nil then
        self.rotationPartMarkerRightOuter = {};
        self.rotationPartMarkerRightOuter.node = rotationPartNodeMarkerRightOuter;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightOuter#minRot"));
        self.rotationPartMarkerRightOuter.minRot = {};
        self.rotationPartMarkerRightOuter.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerRightOuter.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerRightOuter.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightOuter#maxRot"));
        self.rotationPartMarkerRightOuter.maxRot = {};
        self.rotationPartMarkerRightOuter.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerRightOuter.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerRightOuter.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMarkerRightOuter.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightOuter#rotTime"), 2)*1000;
        self.rotationPartMarkerRightOuter.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightOuter#touchRotLimit"), 10));
    end;

	local rotationPartNodeMarkerLeftExtension1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftExtension1#index"));
    if rotationPartNodeMarkerLeftExtension1 ~= nil then
        self.rotationPartMarkerLeftExtension1 = {};
        self.rotationPartMarkerLeftExtension1.node = rotationPartNodeMarkerLeftExtension1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftExtension1#minRot"));
        self.rotationPartMarkerLeftExtension1.minRot = {};
        self.rotationPartMarkerLeftExtension1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerLeftExtension1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerLeftExtension1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftExtension1#maxRot"));
        self.rotationPartMarkerLeftExtension1.maxRot = {};
        self.rotationPartMarkerLeftExtension1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerLeftExtension1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerLeftExtension1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMarkerLeftExtension1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftExtension1#rotTime"), 2)*1000;
        self.rotationPartMarkerLeftExtension1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftExtension1#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeMarkerRightExtension1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartMarkerRightExtension1#index"));
    if rotationPartNodeMarkerRightExtension1 ~= nil then
        self.rotationPartMarkerRightExtension1 = {};
        self.rotationPartMarkerRightExtension1.node = rotationPartNodeMarkerRightExtension1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightExtension1#minRot"));
        self.rotationPartMarkerRightExtension1.minRot = {};
        self.rotationPartMarkerRightExtension1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerRightExtension1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerRightExtension1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightExtension1#maxRot"));
        self.rotationPartMarkerRightExtension1.maxRot = {};
        self.rotationPartMarkerRightExtension1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerRightExtension1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerRightExtension1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMarkerRightExtension1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightExtension1#rotTime"), 2)*1000;
        self.rotationPartMarkerRightExtension1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightExtension1#touchRotLimit"), 10));
    end;

	local rotationPartNodeMarkerLeftExtension2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftExtension2#index"));
    if rotationPartNodeMarkerLeftExtension2 ~= nil then
        self.rotationPartMarkerLeftExtension2 = {};
        self.rotationPartMarkerLeftExtension2.node = rotationPartNodeMarkerLeftExtension2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftExtension2#minRot"));
        self.rotationPartMarkerLeftExtension2.minRot = {};
        self.rotationPartMarkerLeftExtension2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerLeftExtension2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerLeftExtension2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftExtension2#maxRot"));
        self.rotationPartMarkerLeftExtension2.maxRot = {};
        self.rotationPartMarkerLeftExtension2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerLeftExtension2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerLeftExtension2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMarkerLeftExtension2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftExtension2#rotTime"), 2)*1000;
        self.rotationPartMarkerLeftExtension2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftExtension2#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeMarkerRightExtension2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartMarkerRightExtension2#index"));
    if rotationPartNodeMarkerRightExtension2 ~= nil then
        self.rotationPartMarkerRightExtension2 = {};
        self.rotationPartMarkerRightExtension2.node = rotationPartNodeMarkerRightExtension2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightExtension2#minRot"));
        self.rotationPartMarkerRightExtension2.minRot = {};
        self.rotationPartMarkerRightExtension2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerRightExtension2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerRightExtension2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightExtension2#maxRot"));
        self.rotationPartMarkerRightExtension2.maxRot = {};
        self.rotationPartMarkerRightExtension2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerRightExtension2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerRightExtension2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMarkerRightExtension2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightExtension2#rotTime"), 2)*1000;
        self.rotationPartMarkerRightExtension2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightExtension2#touchRotLimit"), 10));
    end;

	local rotationPartNodeMarkerLeftExtension3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftExtension3#index"));
    if rotationPartNodeMarkerLeftExtension3 ~= nil then
        self.rotationPartMarkerLeftExtension3 = {};
        self.rotationPartMarkerLeftExtension3.node = rotationPartNodeMarkerLeftExtension3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftExtension3#minRot"));
        self.rotationPartMarkerLeftExtension3.minRot = {};
        self.rotationPartMarkerLeftExtension3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerLeftExtension3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerLeftExtension3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftExtension3#maxRot"));
        self.rotationPartMarkerLeftExtension3.maxRot = {};
        self.rotationPartMarkerLeftExtension3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerLeftExtension3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerLeftExtension3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMarkerLeftExtension3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftExtension3#rotTime"), 2)*1000;
        self.rotationPartMarkerLeftExtension3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftExtension3#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeMarkerRightExtension3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartMarkerRightExtension3#index"));
    if rotationPartNodeMarkerRightExtension3 ~= nil then
        self.rotationPartMarkerRightExtension3 = {};
        self.rotationPartMarkerRightExtension3.node = rotationPartNodeMarkerRightExtension3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightExtension3#minRot"));
        self.rotationPartMarkerRightExtension3.minRot = {};
        self.rotationPartMarkerRightExtension3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerRightExtension3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerRightExtension3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightExtension3#maxRot"));
        self.rotationPartMarkerRightExtension3.maxRot = {};
        self.rotationPartMarkerRightExtension3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerRightExtension3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerRightExtension3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMarkerRightExtension3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightExtension3#rotTime"), 2)*1000;
        self.rotationPartMarkerRightExtension3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightExtension3#touchRotLimit"), 10));
    end;

	local rotationPartNodeMarkerLeftExtension4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftExtension4#index"));
    if rotationPartNodeMarkerLeftExtension4 ~= nil then
        self.rotationPartMarkerLeftExtension4 = {};
        self.rotationPartMarkerLeftExtension4.node = rotationPartNodeMarkerLeftExtension4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftExtension4#minRot"));
        self.rotationPartMarkerLeftExtension4.minRot = {};
        self.rotationPartMarkerLeftExtension4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerLeftExtension4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerLeftExtension4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftExtension4#maxRot"));
        self.rotationPartMarkerLeftExtension4.maxRot = {};
        self.rotationPartMarkerLeftExtension4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerLeftExtension4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerLeftExtension4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMarkerLeftExtension4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftExtension4#rotTime"), 2)*1000;
        self.rotationPartMarkerLeftExtension4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftExtension4#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeMarkerRightExtension4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartMarkerRightExtension4#index"));
    if rotationPartNodeMarkerRightExtension4 ~= nil then
        self.rotationPartMarkerRightExtension4 = {};
        self.rotationPartMarkerRightExtension4.node = rotationPartNodeMarkerRightExtension4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightExtension4#minRot"));
        self.rotationPartMarkerRightExtension4.minRot = {};
        self.rotationPartMarkerRightExtension4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerRightExtension4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerRightExtension4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightExtension4#maxRot"));
        self.rotationPartMarkerRightExtension4.maxRot = {};
        self.rotationPartMarkerRightExtension4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerRightExtension4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerRightExtension4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMarkerRightExtension4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightExtension4#rotTime"), 2)*1000;
        self.rotationPartMarkerRightExtension4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightExtension4#touchRotLimit"), 10));
    end;

	local rotationPartNodeMarkerLeftHydraulics = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftHydraulics#index"));
    if rotationPartNodeMarkerLeftHydraulics ~= nil then
        self.rotationPartMarkerLeftHydraulics = {};
        self.rotationPartMarkerLeftHydraulics.node = rotationPartNodeMarkerLeftHydraulics;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftHydraulics#minRot"));
        self.rotationPartMarkerLeftHydraulics.minRot = {};
        self.rotationPartMarkerLeftHydraulics.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerLeftHydraulics.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerLeftHydraulics.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftHydraulics#maxRot"));
        self.rotationPartMarkerLeftHydraulics.maxRot = {};
        self.rotationPartMarkerLeftHydraulics.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerLeftHydraulics.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerLeftHydraulics.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMarkerLeftHydraulics.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftHydraulics#rotTime"), 2)*1000;
        self.rotationPartMarkerLeftHydraulics.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerLeftHydraulics#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeMarkerRightHydraulics = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartMarkerRightHydraulics#index"));
    if rotationPartNodeMarkerRightHydraulics ~= nil then
        self.rotationPartMarkerRightHydraulics = {};
        self.rotationPartMarkerRightHydraulics.node = rotationPartNodeMarkerRightHydraulics;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightHydraulics#minRot"));
        self.rotationPartMarkerRightHydraulics.minRot = {};
        self.rotationPartMarkerRightHydraulics.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerRightHydraulics.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerRightHydraulics.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightHydraulics#maxRot"));
        self.rotationPartMarkerRightHydraulics.maxRot = {};
        self.rotationPartMarkerRightHydraulics.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMarkerRightHydraulics.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMarkerRightHydraulics.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMarkerRightHydraulics.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightHydraulics#rotTime"), 2)*1000;
        self.rotationPartMarkerRightHydraulics.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMarkerRightHydraulics#touchRotLimit"), 10));
    end;

	local translationPartMarkerLeftHydraulicsNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartMarkerLeftHydraulics#index"));
    if translationPartMarkerLeftHydraulicsNode ~= nil then
        self.translationPartMarkerLeftHydraulics = {};
        self.translationPartMarkerLeftHydraulics.node = translationPartMarkerLeftHydraulicsNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartMarkerLeftHydraulics#minTrans"));
        self.translationPartMarkerLeftHydraulics.minTrans = {};
        self.translationPartMarkerLeftHydraulics.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartMarkerLeftHydraulics.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartMarkerLeftHydraulics.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartMarkerLeftHydraulics#maxTrans"));
        self.translationPartMarkerLeftHydraulics.maxTrans = {};
        self.translationPartMarkerLeftHydraulics.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartMarkerLeftHydraulics.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartMarkerLeftHydraulics.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartMarkerLeftHydraulics.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartMarkerLeftHydraulics#transTime"), 2)*1000;
        self.translationPartMarkerLeftHydraulics.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartMarkerLeftHydraulics#touchTransLimit"), 10);
    end;

	local translationPartMarkerRightHydraulicsNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartMarkerRightHydraulics#index"));
    if translationPartMarkerRightHydraulicsNode ~= nil then
        self.translationPartMarkerRightHydraulics = {};
        self.translationPartMarkerRightHydraulics.node = translationPartMarkerRightHydraulicsNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartMarkerRightHydraulics#minTrans"));
        self.translationPartMarkerRightHydraulics.minTrans = {};
        self.translationPartMarkerRightHydraulics.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartMarkerRightHydraulics.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartMarkerRightHydraulics.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartMarkerRightHydraulics#maxTrans"));
        self.translationPartMarkerRightHydraulics.maxTrans = {};
        self.translationPartMarkerRightHydraulics.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartMarkerRightHydraulics.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartMarkerRightHydraulics.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartMarkerRightHydraulics.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartMarkerRightHydraulics#transTime"), 2)*1000;
        self.translationPartMarkerRightHydraulics.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartMarkerRightHydraulics#touchTransLimit"), 10);
    end;

	local rotationPartNodeMainbodyLifterHydraulics = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartMainbodyLifterHydraulics#index"));
    if rotationPartNodeMainbodyLifterHydraulics ~= nil then
        self.rotationPartMainbodyLifterHydraulics = {};
        self.rotationPartMainbodyLifterHydraulics.node = rotationPartNodeMainbodyLifterHydraulics;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMainbodyLifterHydraulics#minRot"));
        self.rotationPartMainbodyLifterHydraulics.minRot = {};
        self.rotationPartMainbodyLifterHydraulics.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMainbodyLifterHydraulics.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMainbodyLifterHydraulics.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMainbodyLifterHydraulics#maxRot"));
        self.rotationPartMainbodyLifterHydraulics.maxRot = {};
        self.rotationPartMainbodyLifterHydraulics.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMainbodyLifterHydraulics.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMainbodyLifterHydraulics.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMainbodyLifterHydraulics.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMainbodyLifterHydraulics#rotTime"), 2)*1000;
        self.rotationPartMainbodyLifterHydraulics.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMainbodyLifterHydraulics#touchRotLimit"), 10));
    end;

	local translationPartMainbodyLifterHydraulicsNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartMainbodyLifterHydraulics#index"));
    if translationPartMainbodyLifterHydraulicsNode ~= nil then
        self.translationPartMainbodyLifterHydraulics = {};
        self.translationPartMainbodyLifterHydraulics.node = translationPartMainbodyLifterHydraulicsNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartMainbodyLifterHydraulics#minTrans"));
        self.translationPartMainbodyLifterHydraulics.minTrans = {};
        self.translationPartMainbodyLifterHydraulics.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartMainbodyLifterHydraulics.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartMainbodyLifterHydraulics.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartMainbodyLifterHydraulics#maxTrans"));
        self.translationPartMainbodyLifterHydraulics.maxTrans = {};
        self.translationPartMainbodyLifterHydraulics.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartMainbodyLifterHydraulics.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartMainbodyLifterHydraulics.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartMainbodyLifterHydraulics.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartMainbodyLifterHydraulics#transTime"), 2)*1000;
        self.translationPartMainbodyLifterHydraulics.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartMainbodyLifterHydraulics#touchTransLimit"), 10);
    end;

	local rotationPartNodeLeftExtLifterHydraulics = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeftExtLifterHydraulics#index"));
    if rotationPartNodeLeftExtLifterHydraulics ~= nil then
        self.rotationPartLeftExtLifterHydraulics = {};
        self.rotationPartLeftExtLifterHydraulics.node = rotationPartNodeLeftExtLifterHydraulics;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeftExtLifterHydraulics#minRot"));
        self.rotationPartLeftExtLifterHydraulics.minRot = {};
        self.rotationPartLeftExtLifterHydraulics.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeftExtLifterHydraulics.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeftExtLifterHydraulics.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeftExtLifterHydraulics#maxRot"));
        self.rotationPartLeftExtLifterHydraulics.maxRot = {};
        self.rotationPartLeftExtLifterHydraulics.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeftExtLifterHydraulics.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeftExtLifterHydraulics.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeftExtLifterHydraulics.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeftExtLifterHydraulics#rotTime"), 2)*1000;
        self.rotationPartLeftExtLifterHydraulics.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeftExtLifterHydraulics#touchRotLimit"), 10));
    end;

	local translationPartLeftExtLifterHydraulicsNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartLeftExtLifterHydraulics#index"));
    if translationPartLeftExtLifterHydraulicsNode ~= nil then
        self.translationPartLeftExtLifterHydraulics = {};
        self.translationPartLeftExtLifterHydraulics.node = translationPartLeftExtLifterHydraulicsNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartLeftExtLifterHydraulics#minTrans"));
        self.translationPartLeftExtLifterHydraulics.minTrans = {};
        self.translationPartLeftExtLifterHydraulics.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartLeftExtLifterHydraulics.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartLeftExtLifterHydraulics.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartLeftExtLifterHydraulics#maxTrans"));
        self.translationPartLeftExtLifterHydraulics.maxTrans = {};
        self.translationPartLeftExtLifterHydraulics.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartLeftExtLifterHydraulics.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartLeftExtLifterHydraulics.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartLeftExtLifterHydraulics.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartLeftExtLifterHydraulics#transTime"), 2)*1000;
        self.translationPartLeftExtLifterHydraulics.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartLeftExtLifterHydraulics#touchTransLimit"), 10);
    end;

	local rotationPartNodeRightExtLifterHydraulics = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRightExtLifterHydraulics#index"));
    if rotationPartNodeRightExtLifterHydraulics ~= nil then
        self.rotationPartRightExtLifterHydraulics = {};
        self.rotationPartRightExtLifterHydraulics.node = rotationPartNodeRightExtLifterHydraulics;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRightExtLifterHydraulics#minRot"));
        self.rotationPartRightExtLifterHydraulics.minRot = {};
        self.rotationPartRightExtLifterHydraulics.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRightExtLifterHydraulics.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRightExtLifterHydraulics.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRightExtLifterHydraulics#maxRot"));
        self.rotationPartRightExtLifterHydraulics.maxRot = {};
        self.rotationPartRightExtLifterHydraulics.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRightExtLifterHydraulics.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRightExtLifterHydraulics.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRightExtLifterHydraulics.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRightExtLifterHydraulics#rotTime"), 2)*1000;
        self.rotationPartRightExtLifterHydraulics.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRightExtLifterHydraulics#touchRotLimit"), 10));
    end;

	local translationPartRightExtLifterHydraulicsNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartRightExtLifterHydraulics#index"));
    if translationPartRightExtLifterHydraulicsNode ~= nil then
        self.translationPartRightExtLifterHydraulics = {};
        self.translationPartRightExtLifterHydraulics.node = translationPartRightExtLifterHydraulicsNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartRightExtLifterHydraulics#minTrans"));
        self.translationPartRightExtLifterHydraulics.minTrans = {};
        self.translationPartRightExtLifterHydraulics.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartRightExtLifterHydraulics.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartRightExtLifterHydraulics.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartRightExtLifterHydraulics#maxTrans"));
        self.translationPartRightExtLifterHydraulics.maxTrans = {};
        self.translationPartRightExtLifterHydraulics.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartRightExtLifterHydraulics.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartRightExtLifterHydraulics.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartRightExtLifterHydraulics.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartRightExtLifterHydraulics#transTime"), 2)*1000;
        self.translationPartRightExtLifterHydraulics.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartRightExtLifterHydraulics#touchTransLimit"), 10);
    end;

	local translationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart#index"));
    if translationPartNode ~= nil then
        self.translationPart = {};
        self.translationPart.node = translationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#minTrans"));
        self.translationPart.minTrans = {};
        self.translationPart.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#maxTrans"));
        self.translationPart.maxTrans = {};
        self.translationPart.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#transTime"), 2)*1000;
        self.translationPart.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#touchTransLimit"), 10);
    end;
	
	self.downPosition = false;
	self.leftExtended = false;
	self.rightExtended = false;
	self.leftMarker = false;
	self.rightMarker = false;

      self.rotationMaxMainBody = true;
	self.rotationMaxLeftExtension = false;
	self.rotationMaxRightExtension = false;

	self.rotationMaxExtLifters = false;

	self.rotationMaxMarkerLeft = false;
	self.rotationMaxMarkerRight = false;

	self.applyingFertilizer = false;
	self.isLifting = false;
	self.isLowering = false;
	self.lastLiftRotation = 0;

    	self.fillLevel = 0;
    	self.stop = false; 
end;

function JD1760:delete()
    Utils.deleteParticleSystem(self.groundParticleSystems);

    if self.sowingSound ~= nil then
        delete(self.sowingSound);
    end;
end;

function JD1760:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JD1760:keyEvent(unicode, sym, modifier, isDown)	
	if isDown and sym == Input.KEY_n then
		self.rotationMaxMainBody = not self.rotationMaxMainBody;
		--if self.rotationMaxLeftExtension then
		  --self.rotationMaxExtLifters = self.rotationMaxMainBody;
		--end;
	end;

	if isDown and sym == Input.KEY_b then
	    if self.rotationMaxMainBody then
		self.rotationMaxLeftExtension = not self.rotationMaxLeftExtension;
		self.rotationMaxRightExtension = not self.rotationMaxRightExtension;
	    end;
	end;

	if isDown and sym == Input.KEY_KP_1 then
		self.rotationMaxMarkerLeft = true;
		self.rotationMaxMarkerRight = false;
	end;

	if isDown and sym == Input.KEY_KP_3 then
		self.rotationMaxMarkerLeft = false;
		self.rotationMaxMarkerRight = true;
	end;
	
	if isDown and sym == Input.KEY_KP_2 then
		self.rotationMaxMarkerLeft = false;
		self.rotationMaxMarkerRight = false;
	end;

	if isDown and sym == Input.KEY_j then
		self.applyingFertilizer = not self.applyingFertilizer;
	end;


    if isDown and sym ==  Input.KEY_0 then
	local currentFillLevel = self.fillLevel - self.grainUnloading;
	if currentFillLevel > 0 then
		self:setFillLevel(self.fillLevel - self.grainUnloading, self.currentFillType);
	else
		self:setFillLevel(0, self.currentFillType);
	end;
    end;

    
		
      local trailer = g_currentMission.objectToTrailer[self.trailerFound];
	if self.trailerFound ~= 0 and self.fillTypes[trailer.currentFillType] == true then
    		if self.currentFillType == trailer.currentFillType or self.fillLevel == 0 then
			if isDown and sym == Input.KEY_m then
          			local deltaLevel = self.grainUnloading;
	    			deltaLevel = math.min(deltaLevel, trailer.capacity - trailer.fillLevel);
				self.currentFillType = trailer.currentFillType;

	    			self.fillLevel = self.fillLevel+deltaLevel;
	    			if self.fillLevel >= self.capacity then
	         			self.fillLevel = self.capacity;
		    			self.activeUnloading = false;
	    			end;
	    			if trailer.fillLevel <= 0.0 then
	          			trailer.fillLevel = 0.0;
		    			trailer.currentFillType = FruitUtil.FRUITTYPE_UNKNOWN;
		    			self.activeUnloading = false;
	    			end;
	    			self:setFillLevel(self.fillLevel, trailer.currentFillType);
	    			trailer:setFillLevel(trailer.fillLevel-deltaLevel, trailer.currentFillType);
			end;
		end;
    end;
end;

function JD1760:update(dt)	
	
	if self.fillLevel == 0 then
		self.currentFillType = FruitUtil.FRUITTYPE_UNKNOWN;
	else
		self.currentFillType = self.currentFillType;
	end;
	
	if self.translationMax ~= nil then
		local x, y, z = getTranslation(self.translationPart.node);
        	local trans = {x,y,z};
        	local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart.maxTrans, self.translationPart.minTrans, 3, self.translationPart.transTime, dt, not self.translationMax);
        	setTranslation(self.translationPart.node, unpack(newTrans));
	end;

		self.translationMax = false;

	if self.attacherVehicle then
		self.trailerFound = 0;
		local x,y,z = getWorldTranslation(self.trailerPosition);
    		raycastAll(x, y, z, 0, -1, 0, "findTrailerRaycastCallback", 10, self);

		self.translationMax = true;


	  self.downPosition = false;
	  if self.rotationPartMainBody ~= nil then
            local x, y, z = getRotation(self.rotationPartMainBody.node);
            local minRot = self.rotationPartMainBody.minRot;
            local eps = self.rotationPartMainBody.touchRotLimit;

            if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
                self.downPosition = true;
            end;
        end;

	  self.leftExtended = false;
	  if self.rotationPartLeftExtension ~= nil then
            local x, y, z = getRotation(self.rotationPartLeftExtension.node);
            local maxRot = self.rotationPartLeftExtension.maxRot;
            local eps = self.rotationPartLeftExtension.touchRotLimit;

            if math.abs(maxRot[1]-x) < eps and math.abs(maxRot[2]-y) < eps and math.abs(maxRot[3]-z) < eps then
                self.leftExtended = true;
            end;
        end;

	  self.rightExtended = false;
	  if self.rotationPartRightExtension ~= nil then
            local x, y, z = getRotation(self.rotationPartRightExtension.node);
            local maxRot = self.rotationPartRightExtension.maxRot;
            local eps = self.rotationPartRightExtension.touchRotLimit;

            if math.abs(maxRot[1]-x) < eps and math.abs(maxRot[2]-y) < eps and math.abs(maxRot[3]-z) < eps then
                self.rightExtended = true;
            end;
        end;

	  self.leftExtensionLifterDown = false;
	  if self.rotationPartRightExtLifter ~= nil then
            local x, y, z = getRotation(self.rotationPartRightExtLifter.node);
            local maxRot = self.rotationPartRightExtLifter.maxRot;
            local eps = self.rotationPartRightExtLifter.touchRotLimit;

            if math.abs(maxRot[1]-x) < eps and math.abs(maxRot[2]-y) < eps and math.abs(maxRot[3]-z) < eps then
                self.leftExtensionLifterDown = true;
            end;
        end;

	  self.rightExtensionLifterDown = false;
	  if self.rotationPartLeftExtLifter ~= nil then
            local x, y, z = getRotation(self.rotationPartLeftExtLifter.node);
            local maxRot = self.rotationPartLeftExtLifter.maxRot;
            local eps = self.rotationPartLeftExtLifter.touchRotLimit;

            if math.abs(maxRot[1]-x) < eps and math.abs(maxRot[2]-y) < eps and math.abs(maxRot[3]-z) < eps then
                self.rightExtensionLifterDown = true;
            end;
        end;

	  self.leftMarker = false;
	  if self.rotationPartMarkerLeftInner ~= nil then
            local x, y, z = getRotation(self.rotationPartMarkerLeftInner.node);
            local maxRot = self.rotationPartMarkerLeftInner.maxRot;
            local eps = self.rotationPartMarkerLeftInner.touchRotLimit;

            if math.abs(maxRot[1]-x) < eps and math.abs(maxRot[2]-y) < eps and math.abs(maxRot[3]-z) < eps then
                self.leftMarker = true;
            end;
        end;

	  self.rightMarker = false;
	  if self.rotationPartMarkerRightInner ~= nil then
            local x, y, z = getRotation(self.rotationPartMarkerRightInner.node);
            local maxRot = self.rotationPartMarkerRightInner.maxRot;
            local eps = self.rotationPartMarkerRightInner.touchRotLimit;

            if math.abs(maxRot[1]-x) < eps and math.abs(maxRot[2]-y) < eps and math.abs(maxRot[3]-z) < eps then
                self.rightMarker = true;
            end;
        end;

		if not self.downPosition or self.attacherVehicle.lastSpeed*3600 < 3 then
			if self.sowingSoundEnabled then
			stopSample(self.sowingSound);
			self.sowingSoundEnabled = false;
			end;
		end;

		if self.attacherVehicle.isEntered and self.downPosition and self.attacherVehicle.lastSpeed*3600 > 3  then
			if not self.sowingSoundEnabled then
                	playSample(self.sowingSound, 0, 0.4, 0);
                	self.sowingSoundEnabled = true;
			end;
		end;


	  if self.leftExtended and self.rightExtended then
		self.rotationMaxExtLifters = self.rotationMaxMainBody
	  else
	      self.rotationMaxExtLifters = false;
		self.rotationMaxMarkerLeft = false;
		self.rotationMaxMarkerRight = false;
	  end

	  --if self.leftExtended == false or self.rightExtended == false then
		--self.rotationMaxExtLifters = false;
	    --end;


	  if self.wheel1 ~= nil then
		  local x, y, z = getRotation(self.wheels[1].repr);
		  setRotation(self.wheel1, x,y,z);
		  if self.isLifting then 
	        	setRotation(self.wheels[1].repr, x+0.005,y,z);
		  elseif self.isLowering then
			setRotation(self.wheels[1].repr, x-0.005,y,z);
		  end;
	  end;

	  if self.wheel2 ~= nil then
		  local x, y, z = getRotation(self.wheels[2].repr);
		  setRotation(self.wheel2, x,y,z);
		  if self.isLifting then 
	        	setRotation(self.wheels[2].repr, x+0.005,y,z);
		  elseif self.isLowering then
			setRotation(self.wheels[2].repr, x-0.005,y,z);
		  end;
	  end;

	  if self.wheel3 ~= nil then
		  local x, y, z = getRotation(self.wheels[3].repr);
		  setRotation(self.wheel3, x,y,z);
		  if self.isLifting then 
	        	setRotation(self.wheels[3].repr, x+0.005,y,z);
		  elseif self.isLowering then
			setRotation(self.wheels[3].repr, x-0.005,y,z);
		  end;
	  end;

	  if self.wheel4 ~= nil then
		  local x, y, z = getRotation(self.wheels[4].repr);
		  setRotation(self.wheel4, x,y,z);
		  if self.isLifting then 
	        	setRotation(self.wheels[4].repr, x+0.005,y,z);
		  elseif self.isLowering then
			setRotation(self.wheels[4].repr, x-0.005,y,z);
		  end;

	  end;

	  if self.wheel5 ~= nil then
		  local x, y, z = getRotation(self.wheels[5].repr);
		  if self.leftExtended then
		     if not self.LeftExtensionLifterDown or self.downPosition then 
			  setRotation(self.wheel5, x,y,z);
		     end;
		  end;
		  if self.isLifting then 
	        	setRotation(self.wheels[5].repr, x+0.005,y,z);
		  elseif self.isLowering then
			setRotation(self.wheels[5].repr, x-0.005,y,z);
		  end;

	  end;

	  if self.wheel6 ~= nil then
		  local x, y, z = getRotation(self.wheels[6].repr);
		  if self.rightExtended then
		     if not self.RightExtensionLifterDown or self.downPosition then
		  	  setRotation(self.wheel6, x,y,z);
		     end;
		  end;
		  if self.isLifting then 
	        	setRotation(self.wheels[6].repr, x+0.005,y,z);
		  elseif self.isLowering then
			setRotation(self.wheels[6].repr, x-0.005,y,z);
		  end;
	  end;

	  if self.fertilizerDiscLeft ~= nil then
		  local x, y, z = getRotation(self.wheels[5].repr);
		  if self.leftExtended then
		     if self.downPosition then
		  	  setRotation(self.fertilizerDiscLeft, x * 1.5,y,z);
		     end;
		  end;
	   end;

	  if self.fertilizerDiscMiddle ~= nil then
		  local x, y, z = getRotation(self.wheels[2].repr);
		  if self.downPosition then
		  	setRotation(self.fertilizerDiscMiddle, x * 1.5,y,z);
		  end;
	   end;

	  if self.fertilizerDiscRight ~= nil then
		  local x, y, z = getRotation(self.wheels[6].repr);
		  if self.rightExtended then
		     if self.downPosition then
		  	  setRotation(self.fertilizerDiscRight, x * 1.5,y,z);
		     end;
		  end;
	   end;

	  if self.seedDiscLeft ~= nil then
		  local x, y, z = getRotation(self.wheels[5].repr);
		  if self.leftExtended then
		     if self.downPosition then
		  	  setRotation(self.seedDiscLeft, x * 1.5,y,z);
		     end;
		  end;
	   end;

	  if self.seedDiscMiddle ~= nil then
		  local x, y, z = getRotation(self.wheels[2].repr);
		  if self.downPosition then
		  	setRotation(self.seedDiscMiddle, x * 1.5,y,z);
		  end;
	   end;

	  if self.seedDiscRight ~= nil then
		  local x, y, z = getRotation(self.wheels[6].repr);
		  if self.rightExtended then
		     if self.downPosition then
		  	  setRotation(self.seedDiscRight, x * 1.5,y,z);
		     end;
		  end;
	   end;

	  if self.levelWheelLeft ~= nil then
		  local x, y, z = getRotation(self.wheels[5].repr);
		  if self.leftExtended then
		     if self.downPosition then
		  	  setRotation(self.levelWheelLeft, x * 1.3,y,z);
		     end;
		  end;
	   end;

	  if self.levelWheelMiddle ~= nil then
		  local x, y, z = getRotation(self.wheels[2].repr);
		  if self.downPosition then
		  	setRotation(self.levelWheelMiddle, x * 1.3,y,z);
		  end;
	   end;

	  if self.levelWheelRight ~= nil then
		  local x, y, z = getRotation(self.wheels[6].repr);
		  if self.rightExtended then
		     if self.downPosition then
		  	  setRotation(self.levelWheelRight, x * 1.3,y,z);
		     end;
		  end;
	   end;

-------- seed cowering wheels left start

	  if self.seedCowerDiscLeft1 ~= nil then
		  local x, y, z = getRotation(self.wheels[5].repr);
		  if self.downPosition then
		  	if self.leftExtended then
		  		setRotation(self.seedCowerDiscLeft1, x * 2,y,z);
		  	end;
		  end;
	   end;

	  if self.seedCowerDiscLeft2 ~= nil then
		  local x, y, z = getRotation(self.wheels[5].repr);
		  if self.leftExtended then
		  	if self.downPosition then
		  		setRotation(self.seedCowerDiscLeft2, x * -2,y,z);
		  	end;
		  end;
	   end;

	  if self.seedCowerDiscLeft3 ~= nil then
		  local x, y, z = getRotation(self.wheels[5].repr);
		  if self.leftExtended then
		  	if self.downPosition then
		  		setRotation(self.seedCowerDiscLeft3, x * 2,y,z);
		  	end;
		  end;
	   end;

	  if self.seedCowerDiscLeft4 ~= nil then
		  local x, y, z = getRotation(self.wheels[5].repr);
		  if self.downPosition then
		  	if self.leftExtended then
		  		setRotation(self.seedCowerDiscLeft4, x * -2,y,z);
		  	end;
		  end;
	   end;

	  if self.seedCowerDiscLeft5 ~= nil then
		  local x, y, z = getRotation(self.wheels[1].repr);
		  if self.leftExtended then
		  	if self.downPosition then
		  		setRotation(self.seedCowerDiscLeft5, x * 2,y,z);
		  	end;
		  end;
	   end;

	  if self.seedCowerDiscLeft6 ~= nil then
		  local x, y, z = getRotation(self.wheels[1].repr);
		  if self.leftExtended then
		  	if self.downPosition then
		  		setRotation(self.seedCowerDiscLeft6, x * -2,y,z);
		  	end;
		  end;
	   end;

-------- seed cowering wheels left start
-------- seed cowering wheels middle start

	  if self.seedCowerDiscMiddle1 ~= nil then
		  local x, y, z = getRotation(self.wheels[1].repr);
		  if self.downPosition then
		  	setRotation(self.seedCowerDiscMiddle1, x * 2,y,z);
		  end;
	   end;

	  if self.seedCowerDiscMiddle2 ~= nil then
		  local x, y, z = getRotation(self.wheels[1].repr);
		  if self.downPosition then
		  	setRotation(self.seedCowerDiscMiddle2, x * -2,y,z);
		  end;
	   end;

	  if self.seedCowerDiscMiddle3 ~= nil then
		  local x, y, z = getRotation(self.wheels[1].repr);
		  if self.downPosition then
		  	setRotation(self.seedCowerDiscMiddle3, x * 2,y,z);
		  end;
	   end;

	  if self.seedCowerDiscMiddle4 ~= nil then
		  local x, y, z = getRotation(self.wheels[2].repr);
		  if self.downPosition then
		  	setRotation(self.seedCowerDiscMiddle4, x * -2,y,z);
		  end;
	   end;

	  if self.seedCowerDiscMiddle5 ~= nil then
		  local x, y, z = getRotation(self.wheels[2].repr);
		  if self.downPosition then
		  	setRotation(self.seedCowerDiscMiddle5, x * 2,y,z);
		  end;
	   end;

	  if self.seedCowerDiscMiddle6 ~= nil then
		  local x, y, z = getRotation(self.wheels[2].repr);
		  if self.downPosition then
		  	setRotation(self.seedCowerDiscMiddle6, x * -2,y,z);
		  end;
	   end;

	  if self.seedCowerDiscMiddle7 ~= nil then
		  local x, y, z = getRotation(self.wheels[3].repr);
		  if self.downPosition then
		  	setRotation(self.seedCowerDiscMiddle7, x * 2,y,z);
		  end;
	   end;

	  if self.seedCowerDiscMiddle8 ~= nil then
		  local x, y, z = getRotation(self.wheels[3].repr);
		  if self.downPosition then
		  	setRotation(self.seedCowerDiscMiddle8, x * -2,y,z);
		  end;
	   end;

	  if self.seedCowerDiscMiddle9 ~= nil then
		  local x, y, z = getRotation(self.wheels[3].repr);
		  if self.downPosition then
		  	setRotation(self.seedCowerDiscMiddle9, x * 2,y,z);
		  end;
	   end;

	  if self.seedCowerDiscMiddle10 ~= nil then
		  local x, y, z = getRotation(self.wheels[4].repr);
		  if self.downPosition then
		  	setRotation(self.seedCowerDiscMiddle10, x * -2,y,z);
		  end;
	   end;

	  if self.seedCowerDiscMiddle11 ~= nil then
		  local x, y, z = getRotation(self.wheels[4].repr);
		  if self.downPosition then
		  	setRotation(self.seedCowerDiscMiddle11, x * 2,y,z);
		  end;
	   end;

	  if self.seedCowerDiscMiddle12 ~= nil then
		  local x, y, z = getRotation(self.wheels[4].repr);
		  if self.downPosition then
		  	setRotation(self.seedCowerDiscMiddle12, x * -2,y,z);
		  end;
	   end;
-------- seed cowering wheels middle stop

-------- seed cowering wheels right start

	  if self.seedCowerDiscRight1 ~= nil then
		  local x, y, z = getRotation(self.wheels[6].repr);
		  if self.rightExtended then
		  	if self.downPosition then
		  		setRotation(self.seedCowerDiscRight1, x * 2,y,z);
		  	end;
		  end;
	   end;

	  if self.seedCowerDiscRight2 ~= nil then
		  local x, y, z = getRotation(self.wheels[6].repr);
		  if self.rightExtended then
		  	if self.downPosition then
		  		setRotation(self.seedCowerDiscRight2, x * -2,y,z);
		  	end;
		  end;
	   end;

	  if self.seedCowerDiscRight3 ~= nil then
		  local x, y, z = getRotation(self.wheels[6].repr);
		  if self.rightExtended then
		  	if self.downPosition then
		  		setRotation(self.seedCowerDiscRight3, x * 2,y,z);
		  	end;
		  end;
	   end;

	  if self.seedCowerDiscRight4 ~= nil then
		  local x, y, z = getRotation(self.wheels[6].repr);
		  if self.downPosition then
		  	if self.RightExtended then
		  		setRotation(self.seedCowerDiscRight4, x * -2,y,z);
		  	end;
		  end;
	   end;

	  if self.seedCowerDiscRight5 ~= nil then
		  local x, y, z = getRotation(self.wheels[4].repr);
		  if self.rightExtended then
		  	if self.downPosition then
		  		setRotation(self.seedCowerDiscRight5, x * 2,y,z);
		  	end;
		  end;
	   end;

	  if self.seedCowerDiscRight6 ~= nil then
		  local x, y, z = getRotation(self.wheels[4].repr);
		  if self.rightExtended then
		  	if self.downPosition then
		  		setRotation(self.seedCowerDiscRight6, x * -2,y,z);
		  	end;
		  end;
	   end;

-------- seed cowering wheels right stop

-------- marker wheels start
	  if self.markerDiscLeft ~= nil then
		  local x, y, z = getRotation(self.wheels[5].repr);
		  if self.leftMarker then
		  	if self.downPosition then
		  		setRotation(self.markerDiscLeft, x * 1.2,Utils.degToRad(180),0);
		  	end;
		  end;
	   end;

	  if self.markerDiscRight ~= nil then
		  local x, y, z = getRotation(self.wheels[6].repr);
		  if self.rightMarker then
		  	if self.downPosition then
		  		setRotation(self.markerDiscRight, x * -1.2,Utils.degToRad(180),0);
		  	end;
		  end;
	   end;
-------- marker wheels stop

	  if self.rotationPartMainBody ~= nil then
		local x, y, z = getRotation(self.rotationPartMainBody.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMainBody.maxRot, self.rotationPartMainBody.minRot, 3, self.rotationPartMainBody.rotTime, dt, not self.rotationMaxMainBody);
		setRotation(self.rotationPartMainBody.node, unpack(newRot));
		
		if self.lastLiftRotation < x then
		  	self.isLifting = true;
			self.isLowering = false;
			--renderText(0.88, 0.2, 0.02, "Is lifting");
		elseif self.lastLiftRotation > x then
			 self.isLifting = false;
			self.isLowering = true;
			--renderText(0.88, 0.2, 0.02, "Is lowering");
		elseif self.lastLiftRotation == x then
			 self.isLifting = false;
			self.isLowering = false;
			--renderText(0.88, 0.2, 0.02, "Not moving");
		end;

		self.lastLiftRotation = x; 
	  end;

	  if self.rotationPartMainBodyLifters ~= nil then
		local x, y, z = getRotation(self.rotationPartMainBodyLifters.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMainBodyLifters.maxRot, self.rotationPartMainBodyLifters.minRot, 3, self.rotationPartMainBodyLifters.rotTime, dt, not self.rotationMaxMainBody);
		setRotation(self.rotationPartMainBodyLifters.node, unpack(newRot));
	  end;

	 if self.rotationPartLeftExtLifter ~= nil then
		local x, y, z = getRotation(self.rotationPartLeftExtLifter.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeftExtLifter.maxRot, self.rotationPartLeftExtLifter.minRot, 3, self.rotationPartLeftExtLifter.rotTime, dt, not self.rotationMaxExtLifters);
		setRotation(self.rotationPartLeftExtLifter.node, unpack(newRot));
	  end;

	 if self.rotationPartRightExtLifter ~= nil then
		local x, y, z = getRotation(self.rotationPartRightExtLifter.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRightExtLifter.maxRot, self.rotationPartRightExtLifter.minRot, 3, self.rotationPartRightExtLifter.rotTime, dt, not self.rotationMaxExtLifters);
		setRotation(self.rotationPartRightExtLifter.node, unpack(newRot));
	  end;

	 if self.rotationPartLeftExtension ~= nil then
		local x, y, z = getRotation(self.rotationPartLeftExtension.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeftExtension.maxRot, self.rotationPartLeftExtension.minRot, 3, self.rotationPartLeftExtension.rotTime, dt, not self.rotationMaxLeftExtension);
		setRotation(self.rotationPartLeftExtension.node, unpack(newRot));
	  end;

	 if self.rotationPartRightExtension ~= nil then
		local x, y, z = getRotation(self.rotationPartRightExtension.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRightExtension.maxRot, self.rotationPartRightExtension.minRot, 3, self.rotationPartRightExtension.rotTime, dt, not self.rotationMaxRightExtension);
		setRotation(self.rotationPartRightExtension.node, unpack(newRot));
	  end;

	if self.rotationPartMarkerLeftInner ~= nil then
		local x, y, z = getRotation(self.rotationPartMarkerLeftInner.node);
		local rot = {x,y,z};	
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMarkerLeftInner.maxRot, self.rotationPartMarkerLeftInner.minRot, 3, self.rotationPartMarkerLeftInner.rotTime, dt, not self.rotationMaxMarkerLeft);
		setRotation(self.rotationPartMarkerLeftInner.node, unpack(newRot));
	end;

	if self.rotationPartMarkerRightInner ~= nil then
		local x, y, z = getRotation(self.rotationPartMarkerRightInner.node);
		local rot = {x,y,z};	
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMarkerRightInner.maxRot, self.rotationPartMarkerRightInner.minRot, 3, self.rotationPartMarkerRightInner.rotTime, dt, not self.rotationMaxMarkerRight);
		setRotation(self.rotationPartMarkerRightInner.node, unpack(newRot));
	end;

	if self.rotationPartMarkerLeftMiddle ~= nil then
		local x, y, z = getRotation(self.rotationPartMarkerLeftMiddle.node);
		local rot = {x,y,z};	
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMarkerLeftMiddle.maxRot, self.rotationPartMarkerLeftMiddle.minRot, 3, self.rotationPartMarkerLeftMiddle.rotTime, dt, not self.rotationMaxMarkerLeft);
		setRotation(self.rotationPartMarkerLeftMiddle.node, unpack(newRot));
	end;

	if self.rotationPartMarkerRightMiddle ~= nil then
		local x, y, z = getRotation(self.rotationPartMarkerRightMiddle.node);
		local rot = {x,y,z};	
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMarkerRightMiddle.maxRot, self.rotationPartMarkerRightMiddle.minRot, 3, self.rotationPartMarkerRightMiddle.rotTime, dt, not self.rotationMaxMarkerRight);
		setRotation(self.rotationPartMarkerRightMiddle.node, unpack(newRot));
	end;

	if self.rotationPartMarkerLeftOuter ~= nil then
		local x, y, z = getRotation(self.rotationPartMarkerLeftOuter.node);
		local rot = {x,y,z};	
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMarkerLeftOuter.maxRot, self.rotationPartMarkerLeftOuter.minRot, 3, self.rotationPartMarkerLeftOuter.rotTime, dt, not self.rotationMaxMarkerLeft);
		setRotation(self.rotationPartMarkerLeftOuter.node, unpack(newRot));
	end;

	if self.rotationPartMarkerRightOuter ~= nil then
		local x, y, z = getRotation(self.rotationPartMarkerRightOuter.node);
		local rot = {x,y,z};	
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMarkerRightOuter.maxRot, self.rotationPartMarkerRightOuter.minRot, 3, self.rotationPartMarkerRightOuter.rotTime, dt, not self.rotationMaxMarkerRight);
		setRotation(self.rotationPartMarkerRightOuter.node, unpack(newRot));
	end;

	if self.rotationPartMarkerLeftExtension1 ~= nil then
		local x, y, z = getRotation(self.rotationPartMarkerLeftExtension1.node);
		local rot = {x,y,z};	
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMarkerLeftExtension1.maxRot, self.rotationPartMarkerLeftExtension1.minRot, 3, self.rotationPartMarkerLeftExtension1.rotTime, dt, not self.rotationMaxMarkerLeft);
		setRotation(self.rotationPartMarkerLeftExtension1.node, unpack(newRot));
	end;

	if self.rotationPartMarkerRightExtension1 ~= nil then
		local x, y, z = getRotation(self.rotationPartMarkerRightExtension1.node);
		local rot = {x,y,z};	
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMarkerRightExtension1.maxRot, self.rotationPartMarkerRightExtension1.minRot, 3, self.rotationPartMarkerRightExtension1.rotTime, dt, not self.rotationMaxMarkerRight);
		setRotation(self.rotationPartMarkerRightExtension1.node, unpack(newRot));
	end;

	if self.rotationPartMarkerLeftExtension2 ~= nil then
		local x, y, z = getRotation(self.rotationPartMarkerLeftExtension2.node);
		local rot = {x,y,z};	
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMarkerLeftExtension2.maxRot, self.rotationPartMarkerLeftExtension2.minRot, 3, self.rotationPartMarkerLeftExtension2.rotTime, dt, not self.rotationMaxMarkerLeft);
		setRotation(self.rotationPartMarkerLeftExtension2.node, unpack(newRot));
	end;

	if self.rotationPartMarkerRightExtension2 ~= nil then
		local x, y, z = getRotation(self.rotationPartMarkerRightExtension2.node);
		local rot = {x,y,z};	
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMarkerRightExtension2.maxRot, self.rotationPartMarkerRightExtension2.minRot, 3, self.rotationPartMarkerRightExtension2.rotTime, dt, not self.rotationMaxMarkerRight);
		setRotation(self.rotationPartMarkerRightExtension2.node, unpack(newRot));
	end;

	if self.rotationPartMarkerLeftExtension3 ~= nil then
		local x, y, z = getRotation(self.rotationPartMarkerLeftExtension3.node);
		local rot = {x,y,z};	
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMarkerLeftExtension3.maxRot, self.rotationPartMarkerLeftExtension3.minRot, 3, self.rotationPartMarkerLeftExtension3.rotTime, dt, not self.rotationMaxMarkerLeft);
		setRotation(self.rotationPartMarkerLeftExtension3.node, unpack(newRot));
	end;

	if self.rotationPartMarkerRightExtension3 ~= nil then
		local x, y, z = getRotation(self.rotationPartMarkerRightExtension3.node);
		local rot = {x,y,z};	
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMarkerRightExtension3.maxRot, self.rotationPartMarkerRightExtension3.minRot, 3, self.rotationPartMarkerRightExtension3.rotTime, dt, not self.rotationMaxMarkerRight);
		setRotation(self.rotationPartMarkerRightExtension3.node, unpack(newRot));
	end;

	if self.rotationPartMarkerLeftExtension4 ~= nil then
		local x, y, z = getRotation(self.rotationPartMarkerLeftExtension4.node);
		local rot = {x,y,z};	
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMarkerLeftExtension4.maxRot, self.rotationPartMarkerLeftExtension4.minRot, 3, self.rotationPartMarkerLeftExtension4.rotTime, dt, not self.rotationMaxMarkerLeft);
		setRotation(self.rotationPartMarkerLeftExtension4.node, unpack(newRot));
	end;

	if self.rotationPartMarkerRightExtension4 ~= nil then
		local x, y, z = getRotation(self.rotationPartMarkerRightExtension4.node);
		local rot = {x,y,z};	
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMarkerRightExtension4.maxRot, self.rotationPartMarkerRightExtension4.minRot, 3, self.rotationPartMarkerRightExtension4.rotTime, dt, not self.rotationMaxMarkerRight);
		setRotation(self.rotationPartMarkerRightExtension4.node, unpack(newRot));
	end;

	if self.rotationPartMarkerLeftHydraulics ~= nil then
		local x, y, z = getRotation(self.rotationPartMarkerLeftHydraulics.node);
		local rot = {x,y,z};	
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMarkerLeftHydraulics.maxRot, self.rotationPartMarkerLeftHydraulics.minRot, 3, self.rotationPartMarkerLeftHydraulics.rotTime, dt, not self.rotationMaxMarkerLeft);
		setRotation(self.rotationPartMarkerLeftHydraulics.node, unpack(newRot));
	end;

	if self.rotationPartMarkerRightHydraulics ~= nil then
		local x, y, z = getRotation(self.rotationPartMarkerRightHydraulics.node);
		local rot = {x,y,z};	
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMarkerRightHydraulics.maxRot, self.rotationPartMarkerRightHydraulics.minRot, 3, self.rotationPartMarkerRightHydraulics.rotTime, dt, not self.rotationMaxMarkerRight);
		setRotation(self.rotationPartMarkerRightHydraulics.node, unpack(newRot));
	end;

	if self.translationPartMarkerLeftHydraulics ~= nil then
		local x, y, z = getTranslation(self.translationPartMarkerLeftHydraulics.node);
        	local trans = {x,y,z};
        	local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartMarkerLeftHydraulics.maxTrans, self.translationPartMarkerLeftHydraulics.minTrans, 3, self.translationPartMarkerLeftHydraulics.transTime, dt, not self.rotationMaxMarkerLeft);
        	setTranslation(self.translationPartMarkerLeftHydraulics.node, unpack(newTrans));
	end;

	if self.translationPartMarkerRightHydraulics ~= nil then
		local x, y, z = getTranslation(self.translationPartMarkerRightHydraulics.node);
        	local trans = {x,y,z};
        	local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartMarkerRightHydraulics.maxTrans, self.translationPartMarkerRightHydraulics.minTrans, 3, self.translationPartMarkerRightHydraulics.transTime, dt, not self.rotationMaxMarkerRight);
        	setTranslation(self.translationPartMarkerRightHydraulics.node, unpack(newTrans));
	end;

	if self.rotationPartMainbodyLifterHydraulics ~= nil then
		local x, y, z = getRotation(self.rotationPartMainbodyLifterHydraulics.node);
		local rot = {x,y,z};	
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMainbodyLifterHydraulics.maxRot, self.rotationPartMainbodyLifterHydraulics.minRot, 3, self.rotationPartMainbodyLifterHydraulics.rotTime, dt, not self.rotationMaxMainBody);
		setRotation(self.rotationPartMainbodyLifterHydraulics.node, unpack(newRot));
	end;

	if self.translationPartMainbodyLifterHydraulics ~= nil then
		local x, y, z = getTranslation(self.translationPartMainbodyLifterHydraulics.node);
        	local trans = {x,y,z};
        	local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartMainbodyLifterHydraulics.maxTrans, self.translationPartMainbodyLifterHydraulics.minTrans, 3, self.translationPartMainbodyLifterHydraulics.transTime, dt, not self.rotationMaxMainBody);
        	setTranslation(self.translationPartMainbodyLifterHydraulics.node, unpack(newTrans));
	end;

	if self.rotationPartLeftExtLifterHydraulics ~= nil then
		local x, y, z = getRotation(self.rotationPartLeftExtLifterHydraulics.node);
		local rot = {x,y,z};	
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeftExtLifterHydraulics.maxRot, self.rotationPartLeftExtLifterHydraulics.minRot, 3, self.rotationPartLeftExtLifterHydraulics.rotTime, dt, not self.rotationMaxExtLifters);
		setRotation(self.rotationPartLeftExtLifterHydraulics.node, unpack(newRot));
	end;

	if self.translationPartLeftExtLifterHydraulics ~= nil then
		local x, y, z = getTranslation(self.translationPartLeftExtLifterHydraulics.node);
        	local trans = {x,y,z};
        	local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartLeftExtLifterHydraulics.maxTrans, self.translationPartLeftExtLifterHydraulics.minTrans, 3, self.translationPartLeftExtLifterHydraulics.transTime, dt, not self.rotationMaxExtLifters);
        	setTranslation(self.translationPartLeftExtLifterHydraulics.node, unpack(newTrans));
	end;

	if self.rotationPartRightExtLifterHydraulics ~= nil then
		local x, y, z = getRotation(self.rotationPartRightExtLifterHydraulics.node);
		local rot = {x,y,z};	
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRightExtLifterHydraulics.maxRot, self.rotationPartRightExtLifterHydraulics.minRot, 3, self.rotationPartRightExtLifterHydraulics.rotTime, dt, not self.rotationMaxExtLifters);
		setRotation(self.rotationPartRightExtLifterHydraulics.node, unpack(newRot));
	end;

	if self.translationPartRightExtLifterHydraulics ~= nil then
		local x, y, z = getTranslation(self.translationPartRightExtLifterHydraulics.node);
        	local trans = {x,y,z};
        	local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartRightExtLifterHydraulics.maxTrans, self.translationPartRightExtLifterHydraulics.minTrans, 3, self.translationPartRightExtLifterHydraulics.transTime, dt, not self.rotationMaxExtLifters);
        	setTranslation(self.translationPartRightExtLifterHydraulics.node, unpack(newTrans));
	end;

	if self.leftMarker == true then
		if self.cuttingAreas[2] ~= nil and self.downPosition then
			local x,y,z = getWorldTranslation(self.cuttingAreas[2].start);
			local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[2].width);
			local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[2].height);

			Utils.updatePloughArea(x, z, x1, z1, x2, z2);
		end;
	end;

		
	if self.rightMarker == true then
		if self.cuttingAreas[3] ~= nil and self.downPosition then
			local x,y,z = getWorldTranslation(self.cuttingAreas[3].start);
			local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[3].width);
			local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[3].height);
				
			Utils.updatePloughArea(x, z, x1, z1, x2, z2);
	      end;
      end;

-- AI
	if self.attacherVehicle.isAITractorActivated then				
    		self.attacherVehicle.turnStage3Timeout = 0;
		self.rotationMaxMarkerLeft = false;
		self.rotationMaxMarkerRight = false;				
		if self.fillLevel == 0 then
			AITractor.stopAITractor(self.attacherVehicle);
			self.stop = true;
		end;
		if self.attacherVehicle.turnStage == 0 then
			self.rotationMaxMainBody = false;
		else
			self.rotationMaxMainBody = true;
		end;	
	else
		if self.fillLevel == self.capacity and self.stop then
			AITractor.startAITractor(self.attacherVehicle);
			self.rotationMaxMainBody = true;
			self.stop = false;
		end;
		if self.attacherVehicle.isAITractorActivated ~= nil then
			self.attacherVehicle.turnStage3Timeout = 20000;
		end; 	
	end;
-- AU end

--Sowing start
        if self.movingDirection > 0 and self.downPosition and self.leftExtended and self.rightExtended then
            Utils.setEmittingState(self.groundParticleSystems, self.lastSpeed*3600 > 5);
        	local x,y,z = getWorldTranslation(self.cuttingAreas[1].start);
            local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[1].width);
            local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[1].height);
            local area = 0;
		
		if self.fillLevel > 0 then
			area = Utils.updateSowingArea(self.currentFillType, x, z, x1, z1, x2, z2);
		else
			area = 0;
		end;

		if self.currentFillType ~= nil and self.currentFillType ~= FruitUtil.FRUITTYPE_UNKNOWN then 
            local fruitDesc = FruitUtil.fruitIndexToDesc[self.currentFillType];

            local pixelToQm = 2048 / 8192 * 2048 / 8192;
            local qm = area*pixelToQm;
            local ha = qm/10000;
		local speedFactor = self.attacherVehicle.lastSpeed*3600/12;
            local usage = fruitDesc.seedUsagePerQm*qm*speedFactor*5;

		if self.applyingFertilizer then
			Utils.updateSprayArea(x, z, x1, z1, x2, z2);
                  local seedPrice = fruitDesc.seedPricePerLiter*usage;
                  g_currentMission.missionStats.expensesTotal = g_currentMission.missionStats.expensesTotal + seedPrice;
                 	g_currentMission.missionStats.expensesSession = g_currentMission.missionStats.expensesSession + seedPrice;
		end;


		if self.attacherVehicle.lastSpeed*3600 > 0.1 then 
			self:setFillLevel(self.fillLevel-usage, self.currentFillType);
		end;

            g_currentMission.missionStats.seedUsageTotal = g_currentMission.missionStats.seedUsageTotal + usage;
            g_currentMission.missionStats.seedUsageSession = g_currentMission.missionStats.seedUsageSession + usage;

            g_currentMission.missionStats.hectaresSeededTotal = g_currentMission.missionStats.hectaresSeededTotal + ha;
            g_currentMission.missionStats.hectaresSeededSession = g_currentMission.missionStats.hectaresSeededSession + ha;

            g_currentMission.missionStats.seedingDurationTotal = g_currentMission.missionStats.seedingDurationTotal + dt/(1000*60);
            g_currentMission.missionStats.seedingDurationSession = g_currentMission.missionStats.seedingDurationSession + dt/(1000*60);

          	if self:doCheckSpeedLimit() and self.lastSpeed*3600 > 20 then
            	self.speedViolationTimer = self.speedViolationTimer - dt;
                	if self.speedViolationTimer < 0 then
                    	if self.attacherVehicle ~= nil then
                       		self.attacherVehicle:detachImplementByObject(self);
                    	end;
                	end;
            else
                	self.speedViolationTimer = self.speedViolationMaxTime;
           	end;

            if not self.groundParticleSystemActive then
                	self.groundParticleSystemActive = true;
                	Utils.setEmittingState(self.groundParticleSystems, true);
            end;

            	--if self.sowingSound ~= nil and not self.sowingSoundEnabled then
                	--if self.lastSpeed*3600 > 3 and self:getIsActiveForSound() then
                    --		playSample(self.sowingSound, 0, self.sowingSoundVolume, 0);
                    --		setSamplePitch(self.sowingSound, self.sowingSoundPitchOffset);
                    --		self.sowingSoundEnabled = true;
                	--end;
            	--end;
		end;
        else
               	Utils.setEmittingState(self.groundParticleSystems, false);
            	self.speedViolationTimer = self.speedViolationMaxTime;
            	--JD1760.onDeactivateSounds(self);
        end;


    	  if self.sowingSoundEnabled then
        	if self.lastSpeed*3600 < 3 then
            		--JD1760.onDeactivateSounds(self);
        	end;
    	  end;

-- sowing end

   end;
end;

function JD1760:draw()
	if self.currentFillType ~= nil and self.currentFillType ~= FruitUtil.FRUITTYPE_UNKNOWN then
	 	g_currentMission.fruitOverlays[self.currentFillType]:render();
	end;

	if not self.leftExtended and not self.rightExtended then
		g_currentMission:addExtraPrintText("Key B: Extend to work position");
	else
		g_currentMission:addExtraPrintText("Key B: Retract to transport");
	end;

	if self.applyingFertilizer then
		g_currentMission:addExtraPrintText("Key J: Stop Applying liquid fertilizer");
	else
		g_currentMission:addExtraPrintText("Key J: Apply liquid fertilizer");
	end;

	if self.leftExtended and self.rightExtended then
		if not self.leftMarker and self.rightMarker then
			g_currentMission:addExtraPrintText("KP 2: Transport, KP 3: Marker right");
		elseif not self.rightMarker and self.leftMarker then
			g_currentMission:addExtraPrintText("KP 1: Marker Left, KP 2: Transport");
		else
			g_currentMission:addExtraPrintText("KP 1: Marker Left, KP 3: Marker right");
		end;
	end;

	if self.fillLevel > 0 then	
		g_currentMission:addExtraPrintText("Key 0: Drain seed boxes on ground");
	end;
	
      local trailer = g_currentMission.objectToTrailer[self.trailerFound];
    	if self.trailerFound ~= 0 and self.fillTypes[trailer.currentFillType] == true then
    			if self.currentFillType == trailer.currentFillType or self.fillLevel == 0 then
				if self.fillLevel < self.capacity then
					g_currentMission:addExtraPrintText("Key M: Fill planter");
				else
					g_currentMission:addExtraPrintText("Planter full");
				end;
			end;
	else
		g_currentMission:addExtraPrintText("Move planter close to trailer to fill");
	end;

	if self.downPosition then
		g_currentMission:addExtraPrintText("Key N: raise planter");
	else
		g_currentMission:addExtraPrintText("Key N: lower planter")
	end;
    	if math.abs(self.speedViolationTimer - self.speedViolationMaxTime) > 2 then
        	g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "1", InputBinding.getButtonKeyName(InputBinding.SPEED_LEVEL1)), 0.07+0.022, 0.019+0.029);
    	end;
end;

function JD1760:onDetach()

    if self.deactivateOnDetach then
        JD1760.onDeactivate(self);
    else
        JD1760.onDeactivateSounds(self);
    end;

end;

function JD1760:onLeave()

    if self.deactivateOnLeave then
        JD1760.onDeactivate(self);
    end;

end;

function JD1760:onDeactivate()

    self.speedViolationTimer = self.speedViolationMaxTime;
    if self.groundParticleSystemActive then
        self.groundParticleSystemActive = false;
        Utils.setEmittingState(self.groundParticleSystems, false);
    end;
    JD1760.onDeactivateSounds(self);

end;

function JD1760:onDeactivateSounds()

    	if self.sowingSoundEnabled then
		stopSample(self.sowingSound);
		self.sowingSoundEnabled = false;
	end;

end;

function JD1760:setFillLevel(fillLevel, fillType)

    self.fillLevel = fillLevel;
    if self.fillLevel > self.capacity then
        self.fillLevel = self.capacity;
    end;
    if self.fillLevel < 0 then
        self.fillLevel = 0;
    end;
    if self.currentGrainPlane ~= nil then
        setVisibility(self.currentGrainPlane, false);
    end;
    if self.grainPlanes ~= nil and self.defaultGrainPlane ~= nil then
        local fillTypeName = FruitUtil.fruitIndexToDesc[self.currentFillType].name;
        local grainPlane = self.grainPlanes[fillTypeName];
        if grainPlane == nil then
            grainPlane = self.defaultGrainPlane;
        end;
        local yTranslation;
        if self.grainAnimCurve then
            local scaleX, scaleY, scaleZ , yTrans = self.grainAnimCurve:get(self.fillLevel/self.capacity);
            yTranslation = yTrans;
            setScale(grainPlane, scaleX, scaleY, scaleZ);
        else
            local m = (self.grainPlaneMaxY - self.grainPlaneMinY) / self.capacity;
            yTranslation = m*self.fillLevel + self.grainPlaneMinY;
        end;
        local xPos, yPos, zPos = getTranslation(grainPlane);
        setTranslation(grainPlane, xPos, yTranslation, zPos);
        setVisibility(grainPlane, self.fillLevel > 0);
        self.currentGrainPlane = grainPlane;
    end;
end;


