priborkaEvent = {};
priborkaEvent_mt = Class(priborkaEvent, Event);

InitEventClass(priborkaEvent, "priborkaEvent");

function priborkaEvent:emptyNew()
    local self = Event:new(priborkaEvent_mt);
    self.className="priborkaEvent";
    return self;
end;

function priborkaEvent:new(object, isRunning)
    local self = priborkaEvent:emptyNew()
    self.object = object;
	self.isRunning = isRunning;
    return self;
end;

function priborkaEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isRunning = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function priborkaEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isRunning);
end;

function priborkaEvent:run(connection)
	self.object:invokeIgnition(self.isRunning);
    if not connection:getIsServer() then
        g_server:broadcastEvent(priborkaEvent:new(self.object, self.isRunning), nil, connection, self.object);
    end;	
end;

function priborkaEvent.sendEvent(vehicle, isRunning)
	if g_server ~= nil then
		g_server:broadcastEvent(priborkaEvent:new(vehicle, isRunning), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(priborkaEvent:new(vehicle, isRunning));
	end;
end;

