--Specjalizacja dla : Ursus1002 By Marcello1942
--#Autor: marcello1942
--#data: 04/04/2013 r.

Ursus1002 = {};

function Ursus1002.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Ursus1002:load(xmlFile)

	local klapalewa = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#lewe"));
	if klapalewa ~= nil then
		self.klapalewa = klapalewa;
	end;
		local klapaprawa = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#prawe"));
	if klapaprawa ~= nil then
		self.klapaprawa = klapaprawa;
	end;
		local zaczep = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#zaczep"));
	if zaczep ~= nil then
		self.zaczep = zaczep;
	end;
		local maska = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#maska"));
	if maska ~= nil then
		self.maska = maska;
	end;
		local pompka = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#pompka"));
	if pompka ~= nil then
		self.pompka = pompka;
	end;
	local one = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#one"));
	if one ~= nil then
		self.one = one;
	end;
	local two = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#two"));
	if two ~= nil then
		self.two = two;
	end;
	local three = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#three"));
	if three ~= nil then
		self.three = three;
	end;
	local four = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#four"));
	if four ~= nil then
		self.four = four;
	end;
	local szyba = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#szyba"));
	if szyba ~= nil then
		self.szyba = szyba;
	end;
	local right = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#right"));
	if right ~= nil then
		self.right = right;
	end;
	local left = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#left"));
	if left ~= nil then
		self.left = left;
	end;
	
	
	self.klapkaoff = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.klapkaoff#index"));
	self.klapkaon = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.klapkaon#index"));
	setVisibility((self.klapkaoff), true);
	setVisibility((self.klapkaon), false);
	

  	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);
	self.hydraulics = {};
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);
		self.hydraulics[i] = {};
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));
		local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"),"0 1 0"));
		self.hydraulics[i].upVectors = {xUp, yUp, zUp};

		local ax, ay, az;
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		if self.hydraulics[i].translationPunch ~= nil then
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	self.setHydraulicTime = 30;
    self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
    self.otworz = false
	self.zamknij = false
	
	
	local rotationLifter = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Lifter#index"));
	self.Lifter = {};
	self.Lifter.node = rotationLifter;

	local rotationLifterArm = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.LifterArm#index"));
	self.LifterArm = {};
	self.LifterArm.node = rotationLifterArm;

	local rotationLifterBottom = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.LifterBottom#index"));
	self.bottomArm2 = {};
	self.bottomArm2.node = rotationLifterBottom;
	
	
	  hor12nSoundFile = Utils.getFilename("sounds/otworzdrzwi.wav", self.baseDirectory);
    self.hor12nSoundId = createSample("LizardHor12nSound");
    loadSample(self.hor12nSoundId, hor12nSoundFile, false);
    self.hor12nPlaying = false;
	
	openSoundFile = Utils.getFilename("sounds/otworzdrzwi.wav", self.baseDirectory);
    self.openSoundId = createSample("LizardHor12nSound");
    loadSample(self.openSoundId, openSoundFile, false);
    self.openPlaying = false;
	
	clouseSoundFile = Utils.getFilename("sounds/zamknijdrzwi.wav", self.baseDirectory);
    self.clouseSoundId = createSample("LizardHor12nSound");
    loadSample(self.clouseSoundId, clouseSoundFile, false);
    self.clousePlaying = false;
    
      hor123nSoundFile = Utils.getFilename("sounds/zamknijdrzwi.wav", self.baseDirectory);
    self.hor123nSoundId = createSample("LizardHor123nSound");
    loadSample(self.hor123nSoundId, hor123nSoundFile, false);
    self.hor123nPlaying = false;
	
	hor1234nSoundFile = Utils.getFilename("sounds/bieg1.wav", self.baseDirectory);
    self.hor1234nSoundId = createSample("LizardHor123nSound");
    loadSample(self.hor1234nSoundId, hor1234nSoundFile, false);
    self.hor1234nPlaying = false;
	
	hor12345nSoundFile = Utils.getFilename("sounds/bieg2.wav", self.baseDirectory);
    self.hor12345nSoundId = createSample("LizardHor123nSound");
    loadSample(self.hor12345nSoundId, hor12345nSoundFile, false);
    self.hor12345nPlaying = false;
	
	hor123456nSoundFile = Utils.getFilename("sounds/bieg1.wav", self.baseDirectory);
    self.hor123456nSoundId = createSample("LizardHor123nSound");
    loadSample(self.hor123456nSoundId, hor123456nSoundFile, false);
    self.hor123456nPlaying = false;
	
	hor1234567nSoundFile = Utils.getFilename("sounds/bieg1.wav", self.baseDirectory);
    self.hor1234567nSoundId = createSample("LizardHor123nSound");
    loadSample(self.hor1234567nSoundId, hor1234567nSoundFile, false);
    self.hor1234567nPlaying = false;
	
	hor12345678nSoundFile = Utils.getFilename("sounds/bieg2.wav", self.baseDirectory);
    self.hor12345678nSoundId = createSample("LizardHor123nSound");
    loadSample(self.hor12345687nSoundId, hor12345678nSoundFile, false);
    self.hor12345678nPlaying = false;
	
	horn2SoundFile = Utils.getFilename("sounds/bieg1.wav", self.baseDirectory);
    self.horn2SoundId = createSample("LizardHor123nSound");
    loadSample(self.horn2SoundId, horn2SoundFile, false);
    self.horn2Playing = false;
	
	brakeSoundFile = Utils.getFilename("sounds/brake.wav", self.baseDirectory);
    self.brakeSoundId = createSample("LizardHor12nSound");
    loadSample(self.brakeSoundId, brakeSoundFile, false);
    self.brakePlaying = false;
	
	dach_downSoundFile = Utils.getFilename("sounds/dach_down.wav", self.baseDirectory);
    self.dach_downSoundId = createSample("LizardHor12nSound");
    loadSample(self.dach_downSoundId, dach_downSoundFile, false);
    self.dach_downPlaying = false;
	
	dach_upSoundFile = Utils.getFilename("sounds/dach_up.wav", self.baseDirectory);
    self.dach_upSoundId = createSample("LizardHor12nSound");
    loadSample(self.dach_upSoundId, dach_upSoundFile, false);
    self.dach_upPlaying = false;
	
	wajchaSoundFile = Utils.getFilename("sounds/wajcha.wav", self.baseDirectory);
    self.wajchaSoundId = createSample("LizardHor12nSound");
    loadSample(self.wajchaSoundId, wajchaSoundFile, false);
    self.wajchaPlaying = false;
	
	wajcha1SoundFile = Utils.getFilename("sounds/wajcha.wav", self.baseDirectory);
    self.wajcha1SoundId = createSample("LizardHor12nSound");
    loadSample(self.wajcha1SoundId, wajcha1SoundFile, false);
    self.wajcha1Playing = false;
	
	podnosnikSoundFile = Utils.getFilename("sounds/podnosnik.wav", self.baseDirectory);
    self.podnosnikSoundId = createSample("LizardHor12nSound");
    loadSample(self.podnosnikSoundId, podnosnikSoundFile, false);
    self.podnosnikPlaying = false;
	
	powerSoundFile = Utils.getFilename("sounds/powerSound.wav", self.baseDirectory);
    self.powerSoundId = createSample("LizardHor12nSound");
    loadSample(self.powerSoundId, powerSoundFile, false);
    self.powerPlaying = false;
	
	wycieraczkaSoundFile = Utils.getFilename("sounds/wycieraczka.wav", self.baseDirectory);
    self.wycieraczkaSoundId = createSample("LizardHor12nSound");
    loadSample(self.wycieraczkaSoundId, wycieraczkaSoundFile, false);
    self.wycieraczkaPlaying = false;
	
	pstrykSoundFile = Utils.getFilename("sounds/pstryk.wav", self.baseDirectory);
    self.pstrykSoundId = createSample("LizardHor12nSound");
    loadSample(self.pstrykSoundId, pstrykSoundFile, false);
    self.pstrykPlaying = false;
	
	pstryk1SoundFile = Utils.getFilename("sounds/pstryk.wav", self.baseDirectory);
    self.pstryk1SoundId = createSample("LizardHor12nSound");
    loadSample(self.pstryk1SoundId, pstryk1SoundFile, false);
    self.pstryk1Playing = false;

end;
 function Ursus1002:delete()
end;
function Ursus1002:keyEvent(unicode, sym, modifier, isDown)

   if isDown and sym == Input.KEY_0 then
		self.pomoc = not self.pomoc;
	end;
	  
	  
	if isDown and sym == Input.KEY_b then
		self.Przekaznik = not self.Przekaznik;
	end;
	
	
	if isDown and sym == Input.KEY_b then
		self.wajcha = not self.wajcha;
	end;
	
	
	if isDown and sym == Input.KEY_w then
		self.front = not self.front;
	end;
	
	
	if isDown and sym == Input.KEY_s then
		self.backward = not self.backward;
	end;
	
	
	if isDown and sym == Input.KEY_v then
		self.podnosnik = not self.podnosnik;
	end;
	
	if isDown and sym == Input.KEY_l then
		self.wycieraczka = not self.wycieraczka;
	end;
	
	if isDown and sym == Input.KEY_l then
		self.wlacznik = not self.wlacznik;
	end;
		
  
end;


function Ursus1002:update(dt)

        local nearestDistance = 2;
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
	
		
		local px, py, pz = getWorldTranslation(self.klapalewa); 
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.przyklapiel = true; 
		else
			self.przyklapiel = false; 
		end;
		
		local rx, ry, rz = getWorldTranslation(self.klapaprawa); 
		local distance = Utils.vector3Length(rx-vx, ry-vy, rz-vz);	
		if distance < nearestDistance then
			self.przyklapiep = true; 
		else
			self.przyklapiep = false; 
		end;
		
		
		local sx, sy, sz = getWorldTranslation(self.zaczep); 
		local distance = Utils.vector3Length(sx-vx, sy-vy, sz-vz);	
		if distance < nearestDistance then
			self.przyzaczepie = true; 
		else
			self.przyzaczepie = false; 
		end; 

		local tx, ty, tz = getWorldTranslation(self.maska); 
		local distance = Utils.vector3Length(tx-vx, ty-vy, tz-vz);	
		if distance < nearestDistance then
			self.przymaska = true; 
		else
			self.przymaska = false; 
		end; 
		
		local ux, uy, uz = getWorldTranslation(self.pompka); 
		local distance = Utils.vector3Length(ux-vx, uy-vy, uz-vz);	
		if distance < nearestDistance then
			self.przypompka = true; 
		else
			self.przypompka = false; 
		end; 
	
		
		
--------drzwi----------------
--otwieranie--
	if self.przyklapiep or self.isEntered then
	if InputBinding.hasEvent(InputBinding.PRAWE) then
			if self.animationParts[1].clipEndTime then
				self:setAnimationTime(1, self.animationParts[1].offSet);
				self.otworz = true;
				self.zamknij = false;
			elseif self.animationParts[1].clipStartTime then
				self:setAnimationTime(1, self.animationParts[1].animDuration);
				self.otworz = false;
				self.zamknij = true;
			end;
		end;
	end;
	
	if self.przyklapiel or self.isEntered then
	if InputBinding.hasEvent(InputBinding.LEWE) then
			if self.animationParts[2].clipEndTime then
				self:setAnimationTime(2, self.animationParts[2].offSet);
				self.sound7 = true;
				self.sound8 = false;
			elseif self.animationParts[2].clipStartTime then
				self:setAnimationTime(2, self.animationParts[2].animDuration);
				self.sound7 = false;
				self.sound8 = true;
			end;
		end;
	end;  
	
	--Maska--
	if self.przymaska then
		if InputBinding.hasEvent(InputBinding.maska) then
			if self.animationParts[7].clipEndTime then
				self:setAnimationTime(7, self.animationParts[7].offSet);
			elseif self.animationParts[7].clipStartTime then
				self:setAnimationTime(7, self.animationParts[7].animDuration);
			end;
		end;
	end;
	
	--dach-	
	if self.isEntered then				
		if InputBinding.hasEvent(InputBinding.DACH) then
			if self.animationParts[3].clipEndTime then
				self:setAnimationTime(3, self.animationParts[3].offSet);
				self.sound11 = true;
				self.sound12 = false;
			elseif self.animationParts[3].clipStartTime then
				self:setAnimationTime(3, self.animationParts[3].animDuration);
				self.sound11 = false;
				self.sound12 = true;
			end;
		end;
		end;
		
		--szyba_tyl-	
	if self.isEntered then				
		if InputBinding.hasEvent(InputBinding.SZYBA) then
			if self.animationParts[45].clipEndTime then
				self:setAnimationTime(45, self.animationParts[45].offSet);
			elseif self.animationParts[45].clipStartTime then
				self:setAnimationTime(45, self.animationParts[45].animDuration);
			end;
		end;
	end;
	
	--zaczep--
	if self.przyzaczepie then
	 	if InputBinding.isPressed(InputBinding.zaczepP) then
               self:setAnimationTime(4, self.animationParts[4].currentPosition+(self.animationParts[4].offSet+dt), false);
           elseif InputBinding.isPressed(InputBinding.zaczepL) then
               self:setAnimationTime(4, self.animationParts[4].currentPosition-(self.animationParts[4].offSet+dt), false);
        end;
        end;
		
		--pompka--
	if self.przypompka then
	 	if InputBinding.isPressed(InputBinding.pompkaup) then
               self:setAnimationTime(24, self.animationParts[24].currentPosition+(self.animationParts[24].offSet+dt), false);
           elseif InputBinding.isPressed(InputBinding.pompkadown) then
               self:setAnimationTime(24, self.animationParts[24].currentPosition-(self.animationParts[24].offSet+dt), false);
        end;
        end;
		
		---podnosnik---
	
	if self.Lifter.node ~= nil and self.bottomArm2.node ~= nil then
			rBBArmX, rBBArmY, rBBArmZ = getRotation(self.bottomArm2.node);
			setRotation(self.Lifter.node, rBBArmX*1.5, 0, 0);
	end;
	if self.LifterArm.node ~= nil and self.bottomArm2.node ~= nil then
			setRotation(self.LifterArm.node, 0.05-rBBArmX*1.5, 0, 0);
	end;
	
	---wajcha podnosnika---
	
		if self.isEntered then
		if self.podnosnik then
		   self:setAnimationTime(5,self.animationParts[5].animDuration);
		   self.sound19 = true;
		else 
		   self:setAnimationTime(5,self.animationParts[5].offSet);	
           self.sound19 = false;   
		end;
		end;
		
		---wycieraczka---
		
		if self.wycieraczka then
           self:setAnimationTime(67, 1);
		   self.sound20 = true;
        else
           self:setAnimationTime(67, 0);
		   self.sound20 = false;
        end;
		
		if self.isEntered then
		if self.wlacznik then
			self:setAnimationTime(68,self.animationParts[68].animDuration);
			self.sound21 = true;
			self.sound22 = false;
		else
			self:setAnimationTime(68,self.animationParts[68].offSet);
			self.sound21 = false;
			self.sound22 = true;
		end;
		end;
	--------------
		
	if self.setAnimationTime ~= nil then
		if self.isMotorStarted then
			self:setAnimationTime(6, 1);
		else
			self:setAnimationTime(6, 0);
		end;
		if self.isMotorStarted then
			self:setAnimationTime(8, 1);
		else
			self:setAnimationTime(8, 0);
		end;
		if self.Przekaznik then
           self:setAnimationTime(9, 1);
        else
           self:setAnimationTime(9, 0);
        end;
	    if self.isMotorStarted then
			self:setAnimationTime(11,self.animationParts[11].animDuration);
		else
			self:setAnimationTime(11,self.animationParts[11].offSet);
		end;
		 if self.lastSpeed*3600 > 3 then
			self:setAnimationTime(12,self.animationParts[12].animDuration);
		else
			self:setAnimationTime(12,self.animationParts[12].offSet);
		end;
		 if self.lastSpeed*3600 > 6 then
			self:setAnimationTime(13,self.animationParts[13].animDuration);
		else
			self:setAnimationTime(13,self.animationParts[13].offSet);
		end;
		 if self.lastSpeed*3600 > 9 then
			self:setAnimationTime(14,self.animationParts[14].animDuration);
		else
			self:setAnimationTime(14,self.animationParts[14].offSet);
		end;
		 if self.lastSpeed*3600 > 12 then
			self:setAnimationTime(15,self.animationParts[15].animDuration);
		else
			self:setAnimationTime(15,self.animationParts[15].offSet);
		end;
		if self.lastSpeed*3600 > 15 then
			self:setAnimationTime(16,self.animationParts[16].animDuration);
		else
			self:setAnimationTime(16,self.animationParts[16].offSet);
		end;
		 if self.lastSpeed*3600 > 18 then
			self:setAnimationTime(17,self.animationParts[17].animDuration);
		else
			self:setAnimationTime(17,self.animationParts[17].offSet);
		end;
		if self.lastSpeed*3600 > 21 then
			self:setAnimationTime(18,self.animationParts[18].animDuration);
		else
			self:setAnimationTime(18,self.animationParts[18].offSet);
		end;
		 if self.lastSpeed*3600 > 24 then
			self:setAnimationTime(19,self.animationParts[19].animDuration);
		else
			self:setAnimationTime(19,self.animationParts[19].offSet);
		end;
		if self.lastSpeed*3600 > 27 then
			self:setAnimationTime(20,self.animationParts[20].animDuration);
		else
			self:setAnimationTime(20,self.animationParts[20].offSet);
		end;
		 if self.lastSpeed*3600 > 30 then
			self:setAnimationTime(21,self.animationParts[21].animDuration);
		else
			self:setAnimationTime(21,self.animationParts[21].offSet);
		end;
		if self.isMotorStarted then
			self:setAnimationTime(22,self.animationParts[22].animDuration);
		else
			self:setAnimationTime(22,self.animationParts[22].offSet);
		end;
		
		if self.isEntered then
		if self.hamuj then
			self:setAnimationTime(23,self.animationParts[23].animDuration);
			self.sound10 = true;
		else
			self:setAnimationTime(23,self.animationParts[23].offSet);
			self.sound10 = false;
		end;
		end;
		
		
		if self.isEntered then
		if self.wajcha then
			self:setAnimationTime(10,self.animationParts[10].animDuration);
			self.sound17 = true;
			self.sound18 = false;
		else
			self:setAnimationTime(10,self.animationParts[10].offSet);
			self.sound17 = false;
			self.sound18 = true;
		end;
		end;
		if self.lastSpeed*3600 > 23 then
			self:setAnimationTime(26,self.animationParts[26].animDuration);
		else
			self:setAnimationTime(26,self.animationParts[26].offSet);
		end;
		if self.isMotorStarted then
			self:setAnimationTime(25, 1);
		else
			self:setAnimationTime(25, 0);
		end;
		 if self.lastSpeed*3600 > 33 then
			self:setAnimationTime(28,self.animationParts[28].animDuration);
		else
			self:setAnimationTime(28,self.animationParts[28].offSet);
		end;
		 if self.lastSpeed*3600 > 36 then
			self:setAnimationTime(29,self.animationParts[29].animDuration);
		else
			self:setAnimationTime(29,self.animationParts[29].offSet);
		end;
		 if self.lastSpeed*3600 > 39 then
			self:setAnimationTime(30,self.animationParts[30].animDuration);
		else
			self:setAnimationTime(30,self.animationParts[30].offSet);
		end;
		 if self.lastSpeed*3600 > 42 then
			self:setAnimationTime(31,self.animationParts[31].animDuration);
		else
			self:setAnimationTime(31,self.animationParts[31].offSet);
		end;
		if self.lastSpeed*3600 > 45 then
			self:setAnimationTime(32,self.animationParts[32].animDuration);
		else
			self:setAnimationTime(32,self.animationParts[32].offSet);
		end;
		 if self.lastSpeed*3600 > 48 then
			self:setAnimationTime(33,self.animationParts[33].animDuration);
		else
			self:setAnimationTime(33,self.animationParts[33].offSet);
		end;
		if self.lastSpeed*3600 > 51 then
			self:setAnimationTime(34,self.animationParts[34].animDuration);
		else
			self:setAnimationTime(34,self.animationParts[34].offSet);
		end;
		 if self.lastSpeed*3600 > 54 then
			self:setAnimationTime(35,self.animationParts[35].animDuration);
		else
			self:setAnimationTime(35,self.animationParts[35].offSet);
		end;
		if self.lastSpeed*3600 > 57 then
			self:setAnimationTime(36,self.animationParts[36].animDuration);
		else
			self:setAnimationTime(36,self.animationParts[36].offSet);
		end;
		 if self.lastSpeed*3600 > 60 then
			self:setAnimationTime(37,self.animationParts[37].animDuration);
		else
			self:setAnimationTime(37,self.animationParts[37].offSet);
		end;
		
                         --- gearBox marcello1942---		
		
		if self.motor.speedLevel == 4 then
			self:setAnimationTime(41,self.animationParts[41].animDuration);
			self.two = false;
			self.three = false;
			self.one = false;
			self.sound = true;
		else
			self:setAnimationTime(41,self.animationParts[41].offSet);
			self.sound = false;
		end;
		if self.isEntered then
		if self.motor.speedLevel == 3 or Input.isKeyPressed(Input.KEY_w) then
			self:setAnimationTime(40,self.animationParts[40].animDuration);
			self.two = false;
			self.one = false;
			self.four = false;
			self.sound3 = true;
		else
			self:setAnimationTime(40,self.animationParts[40].offSet);
			self.sound3 = false;
		end;
		end;
		if self.motor.speedLevel == 2 then
			self:setAnimationTime(39,self.animationParts[39].animDuration);
			self.one = false;
			self.three = false;
			self.four = false;
			self.sound4 = true;
		else
			self:setAnimationTime(39,self.animationParts[39].offSet);
			self.sound4 = false;
		end;
		if self.isEntered then
		if self.motor.speedLevel == 1 or Input.isKeyPressed(Input.KEY_s) then
			self:setAnimationTime(38,self.animationParts[38].animDuration);
			self.two = false;
			self.three = false;
			self.four = false;
			self.sound6 = true;
		else
			self:setAnimationTime(38,self.animationParts[38].offSet);
			self.sound6 = false;
		end;
		end;
		
		if Input.isKeyPressed(Input.KEY_1) or Input.isKeyPressed(Input.KEY_2) or Input.isKeyPressed(Input.KEY_3) or Input.isKeyPressed(Input.KEY_4) then
		   self:setAnimationTime(42,self.animationParts[42].animDuration);
		else 
		   self:setAnimationTime(42,self.animationParts[42].offSet); 
		end;
		
		if self.isEntered then
		if Input.isKeyPressed(Input.KEY_w) or Input.isKeyPressed(Input.KEY_s) then
		   self:setAnimationTime(43,self.animationParts[43].animDuration);
		   self:setAnimationTime(63,self.animationParts[63].animDuration);
		else 
		   self:setAnimationTime(43,self.animationParts[43].offSet);
		   self:setAnimationTime(63,self.animationParts[63].offSet);
		end;
		end;
				
        if self.front then
			self.two = false;
			self.one = false;
			self.four = false;
		end;
		
		if self.backward then
			self.two = false;
			self.four = false;
			self.three = false;
		end;
		
		                       ---FB---
							   
		if self.isEntered then					   
		if Input.isKeyPressed(Input.KEY_s) then
		   self:setAnimationTime(44, self.animationParts[44].currentPosition+(self.animationParts[44].offSet+dt), false);
		   self.sound2 = true;
		   self.sound5 = false;
        elseif 
		   Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel == 1 or self.motor.speedLevel == 2 or self.motor.speedLevel == 3 or self.motor.speedLevel == 4 then
           self:setAnimationTime(44, self.animationParts[44].currentPosition-(self.animationParts[44].offSet+dt), false);
		   self.sound2 = false;
		   self.sound5 = true;
        end;
        end;
		end;
		
		                 ---wskazowki---
						 
		if self.isMotorStarted then
			self:setAnimationTime(46,self.animationParts[46].animDuration);
		else
			self:setAnimationTime(46,self.animationParts[46].offSet);
		end;
        if self.isMotorStarted then
			self:setAnimationTime(47,self.animationParts[47].animDuration);
		else
			self:setAnimationTime(47,self.animationParts[47].offSet);
		end;
		if self.isMotorStarted then
			self:setAnimationTime(48,self.animationParts[48].animDuration);
		else
			self:setAnimationTime(48,self.animationParts[48].offSet);
		end;
		
		
		if self.isMotorStarted and self.fuelFillLevel > 4 then
		self:setAnimationTime(49,self.animationParts[49].animDuration);
		else
			self:setAnimationTime(49,self.animationParts[49].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 8 then
		self:setAnimationTime(50,self.animationParts[50].animDuration);
		else
			self:setAnimationTime(50,self.animationParts[50].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 12 then
		self:setAnimationTime(51,self.animationParts[51].animDuration);
		else
			self:setAnimationTime(51,self.animationParts[51].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 16 then
		self:setAnimationTime(52,self.animationParts[52].animDuration);
		else
			self:setAnimationTime(52,self.animationParts[52].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 20 then
		self:setAnimationTime(53,self.animationParts[53].animDuration);
		else
			self:setAnimationTime(53,self.animationParts[53].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 24 then
		self:setAnimationTime(54,self.animationParts[54].animDuration);
		else
			self:setAnimationTime(54,self.animationParts[54].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 28 then
		self:setAnimationTime(55,self.animationParts[55].animDuration);
		else
			self:setAnimationTime(55,self.animationParts[55].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 32 then
		self:setAnimationTime(56,self.animationParts[56].animDuration);
		else
			self:setAnimationTime(56,self.animationParts[56].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 36 then
		self:setAnimationTime(57,self.animationParts[57].animDuration);
		else
			self:setAnimationTime(57,self.animationParts[57].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 40 then
		self:setAnimationTime(58,self.animationParts[58].animDuration);
		else
			self:setAnimationTime(58,self.animationParts[58].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 44 then
		self:setAnimationTime(59,self.animationParts[59].animDuration);
		else
			self:setAnimationTime(59,self.animationParts[59].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 48 then
		self:setAnimationTime(60,self.animationParts[60].animDuration);
		else
			self:setAnimationTime(60,self.animationParts[60].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 52 then
		self:setAnimationTime(61,self.animationParts[61].animDuration);
		else
			self:setAnimationTime(61,self.animationParts[61].offSet);
		end;
		if self.isMotorStarted and self.fuelFillLevel > 56 then
		self:setAnimationTime(62,self.animationParts[62].animDuration);
		else
			self:setAnimationTime(62,self.animationParts[62].offSet);
		end;
		
		                        ---r---
		if self.isMotorStarted and self.fuelFillLevel < 12 then
		self:setAnimationTime(66,self.animationParts[66].animDuration);
		else
			self:setAnimationTime(66,self.animationParts[66].offSet);
		end;					
		
		                ---przelacznik kierunki---
						
		if  self.isEntered then				
		if  self.lewy then
			self:setAnimationTime(64,self.animationParts[64].animDuration);
			self.right = false;
		else
			self:setAnimationTime(64,self.animationParts[64].offSet);
		end;
        end;
        if  self.isEntered then		
 		if  self.prawy then
			self:setAnimationTime(65,self.animationParts[65].animDuration);
			self.left = false;
		else
			self:setAnimationTime(65,self.animationParts[65].offSet);
		end;
        end;

                            --klapka--
	  
	  if self.isMotorStarted then
		 setVisibility((self.klapkaoff), false);
		 setVisibility((self.klapkaon), true);
		 else
		 setVisibility((self.klapkaoff), true);
		 setVisibility((self.klapkaon), false);
	  end;		

	
		
	  --napisy
		if self.przyzaczepie then
			g_currentMission:addExtraPrintText(string.format("%s: zaczep up", InputBinding.getKeyNamesOfDigitalAction(InputBinding.zaczepP)));
			g_currentMission:addExtraPrintText(string.format("%s: zaczep down", InputBinding.getKeyNamesOfDigitalAction(InputBinding.zaczepL)));
		end;
		if self.przyklapiel then
	if self.animationParts[2].clipStartTime then
			g_currentMission:addExtraPrintText(string.format("%s: otworz Drzwi", InputBinding.getKeyNamesOfDigitalAction(InputBinding.LEWE)));
		else
			g_currentMission:addExtraPrintText(string.format("%s: zamknij Drzwi", InputBinding.getKeyNamesOfDigitalAction(InputBinding.LEWE)));
		end;
		end;
		if self.przyklapiep then
	if self.animationParts[1].clipStartTime then
			g_currentMission:addExtraPrintText(string.format("%s: otworz Drzwi", InputBinding.getKeyNamesOfDigitalAction(InputBinding.PRAWE)));
		else
			g_currentMission:addExtraPrintText(string.format("%s: zamknij Drzwi", InputBinding.getKeyNamesOfDigitalAction(InputBinding.PRAWE)));
		end;
		end
		if self.przypompka then
			g_currentMission:addExtraPrintText(string.format("%s: pompka up", InputBinding.getKeyNamesOfDigitalAction(InputBinding.pompkaup)));
			g_currentMission:addExtraPrintText(string.format("%s: pompka down", InputBinding.getKeyNamesOfDigitalAction(InputBinding.pompkadown)));
		end;

			if self:getIsActive() then
		self.setHydraulicTime = 30;
	end;


	if self.setHydraulicTime > 0 then
		for k,v in pairs(self.hydraulics) do
			self:setHydraulicDirection(k);
		end;
		self.setHydraulicTime = self.setHydraulicTime - 1;
	end;
	
	
	  if self.otworz then
       if not self.hor12nPlaying then
            playSample(self.hor12nSoundId, 1, 3, 3);
            self.hor12nPlaying = true;
        end;
       
    else
        if self.hor12nPlaying then
            stopSample(self.hor12nSoundId);
            self.hor12nPlaying = false;
        end;
         
    end;
      if self.zamknij then
       if not self.hor123nPlaying then
            playSample(self.hor123nSoundId, 1, 3, 3);
            self.hor123nPlaying = true;
        end;
       
    else
        if self.hor123nPlaying then
            stopSample(self.hor123nSoundId);
            self.hor123nPlaying = false;
        end;
         
    end;
	
	if self.sound then
       if not self.hor1234nPlaying then
            playSample(self.hor1234nSoundId, 1, 3, 3);
            self.hor1234nPlaying = true;
        end;
       
    else
        if self.hor1234nPlaying then
            stopSample(self.hor1234nSoundId);
            self.hor1234nPlaying = false;
        end;
         
    end;
	
	if self.sound2 then
       if not self.hor12345nPlaying then
            playSample(self.hor12345nSoundId, 1, 3, 3);
            self.hor12345nPlaying = true;
        end;
       
    else
        if self.hor12345nPlaying then
            stopSample(self.hor12345nSoundId);
            self.hor12345nPlaying = false;
        end;
         
    end;
	
	if self.sound3 then
       if not self.hor123456nPlaying then
            playSample(self.hor123456nSoundId, 1, 3, 3);
            self.hor123456nPlaying = true;
        end;
       
    else
        if self.hor123456nPlaying then
            stopSample(self.hor123456nSoundId);
            self.hor123456nPlaying = false;
        end;
         
    end;
	
	if self.sound4 then
       if not self.hor1234567nPlaying then
            playSample(self.hor1234567nSoundId, 1, 3, 3);
            self.hor1234567nPlaying = true;
        end;
       
    else
        if self.hor1234567nPlaying then
            stopSample(self.hor1234567nSoundId);
            self.hor1234567nPlaying = false;
        end;
         
    end;
	
	if self.sound5 then
       if not self.hor12345678nPlaying then
            playSample(self.hor12345678nSoundId, 1, 3, 3);
            self.hor12345678nPlaying = true;
        end;
       
    else
        if self.hor12345678nPlaying then
            stopSample(self.hor12345678nSoundId);
            self.hor12345678nPlaying = false;
        end;
         
    end;
	
	if self.sound6 then
       if not self.horn2Playing then
            playSample(self.horn2SoundId, 1, 3, 3);
            self.horn2Playing = true;
        end;
       
    else
        if self.horn2Playing then
            stopSample(self.horn2SoundId);
            self.horn2Playing = false;
        end;
         
    end;
	
	if self.sound7 then
       if not self.openPlaying then
            playSample(self.openSoundId, 1, 3, 3);
            self.openPlaying = true;
        end;
       
    else
        if self.openPlaying then
            stopSample(self.openSoundId);
            self.openPlaying = false;
        end;
         
    end;
	
		if self.sound8 then
       if not self.clousePlaying then
            playSample(self.clouseSoundId, 1, 3, 3);
            self.clousePlaying = true;
        end;
       
    else
        if self.clousePlaying then
            stopSample(self.clouseSoundId);
            self.clousePlaying = false;
        end;
         
    end;
	
	if self.sound10 then
       if not self.brakePlaying then
            playSample(self.brakeSoundId, 1, 3, 3);
            self.brakePlaying = true;
        end;
       
    else
        if self.brakePlaying then
            stopSample(self.brakeSoundId);
            self.brakePlaying = false;
        end;
         
    end;
	
	if self.sound11 then
       if not self.dach_downPlaying then
            playSample(self.dach_downSoundId, 1, 3, 3);
            self.dach_downPlaying = true;
        end;
       
    else
        if self.dach_downPlaying then
            stopSample(self.dach_downSoundId);
            self.dach_downPlaying = false;
        end;
         
    end;
	
	if self.sound12 then
       if not self.dach_upPlaying then
            playSample(self.dach_upSoundId, 1, 3, 3);
            self.dach_upPlaying = true;
        end;
       
    else
        if self.dach_upPlaying then
            stopSample(self.dach_upSoundId);
            self.dach_upPlaying = false;
        end;
         
    end;
	
	if self.sound17 then
       if not self.wajchaPlaying then
            playSample(self.wajchaSoundId, 1, 3, 3);
            self.wajchaPlaying = true;
        end;
       
    else
        if self.wajchaPlaying then
            stopSample(self.wajchaSoundId);
            self.wajchaPlaying = false;
        end;
         
    end;
	
	if self.sound18 then
       if not self.wajcha1Playing then
            playSample(self.wajcha1SoundId, 1, 3, 3);
            self.wajcha1Playing = true;
        end;
       
    else
        if self.wajcha1Playing then
            stopSample(self.wajcha1SoundId);
            self.wajcha1Playing = false;
        end;
         
    end;
	
	if self.sound19 then
       if not self.podnosnikPlaying then
            playSample(self.podnosnikSoundId, 1, 3, 3);
            self.podnosnikPlaying = true;
        end;
       
    else
        if self.podnosnikPlaying then
            stopSample(self.podnosnikSoundId);
            self.podnosnikPlaying = false;
        end;
         
    end;
	
	if self.isEntered then					   
	   if Input.isKeyPressed(Input.KEY_w) then
       if not self.powerPlaying then
            playSample(self.powerSoundId, 1, 3, 3);
            self.powerPlaying = true;
        end;
       
    else
        if self.powerPlaying then
            stopSample(self.powerSoundId);
            self.powerPlaying = false;
        end;
         
    end;
	end;
	
		if self.sound20 then
       if not self.wycieraczkaPlaying then
            playSample(self.wycieraczkaSoundId, 0, 1, 0);
            self.wycieraczkaPlaying = true;
        end;
       
    else
        if self.wycieraczkaPlaying then
            stopSample(self.wycieraczkaSoundId);
            self.wycieraczkaPlaying = false;
        end;
         
    end;
	
	if self.sound21 then
       if not self.pstrykPlaying then
            playSample(self.pstrykSoundId, 1, 3, 3);
            self.pstrykPlaying = true;
        end;
       
    else
        if self.pstrykPlaying then
            stopSample(self.pstrykSoundId);
            self.pstrykPlaying = false;
        end;
         
    end;
	
	if self.sound22 then
       if not self.pstryk1Playing then
            playSample(self.pstryk1SoundId, 1, 3, 3);
            self.pstryk1Playing = true;
        end;
       
    else
        if self.pstryk1Playing then
            stopSample(self.pstryk1SoundId);
            self.pstryk1Playing = false;
        end;
         
    end;
	
	
end;


function Ursus1002:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Ursus1002:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
function Ursus1002:setHydraulicDirection(index)
	local hydraulic = self.hydraulics[index];

	if hydraulic.fixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(hydraulic.node);
		local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
		local xUp, yUp, zUp = unpack(hydraulic.upVectors);
		setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
		if hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
		end;
	end;
end;
function Ursus1002:draw()

    if self.isEntered then
		if not self.pomoc then
			renderText(0.833, 0.175, 0.02, "Klavesa 0: pomoc");
		end;
		if self.pomoc then
			renderText(0.72, 0.85, 0.025, "----->Zetor 8011 CRYSTAL<-----");
			if not self.isMotorStarted then
			renderText(0.72, 0.825, 0.02, " Z: start motora");
			else
			renderText(0.72, 0.825, 0.02, " Z: stop motora");
			end;
	              
                        renderText(0.72, 0.800, 0.02, "zadne okno: K ");
	 

		        renderText(0.72, 0.775, 0.02, "dvere: N, M ");
	
		
			renderText(0.72, 0.75, 0.02, "strecha: T ");
         
           
			renderText(0.72, 0.725, 0.02, "blinkre: Num 1/2/3 ");
	
		
			renderText(0.72, 0.7, 0.02, "ESLimiter: Num_plus, Num_minus ");
			
		
			renderText(0.72, 0.675, 0.02, "pumpicka  up: Z,  down: X ");
			
			
			renderText(0.72, 0.650, 0.02, "zadne pracovne svetla: 7 ");
			
			
			renderText(0.72, 0.625, 0.02, "tiahlo  up: X, down: Z ");
			
			
			renderText(0.72, 0.600, 0.02, "stierac: L ");
			
			
			renderText(0.72, 0.575, 0.02, "----->MARCELLO 1942<-----");
		end;
	end;	
end;

function Ursus1002:updateTick(dt)
		if self.backHydraulic ~= nil then		
		local x, y, z = getRotation(self.attacherJoints[1].bottomArm.rotationNode);
		setRotation(self.backHydraulic.rootArm, x, y, z);	
	end;		
end;