--
-- AllradV4.1.5 PLUS
-- Specialization for Allrad
--
-- V2 by modelleicher & Made by Case_IH_MxU135 | FIX and V4 by DragonLord2007/modhoster
-- www.schwabenmodding.bplaced.net
--
-- V4.1 by Saty / forum.lsczech.cz
-- PLUS >> This version is compatible with ESLimiter PLUS
--


AllradV4 = {};

function AllradV4.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function AllradV4:load(xmlFile)
	self.Allrad = {};
	self.allradState = AllradV4.allradState;

	self.AllradV4Active = false;

	self.hudAllradPosX = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.Allrad#posX"), 0.7543);
	self.hudAllradPosY = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.Allrad#posY"), 0.1715);
	 
	self.hudAllradOverlay = Overlay:new("hudAROverlay", Utils.getFilename("Textury/allRad_hud.dds", self.baseDirectory), self.hudAllradPosX, self.hudAllradPosY, 0.2371, 0.039525);
	
	self.spec_ARP = true;
	
	self.Allrad.AllradNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.indicators.allRad#index"));	
end;

function AllradV4:delete()
    if self.hudAllradOverlay ~= nil then
		self.hudAllradOverlay:delete();
	end;
end;

function AllradV4:readStream(streamId, connection)  
     self:allradState(streamReadBool(streamId), true);  
end;

function AllradV4:writeStream(streamId, connection)  
    streamWriteBool(streamId, self.AllradV4Active);  
end;

function AllradV4:mouseEvent(posX, posY, isDown, isUp, button)
end;
function AllradV4:keyEvent(unicode, sym, modifier, isDown)
end;

function AllradV4:allradState(state, noEventSend)  
    AllradStateEvent.sendEvent(self, state, noEventSend);	
    self.AllradV4Active = state;
end;

function AllradV4:update(dt)
    if self.isClient and self.isEntered then  
		if InputBinding.hasEvent(InputBinding.AllradV4) then
		  self:allradState(not self.AllradV4Active);
		end;
		if self.AllradV4Active then
			self.wheels[1].driveMode = 2;
		 	self.wheels[2].driveMode = 2;
		 	self.wheels[3].driveMode = 1;
		 	self.wheels[4].driveMode = 1;
		else
		 	self.wheels[1].driveMode = 0;
			self.wheels[2].driveMode = 0;
			self.wheels[3].driveMode = 1;
			self.wheels[4].driveMode = 1;			
		end;
		if self.Allrad.AllradNode ~= nil then
			if self.AllradV4Active then
				setVisibility(self.Allrad.AllradNode, true);
			else
				setVisibility(self.Allrad.AllradNode, false);
			end;
		end;
    end; 
end;

function AllradV4:draw()
	if self.isClient and self.isEntered then
		if Steerable.ESL_PLUS and self.spec_ESLPLUS then
			Steerable.ESL_iSeg3:render();
			if self.AllradV4Active then
				g_currentMission:addHelpButtonText(g_i18n:getText("AllradON"), InputBinding.AllradV4);
				Steerable.ESL_i3on:render();
			else
				g_currentMission:addHelpButtonText(g_i18n:getText("AllradOFF"), InputBinding.AllradV4);
				Steerable.ESL_i3of:render();
			end;
		else
			self.hudAllradOverlay:render();
			if self.AllradV4Active then
				g_currentMission:addHelpButtonText(g_i18n:getText("AllradON"), InputBinding.AllradV4);
				setTextBold(true);
				setTextAlignment(RenderText.ALIGN_LEFT);
				setTextColor(0, 0, 0, 1);
				renderText(self.hudAllradPosX + 0.031, self.hudAllradPosY + 0.009, 0.02, "4x4 ON");
				setTextColor(1, 1, 1, 1);
				renderText(self.hudAllradPosX + 0.031, self.hudAllradPosY + 0.011, 0.02, "4x4 ON");
			else
				g_currentMission:addHelpButtonText(g_i18n:getText("AllradOFF"), InputBinding.AllradV4);
				setTextBold(true);
				setTextAlignment(RenderText.ALIGN_LEFT);
				setTextColor(1, 1, 1, 1);
				renderText(self.hudAllradPosX + 0.028, self.hudAllradPosY + 0.010, 0.02, "4x4 OFF");
				setTextColor(0, 0, 0, 1);
				renderText(self.hudAllradPosX + 0.028, self.hudAllradPosY + 0.011, 0.02, "4x4 OFF");
			end;
		end;
	end;
end;

AllradStateEvent = {};
AllradStateEvent_mt = Class(AllradStateEvent, Event);

InitEventClass(AllradStateEvent, "AllradStateEvent");	

function AllradStateEvent:emptyNew() 
    local self = Event:new(AllradStateEvent_mt );
    self.className="AllradStateEvent";
    return self;
end;

function AllradStateEvent:new(vehicle, state) 
    self.vehicle = vehicle;
    self.state = state;
    return self;
end;

function AllradStateEvent:readStream(streamId, connection)  
    local id = streamReadInt32(streamId); 
    self.state = streamReadBool(streamId); 
    self.vehicle = networkGetObject(id); 
    self:run(connection);  
end;

function AllradStateEvent:writeStream(streamId, connection)   
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
    streamWriteBool(streamId, self.state );   
end;

function AllradStateEvent:run(connection)  
    self.vehicle:allradState(self.state, true);
	if not connection:getIsServer() then  
		g_server:broadcastEvent(AllradStateEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;

function AllradStateEvent.sendEvent(vehicle, state, noEventSend)  
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then  
			g_server:broadcastEvent(AllradStateEvent:new(vehicle, state), nil, nil, vehicle);
		else 
			g_client:getServerConnection():sendEvent(AllradStateEvent:new(vehicle, state));
		end;
	end;
end;

