-- wychwytnik iskier
-- edycja i ulepszenia:Grzegorz056 & Lechu


wychwytnikiskier = {};

function wychwytnikiskier.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function wychwytnikiskier:load(xmlFile)

	self.wychwytnikiskier = {};	
	self.wychwytnikiskier.klapa = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wychwytnikiskier#klapa"));
	self.wychwytnikiskier.maxRot = Utils.degToRad(Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wychwytnikiskier#maxRot"),0));
	self.wychwytnikiskier.maxRpm = self.motor:getMaxRpm();

	
end;

function wychwytnikiskier:delete()
end;

function wychwytnikiskier:mouseEvent(posX, posY, isDown, isUp, button)
end;

function wychwytnikiskier:keyEvent(unicode, sym, modifier, isDown)
end;

function wychwytnikiskier:update(dt)

	if self.isMotorStarted then
		if self.wychwytnikiskier.klapa ~= nil then
			local angle = math.rad(math.random(-25,5)) + self.wychwytnikiskier.maxRot * self.motor.lastMotorRpm / self.wychwytnikiskier.maxRpm;	
			angle = math.max(math.min(angle, 0), self.wychwytnikiskier.maxRot);		
			setRotation(self.wychwytnikiskier.klapa,0,0,angle);        --klania sie znajomosc rotacji--
		end;
	end;
end;

function wychwytnikiskier:draw()
end;

function wychwytnikiskier:startMotor()
end;

function wychwytnikiskier:stopMotor()
	if self.wychwytnikiskier.klapa ~= nil then
		setRotation(self.wychwytnikiskier.klapa, 0,0,0);
	end;
end;