-- ##############################################################
-- #	lowFuelIndicator (hladove oko)				#
-- #								#
-- #	author: Webby						#
-- #	edit: Saty						#
-- #								#
-- #	Date: 27.10.2012					#
-- #	version: 1.2 (LS2013)					#
-- #								#
-- ##############################################################

lowFuelIndicator = {};

function lowFuelIndicator.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function lowFuelIndicator:load(xmlFile)
	
	self.lowFuelIndicatorYes = Overlay:new("lowFuelIndicatorOverlay", Utils.getFilename("textures/lowFuel_yes.png", self.baseDirectory), 0.738, 0.052, 0.02, 0.025);
	self.lowFuelIndicatorNo = Overlay:new("lowFuelIndicatorOverlay", Utils.getFilename("textures/lowFuel_no.png", self.baseDirectory), 0.738, 0.052, 0.02, 0.025);
	
	lowFuelSoundFile = Utils.getFilename("sounds/fuelIndicator_bing.wav", self.baseDirectory);
    	self.lowFuelSoundId = createSample("LFSound");
	loadSample(self.lowFuelSoundId, lowFuelSoundFile, false);
	self.lowFuelSoundPlaying = false;
	self.playedSound = false;
end;

function lowFuelIndicator:delete()
end;

function lowFuelIndicator:mouseEvent(posX, posY, isDown, isUp, button)
end;

function lowFuelIndicator:keyEvent(unicode, sym, modifier, isDown)
end;

function lowFuelIndicator:update(dt)
end;

function lowFuelIndicator:draw()
	if self.fuelFillLevel <= (self.fuelCapacity / 100) * 25 then
		self.lowFuelIndicatorYes:render();
		if self.playedSound == false then
			playSample(self.lowFuelSoundId,1,1,0);
			self.playedSound = true;
		end;
		else
			self.lowFuelIndicatorNo:render();
			self.playedSound = false;
	end;
end;
