-- SwitchingNWheelModes
-- Specialization for SwitchingNWheelModes from John Deere OldVersion Pack
--
-- @author  Tobias F. (John Deere 6930)
-- @date 30/01/2011
--[[XML:
<SwitchingNWheelModes switchWheelModeKey="">
	<registerWheel index="" wheelId="" />
	<registerWheelSelectionGroup wheelIds="" nextWheelSelectionGroupRenderText=""/>
	<normalWheelSelectionGroup wheelInteger=""/>
</SwitchingNWheelModes>
]]

SwitchingNWheelModes = {};

function SwitchingNWheelModes.prerequisitesPresent(specializations)
    return true;
end;

function SwitchingNWheelModes:load(xmlFile)	
    self.setWheelSelectionGroup = SpecializationUtil.callSpecializationsFunction("setWheelSelectionGroup");

	local inputKeystr = Utils.getNoNil(getXMLString(xmlFile, "vehicle.SwitchingNWheelModes#switchWheelModeKey"), "IMPLEMENT_EXTRA");
	self.switchWheelModeKey = InputBinding[inputKeystr];
	
	self.wheelVisibility = {};
    local i = 0;
    while true do
		local key = string.format("vehicle.SwitchingNWheelModes.registerWheel(%d)", i);
		local index = getXMLString(xmlFile, key.."#index");
		local wheelId = getXMLString(xmlFile, key.."#wheelId");
		local wheelTrackSpawn = getXMLString(xmlFile, key.."#wheelTrackSpawn");
		if index ~= nil and wheelId ~= nil then
			local entry = {};
			entry.node = Utils.indexToObject(self.components, index);
			setVisibility(entry.node, false);
			entry.wheelId = wheelId;
			if wheelTrackSpawn ~= nil then
				entry.wheelTrackSpawn = Utils.indexToObject(self.components, wheelTrackSpawn);
			end;
			table.insert(self.wheelVisibility, entry);
		else
			break;
		end;
		i = i + 1;
	end;
	
	self.wheelSelectionGroups = {};
	i = 0;
    while true do
		local key = string.format("vehicle.SwitchingNWheelModes.registerWheelSelectionGroup(%d)", i);
		local wheelIdsStr = getXMLString(xmlFile, key.."#wheelIds");
		local nextWheelSelectionGroupRenderTextStr = getXMLString(xmlFile, key.."#nextWheelSelectionGroupRenderText");
		if wheelIdsStr ~= nil and nextWheelSelectionGroupRenderTextStr ~= nil then
			local entry = {}; 
			entry.wheelIds = {};
			local wheelIds = Utils.splitString(" ", wheelIdsStr);
			for k,v in pairs(wheelIds) do
				for a,b in pairs(self.wheelVisibility) do
					if v == b.wheelId then						
						table.insert(entry.wheelIds, b.wheelId);
					end;
				end;
			end;
			entry.nextWheelSelectionGroupRenderText = g_i18n:getText(nextWheelSelectionGroupRenderTextStr)
			table.insert(self.wheelSelectionGroups, entry);
		else
			break;
		end;
		i = i + 1;
	end;
	self.currentSelectedGroup = 0;
	self.startSelectedGroup = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.SwitchingNWheelModes.normalWheelSelectionGroup#wheelInteger"), 1);
end;

function SwitchingNWheelModes:delete()
end;

function SwitchingNWheelModes:readStream(streamId, connection)
	local newSelectedGroup = streamReadInt8(streamId);
	if newSelectedGroup ~= self.currentSelectedGroup then
		self:setWheelSelectionGroup(newSelectedGroup, true);
	end;
end;

function SwitchingNWheelModes:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.currentSelectedGroup);
end;

function SwitchingNWheelModes:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SwitchingNWheelModes:keyEvent(unicode, sym, modifier, isDown)
end;

function SwitchingNWheelModes:update(dt)
	if not self.loadedStartWheels then
		self:setWheelSelectionGroup(self.startSelectedGroup, true);
		self.loadedStartWheels = true;
	end;
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(self.switchWheelModeKey) then
			local newSelectedGroup = self.currentSelectedGroup + 1;
			if newSelectedGroup > table.getn(self.wheelSelectionGroups) then
				newSelectedGroup = 1;
			end;
			self:setWheelSelectionGroup(newSelectedGroup);
		end;
	end;
end;

function SwitchingNWheelModes:updateTick(dt)
end;

function SwitchingNWheelModes:draw()
	if self.currentSelectedGroup > 0 then
		g_currentMission:addHelpButtonText(self.wheelSelectionGroups[self.currentSelectedGroup].nextWheelSelectionGroupRenderText, self.switchWheelModeKey);
	end;
end;

function SwitchingNWheelModes:setWheelSelectionGroup(newSelectedGroup, noEventSend)
	SetWheelSelectionGroupEvent.sendEvent(self, newSelectedGroup, noEventSend);
	local firstSetAllInvisible = true;
	if firstSetAllInvisible then
		for c,d in pairs(self.wheelVisibility) do
			if getVisibility(d.node) then
				setVisibility(d.node, false);
			end;
			if d.activTrack ~= nil then
				d.activTrack = false;
			end;
		end;
		firstSetAllInvisible = false;
	end;
	for k,v in pairs(self.wheelSelectionGroups) do
		if k == newSelectedGroup then
			for a,b in pairs(v.wheelIds) do
				for c,d in pairs(self.wheelVisibility) do
					if b == d.wheelId then
						setVisibility(d.node, true);
						if d.activTrack ~= nil then
							d.activTrack = true;
						end;
					end;
				end;
			end;
		end;
	end;
	self.currentSelectedGroup = newSelectedGroup;
end;

function SwitchingNWheelModes:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
	if not resetVehicles then
		local wheelSelectionGroup = getXMLInt(xmlFile, key.."#wheelSelectionGroup");
		if wheelSelectionGroup > 0 and wheelSelectionGroup <= table.getn(self.wheelSelectionGroups) then
			self:setWheelSelectionGroup(wheelSelectionGroup, true)
		end;
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function SwitchingNWheelModes:getSaveAttributesAndNodes(nodeIdent)
	if self.currentSelectedGroup > 0 then
		local attributes = 'wheelSelectionGroup="' .. tostring(self.currentSelectedGroup) ..'"';
		return attributes, nil;
	end;
end;