PressureWasherLanceEvent = {};
PressureWasherLanceEvent_mt = Class(PressureWasherLanceEvent, Event);

InitEventClass(PressureWasherLanceEvent, "PressureWasherLanceEvent");

function PressureWasherLanceEvent:emptyNew()
    local self = Event:new(PressureWasherLanceEvent_mt);
    self.className="PressureWasherLanceEvent";
    return self;
end;

function PressureWasherLanceEvent:new(vehicle, isActive)
    local self = PressureWasherLanceEvent:emptyNew()
    self.vehicle = vehicle;
	self.isActive = isActive;
    return self;
end;

function PressureWasherLanceEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isActive = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function PressureWasherLanceEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isActive);	
end;

function PressureWasherLanceEvent:run(connection)
	self.vehicle:setLanceActive(self.isActive, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(PressureWasherLanceEvent:new(self.vehicle, self.isActive), nil, connection, self.object);
	end;
end;

function PressureWasherLanceEvent.sendEvent(vehicle, isActive, noEventSend)
	if isActive ~= vehicle.isLanceActive then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(PressureWasherLanceEvent:new(vehicle, isActive), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(PressureWasherLanceEvent:new(vehicle, isActive));
			end;
		end;
	end;
end;