--
-- greenDirectCut
-- 
--
-- upsideDown 09.01.2014
-- V1.0 14.01.2014
-- V1.1 15.01.2014 added support for helper. fixed MP
-- V1.2 skipped, used for additional mod (map colors)
-- V1.3 changes wrapped around update/postUpdate and updateTick/postUpdateTick for intrinsic support e.g. of cutterParticle.lua and others.
--      mapcolors integrated into core mod
-- V2.0 converted to LS15
greenDirectCut = {};
greenDirectCut.doShift = false;




g_statisticView.growthGrowingColors[4] = { 0.87,  1.0,  0.3,  1};




function greenDirectCut:newCutterUpdateTick(superFunc,dt)	
	if self:getIsActive() then		
		greenDirectCut:shiftMinGrowthState(self,-1);
		if g_currentMission.missionStats.difficulty == 3 then
			greenDirectCut:forceGreenForage(self,false);
		end;
	end;
	greenDirectCut.doShift = true;
	superFunc(self,dt);
	-- greenDirectCut.doShift = false;
	-- if self:getIsActive() then		
		-- greenDirectCut:shiftMinGrowthState(self,1);
		-- if g_currentMission.missionStats.difficulty == 3 then
			-- greenDirectCut:forceGreenForage(self,true);
		-- end;
	-- end;
	
	
	-- if false then--remove; maybe repair later
		-- local colors = g_inGameMenu.growthGrowingColors;
		-- colors[4] = {
		  -- 0.87,
		  -- 1.0,
		  -- 0.3,
		  -- 1
		-- };
		-- g_inGameMenu.growthGrowingColors = colors;
	-- end;
	
end;



--newCutterUpdate
function greenDirectCut:newCutterUpdate(superFunc,dt)		
	if self:getIsActive() then		
		greenDirectCut:shiftMinGrowthState(self,-1);
		if g_currentMission.missionStats.difficulty == 3 then
			greenDirectCut:forceGreenForage(self,false);
		end;
	end;
	greenDirectCut.doShift = true;
	
	superFunc(self,dt);
	
	
end;


function greenDirectCut:newCutterPostUpdateTick(superFunc,dt)		
	superFunc(self,dt);
	
	greenDirectCut.doShift = false;
	if self:getIsActive() then		
		greenDirectCut:shiftMinGrowthState(self,1);
		if g_currentMission.missionStats.difficulty == 3 then
			greenDirectCut:forceGreenForage(self,true);
		end;
	end;
end;

function greenDirectCut:newCutterPostUpdateTickSub(dt)	
	greenDirectCut.doShift = false;
	if self:getIsActive() then		
		greenDirectCut:shiftMinGrowthState(self,1);
		if g_currentMission.missionStats.difficulty == 3 then
			greenDirectCut:forceGreenForage(self,true);
		end;
	end;
end;

function greenDirectCut:newCutterPostUpdateSub(dt)	
	greenDirectCut.doShift = false;
	if self:getIsActive() then		
		greenDirectCut:shiftMinGrowthState(self,1);
		if g_currentMission.missionStats.difficulty == 3 then
			greenDirectCut:forceGreenForage(self,true);
		end;
	end;
end;

function greenDirectCut:newCutterPostUpdate(superFunc,dt)		
	superFunc(self,dt);
	
	greenDirectCut.doShift = false;
	if self:getIsActive() then		
		greenDirectCut:shiftMinGrowthState(self,1);
		if g_currentMission.missionStats.difficulty == 3 then
			greenDirectCut:forceGreenForage(self,true);
		end;
	end;
end;


function greenDirectCut:shiftMinGrowthState(self,delta)
	for fruitType,entry in pairs(g_currentMission.fruits) do
		local outputFruitType = fruitType;
		if self.convertedFruits[fruitType] ~= nil then
			 outputFruitType = self.convertedFruits[fruitType];
		end;
		if outputFruitType == FruitUtil.FRUITTYPE_CHAFF then --its a chopper, and...
			--if entry.windrowId ~= nil and entry.windrowId ~= 0 then --we chop something with windrows, and...
				local desc = FruitUtil.fruitIndexToDesc[fruitType];
				if desc.name ~= "grass" then -- its not grass: go for it! :)
					desc.minHarvestingGrowthState = desc.minHarvestingGrowthState + delta;
					desc.isShifted = delta<0;
					FruitUtil.fruitIndexToDesc[fruitType] = desc;
				end;
			--end;
		end;
	end;
end;

function greenDirectCut:forceGreenForage(self,reset)
	for fruitType,entry in pairs(g_currentMission.fruits) do
		local outputFruitType = fruitType;
		--print(self.name)
		if self.convertedFruits[fruitType] ~= nil then
			 outputFruitType = self.convertedFruits[fruitType];		
		end;
		if outputFruitType == FruitUtil.FRUITTYPE_CHAFF then --its a chopper, and...
			--if entry.windrowId ~= nil and entry.windrowId ~= 0 then --we chop something with windrows, and...
				local desc = FruitUtil.fruitIndexToDesc[fruitType];
				if desc.name ~= "grass" then -- its not grass: go for it! :)
					if reset then
						desc.maxHarvestingGrowthState = desc.origMaxHarvestingGrowthState;
					else
						desc.origMaxHarvestingGrowthState = desc.maxHarvestingGrowthState;
						desc.maxHarvestingGrowthState = desc.minHarvestingGrowthState;
					end;
					
					FruitUtil.fruitIndexToDesc[fruitType] = desc;
				end;
			--end;
		end;
	end;
end;


function greenDirectCut:newAIUpdateTick(superFunc, dt)
	if self:getIsActive() then
		
		for cutter,_ in pairs(self.attachedCutters) do
			greenDirectCut:shiftMinGrowthState(cutter,-1);
			if g_currentMission.missionStats.difficulty == 3 then
				greenDirectCut:forceGreenForage(cutter,false);
			end;
		end;
	end;
	superFunc(self,dt);
	if self:getIsActive() then
		for cutter, _ in pairs(self.attachedCutters) do
			greenDirectCut:shiftMinGrowthState(cutter,1);
			if g_currentMission.missionStats.difficulty == 3 then
				greenDirectCut:forceGreenForage(cutter,true);
			end;
		end;
	end;
end;

function greenDirectCut:writeStream(superFunc,streamId, connection)
	
	local desc = FruitUtil.fruitIndexToDesc[self.fruitType];
	local doSend = greenDirectCut.doShift and Utils.getNoNil(desc.isShifted,false);
	streamWriteBool(streamId, doSend);
	
	if doSend then
		streamWriteUIntN(streamId, self.fruitType, FruitUtil.sendNumBits);
	end;
	superFunc(self, streamId, connection);
end;

function greenDirectCut:readStream(superFunc,streamId, connection)
	local doShift = streamReadBool(streamId, greenDirectCut.doShift);
	local fruitType;
	local desc;
	if doShift then
		 fruitType = streamReadUIntN(streamId, FruitUtil.sendNumBits);
		 desc = FruitUtil.fruitIndexToDesc[fruitType];
		 desc.minHarvestingGrowthState = desc.minHarvestingGrowthState -1;
		 if g_currentMission.missionStats.difficulty == 3 then
			desc.origMaxHarvestingGrowthState = desc.maxHarvestingGrowthState;
			desc.maxHarvestingGrowthState = desc.minHarvestingGrowthState;
		 end;
		 FruitUtil.fruitIndexToDesc[fruitType] = desc;
	end;
	superFunc(self, streamId, connection);
	if doShift then
		desc.minHarvestingGrowthState = desc.minHarvestingGrowthState +1;
		 if g_currentMission.missionStats.difficulty == 3 then			
			desc.maxHarvestingGrowthState = desc.origMaxHarvestingGrowthState;
		 end;
		 FruitUtil.fruitIndexToDesc[fruitType] = desc;
	end;
	
end;

print("--- loading greenDirectCut mod V2.0 --- (by upsidedown)")
Cutter.updateTick = Utils.overwrittenFunction(Cutter.updateTick,greenDirectCut.newCutterUpdateTick);
AICombine.updateTick = Utils.overwrittenFunction(AICombine.updateTick,greenDirectCut.newAIUpdateTick);
CutterAreaEvent.writeStream = Utils.overwrittenFunction(CutterAreaEvent.writeStream,greenDirectCut.writeStream);
CutterAreaEvent.readStream  = Utils.overwrittenFunction(CutterAreaEvent.readStream, greenDirectCut.readStream);

--new in V1.3
if Cutter.postUpdateTick == nil then
	Cutter.postUpdateTick = greenDirectCut.newCutterPostUpdateTickSub;
else
	Cutter.postUpdateTick = Utils.overwrittenFunction(Cutter.postUpdateTick,greenDirectCut.newCutterPostUpdateTickSub);
end;

if Cutter.postUpdate == nil then
	Cutter.postUpdate = greenDirectCut.newCutterPostUpdateSub;
else
	Cutter.postUpdate = Utils.overwrittenFunction(Cutter.postUpdate,greenDirectCut.newCutterPostUpdate);
end;

Cutter.update = Utils.overwrittenFunction(Cutter.update,greenDirectCut.newCutterUpdate);