--
-- complexBGA
--
-- upsideDown project start: 01.06.2014
-- restart from scrap: 26.8.2014
-- 
-- V0.9Beta: 1.9.2014: All intended features implemented, SP only!
-- V0.91Beta: 2.9.2014: MP added
-- V1.0 initial release, 5.9.2014
-- V1.1 save bug removed, made readout for MapBuyableObject, correction of LM-trigger collisionMask (Holzhausen, Herrenhausen map etc)

g_i18n.globalI18N.texts["complexBGA_fermenter_TS"]    = g_i18n:getText("complexBGA_fermenter_TS");
g_i18n.globalI18N.texts["complexBGA_power"]    = g_i18n:getText("complexBGA_power");
g_i18n.globalI18N.texts["complexBGA_fermenter_feeding_speed"]    = g_i18n:getText("complexBGA_fermenter_feeding_speed");
g_i18n.globalI18N.texts["complexBGA_more_feeding"]    = g_i18n:getText("complexBGA_more_feeding");
g_i18n.globalI18N.texts["complexBGA_less_feeding"]    = g_i18n:getText("complexBGA_less_feeding");
g_i18n.globalI18N.texts["complexBGA_buyAndStartup"]    = g_i18n:getText("complexBGA_buyAndStartup");
g_i18n.globalI18N.texts["complexBGA_Startup"]    = g_i18n:getText("complexBGA_Startup");
g_i18n.globalI18N.texts["complexBGA_noMoney"]    = g_i18n:getText("complexBGA_noMoney");

Bga.complexBgaDebug = false; --dont touch this unless you really know what you are doing...

complexBGA = {};
addModEventListener(complexBGA);

function complexBGA:loadMap(name)
	print("--- loading complexBGA mod V1.1 --- (by upsidedown)")

	Bga.addBGAfillType(Fillable.FILLTYPE_SILAGE,0.3,202*0.52,1.0,false)
	Bga.addBGAfillType(Fillable.FILLTYPE_MANURE,0.25,45*0.60,0.75,false)
	Bga.addBGAfillType(Fillable.FILLTYPE_DRYGRASS,0.35,172*0.54,0.9,false)
	Bga.addBGAfillType(Fillable.FILLTYPE_DRYGRASS_WINDROW,0.35,172*0.54,0.9,false)
	Bga.addBGAfillType(Fillable.FILLTYPE_SUGARBEET,0.23,111*0.51,1.2,false)
	
	Bga.addBGAfillType("hay",0.87,324*0.67,0.95,false)
	
	Bga.addBGAfillType(Fillable.FILLTYPE_WHEAT,0.88,490*0.54,0.9,false)
	Bga.addBGAfillType(Fillable.FILLTYPE_BARLEY,0.88,490*0.54,0.9,false)
	Bga.addBGAfillType(Fillable.FILLTYPE_RAPE,0.88,490*0.54,0.9,false)
	Bga.addBGAfillType(Fillable.FILLTYPE_OAT,0.88,490*0.54,0.9,false)
	Bga.addBGAfillType(Fillable.FILLTYPE_RYE,0.88,490*0.54,0.9,false)
	Bga.addBGAfillType(Fillable.FILLTYPE_MILLET,0.88,490*0.54,0.9,false)
	Bga.addBGAfillType(Fillable.FILLTYPE_DINKEL,0.88,490*0.54,0.9,false)
	
	Bga.noComplexBgaBuyNeeded = false;	
	
	local MBO = getfenv(0)['MapBuyableObject'];
	if MBO ~= nil then		
		local ObjectBuy = MBO.ObjectBuy;
		if ObjectBuy ~= nil then
			--print("BGA: ObjectBuy found!")			
			if ObjectBuy.drawParts ~= nil then
				--print("BGA: ObjectBuy.drawParts found!")
				local N = table.getn(ObjectBuy.drawParts)
				--print(N)
				if N > 0 then
					Bga.noComplexBgaBuyNeeded = true;
				end;
			end;
		end;	
	end;

	
end;

function complexBGA:deleteMap()
end


function complexBGA:mouseEvent(posX, posY, isDown, isUp, button)
end;

function complexBGA:keyEvent(unicode, sym, modifier, isDown)
end;


function complexBGA:update(dt)
	
end


function complexBGA:draw()   
end;

function Bga.addBGAfillType(fillType,TS,quality,speedFx,force)
	if Bga.complexBGA_data == nil then
		Bga.complexBGA_data = {};
	end;
	
	if fillType ~= nil then
		if Bga.complexBGA_data[fillType] == nil or force then
			Bga.complexBGA_data[fillType] = {};
			Bga.complexBGA_data[fillType].TS = TS;
			Bga.complexBGA_data[fillType].quality = quality/TS; 
			Bga.complexBGA_data[fillType].speedFx = speedFx;
		end;
	end;
	
end;


local oldBGAload = Bga.load;
function Bga:load(nodeId)
	local res = oldBGAload(self,nodeId);
	self.fermenterCapacity = 1000*1250*self.bunkerUseSpeed/25; --25 is standard, is set equal to 500kW_el installation
	
	-- self.fermenterTS = 0.12; 
	-- self.fermenter_quality = 45*0.60;   --fermenter in manure mode
	-- self.fermenter_speedFx = 0.75;
	
	-- self.fermenterTS = 0.13; 
	-- self.fermenter_quality = 202*0.52;   --fermenter in silage mode
	-- self.fermenter_speedFx = 1.0;
	self.fermenterTS = 0.0; 
	self.fermenter_quality = 0;   --fermenter in empty mode
	self.fermenter_speedFx = 1.0;
		
	self.bunkerUseSpeed = self.bunkerUseSpeed * self.bunkerUseSpeed/75*0.57*1.0;
	
	self.bunker_quality = 202*0.52/0.3;   -- bunker filled with maize silage
	self.bunker_TS = 0.30;
	self.bunker_speed = 1.0;
	
	--self.bunker_quality = 202*0.52;   -- bunker empty at start
	--self.bunker_quality = 45*0.60;   -- bunker empty at start
	--self.bunker_TS = 0.25;
	--self.bunker_speed = 0.75;
	
	self.bunkerFeedFactor = 1.0;
	
	self.fermenter_TS_min = 0.04;
	self.fermenter_TS_opt = 0.10;
	self.fermenter_TS_clog = 0.16;
	
	self.fermenter_bioOK = false; --default off
	
	-- for _,trigger in pairs(self.tipTriggers) do
		-- for fillType, pm in pairs(trigger.priceMultipliers) do
			-- pm = 0;
		-- end;
	-- end;

	if self.liquidManureSiloTrigger ~= nil then
		self.liquidManureSiloTrigger.bga = self; --reference to BGA within manure_trigger
		
		--correct collisionMask if necessary:
		--print("BGA: CHECK COLLISIONMASK:")
		local target = 11534336;
		local colli = getCollisionMask(self.liquidManureSiloTrigger.triggerId);
		
		if colli~= target then			
			setCollisionMask(self.liquidManureSiloTrigger.triggerId,target)
			print("BGAextension: collisionMask of LiquidManureFillTrigger with id "..tostring(self.liquidManureSiloTrigger.triggerId) .." corrected from "..tostring(colli).." to "..tostring(target))
		end;
		
		
	end;
	
	self.printPower = 0;
	self.initialSyncDone = false;
	
	
	
	--print("BGA load done")
	return res;
end;


	local DebugTime = 0; --DEBUG
	local DebugMoney = 0;
	local DebugMoneyFromPrice = 0;
	local DebugLastFeed = 0;


function Bga:updateTick(dt)
	DebugTime = DebugTime+dt/1000*g_currentMission.missionStats.timeScale;
    if self.isServer then
			if not self.initialSyncDone then
				BGAsyncEvent.sendEvent(self)
				self.initialSyncDone = true;
			end;
			
			self.bunkerUseTime = self.bunkerUseTime + dt;

			local timestep = 1000;
			if g_currentMission.missionStats.timeScale > 50 then
				timestep = timestep*0.5;
			end;
			if g_currentMission.missionStats.timeScale > 100 then
				timestep = timestep*0.5;
			end;
			if g_currentMission.missionStats.timeScale > 120 then --run on dt if "fastForward" is used
				timestep = 0;
			end;
			
			if self.fermenter_bioOK then
				if self.bunkerUseTime > timestep then
					if math.abs(g_currentMission.environment.currentHour - 8) < 0.5 or math.abs(g_currentMission.environment.currentHour - 20) < 0.5 then --feed twice a day
						if self.bunkerFillLevel > 0 and (self.liquidManureSiloTrigger == nil or self.liquidManureSiloTrigger.fillLevel < self.liquidManureSiloTrigger.capacity) then 
							local oldFillLevel = self.bunkerFillLevel;

							local bunkerUseSpeed = self.bunkerUseSpeed*g_currentMission.missionStats.timeScale--/self.bunkerUseTime;
							
							local m_add = self.bunkerUseTime/1000 * bunkerUseSpeed * 0.35/self.bunker_TS; --normed to maize silage;
							
							m_add = m_add*self.bunkerFeedFactor;
							
							self:setBunkerFillLevel(self.bunkerFillLevel - m_add);

							local delta = oldFillLevel-self.bunkerFillLevel;					
							if delta > 0 and self.liquidManureSiloTrigger ~= nil then
								self.liquidManureSiloTrigger:setFillLevel(self.liquidManureSiloTrigger.fillLevel + delta*self.fillDeltaToManureDeltaScale);
							end;						
												
							self.fermenterTS = ((self.fermenterCapacity-delta)*self.fermenterTS + delta*self.bunker_TS)/self.fermenterCapacity;
							self.fermenter_quality = ((self.fermenterCapacity-delta)*self.fermenter_quality + delta*self.bunker_quality)/self.fermenterCapacity;
							self.fermenter_speedFx = ((self.fermenterCapacity-delta)*self.fermenter_speedFx + delta*self.bunker_speed)/self.fermenterCapacity;					
							
						end;
					elseif Bga.complexBgaDebug then --DEBUG FEEDING
						if g_currentMission.controlPlayer then --DEBUG ONLY!!!
							
							local delta = math.max(50000 - self.bunkerFillLevel,0)
							
							local difficultyMultiplier = math.max(2 * (3 - g_currentMission.missionStats.difficulty), 1)
							local money = Fillable.fillTypeIndexToDesc[Fillable.FILLTYPE_SILAGE].pricePerLiter * difficultyMultiplier * delta
							DebugMoneyFromPrice = DebugMoneyFromPrice + money;
							
							self.bunkerFillLevel = self.bunkerFillLevel + delta;
							
							DebugLastFeed = delta;
						end;
					end;
					
					--- end feeding
					
					--start digesting:
					local k = 0.0025/3600/24*75; --s^-1
													
					local f_TS = 0.0; 
										
					if self.fermenterTS > self.fermenter_TS_min and self.fermenterTS <= self.fermenter_TS_opt then
						f_TS = (self.fermenterTS - self.fermenter_TS_min)^2/(self.fermenter_TS_opt-self.fermenter_TS_clog)^2
					elseif self.fermenterTS > self.fermenter_TS_opt then
						f_TS = 1.0;
					end; --clogging comes later (if ever)
					
					local dTS = self.fermenterTS^1.5 * f_TS * k * self.fermenter_speedFx;
					
					-- damping
					-- if false then
						-- if self.oldDTS == nil then
							-- self.oldDTS = dTS;
						-- end;
						-- local damping = 1e-6;
						-- if dTS > self.oldDTS then
							-- damping = math.min(damping * g_currentMission.missionStats.timeScale*self.bunkerUseTime,1);
							-- dTS = damping*dTS + (1-damping) * self.oldDTS;
						-- end;
						-- self.oldDTS = dTS;
					-- end;
					--damping
					
					dTS = dTS * self.bunkerUseTime/1000*g_currentMission.missionStats.timeScale;
					self.fermenterTS = self.fermenterTS - dTS;
					
					local m_gas = dTS*self.fermenterCapacity/1000*self.fermenter_quality;
					
					self.printPower = m_gas/(g_currentMission.missionStats.timeScale*self.bunkerUseTime/1000)*3600*40/2.5/3;
					
					
					local difficultyMultiplier = math.max(2 * (3 - g_currentMission.missionStats.difficulty), 1)
					local money = m_gas*35*Fillable.fillTypeIndexToDesc[Fillable.FILLTYPE_SILAGE].pricePerLiter;
					money = money*difficultyMultiplier;

					g_currentMission:addSharedMoney(money, "harvestIncome")				
					
					local dayCost = g_currentMission.missionStats.difficulty*1000*(1 + math.max(self.fermenterTS-0.1,0)*10);
					local cost = dayCost/24/3600/1000*self.bunkerUseTime;
					
					g_currentMission:addSharedMoney(-cost, "propertyMaintenance");			
					
					if self.fermenterTS < 0.05 then
						self.fermenter_bioOK = false;
						self.printPower = 0;
					end;

					if Bga.complexBgaDebug then
						DebugMoney = DebugMoney + money - cost;
						print(DebugTime," ",DebugMoney," "..tostring(DebugMoneyFromPrice).." "..tostring(DebugLastFeed))
					end;
									
					self.bunkerUseTime = 0;
					
					BGAsyncEvent.sendEvent(self)
					
				end;			
			end;
		if self.bunkerFillLevel ~= self.sentBunkerFillLevel then
			self:raiseDirtyFlags(self.bgaDirtyFlag);

			self.sentBunkerFillLevel = self.bunkerFillLevel;
		end;
    end;
end;

function Bga:update(dt)
  if self.isClient then
    if self.liquidManureSiloTrigger ~= nil then
      self.liquidManureSiloTrigger:update(dt)
    end
    --self.bunkerPlaneAlpha = math.max(self.bunkerPlaneAlpha - self.bunkerUseSpeed * g_currentMission.missionStats.timeScale * 0.001 / self.bunkerCapacity * dt * self.bunkerPlaneMoveScale, 0)
	self.bunkerPlaneAlpha = self.bunkerFillLevel/self.bunkerCapacity;
    if self.bunkerPlaneId ~= nil then
      local x, y, z = getTranslation(self.bunkerPlaneId)
      setTranslation(self.bunkerPlaneId, x, self.bunkerPlaneMinY + self.bunkerPlaneAlpha * (self.bunkerPlaneMaxY - self.bunkerPlaneMinY), z)
    end
    if self.bunkerPlaneAlpha > 0 and (math.abs(g_currentMission.environment.currentHour - 8) < 0.5 or math.abs(g_currentMission.environment.currentHour - 20) < 0.5) then	
      self.bunkerPushersTime = self.bunkerPushersTime + dt * self.bunkerPushersSpeedScale
      while 0 < self.bunkerPushersTime do
        self.bunkerPushersTime = self.bunkerPushersTime - math.pi * 2
      end
      self:updateBunkerPushers()
      for i = 1, table.getn(self.bunkerRolls) do
        rotate(self.bunkerRolls[i], self.bunkerRollsSpeed * dt, 0, 0)
      end
      if not self.bunkerSoundPlaying and self.bunkerSoundId ~= nil then
        setVisibility(self.bunkerSoundId, true)
        self.bunkerSoundPlaying = true
      end
    elseif self.bunkerSoundPlaying then
      setVisibility(self.bunkerSoundId, false)
      self.bunkerSoundPlaying = false
    end
  end
  if false then
	  renderText(0.4,0.3,0.02,"Fermenter: TS: "..tostring(self.fermenterTS).."  quality: "..tostring(self.fermenter_quality).."  speed: "..tostring(self.fermenter_speedFx))
	  renderText(0.4,0.34,0.02,"Bunker: fillLevel: "..tostring(self.bunkerFillLevel).."  TS: "..tostring(self.bunker_TS).."  quality: "..tostring(self.bunker_quality).."speed: "..tostring(self.bunker_speed))
  end
end


function Bga:getAllowShovelFillType(fillType)
	for fillType_bga,_ in pairs(Bga.complexBGA_data) do		
		if fillType == fillType_bga then
			return true;
		end;
	end;
	return false;
end


local oldBGAshovelFillLevel = Bga.addShovelFillLevel;
function Bga:addShovelFillLevel(shovel, fillLevelDelta, fillType)
	
	local oldPrice = Fillable.fillTypeIndexToDesc[fillType].pricePerLiter;
	Fillable.fillTypeIndexToDesc[fillType].pricePerLiter = 0;
	
	local oldFillLevel = self.bunkerFillLevel;
	
	local delta = oldBGAshovelFillLevel(self, shovel, fillLevelDelta, fillType)
	
	Fillable.fillTypeIndexToDesc[fillType].pricePerLiter = oldPrice;
	
	ftData = Bga.complexBGA_data[fillType];
	
	self.bunker_quality = (oldFillLevel*self.bunker_quality + ftData.quality*delta)/self.bunkerFillLevel;
	self.bunker_TS = (oldFillLevel*self.bunker_TS + ftData.TS*delta)/self.bunkerFillLevel;
	self.bunker_speed = (oldFillLevel*self.bunker_speed + ftData.speedFx*delta)/self.bunkerFillLevel;
	
	if Bga.complexBgaDebug then
		local difficultyMultiplier = math.max(2 * (3 - g_currentMission.missionStats.difficulty), 1)
		local money = Fillable.fillTypeIndexToDesc[fillType].pricePerLiter * difficultyMultiplier * fillLevelDelta
		DebugMoneyFromPrice = DebugMoneyFromPrice + money;
	end
	
	
	return delta	
end;

local oldLMFT_update = LiquidManureFillTrigger.update;

function LiquidManureFillTrigger:update(dt)
  
    oldLMFT_update(self,dt);
  
	if self.bga ~= nil then
		--print("BGA is not nil...")
		local factor = self.bga.fermenterCapacity/(1000*1250);
		factor = math.sqrt(factor);
	  
		local costStartup = 120000*factor;
		local costStartupBuy = 2*costStartup;
			
		if g_currentMission.controlPlayer and self.playerInRange then
			if self.bga.fermenter_bioOK then
				g_currentMission:addExtraPrintText(g_i18n:getText("complexBGA_fermenter_TS") .. " "..tostring(math.floor(self.bga.fermenterTS*10000)/100).."%")
				g_currentMission:addExtraPrintText(g_i18n:getText("complexBGA_power") .. " "..tostring(math.floor(self.bga.printPower*10)/10).. " kW")
				
				g_currentMission:addExtraPrintText(g_i18n:getText("complexBGA_fermenter_feeding_speed")..": "..tostring(math.floor(self.bga.bunkerFeedFactor*100)).."%")
				if g_currentMission:getIsServer() or g_currentMission.isMasterUser then
					g_currentMission:addHelpButtonText(g_i18n:getText("complexBGA_more_feeding"), InputBinding.BGAextension_feedUp);
					g_currentMission:addHelpButtonText(g_i18n:getText("complexBGA_less_feeding"), InputBinding.BGAextension_feedDown);
					if InputBinding.hasEvent(InputBinding.BGAextension_feedUp) then
						self.bga.bunkerFeedFactor = math.min(self.bga.bunkerFeedFactor + 0.05,1.5);
					end;
					if InputBinding.hasEvent(InputBinding.BGAextension_feedDown) then					
						self.bga.bunkerFeedFactor = math.max(self.bga.bunkerFeedFactor - 0.05,0.5);
					end;
				end;
							
			else
				if g_currentMission:getIsServer() or g_currentMission.isMasterUser then
					local needBuy = self.bga.fermenterTS == 0 and not Bga.noComplexBgaBuyNeeded;
					if not needBuy and g_currentMission.missionStats.money >= costStartup or g_currentMission.missionStats.money >= costStartupBuy then
						if needBuy then
							g_currentMission:addHelpButtonText(g_i18n:getText("complexBGA_buyAndStartup")..": "..g_i18n:formatMoney(costStartupBuy), InputBinding.BGAextension_startup);
						else
							g_currentMission:addHelpButtonText(g_i18n:getText("complexBGA_Startup")..": "..g_i18n:formatMoney(costStartup), InputBinding.BGAextension_startup);
						end;
						if InputBinding.hasEvent(InputBinding.BGAextension_startup) then					
							self.bga.fermenterTS = 0.075; 
							self.bga.fermenter_quality = 95/0.28;
							self.bga.fermenter_speedFx = 0.9;
							self.bga.fermenter_bioOK = true;
							if g_currentMission:getIsServer() then
								g_currentMission:addSharedMoney(-costStartup, "propertyMaintenance");   --startup					
								if needBuy then
									g_currentMission:addSharedMoney(-costStartupBuy + costStartup, "constructionCost");   --startup					
								end;
							end;
						end;
					else
						g_currentMission:addExtraPrintText(g_i18n:getText("complexBGA_noMoney"))
					end;
				end;
			end;
			if not g_currentMission:getIsServer() and g_currentMission.isMasterUser then
			
				local buy = InputBinding.hasEvent(InputBinding.BGAextension_startup);
				local feedUp = InputBinding.hasEvent(InputBinding.BGAextension_feedUp);
				local feedDown = InputBinding.hasEvent(InputBinding.BGAextension_feedDown);
				
				if buy or feedUp or feedDown then
					BGAinputEvent.sendEvent(self.bga,buy,feedUp,feedDown)
				end;
				
			end;
		end;
	else 
		
	end;
end;

local oldBGAgetSave = Bga.getSaveAttributesAndNodes;
function Bga:getSaveAttributesAndNodes(nodeIdent)
	local attributes, nodes = oldBGAgetSave(self,nodeIdent);
	
	attributes = attributes.. " fermenterTS=\"" ..tostring(self.fermenterTS) 
	attributes = attributes.. "\" fermenterQuality=\"" ..tostring(self.fermenter_quality)
	attributes = attributes.. "\" fermenterSpeed=\"" ..tostring(self.fermenter_speedFx)
		
	attributes = attributes.. "\" bunkerTS=\"" ..tostring(self.bunker_TS)
	attributes = attributes.. "\" bunkerQuality=\"" ..tostring(self.bunker_quality)
	attributes = attributes.. "\" bunkerSpeed=\"" ..tostring(self.bunker_speed)
	attributes = attributes.. "\" bunkerFeedFx=\"" ..tostring(self.bunkerFeedFactor)
	
	attributes = attributes.. "\" fermenter_bioOK=\"" ..tostring(self.fermenter_bioOK) .."\""
	
	return attributes, nodes
end;

local oldBGAloadFrom = Bga.loadFromAttributesAndNodes;
function Bga:loadFromAttributesAndNodes(xmlFile, key)	
	local ok = oldBGAloadFrom(self,xmlFile, key);
	
	if ok then
		local fermenterTS = getXMLFloat(xmlFile, key .. "#fermenterTS")
	    if fermenterTS ~= nil then
			self.fermenterTS = fermenterTS;
	    end
				
		local fermenter_quality = getXMLFloat(xmlFile, key .. "#fermenterQuality")
	    if fermenter_quality ~= nil then
			self.fermenter_quality = fermenter_quality;
	    end
				
		local fermenter_speedFx = getXMLFloat(xmlFile, key .. "#fermenterSpeed")
	    if fermenter_speedFx ~= nil then
			self.fermenter_speedFx = fermenter_speedFx;
	    end
				
		local bunker_TS = getXMLFloat(xmlFile, key .. "#bunkerTS")
	    if bunkerTS ~= nil then
			self.bunkerTS = bunkerTS;
	    end
		
		local bunker_quality = getXMLFloat(xmlFile, key .. "#bunkerQuality")
	    if bunker_quality ~= nil then
			self.bunker_quality = bunker_quality;
	    end
		
		local bunker_speed = getXMLFloat(xmlFile, key .. "#bunkerSpeed")
	    if bunker_speed ~= nil then
			self.bunker_speed = bunker_speed;
	    end
		
		local bunkerFeedFactor = getXMLFloat(xmlFile, key .. "#bunkerFeedFx")
	    if bunkerFeedFactor ~= nil then
			self.bunkerFeedFactor = bunkerFeedFactor;
	    end
		
		local fermenter_bioOK = getXMLBool(xmlFile, key .. "#fermenter_bioOK") --load bug fixed!
	    if fermenter_bioOK ~= nil then
			self.fermenter_bioOK = fermenter_bioOK;
	    end
		
		
		return true;
	end;
	return false;

end;

function Bga:objectDeleteTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
  if onEnter and otherId ~= 0 then
    local object = g_currentMission:getNodeObject(otherId)
    if object ~= nil and object:isa(Bale) then
				
		local fillLevel = object.fillLevel;
		local fillType = object.fillType;
		
		if fillLevel ~= nil and fillType~= nil then
			if self:getAllowShovelFillType(fillType) then
				if fillLevel <= self.bunkerCapacity - self.bunkerFillLevel then
			
					--> here change fillType hay stuff
					if fillType == Fillable.FILLTYPE_DRYGRASS_WINDROW or fillType == Fillable.FILLTYPE_DRYGRASS then
						fillType = "hay"; --dummy fillType for complexBGA_data
					end;
					
					if fillType == Fillable.FILLTYPE_SILAGE then --if its silage in bales its made from gras silage. so use it similar to gras silage from siloExtension-Mod.
						fillType = Fillable.FILLTYPE_DRYGRASS_WINDROW;
					end;
					
					local oldFillLevel = self.bunkerFillLevel;
					self:setBunkerFillLevel(self.bunkerFillLevel + fillLevel);
					
					ftData = Bga.complexBGA_data[fillType];
	
					self.bunker_quality = (oldFillLevel*self.bunker_quality + ftData.quality*fillLevel)/self.bunkerFillLevel;
					self.bunker_TS = (oldFillLevel*self.bunker_TS + ftData.TS*fillLevel)/self.bunkerFillLevel;
					self.bunker_speed = (oldFillLevel*self.bunker_speed + ftData.speedFx*fillLevel)/self.bunkerFillLevel;
					object:delete()					
				end;
			end;
		end;
		
    end
  end
end

local oldBgaTipTriggerGetDistance = BgaTipTrigger.getTipDistanceFromTrailer;
function BgaTipTrigger:getTipDistanceFromTrailer(trailer, tipReferencePointIndex)  
  if self.isComplexBgaInitDone == nil then	  
	  for fillType,_ in pairs(Bga.complexBGA_data) do
		self.acceptedFillTypes[fillType] = true;
		self.priceMultipliers[fillType] = 0;
	  end;
	  
	  self.isComplexBgaInitDone = true;
  end;  
  
  return oldBgaTipTriggerGetDistance(self,trailer, tipReferencePointIndex);
end

function BgaTipTrigger:updateTrailerTipping(trailer, fillDelta, fillType)
  if self.bga:getAllowShovelFillType(fillType) then
	  if fillDelta < 0 then

		local oldFillLevel = self.bga.bunkerFillLevel;
		self.bga:setBunkerFillLevel(self.bga.bunkerFillLevel - fillDelta)
		
		local delta = -fillDelta;
		local ftData = Bga.complexBGA_data[fillType];

		self.bga.bunker_quality = (oldFillLevel*self.bga.bunker_quality + ftData.quality*delta)/self.bga.bunkerFillLevel;
		self.bga.bunker_TS = (oldFillLevel*self.bga.bunker_TS + ftData.TS*delta)/self.bga.bunkerFillLevel;
		self.bga.bunker_speed = (oldFillLevel*self.bga.bunker_speed + ftData.speedFx*delta)/self.bga.bunkerFillLevel;
				
		BgaTipTrigger:superClass().updateTrailerTipping(self, trailer, fillDelta, fillType)
	  end;
   end;
end





BGAsyncEvent = {};
BGAsyncEvent_mt = Class(BGAsyncEvent, Event);

InitEventClass(BGAsyncEvent, "BGAsyncEvent");

function BGAsyncEvent:emptyNew()
    local self = Event:new(BGAsyncEvent_mt);
    self.className="BGAsyncEvent";
    return self;
end;

function BGAsyncEvent:new(bga)
    local self = BGAsyncEvent:emptyNew()
    self.bga = bga;
	self.fermenterTS = bga.fermenterTS;
	self.fermenter_quality = bga.fermenter_quality;
	self.fermenter_speedFx = bga.fermenter_speedFx;
	self.bunker_TS = bga.bunker_TS;
	self.bunker_speed = bga.bunker_speed;
	self.bunkerFeedFactor = bga.bunkerFeedFactor;
	self.fermenter_bioOK = bga.fermenter_bioOK;
	self.printPower = bga.printPower;
	
    return self;
end;

function BGAsyncEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.bga));
	streamWriteFloat32(streamId, self.fermenterTS);
	streamWriteFloat32(streamId, self.fermenter_quality);
	streamWriteFloat32(streamId, self.fermenter_speedFx);
	streamWriteFloat32(streamId, self.bunker_TS);
	streamWriteFloat32(streamId, self.bunker_quality);
	streamWriteFloat32(streamId, self.bunkerFeedFactor);
	streamWriteBool(streamId, self.fermenter_bioOK);	
	streamWriteFloat32(streamId, self.printPower);	
	--print("server side event is sending stuff")
end;

function BGAsyncEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.bga = networkGetObject(id);
	
	self.bga.fermenterTS = streamReadFloat32(streamId);
	self.bga.fermenter_quality = streamReadFloat32(streamId);
	self.bga.fermenter_speedFx = streamReadFloat32(streamId);
	self.bga.bunker_TS = streamReadFloat32(streamId);
	self.bga.bunker_quality = streamReadFloat32(streamId);
	self.bga.bunkerFeedFactor = streamReadFloat32(streamId);
	self.bga.fermenter_bioOK = streamReadBool(streamId);
	self.bga.printPower = streamReadFloat32(streamId);	
end;

function BGAsyncEvent.sendEvent(bga)
	if g_server ~= nil then
		g_server:broadcastEvent(BGAsyncEvent:new(bga), nil, nil, bga);	
	end;
end;







BGAinputEvent = {};
BGAinputEvent_mt = Class(BGAinputEvent, Event);

InitEventClass(BGAinputEvent, "BGAinputEvent");

function BGAinputEvent:emptyNew()
    local self = Event:new(BGAinputEvent_mt);
    self.className="BGAinputEvent";
    return self;
end;

function BGAinputEvent:new(bga,buy,feedUp,feedDown)
    local self = BGAinputEvent:emptyNew()
    self.bga = bga;
	self.buy = buy;
	self.feedUp = feedUp;
	self.feedDown = feedDown;
	
    return self;
end;

function BGAinputEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.bga));
	streamWriteBool(streamId, self.buy);
	streamWriteBool(streamId, self.feedUp);
	streamWriteBool(streamId, self.feedDown);	
end;

function BGAinputEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    local bga = networkGetObject(id);
	
	local buy = streamReadBool(streamId);
	local feedUp = streamReadBool(streamId);
	local feedDown = streamReadBool(streamId);
	
	if bga.fermenter_bioOK then
		if feedUp then
			bga.bunkerFeedFactor = math.min(bga.bunkerFeedFactor + 0.05,1.5);
		end;
		if feedDown then					
			bga.bunkerFeedFactor = math.max(bga.bunkerFeedFactor - 0.05,0.5);
		end;
	else		
		if buy then
			local needBuy = bga.fermenterTS == 0;
		
			local factor = bga.fermenterCapacity/(1000*1250)
			factor = math.sqrt(factor);		  
			local costStartup = 120000*factor;
			local costStartupBuy = 2*costStartup;
			
			if not needBuy and g_currentMission.missionStats.money >= costStartup or g_currentMission.missionStats.money >= costStartupBuy then
				bga.fermenterTS = 0.075; 
				bga.fermenter_quality = 95/0.28;
				bga.fermenter_speedFx = 0.9;
				bga.fermenter_bioOK = true;
				g_currentMission:addSharedMoney(-costStartup, "propertyMaintenance");   --startup					
				if needBuy then
					g_currentMission:addSharedMoney(-costStartupBuy + costStartup, "constructionCost");   --startup					
				end;
			end;
		end;
	end;
end;

function BGAinputEvent.sendEvent(bga,buy,feedUp,feedDown)
	if g_server ~= nil then		
	else
		g_client:getServerConnection():sendEvent(BGAinputEvent:new(bga, buy,feedUp,feedDown));
	end;
end;