SpecializationUtil.registerSpecialization("GPS", "GPS", g_currentModDirectory.."GPS.lua")

GPS_Register = {};

function GPS_Register:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		print("--- loading GPS mod ---")
		--print("--- loading ESLimiter - specialization for ESLimiter + OperatingHours by Manuel Leithner (SFM-Modding)");
		
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("steerable") then
						local v_name_string = v.name 
						local point_location = string.find(v_name_string, ".", nil, true)
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							if rawget(SpecializationUtil.specializations, string.format("%s.GPS", _name)) ~= nil then
								allowInsertion = false;								
							end;							
						end;
						if allowInsertion then	
							--print("GPS INSERT")
							table.insert(v.specializations, SpecializationUtil.getSpecialization("GPS"));
						end;
						
						vs.GPS_TXT_WIDTH = g_i18n:getText("GPSwidth");
						vs.GPS_TXT_OFF = g_i18n:getText("GPS_OFF");
						vs.GPS_TXT_PAS = g_i18n:getText("GPS_PAS");
						vs.GPS_TXT_ACT = g_i18n:getText("GPS_ACT");
						vs.GPS_TXT_LOAD = g_i18n:getText("GPS_LOAD");
						vs.GPS_TXT_SAVE = g_i18n:getText("GPS_SAVE");
						vs.GPS_TXT_REC = g_i18n:getText("GPS_REC");
					end;
				end;
			end;	
		end;
	end;
end;

function GPS_Register:deleteMap()
  
end;

function GPS_Register:keyEvent(unicode, sym, modifier, isDown)

end;

function GPS_Register:mouseEvent(posX, posY, isDown, isUp, button)

end;

function GPS_Register:update(dt)
	
end;

function GPS_Register:draw()
  
end;

addModEventListener(GPS_Register);