--
-- GPS with steering assistance
-- 
-- 
--
-- upsideDown 04/2013

GPS = {};
local GPS_directory = g_currentModDirectory;
function GPS:prerequisitesPresent(specializations)
    --return true;
	return SpecializationUtil.hasSpecialization(steerable, specializations);
end;

function GPS:load(xmlFile)
	--print("GPS LOAD")
	if Steerable.GPSinserted == nil then
		Steerable.updateVehiclePhysics = Utils.overwrittenFunction(
			Steerable.updateVehiclePhysics,
			GPS.updateVehiclePhysics);
		Steerable.GPSinserted = true;
		print("GPS mod inserted into Steerable Specialization (should happen only once!)")
	end

	self.GPSWidth = 6;
	
	self.GPSfirstrun = true;
	self.lhBeta = 0;
	self.lhAngle = 0;
	self.Active = false;
	self.GPSshowTime = 0;
	--self.GPSswitchTime = 400;
	self.GPSisActiveSteering = false;
	
	self.GPSshowMode = 0;
	
	self.GPSoverlay = Overlay:new("GPSoverlay", Utils.getFilename("GPShud.dds", GPS_directory),  0.3, 0.01238, 0.10, 0.04);
	
	
	self.GPStxt = {};
	self.GPStxt.txt = "";
	self.GPStxt.r = .0;
	self.GPStxt.g = 0.;
	self.GPStxt.b = 0.;
	self.GPStxt.bold = false;
	
	self.GPStxt.printDistance = 0;
	
	self.GPS_blinkTime  = 0;
	self.GPS_lastActionText = "";
end;

function GPS:delete()
end


function GPS:updateVehiclePhysics(oldFunc, axisForward, axisForwardIsAnalog, axisSide, axisSideIsAnalog, dt)	
	local offset = 0;
	if self.GPSsteeringOffset ~= nil then
		offset = self.GPSsteeringOffset
	end

	if math.abs(axisSide) > 0.5 then
		self.GPSisActiveSteering = false;	
	end
    oldFunc(self, axisForward, axisForwardIsAnalog, (axisSide+Utils.getNoNil(offset,0)), true, dt);	
end;


function GPS:mouseEvent(posX, posY, isDown, isUp, button)
end;

function GPS:keyEvent(unicode, sym, modifier, isDown)
end;

function GPS:updateTick(dt)
	if self.GPSActive then
		if self.GPSisActiveSteering then
			self.GPStxt.txt = Steerable.GPS_TXT_ACT;
			self.GPStxt.r = .0;
			self.GPStxt.g = 0.6;
			self.GPStxt.b = 0;
			self.GPStxt.bold = true;
		else
			self.GPStxt.txt = Steerable.GPS_TXT_PAS;
			self.GPStxt.r = .0;
			self.GPStxt.g = 0.;
			self.GPStxt.b = 0.8;
			self.GPStxt.bold = false;
		end
		if self.GPSshowMode > 0 then
			self.GPStxt.txt = string.format("%2.1f m", self.GPStxt.printDistance)
		end
	else
		self.GPStxt.txt = Steerable.GPS_TXT_OFF;
		self.GPStxt.r = .7;
		self.GPStxt.g = 0;
		self.GPStxt.b = 0;
		self.GPStxt.bold = false;
	end

	if self.GPS_blinkTime > 0 then
		self.GPS_blinkTime = self.GPS_blinkTime - dt;
	else
		self.GPS_blinkTime = 0;
	end
	
	if self.GPSshowTime > 0 then
		self.GPSshowTime = self.GPSshowTime - dt;
	else
		self.GPSshowTime = 0;
	end
end;

function GPS:update(dt)
	if self:getIsActiveForInput() or g_currentMission.controlledVehicle == self then
		--if Input.isKeyPressed(Input.KEY_lctrl) and Input.isKeyPressed(Input.KEY_KP_0) and self.GPSswitchTime> 350 then
		if InputBinding.hasEvent(InputBinding.GPS_OnOff) then
			self.GPSActive = not self.GPSActive;
			--self.GPSswitchTime = 0;
		--else
			--if self.GPSswitchTime < 400 then
				--self.GPSswitchTime = self.GPSswitchTime +dt;
			--end;
		end;
		
		if InputBinding.isPressed(InputBinding.GPS_WidthPlus) then
		--if Input.isKeyPressed(Input.KEY_lctrl) and Input.isKeyPressed(Input.KEY_KP_plus) then
			self.GPSWidth = self.GPSWidth + .0004*dt*(self.GPSWidth+1);
			if self.GPSWidth > 50 then
				self.GPSWidth = 50;
			end;
			self.GPSshowTime = 800;
		end;
		
		if InputBinding.isPressed(InputBinding.GPS_WidthMinus) then
		--if Input.isKeyPressed(Input.KEY_lctrl) and Input.isKeyPressed(Input.KEY_KP_minus) then
			self.GPSWidth = self.GPSWidth - .0004*dt*(self.GPSWidth+1);
			if self.GPSWidth < 0 then
				self.GPSWidth = 0;
			end;
			self.GPSshowTime = 800;
		end;
		
		if InputBinding.hasEvent(InputBinding.GPS_SteeringOnOff) then
			self.GPSisActiveSteering = not self.GPSisActiveSteering;
		end
		
		if InputBinding.hasEvent(InputBinding.GPS_InfoMode) then
			self.GPSshowMode = self.GPSshowMode + 1;
			if self.GPSshowMode > 2 then
				self.GPSshowMode = 0;
			end;
		end
		
		if InputBinding.hasEvent(InputBinding.GPS_Save) then
			if not self.GPSfirstrun then
				GPS.Store = {};
				GPS.Store.lhdX0 = self.lhdX0;
				GPS.Store.lhdZ0 = self.lhdZ0;
				GPS.Store.lhX0 = self.lhX0;
				GPS.Store.lhY0 = self.lhY0;
				GPS.Store.lhZ0 = self.lhZ0;
				GPS.Store.GPSWidth = self.GPSWidth;
				self.GPS_blinkTime = 4000;
				self.GPS_lastActionText = Steerable.GPS_TXT_SAVE
			end			
		end

		if InputBinding.hasEvent(InputBinding.GPS_Load) then
			if GPS.Store ~= nil then
				self.GPSfirstrun = false
				self.lhdX0 = GPS.Store.lhdX0;
				self.lhdZ0 = GPS.Store.lhdZ0;
				self.lhX0 = GPS.Store.lhX0;
				self.lhY0 = GPS.Store.lhY0;
				self.lhZ0 = GPS.Store.lhZ0;
				self.GPSWidth = GPS.Store.GPSWidth;
				self.GPS_blinkTime = 2500;
				self.GPS_lastActionText = Steerable.GPS_TXT_LOAD
			end			
		end	
	end
	
	
	
	if self:getIsActive() then		
		if self.GPSActive then							
			local px,py,pz = getWorldTranslation(self.rootNode);
			
			local x,y,z = localDirectionToWorld(self.rootNode, 0, 0, 1);
			local length = Utils.vector2Length(x,z);
			local dX = x/length;
			local dZ = z/length;
			
			if InputBinding.hasEvent(InputBinding.GPS_Init) or self.GPSfirstrun then
			--if (Input.isKeyPressed(Input.KEY_lctrl) and Input.isKeyPressed(Input.KEY_KP_enter)) or self.GPSfirstrun then
				if true then --snap to terrain directions
					local snapAngle = self:getDirectionSnapAngle();
					snapAngle = math.max(snapAngle, math.pi/(g_currentMission.terrainDetailAngleMaxValue+1));

					local angleRad = Utils.getYRotationFromDirection(x, z)
					angleRad = math.floor(angleRad / snapAngle + 0.5) * snapAngle;

					local snapX, snapZ = Utils.getDirectionFromYRotation(angleRad);	
					
					self.lhdX0 = snapX
					self.lhdZ0 = snapZ
				else -- use precisely the current orientation of the tractor (outdated.. isnt fun to operate)
					self.lhdX0 = dX;
					self.lhdZ0 = dZ;
				end
				self.lhX0 = px;
				self.lhY0 = py;
				self.lhZ0 = pz;	
				self.GPSfirstrun = false;
			end;
			
			
			
			local diffAnglecos = math.deg(math.acos(dX*self.lhdX0 + dZ*self.lhdZ0));
					
			local signDiffAngle = math.deg(math.asin(dX*self.lhdZ0 - dZ*self.lhdX0));
			
			local beta = 0;
			if false then
				local b1 = self.lhdZ0
				local b2 = -self.lhdX0
				local b_length =  Utils.vector2Length(b1,b2);
				b1 = b1/b_length*self.GPSWidth;
				b2 = b2/b_length*self.GPSWidth;			
				beta = (self.lhZ0 - pz + self.lhdZ0/self.lhdX0 * (px-self.lhX0)) / (b2 - b1*self.lhdZ0/self.lhdX0);
			else			
				beta = self.lhdX0 *(pz - self.lhZ0) - self.lhdZ0 *(px - self.lhX0)
				beta = beta / self.GPSWidth --*2
			end
			beta = (beta - math.floor(beta+.5)); 
			
			
			
			
			self.lhBeta = beta;
			self.lhAngle = signDiffAngle;
			--self.lhAngle = diffAnglecos;
			
			local lhDirectionPlusMinus = 1;
			if diffAnglecos > 90  then
				lhDirectionPlusMinus = -1;
			end;
			
			--here starts autopilot:
			if self.GPSisActiveSteering then
				local refangle = signDiffAngle*lhDirectionPlusMinus					
				local K1 = 15;
				local K2 = .025
				local angle_soll = K1 * beta * self.GPSWidth*lhDirectionPlusMinus
				local steer = K2*(refangle - angle_soll)
				self.GPSsteeringOffset = steer
			else
				self.GPSsteeringOffset = 0									
			end
			
			local printDistance = beta * self.GPSWidth;
			if math.abs(printDistance) < 0.005 then
				printDistance = 0; --prevent +/- flickering
			end
			self.GPStxt.printDistance = printDistance;
			--renderText(0.68,0.05,0.02, string.format("%3.2f m", printDistance));
			
			if self.GPSshowMode < 2 then
			-- here starts line generation:
				local k
				local lineAx
				local lineAy
				local lineAz
				local lineBx
				local lineBy
				local lineBz
				
				local r = 0;
				local g = .8;
				local b = 0;
				local kmin = 0;
				local kmax = 30;
				local step = 2;
				
				for kk = -1,1,1 do
				
					if kk == 0 then
						r=0;
						g=.8;
						kmin = 5;
						kmax = 30;
						step = 1;
					else
						r=.8;
						g = 0;
						kmin = -15;
						kmax = 10;
						step = 2;
					end;
					
					local line0x = px + self.GPSWidth*self.lhdZ0*(beta+kk/2)
					local line0z = pz - self.GPSWidth*self.lhdX0*(beta+kk/2)
					local line0y = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, line0x, posy, line0z) + .2;
					
						
					for k = kmin,kmax,step do
						lineAx = line0x + k*lhDirectionPlusMinus*self.lhdX0;
						lineAz = line0z + k*lhDirectionPlusMinus*self.lhdZ0;
						lineAy = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, lineAx, posy, lineAz) + .2;
						
						lineBx = line0x + (k+1)*lhDirectionPlusMinus*self.lhdX0;
						lineBz = line0z + (k+1)*lhDirectionPlusMinus*self.lhdZ0;
						lineBy = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, lineBx, posy, lineBz) + .2;
						
						drawDebugLine(lineAx, lineAy, lineAz, r, g, b, lineBx, lineBy, lineBz, r, g, b);		
					end;

				end;
			end;
		else
			self.GPSisActiveSteering= false;
		end;
	end
end;


function GPS:draw()

	self.GPSoverlay:render();
	
	if self.GPS_blinkTime > 0 then
		self.GPStxt.txt = self.GPS_lastActionText;
	end
	
	
	if self.GPS_blinkTime == 0 or self.GPS_blinkTime % 1000 > 500 then
		setTextAlignment(RenderText.ALIGN_RIGHT); 
		setTextBold(self.GPStxt.bold);
		setTextColor(self.GPStxt.r,self.GPStxt.g,self.GPStxt.b,1);
		renderText(.3+ 0.085,0.01238 + 0.010,0.022, self.GPStxt.txt);
	end
	
	if self.GPSshowTime > 0 then
		setTextColor(1,1,1,1)
		setTextBold(false);
		renderText(.5,.8,.015,Steerable.GPS_TXT_WIDTH .. string.format("%3.1f m", self.GPSWidth));		
	end;
	
	
end;


function GPS:getSaveAttributesAndNodes(nodeIdent)
	local attributes = "";
	if self.lhX0 ~= nil then
		attributes = 'GPS_x="'..self.lhX0..'" '
		attributes = attributes..'GPS_y="'..self.lhY0..'" '
		attributes = attributes..'GPS_z="'..self.lhZ0..'" '
		attributes = attributes..'GPS_dx="'..self.lhdX0..'" '
		attributes = attributes..'GPS_dz="'..self.lhdZ0..'" '
		attributes = attributes..'GPS_Width="'..self.GPSWidth..'" '
	end
	return attributes
end;


function GPS:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local x = getXMLFloat(xmlFile, key.."#GPS_x");
	if not resetVehicles then	
		if x ~= nil then
			self.lhX0 = x;
			
			local y = getXMLFloat(xmlFile, key.."#GPS_y");
			self.lhY0 = y;
			
			local z = getXMLFloat(xmlFile, key.."#GPS_z");
			self.lhZ0 = z;

			local dx = getXMLFloat(xmlFile, key.."#GPS_dx");
			self.lhdX0 = dx;
			local dz = getXMLFloat(xmlFile, key.."#GPS_dz");
			self.lhdZ0 = dz;
			local w = getXMLFloat(xmlFile, key.."#GPS_Width");
			self.GPSWidth = w;
			
			self.GPSfirstrun = false;			
		end;		
	end;
end