--
-- KirovetsK700A
-- Specialization for KirovetsK700A
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - added network support, changed update to updateTick
--

KirovetsK700A = {};

function KirovetsK700A.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(ArticulatedSteering, specializations);
end;

function KirovetsK700A:load(xmlFile)        
end;
	
function KirovetsK700A:delete()
end;

function KirovetsK700A:readStream(streamId, connection)
end;

function KirovetsK700A:writeStream(streamId, connection)
end;

function KirovetsK700A:mouseEvent(posX, posY, isDown, isUp, button)
end;

function KirovetsK700A:keyEvent(unicode, sym, modifier, isDown)
end;

function KirovetsK700A:update(dt)
end;

function KirovetsK700A:updateTick(dt)

	if self:getIsActive() then
	
		self.autoRotateBackSpeed = ((self.lastSpeed*3600 / self.maxSpeed) * (self.maxAutoRotateSpeed - self.minAutoRotateSpeed)) + self.minAutoRotateSpeed;
		
		for _, shaft in pairs(self.drivingPowerShafts) do
			local x,y,z = getRotation(self.wheels[1].driveNode);
			setRotation(shaft.node, 0 ,0, x*shaft.speedFactor);
			
			if shaft.trans ~= 0 then
				local newTrans = shaft.trans * self.articulatedSteering.curRot/self.articulatedSteering.maxRot;
				local x,y,z = unpack(shaft.orgTrans);
				setTranslation(getParent(shaft.node), x + newTrans,y,z);
			end;
			if shaft.rot ~= 0 then
				newRot = shaft.rot * self.articulatedSteering.curRot/self.articulatedSteering.maxRot;
				setRotation(getParent(shaft.node), 0, newRot, 0);
		end;
	end;	
end;

function KirovetsK700A:draw()	
end;


function KirovetsK700A:attachImplement(implement)
end;

function KirovetsK700A:detachImplement(implementIndex)
end;

function KirovetsK700A:validateAttacherJoint(implement, jointDesc, dt)
end;

function KirovetsK700A:onLeave()
end;

function KirovetsK700A:onEnter()
end;