AgrolinerTUW20 = {};

function AgrolinerTUW20.prerequisitesPresent(specializations)
    return true;
end;

function AgrolinerTUW20:load(xmlFile)

	self.setSoundState = SpecializationUtil.callSpecializationsFunction("setSoundState");
	self.setUnloadingState = SpecializationUtil.callSpecializationsFunction("setUnloadingState");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));
		if self.hydraulics[i].punch ~= nil and self.hydraulics[i].translationPunch ~= nil then
			local ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
		self.hydraulics[i].doScale = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName .. "#doScale"), false);
	end;

	self.unloadingSounds = {};
	self.unloadingSounds.startSound = {};
	local startSound = getXMLString(xmlFile, "vehicle.unloadingSounds#startFile");
    if startSound ~= nil and startSound ~= "" then
        startSound = Utils.getFilename(startSound, self.baseDirectory); 
        self.unloadingSounds.startSound.file = createSample("startSound");
        self.unloadingSounds.startSound.enabled = false;
		self.unloadingSounds.startSound.duration = getSampleDuration(self.unloadingSounds.startSound.file);
        loadSample(self.unloadingSounds.startSound.file, startSound, false);
    end;
	
	self.unloadingSounds.loopSound = {};
	local loopSound = getXMLString(xmlFile, "vehicle.unloadingSounds#loopFile");
    if loopSound ~= nil and loopSound ~= "" then
        loopSound = Utils.getFilename(loopSound, self.baseDirectory); 
        self.unloadingSounds.loopSound.file = createSample("loopSound");
        self.unloadingSounds.loopSound.enabled = false;
        loadSample(self.unloadingSounds.loopSound.file, loopSound, false);
    end;
	
	self.playLoopSoundTime = 0;
	
	self.triggerNode = {};
	self.triggerNode.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.unloadingTrigger#node"));
	self.triggerNode.distance = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.unloadingTrigger#maxDistance"), 1);
	self.unloadingTipTrigger = nil;
	
	self.pipe = {};
	self.pipe.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipe#index"));
	self.pipe.distance = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipe#raycastDistance"), 7);
	self.pipe.out = false;
	self.pipe.lastPosition = 0;
	
	self.unloadingCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.unloadingCapacity"), 100);
	
	self.allowFillFromAir = true;
	self.isUnloading = false;
	
	self.isLoading = true;
	
	local path = Utils.getFilename("Textura/overlay.dds", self.baseDirectory);
    self.unloadingOverlay = Overlay:new("hudPDAControl", path, g_currentMission.fruitSymbolX, g_currentMission.fruitSymbolY-0.11, g_currentMission.fruitSymbolSize, g_currentMission.fruitSymbolSize * (4 / 3)); 

end;

function AgrolinerTUW20:delete()
	if self.unloadingSounds.loopSound.file ~= nil then
        delete(self.unloadingSounds.loopSound.file);
    end;
	if self.unloadingSounds.startSound.file ~= nil then
        delete(self.unloadingSounds.startSound.file);
    end;
end;

function AgrolinerTUW20:readStream(streamId, connection)
	self.isLoading = true;
	local isUnloading = streamReadBool(streamId);
	self:setUnloadingState(isUnloading, true);
end;

function AgrolinerTUW20:writeStream(streamId, connection)
	streamWriteBool(streamId, self.isUnloading);
end;

function AgrolinerTUW20:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AgrolinerTUW20:keyEvent(unicode, sym, modifier, isDown)
end;

function AgrolinerTUW20:update(dt)
	
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			if self.pipe.out then
				self:setAnimationTime(1, self.animationParts[1].offSet, false);
				self:setUnloadingState(false);
			else
				self:setAnimationTime(1, self.animationParts[1].animDuration, false);
			end;
		end;
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			self:setUnloadingState(not self.isUnloading);
		end;
		
	end;
	
	if self.animationParts[1].inputDone and self.animationParts[1].clipEndTime then
		self.pipe.out = true;
		if InputBinding.isPressed(InputBinding.AgrolinerTUW20_DOWN) and self:getIsActiveForInput() then
			self:setAnimationTime(2, self.animationParts[2].currentPosition+(self.animationParts[2].offSet+dt), false);
			self.pipe.lastPosition = self.animationParts[2].currentPosition;
		elseif InputBinding.isPressed(InputBinding.AgrolinerTUW20_UP) and self:getIsActiveForInput() then
			self:setAnimationTime(2, self.animationParts[2].currentPosition-(self.animationParts[2].offSet+dt), false);
			self.pipe.lastPosition = self.animationParts[2].currentPosition;
		end;
	elseif not self.animationParts[1].clipEndTime then
		self:setAnimationTime(2, self.animationParts[2].startPosition, false);
		self.pipe.out = false;
	end;

	if self.animationParts[1].clipEndTime and self.animationParts[2].currentPosition == self.animationParts[2].startPosition then
		self:setAnimationTime(2, self.pipe.lastPosition, false);
	end;
	
	
	
	local hydraulicSoundEnabled = false;
	for i=1, 2 do
		if not self.animationParts[i].inputDone then
			hydraulicSoundEnabled = true;
		end;
	end;
	if hydraulicSoundEnabled then
		if not self.hydraulicSoundEnabled and self.hydraulicSound ~= nil and self:getIsActiveForSound() then
			playSample(self.hydraulicSound, 0, self.hydraulicSoundVolume, 0);
			setSamplePitch(self.hydraulicSound, self.hydraulicSoundPitchOffset-0.4);
			self.hydraulicSoundEnabled = true;   
		end;
	else
		if self.hydraulicSoundEnabled then
			stopSample(self.hydraulicSound);
			self.hydraulicSoundEnabled = false;   
		end;
	end;
end;

function AgrolinerTUW20:updateTick(dt)

	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
		setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.hydraulics[i].punch ~= nil and self.hydraulics[i].punchDistance ~= nil and self.hydraulics[i].translationPunch then
			if self.hydraulics[i].doScale then
				local xScale, yScale, zScale = getScale(self.hydraulics[i].punch);
				local newScale = xScale * (distance / self.hydraulics[i].punchDistance);
				setScale(self.hydraulics[i].punch, 1, 1, newScale);
			else
				setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
			end;
		end;
	end;
	
	self.trailerFoundId = 0;
	self.unloadingTipTrigger = nil;
	
	if self.fillLevel > 0 and self.pipe.out then
		for k, tipTrigger in pairs(g_currentMission.tipTriggers) do
			local trailerX, trailerY, trailerZ = getWorldTranslation(self.triggerNode.index);
			local triggerX, triggerY, triggerZ = getWorldTranslation(tipTrigger.triggerId);
			local distance = Utils.vector3Length(trailerX-triggerX, trailerY-triggerY, trailerZ-triggerZ);
			if distance < self.triggerNode.distance then
				self.unloadingTipTrigger = tipTrigger;
			end;
		end;
		if self.unloadingTipTrigger == nil then
			local x, y, z = getWorldTranslation(self.pipe.node);
			local dx, dy, dz = localDirectionToWorld(self.pipe.node, 0, -0.5, 0);
			raycastAll(x, y, z, dx, dy, dz, "trailerRaycastCallback", self.pipe.distance, self);
		end;
	end;
	
	if self:getIsActive() then
		local renderOverlay = false;
		local deltaLevel = 0;
		if self.trailerFoundId ~= nil and self.trailerFoundId ~= 0 then
			local trailer = g_currentMission.nodeToVehicle[self.trailerFoundId];
			if trailer ~= nil and trailer ~= self and trailer:allowFillType(self.currentFillType, true) and trailer.allowFillFromAir and trailer.capacity ~= trailer.fillLevel then
				if self.isUnloading then
					deltaLevel = math.min(self.unloadingCapacity*dt/1000.0, trailer.capacity-trailer.fillLevel);
					trailer:setFillLevel(trailer.fillLevel+deltaLevel, self.currentFillType);
				else
					renderOverlay = true;
				end;
			elseif self.isUnloading then
				self:setUnloadingState(false);
			end;
		elseif self.unloadingTipTrigger ~= nil then
			local tipTrigger = self.unloadingTipTrigger;
			local fruitType = FruitUtil.fillTypeToFruitType[self.currentFillType];
			--local fruitAccept = tipTrigger.acceptedFruitTypes[fruitType];
			local fruitAccept = tipTrigger.acceptedFillTypes[self.currentFillType];
			if tipTrigger.isFarmTrigger and fruitAccept then
				if self.isUnloading then
					deltaLevel = self.unloadingCapacity*dt/1000.0;
					g_currentMission.missionStats.farmSiloAmounts[self.currentFillType] = g_currentMission.missionStats.farmSiloAmounts[self.currentFillType] + deltaLevel;
				else
					renderOverlay = true;
				end;
			elseif fruitAccept then
				if self.isUnloading then
					deltaLevel = self.unloadingCapacity*dt/1000.0;
					local priceMultiplier = tipTrigger.priceMultipliers[fruitType];
					local difficultyMultiplier = math.max(3 * (3 - g_currentMission.missionStats.difficulty), 1);
					local money = FruitUtil.fruitIndexToDesc[fruitType].pricePerLiter * priceMultiplier * difficultyMultiplier * deltaLevel;
					g_currentMission:addSharedMoney(money);
				else
					renderOverlay = true;
				end;
			else
				if FruitUtil.fruitIndexToDesc[fruitType].name ~= nil then
					g_currentMission:addWarning(g_i18n:getText(FruitUtil.fruitIndexToDesc[fruitType].name) .. g_i18n:getText("notAcceptedHere"), 0.018, 0.033);
				end;
			end;
			if deltaLevel > 0 then
				tipTrigger:updateMoving(deltaLevel);
			end;
		elseif self.isUnloading then
			self:setUnloadingState(false);
		end;
		self.fillLevel = self.fillLevel-deltaLevel;
		if deltaLevel == 0 and self.isUnloading then
			self:setUnloadingState(false);
		end;
		if self.fillLevel <= 0.0 then
			self.fillLevel = 0.0;
			if self.isUnloading then
				self:setUnloadingState(false);
			end;
			Utils.setEmittingState(self.tipAnimations[1].dischargeParticleSystems[self.currentFillType], self.isUnloading);
			self.currentFillType = Fillable.FRUITTYPE_UNKNOWN;
		end;
		self:setFillLevel(self.fillLevel, self.currentFillType);
		self.renderOverlay = renderOverlay;
		Utils.setEmittingState(self.tipAnimations[1].dischargeParticleSystems[self.currentFillType], self.isUnloading);
		self:setSoundState(self.isUnloading);		
	end;
end;

function AgrolinerTUW20:trailerRaycastCallback(transformId, x, y, z, distance)
	local vehicle = g_currentMission.nodeToVehicle[transformId];
	if vehicle ~= nil then
		if vehicle.exactFillRootNode == transformId then
			self.trailerFoundId = transformId;
			return false;
		end;
	end;
	return true;
end;

function AgrolinerTUW20:setUnloadingState(state, noEventSend)
	SetUnloadingEvent.sendEvent(self, state, noEventSend);
	self.isUnloading = state;
end;

function AgrolinerTUW20:setSoundState(value)
	if value == true then
		if not self.unloadingSounds.startSound.enabled and self:getIsActiveForSound() and self.unloadingSounds.startSound.file ~= nil then
			playSample(self.unloadingSounds.startSound.file, 1, 0.35, 0);
			setSamplePitch(self.unloadingSounds.startSound.file ,1);
			self.unloadingSounds.startSound.enabled = true;
			self.playLoopSoundTime = self.time + self.unloadingSounds.startSound.duration;
		end;
		if self.playLoopSoundTime <= self.time and not self.unloadingSounds.loopSound.enabled and self:getIsActiveForSound() and self.unloadingSounds.loopSound.file ~= nil then
			playSample(self.unloadingSounds.loopSound.file, 0, 0.35, 0);
			setSamplePitch(self.unloadingSounds.loopSound.file,1);
			self.unloadingSounds.loopSound.enabled  = true;
		end;
	else
		if self.unloadingSounds.loopSound.enabled and self.unloadingSounds.loopSound.file ~= nil then
			stopSample(self.unloadingSounds.loopSound.file);
			self.unloadingSounds.loopSound.enabled = false;
		end;
		if self.unloadingSounds.startSound.enabled and self.unloadingSounds.startSound.file ~= nil then
			stopSample(self.unloadingSounds.startSound.file);
			self.unloadingSounds.startSound.enabled = false;
		end;
	end;
end;



function AgrolinerTUW20:draw()	

	if self.pipe.out then
		g_currentMission:addHelpButtonText(g_i18n:getText("AgrolinerTUW20_1"), InputBinding.IMPLEMENT_EXTRA);
		if self.animationParts[1].inputDone then
			g_currentMission:addExtraPrintText(string.format(""..InputBinding.getKeyNamesOfDigitalAction(InputBinding.AgrolinerTUW20_UP) .. " / " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.AgrolinerTUW20_DOWN)..":                 "..g_i18n:getText("AgrolinerTUW20_2")..""));
			if self.isUnloading then
				g_currentMission:addHelpButtonText(g_i18n:getText("AgrolinerTUW20_4"), InputBinding.IMPLEMENT_EXTRA2);
			elseif self.renderOverlay then
				self.unloadingOverlay:render();
				g_currentMission:addHelpButtonText(g_i18n:getText("AgrolinerTUW20_3"), InputBinding.IMPLEMENT_EXTRA2);
			end;
		end;
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("AgrolinerTUW20_5"), InputBinding.IMPLEMENT_EXTRA);
	end;

end;





function AgrolinerTUW20:onLeave()
	if self.deactivateOnLeave then
        self:onDeactivate(self);
    else
        self:onDeactivateSounds(self);
    end;
	
end;

function AgrolinerTUW20:onDeactivate()
	self:setUnloadingState(false);
	self.unloadingTipTrigger = nil;	
	for k, particle in pairs(self.tipAnimations[1].dischargeParticleSystems) do
		Utils.setEmittingState(particle, false);
	end;
    self:onDeactivateSounds(self);
end;

function AgrolinerTUW20:onDeactivateSounds()
	self:setSoundState(false);
end;