--
-- ChangeWheel
-- Specialization for ChangeWheel
--
-- @author  	71biTi (Shed Tuning System, STS)
-- @version 	v1.0
-- @date  		20/01/13
-- @history:	v1.0 - Initial version
--

ChangeWheel = {};

function ChangeWheel.prerequisitesPresent(specializations)
    return true;
end;

function ChangeWheel:load(xmlFile)	

	self.setWheel = SpecializationUtil.callSpecializationsFunction("setWheel");

	self.wheel1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wheels1#index1"));
	self.wheel2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wheels1#index2"));
	self.wheel3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wheels2#index1"));
	self.wheel4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wheels2#index2"));
	self.wheel5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wheels3#index1"));
	self.wheel6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wheels3#index2"));
	self.wheel7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wheels4#index1"));
	self.wheel8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wheels4#index2"));
	self.wheelId = 0;
end;

function ChangeWheel:delete()
end;

function ChangeWheel:readStream(streamId, connection)
	self:setWheel(streamReadInt8(streamId), true);
end;

function ChangeWheel:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.wheelId);	
end;

function ChangeWheel:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ChangeWheel:keyEvent(unicode, sym, modifier, isDown)
end;

function ChangeWheel:update(dt)
	if self:getIsActive() then
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.Change_Wheels) then
				self:setWheel(math.abs(self.wheelId - 1));
			end;
		end;
	end;
end;

function ChangeWheel:draw()
	g_currentMission:addHelpButtonText(g_i18n:getText("Change_wheel"), InputBinding.Change_Wheels);
end;

function ChangeWheel:setWheel(wheel, noEventSend)
	ChangeWheelEvent.sendEvent(self, wheel, noEventSend);

	setVisibility(self.wheel1, wheel == 0);
	setVisibility(self.wheel3, wheel == 0);
	setVisibility(self.wheel5, wheel == 0);
	setVisibility(self.wheel7, wheel == 0);
	setVisibility(self.wheel2, wheel == 1);
	setVisibility(self.wheel4, wheel == 1);
	setVisibility(self.wheel6, wheel == 1);
	setVisibility(self.wheel8, wheel == 1);
	self.wheelId = wheel;
end;

function ChangeWheel:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self:setWheel(Utils.getNoNil(getXMLInt(xmlFile, key.."#wheelId"),0), true);
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function ChangeWheel:getSaveAttributesAndNodes(nodeIdent)	
    local attributes = 'wheelId="'.. tostring(self.wheelId) .. '"';
    return attributes, nil;
end;





ChangeWheelEvent = {};
ChangeWheelEvent_mt = Class(ChangeWheelEvent, Event);

InitEventClass(ChangeWheelEvent, "ChangeWheelEvent");

function ChangeWheelEvent:emptyNew()
    local self = Event:new(ChangeWheelEvent_mt);
    return self;
end;

function ChangeWheelEvent:new(vehicle, wheel)
    local self = ChangeWheelEvent:emptyNew()
    self.vehicle = vehicle;
	self.wheel = wheel;
    return self;
end;

function ChangeWheelEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.wheel = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ChangeWheelEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.wheel);	
end;

function ChangeWheelEvent:run(connection)
	self.vehicle:setWheel(self.wheel, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(ChangeWheelEvent:new(self.vehicle, self.wheel), nil, connection, self.vehicle);
	end;
end;

function ChangeWheelEvent.sendEvent(vehicle, wheel, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ChangeWheelEvent:new(vehicle, wheel), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ChangeWheelEvent:new(vehicle, wheel));
		end;
	end;
end;
