SetToggleSiatkaEvent = {};
SetToggleSiatkaEvent_mt = Class(SetToggleSiatkaEvent, Event);
InitEventClass(SetToggleSiatkaEvent, "SetToggleSiatkaEvent");
function SetToggleSiatkaEvent:emptyNew()
      local self = Event:new(SetToggleSiatkaEvent_mt);
      self.className="SetToggleSiatkaEvent";
      return self;
end;
function SetToggleSiatkaEvent:new(object, siatkaActive)
      local self = SetToggleSiatkaEvent:emptyNew()
      self.siatkaActive = siatkaActive;
      self.object = object;
      return self;
end;
function SetToggleSiatkaEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.siatkaActive = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
function SetToggleSiatkaEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.siatkaActive);
end;
function SetToggleSiatkaEvent:run(connection)
      self.object:setToggleSiatka(self.siatkaActive, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetToggleSiatkaEvent:new(self.object, self.siatkaActive), nil, connection, self.object);
      end;
end;