--
-- Specialization for the trailer Pronar T022
--
-- @autor: Burner, Ziuta (Ziut, xXx, ja_pizgam)
-- @wielka pomoc: Burner, Koper
-- @data: 12.08.2013
--
--

Pronar_T022 = {}

function Pronar_T022.prerequisitesPresent(specializations)
    return true
end

function Pronar_T022:load(xmlFile)
	self.getIsFoldAllowed = Utils.overwrittenFunction(self.getIsFoldAllowed, Pronar_T022.getIsFoldAllowed)
	self.SetRozsuwanie = SpecializationUtil.callSpecializationsFunction("SetRozsuwanie")
	self.rozsuwanieAnimation = getXMLString(xmlFile, "vehicle.rozsuwanie#animationName")
	self.rozsuwanie = true
	self.rozlozone = true
	self.info = false
	self.infoTime = 0
end

function Pronar_T022:delete()
end

function Pronar_T022:readStream(streamId, connection)
	self:SetRozsuwanie(streamReadBool(streamId), true)
end

function Pronar_T022:writeStream(streamId, connection)
	streamWriteBool(streamId, self.rozsuwanie)
end

function Pronar_T022:readUpdateStream(streamId, timestamp, connection)
end

function Pronar_T022:writeUpdateStream(streamId, connection, dirtyMask)
end

function Pronar_T022:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		if self.rozsuwanieAnimation ~= nil and self.playAnimation ~= nil then
            local rozsuwanieAnimationTime = getXMLFloat(xmlFile, key.."#rozsuwanieAnimTime")
            self:setAnimationTime(self.rozsuwanieAnimation, rozsuwanieAnimationTime)
		end
    end
 
    return BaseMission.VEHICLE_LOAD_OK
end

function Pronar_T022:getSaveAttributesAndNodes(nodeIdent)
	local attributes = ''
    if self.rozsuwanieAnimation ~= nil and self.playAnimation ~= nil then
        local rozsuwanieAnimationTime = self:getAnimationTime(self.rozsuwanieAnimation)
        attributes = attributes..' rozsuwanieAnimTime="'..rozsuwanieAnimationTime..'"'
    end
    local nodes = ""
    return attributes, nodes
end

function Pronar_T022:mouseEvent(posX, posY, isDown, isUp, button)
end

function Pronar_T022:keyEvent(unicode, sym, modifier, isDown)
end

function Pronar_T022:update(dt)
	if self:getIsActiveForInput() then
		if self:getIsFoldAllowed() then
			if InputBinding.hasEvent(InputBinding.przedluzenie) then
				if self.foldAnimTime == 0 then
					self:SetRozsuwanie(not self.rozsuwanie)
				else
					self.info = true
				end
			end
		end
	end
	
	if self.info then
		self.infoTime = self.infoTime + dt
		if self.infoTime > 2000 then
			self.info = false
			self.infoTime = 0
		end
	end
end

function Pronar_T022:updateTick(dt)	
end

function Pronar_T022:SetRozsuwanie(rozsuwanieState,noEventSend)
	SetRozsuwanieEvent.sendEvent(self, rozsuwanieState, noEventSend)
	if rozsuwanieState then
		if self.rozsuwanieAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.rozsuwanieAnimation, -1, nil, true)
			self.rozsuwanie = true
		end;
	else
		if self.rozsuwanieAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.rozsuwanieAnimation, 1, nil, true)
			self.rozsuwanie = false
		end
	end
end

function Pronar_T022:draw()
	if self.rozsuwanie then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("rozsuwanie"), self.typeDesc), InputBinding.przedluzenie)
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("zsuwanie"), self.typeDesc), InputBinding.przedluzenie)
	end

	if self.info then
		g_currentMission:addWarning(g_i18n:getText("uwaga"))
	end
end

function Pronar_T022:getIsFoldAllowed()
	if self:getAnimationTime(self.rozsuwanieAnimation) > 0 and self:getAnimationTime(self.rozsuwanieAnimation) < 1 then
		return false
	end;
	return true
 end

--
--
--

SetRozsuwanieEvent = {}
SetRozsuwanieEvent_mt = Class(SetRozsuwanieEvent, Event)

InitEventClass(SetRozsuwanieEvent, "SetRozsuwanieEvent")

function SetRozsuwanieEvent:emptyNew()
    local self = Event:new(SetRozsuwanieEvent_mt)
    self.className="SetRozsuwanieEvent"
    return self
end

function SetRozsuwanieEvent:new(vehicle, rozsuwanieState)
    local self = SetRozsuwanieEvent:emptyNew()
    self.vehicle = vehicle
	self.rozsuwanieState = rozsuwanieState
    return self
end

function SetRozsuwanieEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId)
	self.rozsuwanieState = streamReadBool(streamId)
    self.vehicle = networkGetObject(id)
    self:run(connection)
end

function SetRozsuwanieEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle))
	streamWriteBool(streamId, self.rozsuwanieState)
end

function SetRozsuwanieEvent:run(connection)   
	self.vehicle:SetRozsuwanie(self.rozsuwanieState, true)
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetRozsuwanieEvent:new(self.vehicle, self.rozsuwanieState), nil, connection, self.vehicle)
    end
end

function SetRozsuwanieEvent.sendEvent(vehicle, rozsuwanieState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetRozsuwanieEvent:new(vehicle, rozsuwanieState), nil, nil, vehicle)
		else
			g_client:getServerConnection():sendEvent(SetRozsuwanieEvent:new(vehicle, rozsuwanieState))
		end
	end
end