-- 
-- by PeterJ (11/04/2011)
--  


LM218 = {};

function LM218.prerequisitesPresent(specializations)

    return true;
end;

function LM218:load(xmlFile)

     self.setTranslationMaxWindows = SpecializationUtil.callSpecializationsFunction("setTranslationMaxWindows");
		
		local translationPartNodeWindows = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translationPartWindows#index"));
		if translationPartNodeWindows ~= nil then
        self.translationPartWindows = {};
        self.translationPartWindows.node = translationPartNodeWindows;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartWindows#minTrans"));
        self.translationPartWindows.minTrans = {};
        self.translationPartWindows.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartWindows.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartWindows.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartWindows#maxTrans"));
        self.translationPartWindows.maxTrans = {};
        self.translationPartWindows.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartWindows.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartWindows.maxTrans[3] = Utils.getNoNil(z, 0);
		self.translationPartWindows.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartWindows#transTime"), 2)*1000;
        self.translationPartWindows.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartWindows#touchTransLimit"), 10);
    end;
	local rotationPartNodeEmbraiagem = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationEmbraiagem#index"));
    if rotationPartNodeEmbraiagem ~= nil then
        self.rotationEmbraiagem = {};
        self.rotationEmbraiagem.node = rotationPartNodeEmbraiagem;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationEmbraiagem#minRot"));
        self.rotationEmbraiagem.minRot = {};
        self.rotationEmbraiagem.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationEmbraiagem.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationEmbraiagem.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationEmbraiagem#maxRot"));
        self.rotationEmbraiagem.maxRot = {};
        self.rotationEmbraiagem.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationEmbraiagem.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationEmbraiagem.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationEmbraiagem.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationEmbraiagem#rotTime"), 2)*1000;
        self.rotationEmbraiagem.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationEmbraiagem#touchRotLimit"), 10));
    end;

	local rotationPartNodeAcelerador = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationAcelerador#index"));
    if rotationPartNodeAcelerador ~= nil then
        self.rotationAcelerador = {};
        self.rotationAcelerador.node = rotationPartNodeAcelerador;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationAcelerador#minRot"));
        self.rotationAcelerador.minRot = {};
        self.rotationAcelerador.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationAcelerador.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationAcelerador.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationAcelerador#maxRot"));
        self.rotationAcelerador.maxRot = {};
        self.rotationAcelerador.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationAcelerador.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationAcelerador.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationAcelerador.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationAcelerador#rotTime"), 2)*1000;
        self.rotationAcelerador.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationAcelerador#touchRotLimit"), 10));
    end;
	local rotationPartNodeTravoes = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationTravoes#index"));
    if rotationPartNodeTravoes ~= nil then
        self.rotationTravoes = {};
        self.rotationTravoes.node = rotationPartNodeTravoes;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationTravoes#minRot"));
        self.rotationTravoes.minRot = {};
        self.rotationTravoes.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationTravoes.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationTravoes.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationTravoes#maxRot"));
        self.rotationTravoes.maxRot = {};
        self.rotationTravoes.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationTravoes.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationTravoes.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationTravoes.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationTravoes#rotTime"), 2)*1000;
        self.rotationTravoes.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationTravoes#touchRotLimit"), 10));
    end;

	self.translationMaxWindows = false;
        self.rotationMaxEmbraiagem = false;
        self.rotationMaxAcelerador = false;
        self.rotationMaxTravoes = false;

	self.armrot = {};
	self.armrot.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.armRot#index"));
	self.armrot.minRot = {Utils.degToRad(getXMLFloat(xmlFile, "vehicle.armRot#minRot"))};
	self.armrot.maxRot = {Utils.degToRad(getXMLFloat(xmlFile, "vehicle.armRot#maxRot"))};
	self.armrot.Rot = {Utils.degToRad(getXMLFloat(xmlFile, "vehicle.armRot#Rot"))};
	self.armrot.rotTime = getXMLFloat(xmlFile, "vehicle.armRot#rotTime")*1000;
    self.armrot.posX = true;
    self.armrot.posZ = true;

	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"),"0 1 0"));
		self.hydraulics[i].upVectors = {xUp, yUp, zUp};
		
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		if self.hydraulics[i].translationPunch ~= nil then
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	self.setHydraulicTime = 30;

end;

function LM218:readStream(streamId, connection)
     self.translateMax = streamReadBool(streamId);
     if self.translationPartWindows ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
         setTranslation(self.translationPartWindows.node, x, y, z);
      end;
end;
  
function LM218:writeStream(streamId, connection)
      streamWriteBool(streamId, self.translateMax);
		if self.translationPartWindows ~= nil then
          local x, y, z = getTranslation(self.translationPartWindows.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
end;

function LM218:delete()

end;

function LM218:keyEvent(unicode, sym, modifier, isDown)

end;

function LM218:update(dt)

      if self:getIsActiveForInput() then
          if InputBinding.hasEvent(InputBinding.LMWINDOWS) then
				self:setTranslationMaxWindows(not self.translationMaxWindows);
          end;
          if Input.isKeyPressed(Input.KEY_s) then
				self.rotationMaxEmbraiagem = true;
          else
				self.rotationMaxEmbraiagem = false;
          end;
          if Input.isKeyPressed(Input.KEY_w) then
				self.rotationMaxAcelerador = true;
          else
				self.rotationMaxAcelerador = false;
          end;
          if Input.isKeyPressed(Input.KEY_s) then
				self.rotationMaxTravoes = true;
          else
				self.rotationMaxTravoes = false;
          end;
	local doRotate = self.rotationJoystickArmmax or self.rotationJoystickArmmin 
	if self.rotationJoystickArm ~= nil and doRotate then
          local x, y, z = getRotation(self.rotationJoystickArm.node);
          local rot = {x,y,z};
          local newRot = Utils.getMovedLimitedValues(rot, self.rotationJoystickArm.maxRot, self.rotationJoystickArm.minRot, 3, self.rotationJoystickArm.rotTime, dt, not self.rotationJoystickArmmax);
          setRotation(self.rotationJoystickArm.node, unpack(newRot));
	end;
	local doRotate = self.rotationJoystickToolmax or self.rotationJoystickToolmin 
	if self.rotationJoystickTool ~= nil and doRotate then
          local x, y, z = getRotation(self.rotationJoystickTool.node);
          local rot = {x,y,z};
          local newRot = Utils.getMovedLimitedValues(rot, self.rotationJoystickTool.maxRot, self.rotationJoystickTool.minRot, 3, self.rotationJoystickTool.rotTime, dt, not self.rotationJoystickToolmax);
          setRotation(self.rotationJoystickTool.node, unpack(newRot));
	end;

	if self:getIsActiveForInput() and self.isMotorStarted then
		if InputBinding.isPressed(InputBinding.FRONTLOADER_ARM_POSMAN) then
		    self.armrot.posX = true;
			x,y,z = getRotation(self.armrot.node);	
		    local newRot = Utils.getMovedLimitedValues({x}, self.armrot.maxRot, self.armrot.minRot, 1, self.armrot.rotTime, dt, true);
		    setRotation(self.armrot.node, newRot[1],y,z);	
	    end;
		if InputBinding.isPressed(InputBinding.FRONTLOADER_ARM_NEGMAN) then
		    self.armrot.posX = false;
			x,y,z = getRotation(self.armrot.node);	
		    local newRot = Utils.getMovedLimitedValues({x}, self.armrot.maxRot, self.armrot.minRot, 1, self.armrot.rotTime, dt, false );
		    setRotation(self.armrot.node, newRot[1],y,z);		
		end;
		if not InputBinding.isPressed(InputBinding.FRONTLOADER_ARM_NEGMAN) and not InputBinding.isPressed(InputBinding.FRONTLOADER_ARM_POSMAN) then
		    if self.armrot.posX then
		    	x,y,z = getRotation(self.armrot.node);	
		        local newRot = Utils.getMovedLimitedValues({x}, self.armrot.minRot, self.armrot.Rot, 1, self.armrot.rotTime/2, dt, true);
		        setRotation(self.armrot.node, newRot[1],y,z);
            else
			    x,y,z = getRotation(self.armrot.node);	
		        local newRot = Utils.getMovedLimitedValues({x}, self.armrot.maxRot, self.armrot.Rot, 1, self.armrot.rotTime/2, dt, true);
		        setRotation(self.armrot.node, newRot[1],y,z);		
		    end;
		end;
		if InputBinding.isPressed(InputBinding.FRONTLOADER_TILT_POSMAN) then
		 	self.armrot.posZ = true;   
			x,y,z = getRotation(self.armrot.node);	
		    local newRot = Utils.getMovedLimitedValues({z}, self.armrot.maxRot, self.armrot.minRot, 1, self.armrot.rotTime, dt, true );
		    setRotation(self.armrot.node, x,y,newRot[1]);	
		elseif InputBinding.isPressed(InputBinding.FRONTLOADER_TILT_NEGMAN) then
		    self.armrot.posZ = false;   
			x,y,z = getRotation(self.armrot.node);	
		    local newRot = Utils.getMovedLimitedValues({z}, self.armrot.maxRot, self.armrot.minRot, 1, self.armrot.rotTime, dt, false );
		    setRotation(self.armrot.node, x,y,newRot[1]);	
		end;
		if not InputBinding.isPressed(InputBinding.FRONTLOADER_TILT_NEGMAN) and not InputBinding.isPressed(InputBinding.FRONTLOADER_TILT_POSMAN) then
		    if self.armrot.posZ then
			    x,y,z = getRotation(self.armrot.node);	
		        local newRot = Utils.getMovedLimitedValues({z}, self.armrot.minRot, self.armrot.Rot, 1, self.armrot.rotTime/2, dt, true);
		        setRotation(self.armrot.node, x,y,newRot[1]);		
		    else
			    x,y,z = getRotation(self.armrot.node);	
		        local newRot = Utils.getMovedLimitedValues({z}, self.armrot.maxRot, self.armrot.Rot, 1, self.armrot.rotTime/2, dt, true);
		        setRotation(self.armrot.node, x,y,newRot[1]);		
			end;
		end;
	end;
      end;

	if self:getIsActive() then			
		self.setHydraulicTime = 30;	
	end;

	if self.setHydraulicTime > 0 then
		for k,v in pairs(self.hydraulics) do 
			self:setHydraulicDirection(k);
		end;
		self.setHydraulicTime = self.setHydraulicTime - 1;
	end;

end;

function LM218:updateTick(dt)
	if self:getIsActive() and self.isClient then
			if self.translationPartWindows ~= nil then
				local x, y, z = getTranslation(self.translationPartWindows.node);
				local trans = {x,y,z};
				local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartWindows.maxTrans, self.translationPartWindows.minTrans, 3, self.translationPartWindows.transTime, dt, not self.translationMaxWindows);
				setTranslation(self.translationPartWindows.node, unpack(newTrans));
			end;
			if self.rotationEmbraiagem ~= nil then
				local x, y, z = getRotation(self.rotationEmbraiagem.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationEmbraiagem.maxRot, self.rotationEmbraiagem.minRot, 3, self.rotationEmbraiagem.rotTime, dt, not self.rotationMaxEmbraiagem);
				setRotation(self.rotationEmbraiagem.node, unpack(newRot));
			end;
			if self.rotationAcelerador ~= nil then
				local x, y, z = getRotation(self.rotationAcelerador.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationAcelerador.maxRot, self.rotationAcelerador.minRot, 3, self.rotationAcelerador.rotTime, dt, not self.rotationMaxAcelerador);
				setRotation(self.rotationAcelerador.node, unpack(newRot));
			end;
			if self.rotationTravoes ~= nil then
				local x, y, z = getRotation(self.rotationTravoes.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationTravoes.maxRot, self.rotationTravoes.minRot, 3, self.rotationTravoes.rotTime, dt, not self.rotationMaxTravoes);
				setRotation(self.rotationTravoes.node, unpack(newRot));
			end;
			if self.rotationManete ~= nil then
				local x, y, z = getRotation(self.rotationManete.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationManete.maxRot, self.rotationManete.minRot, 3, self.rotationManete.rotTime, dt, not self.rotationMaxManete);
				setRotation(self.rotationManete.node, unpack(newRot));
			end;
	end;		
end;

function LM218:draw()
end;


function LM218:mouseEvent(posX, posY, isDown, isUp, button)
end;

function LM218:setTranslationMaxWindows(translationMaxWindows, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
              g_server:broadcastEvent(SetWindowsEvent:new(self, translationMaxWindows), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetWindowsEvent:new(self, translationMaxWindows));
          end;
      end;
      self.translationMaxWindows = translationMaxWindows;
end;

function LM218:setHydraulicDirection(index)
	local hydraulic = self.hydraulics[index];

	if hydraulic.fixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(hydraulic.node);
		local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
		local xUp, yUp, zUp = unpack(hydraulic.upVectors);
		setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
		if hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
		end;
	end;
end;

function LM218:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;


SetWindowsEvent = {};
SetWindowsEvent_mt = Class(SetWindowsEvent, Event);
  
InitEventClass(SetWindowsEvent, "SetWindowsEvent");
  
function SetWindowsEvent:emptyNew()
      local self = Event:new(SetWindowsEvent_mt);
      self.className="SetWindowsEvent";
      return self;
 end;

function SetWindowsEvent:new(object, translationMaxWindows)
      local self = SetWindowsEvent:emptyNew()
      self.object = object;
      self.translationMaxWindows = translationMaxWindows;
      return self;
end;
 
function SetWindowsEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.translationMaxWindows = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetWindowsEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.translationMaxWindows);
end;
 
function SetWindowsEvent:run(connection)
      self.object:setTranslationMaxWindows(self.translationMaxWindows, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetWindowsEvent:new(self.object, self.translationMaxWindows), nil, connection, self.object);
      end;
end;