-- 
-- by PeterJ (11/04/2011)
--  


LM642 = {};

function LM642.prerequisitesPresent(specializations)

    return true;
end;

function LM642:load(xmlFile)

	local rotationPartNodeEmbraiagem = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationEmbraiagem#index"));
    if rotationPartNodeEmbraiagem ~= nil then
        self.rotationEmbraiagem = {};
        self.rotationEmbraiagem.node = rotationPartNodeEmbraiagem;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationEmbraiagem#minRot"));
        self.rotationEmbraiagem.minRot = {};
        self.rotationEmbraiagem.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationEmbraiagem.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationEmbraiagem.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationEmbraiagem#maxRot"));
        self.rotationEmbraiagem.maxRot = {};
        self.rotationEmbraiagem.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationEmbraiagem.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationEmbraiagem.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationEmbraiagem.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationEmbraiagem#rotTime"), 2)*1000;
        self.rotationEmbraiagem.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationEmbraiagem#touchRotLimit"), 10));
    end;

	local rotationPartNodeAcelerador = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationAcelerador#index"));
    if rotationPartNodeAcelerador ~= nil then
        self.rotationAcelerador = {};
        self.rotationAcelerador.node = rotationPartNodeAcelerador;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationAcelerador#minRot"));
        self.rotationAcelerador.minRot = {};
        self.rotationAcelerador.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationAcelerador.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationAcelerador.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationAcelerador#maxRot"));
        self.rotationAcelerador.maxRot = {};
        self.rotationAcelerador.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationAcelerador.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationAcelerador.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationAcelerador.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationAcelerador#rotTime"), 2)*1000;
        self.rotationAcelerador.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationAcelerador#touchRotLimit"), 10));
    end;
	local rotationPartNodeTravoes = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationTravoes#index"));
    if rotationPartNodeTravoes ~= nil then
        self.rotationTravoes = {};
        self.rotationTravoes.node = rotationPartNodeTravoes;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationTravoes#minRot"));
        self.rotationTravoes.minRot = {};
        self.rotationTravoes.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationTravoes.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationTravoes.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationTravoes#maxRot"));
        self.rotationTravoes.maxRot = {};
        self.rotationTravoes.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationTravoes.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationTravoes.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationTravoes.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationTravoes#rotTime"), 2)*1000;
        self.rotationTravoes.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationTravoes#touchRotLimit"), 10));
    end;

	self.translationMaxWindows = false;
        self.rotationMaxEmbraiagem = false;
        self.rotationMaxAcelerador = false;
        self.rotationMaxTravoes = false;

	self.armrot = {};
	self.armrot.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.armRot#index"));
	self.armrot.minRot = {Utils.degToRad(getXMLFloat(xmlFile, "vehicle.armRot#minRot"))};
	self.armrot.maxRot = {Utils.degToRad(getXMLFloat(xmlFile, "vehicle.armRot#maxRot"))};
	self.armrot.Rot = {Utils.degToRad(getXMLFloat(xmlFile, "vehicle.armRot#Rot"))};
	self.armrot.rotTime = getXMLFloat(xmlFile, "vehicle.armRot#rotTime")*1000;
    self.armrot.posX = true;
    self.armrot.posZ = true;

end;

function LM642:delete()

end;

function LM642:keyEvent(unicode, sym, modifier, isDown)

end;

function LM642:update(dt)

      if self:getIsActiveForInput() then
          if Input.isKeyPressed(Input.KEY_s) then
				self.rotationMaxEmbraiagem = true;
          else
				self.rotationMaxEmbraiagem = false;
          end;
          if Input.isKeyPressed(Input.KEY_w) then
				self.rotationMaxAcelerador = true;
          else
				self.rotationMaxAcelerador = false;
          end;
          if Input.isKeyPressed(Input.KEY_s) then
				self.rotationMaxTravoes = true;
          else
				self.rotationMaxTravoes = false;
          end;
	local doRotate = self.rotationJoystickArmmax or self.rotationJoystickArmmin 
	if self.rotationJoystickArm ~= nil and doRotate then
          local x, y, z = getRotation(self.rotationJoystickArm.node);
          local rot = {x,y,z};
          local newRot = Utils.getMovedLimitedValues(rot, self.rotationJoystickArm.maxRot, self.rotationJoystickArm.minRot, 3, self.rotationJoystickArm.rotTime, dt, not self.rotationJoystickArmmax);
          setRotation(self.rotationJoystickArm.node, unpack(newRot));
	end;
	local doRotate = self.rotationJoystickToolmax or self.rotationJoystickToolmin 
	if self.rotationJoystickTool ~= nil and doRotate then
          local x, y, z = getRotation(self.rotationJoystickTool.node);
          local rot = {x,y,z};
          local newRot = Utils.getMovedLimitedValues(rot, self.rotationJoystickTool.maxRot, self.rotationJoystickTool.minRot, 3, self.rotationJoystickTool.rotTime, dt, not self.rotationJoystickToolmax);
          setRotation(self.rotationJoystickTool.node, unpack(newRot));
	end;

	if self:getIsActiveForInput() and self.isMotorStarted then
		if InputBinding.isPressed(InputBinding.FRONTLOADER_ARM_POSMAN) then
		    self.armrot.posX = true;
			x,y,z = getRotation(self.armrot.node);	
		    local newRot = Utils.getMovedLimitedValues({x}, self.armrot.maxRot, self.armrot.minRot, 1, self.armrot.rotTime, dt, true);
		    setRotation(self.armrot.node, newRot[1],y,z);	
	    end;
		if InputBinding.isPressed(InputBinding.FRONTLOADER_ARM_NEGMAN) then
		    self.armrot.posX = false;
			x,y,z = getRotation(self.armrot.node);	
		    local newRot = Utils.getMovedLimitedValues({x}, self.armrot.maxRot, self.armrot.minRot, 1, self.armrot.rotTime, dt, false );
		    setRotation(self.armrot.node, newRot[1],y,z);		
		end;
		if not InputBinding.isPressed(InputBinding.FRONTLOADER_ARM_NEGMAN) and not InputBinding.isPressed(InputBinding.FRONTLOADER_ARM_POSMAN) then
		    if self.armrot.posX then
		    	x,y,z = getRotation(self.armrot.node);	
		        local newRot = Utils.getMovedLimitedValues({x}, self.armrot.minRot, self.armrot.Rot, 1, self.armrot.rotTime/2, dt, true);
		        setRotation(self.armrot.node, newRot[1],y,z);
            else
			    x,y,z = getRotation(self.armrot.node);	
		        local newRot = Utils.getMovedLimitedValues({x}, self.armrot.maxRot, self.armrot.Rot, 1, self.armrot.rotTime/2, dt, true);
		        setRotation(self.armrot.node, newRot[1],y,z);		
		    end;
		end;
		if InputBinding.isPressed(InputBinding.FRONTLOADER_TILT_POSMAN) then
		 	self.armrot.posZ = true;   
			x,y,z = getRotation(self.armrot.node);	
		    local newRot = Utils.getMovedLimitedValues({z}, self.armrot.maxRot, self.armrot.minRot, 1, self.armrot.rotTime, dt, true );
		    setRotation(self.armrot.node, x,y,newRot[1]);	
		elseif InputBinding.isPressed(InputBinding.FRONTLOADER_TILT_NEGMAN) then
		    self.armrot.posZ = false;   
			x,y,z = getRotation(self.armrot.node);	
		    local newRot = Utils.getMovedLimitedValues({z}, self.armrot.maxRot, self.armrot.minRot, 1, self.armrot.rotTime, dt, false );
		    setRotation(self.armrot.node, x,y,newRot[1]);	
		end;
		if not InputBinding.isPressed(InputBinding.FRONTLOADER_TILT_NEGMAN) and not InputBinding.isPressed(InputBinding.FRONTLOADER_TILT_POSMAN) then
		    if self.armrot.posZ then
			    x,y,z = getRotation(self.armrot.node);	
		        local newRot = Utils.getMovedLimitedValues({z}, self.armrot.minRot, self.armrot.Rot, 1, self.armrot.rotTime/2, dt, true);
		        setRotation(self.armrot.node, x,y,newRot[1]);		
		    else
			    x,y,z = getRotation(self.armrot.node);	
		        local newRot = Utils.getMovedLimitedValues({z}, self.armrot.maxRot, self.armrot.Rot, 1, self.armrot.rotTime/2, dt, true);
		        setRotation(self.armrot.node, x,y,newRot[1]);		
			end;
		end;
	end;
      end;

end;

function LM642:updateTick(dt)
	if self:getIsActive() and self.isClient then
			if self.rotationEmbraiagem ~= nil then
				local x, y, z = getRotation(self.rotationEmbraiagem.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationEmbraiagem.maxRot, self.rotationEmbraiagem.minRot, 3, self.rotationEmbraiagem.rotTime, dt, not self.rotationMaxEmbraiagem);
				setRotation(self.rotationEmbraiagem.node, unpack(newRot));
			end;
			if self.rotationAcelerador ~= nil then
				local x, y, z = getRotation(self.rotationAcelerador.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationAcelerador.maxRot, self.rotationAcelerador.minRot, 3, self.rotationAcelerador.rotTime, dt, not self.rotationMaxAcelerador);
				setRotation(self.rotationAcelerador.node, unpack(newRot));
			end;
			if self.rotationTravoes ~= nil then
				local x, y, z = getRotation(self.rotationTravoes.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationTravoes.maxRot, self.rotationTravoes.minRot, 3, self.rotationTravoes.rotTime, dt, not self.rotationMaxTravoes);
				setRotation(self.rotationTravoes.node, unpack(newRot));
			end;
		if self.rotationPartManete ~= nil and (self.rotationMaxManete or self.rotationMinManete) then
			local x, y, z = getRotation(self.rotationPartManete.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartManete.maxRot, self.rotationPartManete.minRot, 3, self.rotationPartManete.rotTime, dt, not self.rotationMaxManete);
			setRotation(self.rotationPartManete.node, unpack(newRot));
		end;
	end;		
end;

function LM642:draw()
end;


function LM642:mouseEvent(posX, posY, isDown, isUp, button)
end;

function LM642:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
