-- By PeterJ (30-11-2010)



volvo = {};

function volvo.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function volvo:load(xmlFile)

    self.worklight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.volvo.worklight#index"));
    self.extrawheel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.volvo.extrawheel#index"));
    
    self.extrawheel1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.volvo.extrawheel1#index"));
    self.weight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.volvo.weight#index"));

	self.worklights = false;
	self.extrawheels = false;

	self.extrawheels1 = false;
	self.weights = true;

	self.controlpath = Utils.getFilename("info.png", self.baseDirectory);
    self.helpPoxX = 0.87;
    self.helpPoxY = 0.41;
    self.helpWidth = 0.12;
    self.helpHeight = 0.46;
    self.helpOverlay = Overlay:new("help", self.controlpath, self.helpPoxX, self.helpPoxY, self.helpWidth, self.helpHeight);
    self.bcActive = true;

end;

function volvo:keyEvent(unicode, sym, modifier, isDown)

		if isDown and sym == 48 then -- Key: 0
			self.bcActive = not self.bcActive;
		end;

	if isDown and sym == Input.KEY_6 then
		self.worklights = not self.worklights;
	end;
	
	if isDown and sym == Input.KEY_7 then
		self.weights = not self.weights;
	end;
	
	if isDown and sym == Input.KEY_8 then
		self.extrawheels = not self.extrawheels;
		self.extrawheels1 = not self.extrawheels1;
	end;
end;

function volvo:update(dt)

    if self:getIsActiveForInput() and self.isEntered then


		if InputBinding.hasEvent(InputBinding.WORKLIGHT) then
		   	if self.worklights == false then
		   	   self.worklights = true
		   	else
		   		self.worklights = false
		   	end;
		end;
		
		if InputBinding.hasEvent(InputBinding.EXTRAWHEEL) then
		   	if self.extrawheels == false then
		   	   self.extrawheels = true
		   	else
		   		self.extrawheels = false
		   	end;
		end;		

        if InputBinding.hasEvent(InputBinding.EXTRAWHEEL1) then
		   	if self.extrawheels1 == false then
		   	   self.extrawheels1 = true
		   	else
		   		self.extrawheels1 = false
		   	end;
		end;

        if InputBinding.hasEvent(InputBinding.WEIGHT) then
		   	if self.weights == false then
		   	   self.weights = true
		   	else
		   		self.weights = false
		   	end;
		end;
	end;	
		
if self.isEntered then

	-- extrawheel
		if self.extrawheels then
				setVisibility(self.extrawheel, self.extrawheels);
		else
				setVisibility(self.extrawheel, self.extrawheels, false);
		end;

	-- worklight
		if self.worklights then
				setVisibility(self.worklight, self.worklights);
		else
				setVisibility(self.worklight, self.worklights, false);
		end;
		
	-- extrawheel1
		if self.extrawheel1 then
				setVisibility(self.extrawheel1, self.extrawheels1);
		else
				setVisibility(self.extrawheel1, self.extrawheels1, false);
		end;

	-- weight
		if self.weight then
				setVisibility(self.weight, self.weights);
		else
				setVisibility(self.weight, self.weights, false);
		end;


end;

end;

function volvo:draw()

	 if self.helpOverlay ~= nil then
		if self.bcActive then
		self.helpOverlay:render();
		end;
	end;
		if self.bcActive then	
			g_currentMission:addExtraPrintText("Key 0: Info Off");
		else
			g_currentMission:addExtraPrintText("Key 0: Info On");
		end;

end;

function volvo:onEnter()
end;

function volvo:onLeave()
end;

function volvo:delete()
end;

function volvo:mouseEvent(posX, posY, isDown, isUp, button)
end;





