﻿--     <Attribute name="Icon_Rotate" type="boolean" value="true"/>
--     <Attribute name="Icon_Jump" type="boolean" value="true"/>
--     <Attribute name="Icon_Ident_Object" type="integer" value="1"/>
--     <Attribute name="Jumping_High" type="float" value="0.03"/>
--     <Attribute name="Jumping_Step*dt" type="float" value="0.00015"/>
--     <Attribute name="Rotate_Speed*dt" type="float" value="0.0025"/>
--     <Attribute name="onCreate" type="scriptCallback" value="MapBuyableObject.onCreateIcon"/>
--
--
--		icon for MapBuyableObject
--@date: 01/08/2013
--@Author: Bluebaby210		www.mod-portal.com
--@Version: v1.0	release
--
--darf in jede Map eingebaut werden, MapBuyableObject.zip darf nicht neu hochgeladen werden
--
--Keine Änderung ohne meine Erlaubnis
--No modification without my permission
--
--
--[[ InfospotTrigger class
InfospotTriggers consist of a trigger object and an 'i' (which is a child of the trigger object) that rotates around its y axis
Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
Orginal: Giants 
Edit: Bluebaby210
--]]
--
	print("   Map: Buyable Objects (Icon) v1.0  by Bluebaby210 loaded!");

function onCreateIcon(self, id)
	--print("created jumping Icon , id: ", id);
	local jumping = icon:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(jumping);
    jumping:load(id);
    jumping:register(true);
	table.insert(ObjectBuy.drawPartsIcon, jumping);
end;

icon = {}
icon_directory = g_currentModDirectory;
local icon_mt = Class(icon, Object);

function icon:new(isServer, isClient)
    local self = Object:new(isServer, isClient, icon_mt);
    self.className = "icon";
    return self;
end;

function icon:load(id)

	self.icon = id;
	
	self.iconRotate = Utils.getNoNil(getUserAttribute(id, "Icon_Rotate"), true);	--boolean	
	self.iconJump = Utils.getNoNil(getUserAttribute(id, "Icon_Jump"), true);	--boolean
	self.jumpingHigh = Utils.getNoNil(getUserAttribute(id, "Jumping_High"), 0.03);	--float
	self.jumpingStep = Utils.getNoNil(getUserAttribute(id, "Jumping_Step*dt"), 0.00015);	--float
	self.rotateSpeed = Utils.getNoNil(getUserAttribute(id, "Rotate_Speed*dt"), 0.0025);	--float
	
	self.iconToObject = Utils.getNoNil(getUserAttribute(id, "Icon_Ident_Object"), 86547);
	self.iconVisible = true;
	
	if self.iconJump then
		local x, y, z = getTranslation(self.icon);
		self.positionY = y;
		self.jumping = self.jumpingHigh;
	end;

	self.iconText = getUserAttribute(getParent(id), "TextName");

	self.oldIcon = getNumOfChildren(self.icon)

	if self.oldIcon <= 1 then
		local loadedI3DFile = loadI3DFile(icon_directory.."buyable/icon.i3d")
		link(self.icon, loadedI3DFile);
	end;

end;

function icon:delete()
end;

function icon:mouseEvent(posX, posY, isDown, isUp, button)
end;

function icon:keyEvent(unicode, sym, modifier, isDown)
end;

function icon:readStream(streamId, connection)
	self.iconVisible = streamReadBool(streamId);
	if not self.iconVisible then
		self:visibilityIcon(true, true);
	end;
end;

function icon:writeStream(streamId, connection)
	streamWriteBool(streamId, self.iconVisible);
end;

function icon:TriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
end;

function icon:update(dt)

	if self.iconJump then
		self.jumping = self.jumping - (self.jumpingStep * dt);
		local x, y, z = getTranslation(self.icon);
		setTranslation(self.icon, x, y + self.jumping, z);
			if y + self.jumping <= self.positionY then
				self.jumping = self.jumpingHigh;
			end;
	end;
	
	if self.iconRotate then
		rotate(self.icon, 0, self.rotateSpeed * dt, 0);
	end;
	
	if self.iconToObject == iconNumber and self.iconVisible then
		self:visibilityIcon(true);
	end;
	
end;

function icon:visibilityIcon(visible, noEventSend)
 
 if not noEventSend then
    iconEvent.sendEvent(self, visible, noEventSend); 
  end;

		if visible then
			setVisibility(self.icon, false);
			self.iconRotate = false;
			self.iconJump = false;
			self.iconVisible = false;
		end;
end;

function icon:draw()
end;

iconEvent = {};
iconEvent_mt = Class(iconEvent, Event);
InitEventClass(iconEvent, "iconEvent");

function iconEvent:emptyNew()
    local self = Event:new(iconEvent_mt);
    self.className="iconEvent";
    return self;
end;

function iconEvent:new(object, visible)
    local self = iconEvent:emptyNew();
    self.object = object;
    self.visible = visible;
    return self;
end;

function iconEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteBool(streamId, self.visible);
end;

function iconEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.visible  = streamReadBool(streamId);
    self:run(connection);
end;

function iconEvent:run(connection)
  self.object:visibilityIcon(self.visible, true);
  
  if not connection:getIsServer() then 
      g_server:broadcastEvent(iconEvent:new(self.object, self.visible), nil, connection, self.object);
  end;  
end;

function iconEvent.sendEvent(object, visible, noEventSend)
  if noEventSend == nil or noEventSend == false then
    if g_server ~= nil then
      g_server:broadcastEvent(iconEvent:new(object, visible), nil, nil, object);
    else
      g_client:getServerConnection():sendEvent(iconEvent:new(object, visible));
    end;
  end;
end;
