-- by "Marhu" 
-- v 1.0
-- Date: 21.02.2013
-- Neu Positionirung der Eier in Hnerstall

Huehnerstall = {};
Huehnerstall_mt = Class(Huehnerstall, Placeable);
InitObjectClass(Huehnerstall, "Huehnerstall");

function Huehnerstall:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, Huehnerstall_mt);
    registerObjectClassName(self, "Huehnerstall");
	
	return self;
end;

function Huehnerstall:delete()
    if self.TuerTrigger then
		removeTrigger(self.TuerTrigger);
	end
	for nodeID, pos in pairs(self.eggs) do
		local trigger = getChildAt(nodeID,0);
		setRigidBodyType(trigger, "NoRigidBody")
		setTranslation(nodeID, unpack(pos))
		setRigidBodyType(trigger, "Static")
		g_currentMission.EggsInChickenCoop[nodeID] = nil
	end
	self.eggs ={}
	unregisterObjectClassName(self);
    Huehnerstall:superClass().delete(self);
end;

function Huehnerstall:deleteFinal()
    Huehnerstall:superClass().deleteFinal(self);
end;

function Huehnerstall:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
    if not Huehnerstall:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
        return false;
    end;
	
	self.eggs = {}
	
	if not moveMode then
	
	local xmlFile = loadXMLFile("TempXML", xmlFilename);
	self.TuerTrigger = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.TuerTrigger#index"));
	Barrier:onCreate(self.TuerTrigger)
	
	local start = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.EggPos#start"));
	self.start = {getTranslation(start)}
	local widht = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.EggPos#widht"));
	self.widht = {getTranslation(widht)}
	local height = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.EggPos#height"));
	self.height = {getTranslation(height)}
		
	self.Glucke = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.Glucke#index"));
	
	delete(xmlFile);
	 
	
	self.pos = {x,y,z}
	self.rotX = {localDirectionToWorld(self.nodeId, 1, 0, 0)}
	self.rotY = {localDirectionToWorld(self.nodeId, 0, 1, 0)}
	self.rotZ = {localDirectionToWorld(self.nodeId, 0, 0, 1)}
	
	if not g_currentMission.EggsInChickenCoop then g_currentMission.EggsInChickenCoop = {} end;
	
	local ObjectsId = g_currentMission.husbandries.chicken.pickupObjectsId
	local EggGroup = {getWorldTranslation(ObjectsId)}
	local Num = getNumOfChildren(g_currentMission.husbandries.chicken.pickupObjectsId)
	for i=1, Num do
        local child = getChildAt(ObjectsId, i-1);
		if not g_currentMission.EggsInChickenCoop[child] and not self.eggs[child] then
			g_currentMission.EggsInChickenCoop[child] = true
			local x,y,z = getTranslation(child)
			self.eggs[child] = {x,y,z}
			local trigger = getChildAt(child,0);
			setRigidBodyType(trigger, "NoRigidBody")
			local zOff = math.random( 0, (self.widht[3]- self.start[3])*100 ) -- Verteilung
			local xOff = math.random( 0, (self.widht[1]- self.start[1])*100 )
			zOff = (zOff/100) + self.start[3]
			xOff = (xOff/100) + self.start[1]
			local x2 = self.pos[1] - (self.rotZ[1] * zOff) -- ZPos
			local z2 = self.pos[3] - (self.rotZ[3] * zOff)
			x2 = x2 + (self.rotX[1] * xOff) - EggGroup[1] -- XPos
			z2 = z2 + (self.rotX[3] * xOff) - EggGroup[3]
			local y2 = self.pos[2] - EggGroup[2]
			local yOff = math.random( 0, 100 ) -- Oben/Unten
			if yOff >= 50 then
				y2 = y2 + (self.rotY[2] * self.height[2]) --YPos
			else
				y2 = y2 + (self.rotY[2] * self.start[2])
			end
			setTranslation(child, x2, y2, z2)
			setRigidBodyType(trigger, "Static")
		end
	end
  end
  
	return true;
end;

function Huehnerstall:update(dt)
	
	if not self.ShowGlucke then
		if g_currentMission.husbandries.chicken.numAnimals[0] >= 10 then
			setVisibility(self.Glucke, true);
			self.ShowGlucke = true
		end
	end
end;

registerPlaceableType("Huehnerstall", Huehnerstall);