Hose_SetStationEvent = {};
Hose_SetStationEvent_mt = Class(Hose_SetStationEvent, Event);

InitEventClass(Hose_SetStationEvent, "Hose_SetStationEvent");

function Hose_SetStationEvent:emptyNew()
    local self = Event:new(Hose_SetStationEvent_mt);
    self.className="Hose_SetStationEvent";
    return self;
end;

function Hose_SetStationEvent:new(vehicle, stat)
    local self = Hose_SetStationEvent:emptyNew()
    self.vehicle = vehicle;
	self.stat = stat;
	return self;
end;

function Hose_SetStationEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
    local id2 = streamReadInt32(streamId);
	if id2 ~= 0 then
		self.stat = networkGetObject(id2);
	else
		self.stat = 0;
	end;
    self:run(connection);
end;

function Hose_SetStationEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	if self.stat ~= 0 then
		streamWriteInt32(streamId, networkGetObjectId(self.stat));	
	else
		streamWriteInt32(streamId, 0);	
	end;
end;

function Hose_SetStationEvent:run(connection)
	self.vehicle:setStationInRange(self.stat, true);
	if not connection:getIsServer() then			
		g_server:broadcastEvent(Hose_SetStationEvent:new(self.vehicle, self.stat), nil, connection, self.vehicle);
	end;
end;


function Hose_SetStationEvent.sendEvent(vehicle, stat, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(Hose_SetStationEvent:new(vehicle, stat), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(Hose_SetStationEvent:new(vehicle, stat));
		end;
	end;
end;