Hose_SetIsAttachedEvent = {};
Hose_SetIsAttachedEvent_mt = Class(Hose_SetIsAttachedEvent, Event);

InitEventClass(Hose_SetIsAttachedEvent, "Hose_SetIsAttachedEvent");

function Hose_SetIsAttachedEvent:emptyNew()
    local self = Event:new(Hose_SetIsAttachedEvent_mt);
    self.className="Hose_SetIsAttachedEvent";
    return self;
end;

function Hose_SetIsAttachedEvent:new(vehicle, sId, state)
    local self = Hose_SetIsAttachedEvent:emptyNew()
    self.vehicle = vehicle;
	self.sId = sId;
	self.state = state;
	return self;
end;

function Hose_SetIsAttachedEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
	self.sId = streamReadInt8(streamId);
	self.state = streamReadBool(streamId);
    self:run(connection);
end;

function Hose_SetIsAttachedEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.sId);
	streamWriteBool(streamId, self.state);
end;

function Hose_SetIsAttachedEvent:run(connection)
	self.vehicle:setIsAttached(self.sId, self.state, true);
	if not connection:getIsServer() then				
		g_server:broadcastEvent(Hose_SetIsAttachedEvent:new(self.vehicle, self.sId, self.state), nil, connection, self.vehicle);
	end;
end;


function Hose_SetIsAttachedEvent.sendEvent(vehicle, sId, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(Hose_SetIsAttachedEvent:new(vehicle, sId, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(Hose_SetIsAttachedEvent:new(vehicle, sId, state));
		end;
	end;
end;