Hose_SetFollowEvent = {};
Hose_SetFollowEvent_mt = Class(Hose_SetFollowEvent, Event);

InitEventClass(Hose_SetFollowEvent, "Hose_SetFollowEvent");

function Hose_SetFollowEvent:emptyNew()
    local self = Event:new(Hose_SetFollowEvent_mt);
    self.className="Hose_SetFollowEvent";
    return self;
end;

function Hose_SetFollowEvent:new(vehicle, plId, sId, state)
    local self = Hose_SetFollowEvent:emptyNew()
    self.vehicle = vehicle;
	self.plId = plId;
	self.sId = sId;
	self.state = state;
	return self;
end;

function Hose_SetFollowEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
	self.plId = streamReadInt32(streamId);
	self.sId = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self:run(connection);
end;

function Hose_SetFollowEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt32(streamId, self.plId);
	streamWriteInt32(streamId, self.sId);
	streamWriteBool(streamId, self.state);
end;

function Hose_SetFollowEvent:run(connection)
	self.vehicle:setFollow(self.plId, self.sId, self.state, true);
	if not connection:getIsServer() then				
		g_server:broadcastEvent(Hose_SetFollowEvent:new(self.vehicle, self.plId, self.sId, self.state), nil, connection, self.vehicle);
	end;
end;


function Hose_SetFollowEvent.sendEvent(vehicle, plId, sId, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(Hose_SetFollowEvent:new(vehicle, plId, sId, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(Hose_SetFollowEvent:new(vehicle, plId, sId, state));
		end;
	end;
end;