-- vervaetHose
--
-- Original specialisation for the Wienhoff 20200 VTW
--
-- @ Autor  Tobias F. (John Deere 6930)
-- @ Last Edit  26/06/2014
-- @ Edit for Vervaet: Wout vd. B. (Woutvdberg)
-- @ Edit for only the left hose: Sander K.(Sanderrr)
--
-- FS-C Modteam
--
-- FS-Community.nl
--

vervaetHose = {};

function vervaetHose.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function vervaetHose:load(xmlFile)
	
	self.leftHoseArm = 1;
	self.leftHoseArmChanged = false;

	self.leftHosePark = 3;
	self.lastLeftHoseParkHose = nil;
	self.leftHoseParkNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hoseParkDummys#Index"));
	self.leftHoseParkChanged = false;
	
	self.searchHoseRefs = false;
	
end;

function vervaetHose:delete()
end;

function vervaetHose:readStream(streamId, connection)
end;

function vervaetHose:writeStream(streamId, connection)
end;

function vervaetHose:mouseEvent(posX, posY, isDown, isUp, button)
end;

function vervaetHose:keyEvent(unicode, sym, modifier, isDown)
end;

function vervaetHose:update(dt)

	if not self.searchHoseRefs then
		if self.hoseRef.refs[self.leftHoseArm] ~= nil then
			self.leftHoseArm = self.hoseRef.refs[self.leftHoseArm];
		end;
		if self.hoseRef.refs[self.leftHosePark] ~= nil then
			self.leftHosePark = self.hoseRef.refs[self.leftHosePark];
		end;
		self:playAnimation("leftDockingStationArm", -1, nil);
		self.searchHoseRefs = true;
	end;
end;

function vervaetHose:updateTick(dt)
	if self.leftHoseArmChanged ~= self.leftHoseArm.isUsed then
		self.leftHoseArmChanged = self.leftHoseArm.isUsed;
		if self.leftHoseArm.isUsed then
			self:playAnimation("leftDockingStationArm", 1, nil);
		else
			self:playAnimation("leftDockingStationArm", -1, nil);
		end;
	end;

	if self.leftHoseParkChanged ~= self.leftHosePark.isUsed then
		self.leftHoseParkChanged = self.leftHosePark.isUsed;
		setVisibility(self.leftHoseParkNode, self.leftHosePark.isUsed);
		
		if self.lastLeftHoseParkHose == nil then
			self.lastLeftHoseParkHose = self.leftHosePark.hose.msh;
			setVisibility(self.lastLeftHoseParkHose, false);
		else
			setVisibility(self.lastLeftHoseParkHose, true);
			self.lastLeftHoseParkHose = nil;		
		end;
	end;
end;

function vervaetHose:draw()
end;

function vervaetHose:onAttach(attacherVehicle)
end;

function vervaetHose:onDetach()
end;

