-- manureMeter
-- 
--
-- author: Sanderrr
--
-- Original specialisation for the Zunhammer 18500 pu
--
-- FS-Community Modteam
-- www.FS-C.nl
-- 

manureMeter = {};


function manureMeter.prerequisitesPresent(specializations)
    return true;
end;


function manureMeter:load(xmlFile)	
	self.fm = {};
	self.fm.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fillmeter#index") );
	local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.fillmeter#minRot"));
	local x1, y1, z1 = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.fillmeter#maxRot"));
	self.fm.minRot = {Utils.degToRad(x),Utils.degToRad(y),Utils.degToRad(z)};
	self.fm.curRot = {Utils.degToRad(x),Utils.degToRad(y),Utils.degToRad(z)};
	self.fm.maxRot = {Utils.degToRad(x1),Utils.degToRad(y1),Utils.degToRad(z1)};
	self.fm.lastFillLevel = 0;
	self.fm.fillLevelChanged = 0;
end;

function manureMeter:delete()
end;


function manureMeter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function manureMeter:keyEvent(unicode, sym, modifier, isDown)

end;

function manureMeter:update(dt)

end;

function manureMeter:updateTick(dt)
		if self.fm.lastFillLevel ~= self.fillLevel then
			self.fm.fillLevelChanged = self.fillLevel - self.fm.lastFillLevel;
			self.fm.lastFillLevel = self.fillLevel;
			local newRot = Utils.getMovedLimitedValues(self.fm.minRot, self.fm.minRot, self.fm.maxRot, 3, self.capacity, self.fillLevel, true);
			setRotation(self.fm.node, newRot[1],newRot[2],newRot[3]);
		else
			self.fm.fillLevelChanged = 0;
		end;	
end;

function manureMeter:draw()

end;

function manureMeter:onAttach()

end;

function manureMeter:onDetach()
end;
