--
-- Autopilot
-- Specialization for AP Tractors
--
-- @author  zartask / Mr. F
-- @date  10/12/09
--
-- Copyright (C) www.planet-ls.de


Autopilot = {};

function Autopilot.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Hirable, specializations) and SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Autopilot:load(xmlFile)

    self.startAutopilot = SpecializationUtil.callSpecializationsFunction("startAutopilot");
    self.stopAutopilot = SpecializationUtil.callSpecializationsFunction("stopAutopilot");
    self.onTrafficCollisionTrigger = Autopilot.onTrafficCollisionTrigger;
    self.onToolTrafficCollisionTrigger = Autopilot.onToolTrafficCollisionTrigger;

    self.isAutopilotActivated = false;


    self.turnStage = 0;



    self.aiTrafficCollisionTrigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiTrafficCollisionTrigger#index"));

    self.aiTurnWidthScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.aiTurnWidthScale#value"), 0.9);


    self.trafficCollisionIgnoreList = {};
    for k,v in pairs(self.components) do
        self.trafficCollisionIgnoreList[v.node] = true;
    end;
    self.numCollidingVehicles = 0;
    self.numToolsCollidingVehicles = {};

    self.aiToolsDirty = true;

    self.dtSum = 0;

    local aiMotorSound  = getXMLString(xmlFile, "vehicle.aiMotorSound#file");
    if aiMotorSound  ~= nil and aiMotorSound  ~= "" then
        aiMotorSound  = Utils.getFilename(aiMotorSound, self.baseDirectory);
        self.aiMotorSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundRun#pitchOffset"), 0);
        self.aiMotorSoundRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundRun#radius"), 50);
        self.aiMotorSoundInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundRun#innerRadius"), 10);
        self.aiMotorSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundRun#volume"), 1);
        self.aiMotorSound = createAudioSource("aiMotorSound", aiMotorSound, self.aiMotorSoundRadius, self.aiMotorSoundInnerRadius, self.aiMotorSoundVolume, 0);
        link(self.components[1].node, self.aiMotorSound);
        setVisibility(self.aiMotorSound, false);
    end;

    local translationPartNodeLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.autoPilotAreas.autoPilotAreaLeft#index"));
    if translationPartNodeLeft ~= nil then
        self.translationPartLeft = {};
        self.translationPartLeft.node = translationPartNodeLeft;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.autoPilotAreas.autoPilotAreaLeft#minTrans"));
        self.translationPartLeft.minTrans = {};
        self.translationPartLeft.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartLeft.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartLeft.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.autoPilotAreas.autoPilotAreaLeft#maxTrans"));
        self.translationPartLeft.maxTrans = {};
        self.translationPartLeft.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartLeft.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartLeft.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartLeft.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.autoPilotAreas.autoPilotAreaLeft#transTime"), 5)*20000;
        self.translationPartLeft.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.autoPilotAreas.autoPilotAreaLeft#touchTransLimit"), 5);
    end;
	
	local translationPartNodeRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.autoPilotAreas.autoPilotAreaRight#index"));
    if translationPartNodeRight ~= nil then
        self.translationPartRight = {};
        self.translationPartRight.node = translationPartNodeRight;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.autoPilotAreas.autoPilotAreaRight#minTrans"));
        self.translationPartRight.minTrans = {};
        self.translationPartRight.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartRight.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartRight.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.autoPilotAreas.autoPilotAreaRight#maxTrans"));
        self.translationPartRight.maxTrans = {};
        self.translationPartRight.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartRight.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartRight.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartRight.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.autoPilotAreas.autoPilotAreaRight#transTime"), 5)*20000;
        self.translationPartRight.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.autoPilotAreas.autoPilotAreaRight#touchTransLimit"), 5);
    end;	

    local wheeleupdownId = getChild(g_currentMission.Map01, "smallGasStationTrigger");

    self.dWheel1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.dWheel1#index"));
    self.dWheel2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.dWheel2#index"));
    
    

    self.autoPilotAreaLeft = {};
    self.autoPilotAreaLeft.available = getXMLBool(xmlFile, "vehicle.autoPilotAreas#left");
    self.autoPilotAreaLeft.startOutside = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.autoPilotAreas.autoPilotAreaLeft#startOutside"));
    self.autoPilotAreaLeft.widthOutside = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.autoPilotAreas.autoPilotAreaLeft#widthOutside"));
    self.autoPilotAreaLeft.heightOutside = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.autoPilotAreas.autoPilotAreaLeft#heightOutside"));
    self.autoPilotAreaLeft.startInside = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.autoPilotAreas.autoPilotAreaLeft#startInside"));
    self.autoPilotAreaLeft.widthInside = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.autoPilotAreas.autoPilotAreaLeft#widthInside"));
    self.autoPilotAreaLeft.heightInside = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.autoPilotAreas.autoPilotAreaLeft#heightInside"));
    self.autoPilotAreaLeft.active = false;

    self.autoPilotAreaRight = {};
    self.autoPilotAreaRight.available = getXMLBool(xmlFile, "vehicle.autoPilotAreas#right");
    self.autoPilotAreaRight.startOutside = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.autoPilotAreas.autoPilotAreaRight#startOutside"));
    self.autoPilotAreaRight.widthOutside = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.autoPilotAreas.autoPilotAreaRight#widthOutside"));
    self.autoPilotAreaRight.heightOutside = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.autoPilotAreas.autoPilotAreaRight#heightOutside"));
    self.autoPilotAreaRight.startInside = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.autoPilotAreas.autoPilotAreaRight#startInside"));
    self.autoPilotAreaRight.widthInside = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.autoPilotAreas.autoPilotAreaRight#widthInside"));
    self.autoPilotAreaRight.heightInside = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.autoPilotAreas.autoPilotAreaRight#heightInside"));
    self.autoPilotAreaRight.active = false;

    if self.autoPilotAreaLeft.available or self.autoPilotAreaRight.available then
        self.autoPilotPresent = true;
    else
        self.autoPilotPresent = false;
    end;   
    
	
	self.workWidth = nil;
    self.autoPilotEnabled = false;
    self.autoPilotDelayLeft = 0;
    self.autoPilotDelayRight = 0;
    self.autopilotId = 0;
    
	self.turnDirection = 0;
    self.autoRotateBackSpeedBackup = self.autoRotateBackSpeed;

	self.helpPanelPath = Utils.getFilename("texturas/ApHud.png", self.baseDirectory);
	self.HudWidth = 0.32;
	self.HudHeight = 0.18; 
	self.HudPosX = 0.43;
	self.HudPosY = 0.047;
	self.helpPanelTextPosX = 0.435;
	self.helpPanelTextPosY = 0.359;
	self.helpPanelOverlay = Overlay:new("ApHud", self.helpPanelPath, self.HudPosX, self.HudPoxY, self.HudWidth, self.HudHeight);
	self.helpPanelActive = false;	
	
end;

function Autopilot:delete()
    self:stopAutopilot();
end;

function Autopilot:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Autopilot:keyEvent(unicode, sym, modifier, isDown)
	
	if isDown and sym == Input.KEY_1 then
		self.speed2Level = 1;
	elseif isDown and sym == Input.KEY_2 then
		self.speed2Level = 2;
	elseif isDown and sym == Input.KEY_3 then
		self.speed2Level = 3;
	elseif isDown and sym == Input.KEY_s then
		self.speed2Level = 0;
	end;
            if sym == Input.KEY_KP_4 and isDown then
                self.autoPilotAreaLeft.active = self.autoPilotAreaLeft.available;
                self.autoPilotAreaRight.active = false;

                self.autoPilotDelayLeft = 0;
                self.autoPilotDelayRight = 0;           
			end;

            if sym == Input.KEY_KP_6 and isDown then
                self.autoPilotAreaRight.active = self.autoPilotAreaRight.available;
                self.autoPilotAreaLeft.active = false;

                self.autoPilotDelayRight = 0;
                self.autoPilotDelayLeft = 0;

		    end;
			if sym == Input.KEY_KP_1 then
				self.translationMaxLeft = isDown;
				self.translationMaxRight = isDown;
			end;
			if sym == Input.KEY_KP_3 then
				self.translationMinLeft = isDown;
				self.translationMinRight = isDown;
			end;

	if isDown and sym == Input.KEY_KP_5 then
        self.autopilotId = self.autopilotId - 1;
		if self.autopilotId < 0 then
		    self.autopilotId = 0
		end;
 	end;	

	if isDown and sym == Input.KEY_KP_2 then
        self.autopilotId = self.autopilotId + 1;
		if self.autopilotId > 32 then
		    self.autopilotId = 32
		end;
 	end;	
	
	if isDown and sym == Input.KEY_0 then
        self.helpPanelActive = not self.helpPanelActive;
    end;			

	if isDown and sym == Input.KEY_r then
        if self.isAutopilotActivated then
            self:stopAutopilot();
            self.autoPilotEnabled = false;
		else
            if	self.motor.speedLevel == 0 then
				self.speed2Level = 1;
			end;
			self:startAutopilot();
            self.autoPilotEnabled = true;
		end;
    end;
	
	
end;

function Autopilot:update(dt)

    
	self.workWidth = getTranslation(self.translationPartLeft.node) * 2;
    --if self.aiToolsDirty then
      --  Autopilot.updateToolsInfo(self);
    --end;
	if self.isEntered then
	if self.autoPilotAreaRight.available then
        if self.translationPartRight ~= nil and (self.translationMaxRight or self.translationMinRight) then
        local x, y, z = getTranslation(self.translationPartRight.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartRight.maxTrans, self.translationPartRight.minTrans, 3, self.translationPartRight.transTime, dt, not self.translationMaxRight);
        setTranslation(self.translationPartRight.node, unpack(newTrans));
		end;
	end;
	
	if self.autoPilotAreaLeft.available then
		if self.translationPartLeft ~= nil and (self.translationMaxLeft or self.translationMinLeft) then
        local x, y, z = getTranslation(self.translationPartLeft.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartLeft.maxTrans, self.translationPartLeft.minTrans, 3, self.translationPartLeft.transTime, dt, not self.translationMaxRight);
        setTranslation(self.translationPartLeft.node, unpack(newTrans));
		end;
	end;
    end;
	if self.isAutopilotActivated then
        if self.isBroken then
            self:stopAutopilot();
        end;
        self.dtSum = self.dtSum + dt;
        if self.dtSum > 20 then
            Autopilot.updateAIMovement(self, self.dtSum);
            self.dtSum = 0;
        end;
        --local x,y,z = getWorldTranslation(self.AutopilotDirectionNode);
        --setTranslation(self.debugPosition, self.AutopilotTargetX, y, self.AutopilotTargetZ);
        Autopilot.updateAIMovement(self, dt);
    else
        --self.dtSum = 0;
    end;
end;

function Autopilot:startAutopilot()
    self:hire();
    if not self.isAutopilotActivated then

        self.isAutopilotActivated = true;
       -- self.turnTimer = self.turnTimeoutLong;
        --self.turnStage = 0;
				if self.autoPilotPresent then
					if not self.autoPilotAreaLeft.active and not self.autoPilotAreaRight.active then
						if self.autoPilotAreaLeft.available then
							self.autoPilotAreaLeft.active = true;
						elseif self.autoPilotAreaRight.available then
							self.autoPilotAreaRight.active = true;
						end;
					end;

					if self.autoPilotEnabled then
						self.autoRotateBackSpeed = 0;
					else
						self.autoRotateBackSpeed = self.autoRotateBackSpeedBackup;
					end;
				end;

        self.numCollidingVehicles = 0;
        if self.aiTrafficCollisionTrigger ~= nil then
            addTrigger(self.aiTrafficCollisionTrigger, "onTrafficCollisionTrigger", self);
        end;



        self.checkSpeedLimit = false;

        setVisibility(self.aiMotorSound, true);

    end;
end;

function Autopilot:stopAutopilot()
    self:dismiss();
    if self.isAutopilotActivated then

        self.motor:setSpeedLevel(0, false);
        self.motor.maxRpmOverride = nil;

        WheelsUtil.updateWheelsPhysics(self, 0, self.lastSpeed, 0, false, self.requiredDriveMode);

        if self.aiTrafficCollisionTrigger ~= nil then
            removeTrigger(self.aiTrafficCollisionTrigger);
        end;
        self.isAutopilotActivated = false;

        self.checkSpeedLimit = true;

        setVisibility(self.aiMotorSound, false);

    end;
end;

function Autopilot.updateAIMovement(self, dt)

    local allowedToDrive = true;

    if self.numCollidingVehicles > 0 then
        allowedToDrive = false;
    end;
    for k,v in pairs(self.numToolsCollidingVehicles) do
        if v > 0 then
            allowedToDrive = false;
            break;
        end;
    end;

			if self.autoPilotPresent then
				if self.autoPilotEnabled then --and self.attachedCutter.hasGroundContact then | and self.movingDirection > 0
					self.turnDirection = 0;

if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 20  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_BARLEY, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_BARLEY, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +1;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 20 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_BARLEY, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_BARLEY, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +1;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;

if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 21  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_WHEAT, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_WHEAT, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +1;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 21 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_WHEAT, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_WHEAT, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +1;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;

if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 31  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_PEA, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_PEA, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +1;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 31 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_PEA, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_PEA, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +1;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;

if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 32  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_SUGARCANE, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_SUGARCANE, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +1;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 32 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_SUGARCANE, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_SUGARCANE, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +1;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;

if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 22  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_MAIZE, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_MAIZE, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +1;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 22 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_MAIZE, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_MAIZE, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +1;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;

if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 23  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_RAPE, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_RAPE, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +1;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 23 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_RAPE, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_RAPE, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +1;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;

if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 24  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_SUNFLOWER, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_SUNFLOWER, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +1;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 24 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_SUNFLOWER, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_SUNFLOWER, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +1;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;

if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 25  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_SUGARBEET, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_SUGARBEET, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +1;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 25 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_SUGARBEET, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_SUGARBEET, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +1;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;

if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 26  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_SOYBEAN, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_SOYBEAN, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +1;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 26 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_SOYBEAN, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_SOYBEAN, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +1;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;

if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 27  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_RICE, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_RICE, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +1;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 27 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_RICE, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_RICE, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +1;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;

if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 28  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_POTATO, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_POTATO, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +1;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 28 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_POTATO, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_POTATO, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +1;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;

if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 29  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_MAIZEV2, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_MAIZEV2, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +1;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 29 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_MAIZEV2, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_MAIZEV2, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +1;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;
                if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 5  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_WHEAT].windrowId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_WHEAT].windrowId, 0, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +0.00001;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 5 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_WHEAT].windrowId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_WHEAT].windrowId, 0, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +0.00001;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;

                if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 6  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_BARLEY].windrowId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_BARLEY].windrowId, 0, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +0.00001;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 6 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_BARLEY].windrowId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_BARLEY].windrowId, 0, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +0.00001;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;

                if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 2  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_GRASS].windrowId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_GRASS].windrowId, 0, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +0.00001;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 2 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_GRASS].windrowId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_GRASS].windrowId, 0, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +0.00001;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;

                if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 1  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_GRASS].cutLongId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_GRASS].cutLongId, 0, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +0.00001;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 1 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_GRASS].cutLongId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_GRASS].cutLongId, 0, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +0.00001;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;

                if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 0  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_GRASS, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_GRASS, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +0.00001;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 0 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_GRASS, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_GRASS, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +0.00001;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;
				
                if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 3  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_DRYGRASS].cutLongId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_DRYGRASS].cutLongId, 0, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +0.00001;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 3 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_DRYGRASS].cutLongId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_DRYGRASS].cutLongId, 0, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +0.00001;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;
				
                if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 4  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_DRYGRASS].windrowId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_DRYGRASS].windrowId, 0, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +0.00001;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 4 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_DRYGRASS].windrowId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_DRYGRASS].windrowId, 0, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +0.00001;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;				
				
                if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 7  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MAIZE].cutShortId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MAIZE].cutShortId, 0, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +0.00001;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 7 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MAIZE].cutShortId, 0, x, z, x1, z1, x2, z2);
					
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MAIZE].cutShortId, 0, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +0.00001;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;				
				
				if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 8  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_WHEAT].cutShortId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_WHEAT].cutShortId, 0, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +0.00001;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 8 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_WHEAT].cutShortId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_WHEAT].cutShortId, 0, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +0.00001;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;
			    
				if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 9  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_RAPE].cutShortId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_RAPE].cutShortId, 0, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +0.00001;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 9 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_RAPE].cutShortId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_RAPE].cutShortId, 0, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +0.00001;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;
				
				if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 10  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_BARLEY].cutShortId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_BARLEY].cutShortId, 0, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +0.00001;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 10 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_BARLEY].cutShortId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_BARLEY].cutShortId, 0, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +0.00001;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;				

				if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 11  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getDensity(g_currentMission.terrainDetailId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getDensity(g_currentMission.terrainDetailId, 0, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +0.00001;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 11 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getDensity(g_currentMission.terrainDetailId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getDensity(g_currentMission.terrainDetailId, 0, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +0.00001;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;				


if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 12  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_SUNFLOWER].cutShortId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_SUNFLOWER].cutShortId, 0, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +1;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 12 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_SUNFLOWER].cutShortId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_SUNFLOWER].cutShortId, 0, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +1;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;

                              if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 13  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_SUGARBEET].cutShortId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_SUGARBEET].cutShortId, 0, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +1;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 13 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_SUGARBEET].cutShortId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_SUGARBEET].cutShortId, 0, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +1;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;

                              if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 14  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_SOYBEAN].cutShortId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_SOYBEAN].cutShortId, 0, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +1;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 14 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_SOYBEAN].cutShortId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_SOYBEAN].cutShortId, 0, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +1;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;

                          if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 15  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_RICE].cutShortId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_RIZE].cutShortId, 0, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +1;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 15 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_RICE].cutShortId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_RICE].cutShortId, 0, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +1;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;

                               if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 16 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_POTATO].cutShortId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_POTATO].cutShortId, 0, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +1;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 16 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_POTATO].cutShortId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_POTATO].cutShortId, 0, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +1;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;

                                 if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 17  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MAIZEV2].cutShortId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MAIZEV2].cutShortId, 0, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +1;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 17 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MAIZEV2].cutShortId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MAIZEV2].cutShortId, 0, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +1;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;

                               if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 30  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_COTTON, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_COTTON, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +1;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 30 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getFruitArea(FruitUtil.FRUITTYPE_COTTON, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getFruitArea(FruitUtil.FRUITTYPE_COTTON, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +1;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;

                             
                if self.autoPilotAreaRight.available and self.autoPilotAreaRight.active and self.autopilotId == 19  then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightOutside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MAIZEV2].windrowId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaRight.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaRight.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaRight.heightInside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MAIZEV2].windrowId, 0, x, z, x1, z1, x2, z2);
                    self.turnDirection = right -(9 -left);

                    self.turnDirection = right*4 -(20 -left);

                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayRight = self.autoPilotDelayRight +1;
                    else
                        self.autoPilotDelayRight = 0;
                    end;
                end;

				if self.autoPilotAreaLeft.available and self.autoPilotAreaLeft.active and self.autopilotId == 19 then
                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startOutside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthOutside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightOutside);
                    local left = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MAIZEV2].windrowId, 0, x, z, x1, z1, x2, z2);

                    local x,y,z = getWorldTranslation(self.autoPilotAreaLeft.startInside);
                    local x1,y1,z1 = getWorldTranslation(self.autoPilotAreaLeft.widthInside);
                    local x2,y2,z2 = getWorldTranslation(self.autoPilotAreaLeft.heightInside);
                    local right = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MAIZEV2].windrowId, 0, x, z, x1, z1, x2, z2);

                    self.turnDirection = ((20 -right) -left*4);
					
                    if (left < 1 and right < 1) or (left > 19 and right > 19) then
                        self.autoPilotDelayLeft = self.autoPilotDelayLeft +1;
                    else
                        self.autoPilotDelayLeft = 0;
                    end;
                end;
				local acceleration = 0;
					 if self.isMotorStarted then
						if self.motor.speedLevel ~= 0 then
							acceleration = 1.0; 
               
						end;
					end;
					if self.fuelFillLevel == 0 then
						acceleration = 0;
					end;

				local rotScale = math.min(1.0/(self.lastSpeed*50+1), 1);
				if self.autoPilotAreaLeft.active and self.turnDirection < -19 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*rotScale, 0.90);-----self.minRotTime
				elseif self.turnDirection < -18 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*70, 0.84);----self.maxRotTime
				elseif self.turnDirection < -17 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*65, 0.78);----self.maxRotTime
				elseif self.turnDirection < -16 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*55, 0.72);----self.maxRotTime
                elseif self.turnDirection < -15 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*45, 0.66);----self.maxRotTime
				elseif self.turnDirection < -14 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*35, 0.60);----self.maxRotTime
				elseif self.turnDirection < -13 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*30, 0.54);----self.maxRotTime
				elseif self.turnDirection < -12 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*25, 0.36);----self.maxRotTime
				elseif self.turnDirection < -11 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*20, 0.28);----self.maxRotTime
				elseif self.turnDirection < -10 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*15, 0.22);----self.maxRotTime
				elseif self.turnDirection < -9 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*10, 0.18);----self.maxRotTime
                elseif self.turnDirection < -8 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*5, 0.16);----self.maxRotTime
				elseif self.turnDirection < -7 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*1, 0.14);----self.maxRotTime
				elseif self.turnDirection < -6 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*0.5, 0.12);----self.maxRotTime
				elseif self.turnDirection < -5 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*0.1, 0.10);----self.maxRotTime
				elseif self.turnDirection < -4 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*0.08, 0.08);----self.maxRotTime
				elseif self.turnDirection < -3 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*0.06, 0.06);----self.maxRotTime
				elseif self.turnDirection < -2 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*0.04, 0.04);----self.maxRotTime
				elseif self.turnDirection < -1 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*0.02, 0.02);----self.maxRotTime
				elseif self.autoPilotAreaLeft.active and self.turnDirection > 19 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*rotScale, -0.90);-----self.minRotTime
				elseif self.turnDirection > 18 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*70, -0.84);-----self.minRotTime
				elseif self.turnDirection > 17 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*65, -0.78);-----self.minRotTime
				elseif self.turnDirection > 16 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*55, -0.72);-----self.minRotTime
				elseif self.turnDirection > 15 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*45, -0.66);-----self.minRotTime
				elseif self.turnDirection > 14 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*35, -0.60);-----self.minRotTime
				elseif self.turnDirection > 13 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*30, -0.54);-----self.minRotTime
                elseif self.turnDirection > 12 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*25, -0.36);-----self.minRotTime
				elseif self.turnDirection > 11 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*20, -0.28);-----self.minRotTime
				elseif self.turnDirection > 10 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*15, -0.22);-----self.minRotTime
				elseif self.turnDirection > 9 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*10, -0.18);-----self.minRotTime
				elseif self.turnDirection > 8 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*5, -0.16);-----self.minRotTime
				elseif self.turnDirection > 7 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*1, -0.14);-----self.minRotTime
				elseif self.turnDirection > 6 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*0.5, -0.12);-----self.minRotTime
                elseif self.turnDirection > 5 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*0.10, -0.10);-----self.minRotTime
				elseif self.turnDirection > 4 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*0.08, -0.08);-----self.minRotTime
				elseif self.turnDirection > 3 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*0.06, -0.06);-----self.minRotTime
                elseif self.turnDirection > 2 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*0.04, -0.04);-----self.minRotTime
				elseif self.turnDirection > 1 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*0.02, -0.02);-----self.minRotTime
                else
                    self.rotatedTime = 0;
                end;
				
				local rotScale = math.min(1.0/(self.lastSpeed*50+1), 1);
				if self.autoPilotAreaRight.active and self.turnDirection < -19 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*rotScale, 0.90);-----self.minRotTime
				elseif self.turnDirection < -18 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*70, 0.84);----self.maxRotTime
				elseif self.turnDirection < -17 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*65, 0.78);----self.maxRotTime
				elseif self.turnDirection < -16 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*55, 0.72);----self.maxRotTime
                elseif self.turnDirection < -15 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*45, 0.66);----self.maxRotTime
				elseif self.turnDirection < -14 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*35, 0.60);----self.maxRotTime
				elseif self.turnDirection < -13 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*30, 0.54);----self.maxRotTime
				elseif self.turnDirection < -12 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*25, 0.36);----self.maxRotTime
				elseif self.turnDirection < -11 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*20, 0.28);----self.maxRotTime
				elseif self.turnDirection < -10 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*15, 0.22);----self.maxRotTime
				elseif self.turnDirection < -9 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*10, 0.18);----self.maxRotTime
                elseif self.turnDirection < -8 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*5, 0.16);----self.maxRotTime
				elseif self.turnDirection < -7 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*1, 0.14);----self.maxRotTime
				elseif self.turnDirection < -6 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*0.5, 0.12);----self.maxRotTime
				elseif self.turnDirection < -5 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*0.1, 0.10);----self.maxRotTime
				elseif self.turnDirection < -4 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*0.08, 0.08);----self.maxRotTime
				elseif self.turnDirection < -3 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*0.06, 0.06);----self.maxRotTime
				elseif self.turnDirection < -2 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*0.04, 0.04);----self.maxRotTime
				elseif self.turnDirection < -1 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1*self.turnDirection*0.02, 0.02);----self.maxRotTime
				elseif self.autoPilotAreaRight.active and self.turnDirection > 19 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*rotScale, -0.90);-----self.minRotTime
				elseif self.turnDirection > 18 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*70, -0.84);-----self.minRotTime
				elseif self.turnDirection > 17 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*65, -0.78);-----self.minRotTime
				elseif self.turnDirection > 16 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*55, -0.72);-----self.minRotTime
				elseif self.turnDirection > 15 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*45, -0.66);-----self.minRotTime
				elseif self.turnDirection > 14 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*35, -0.60);-----self.minRotTime
				elseif self.turnDirection > 13 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*30, -0.54);-----self.minRotTime
                elseif self.turnDirection > 12 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*25, -0.36);-----self.minRotTime
				elseif self.turnDirection > 11 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*20, -0.28);-----self.minRotTime
				elseif self.turnDirection > 10 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*15, -0.22);-----self.minRotTime
				elseif self.turnDirection > 9 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*10, -0.18);-----self.minRotTime
				elseif self.turnDirection > 8 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*5, -0.16);-----self.minRotTime
				elseif self.turnDirection > 7 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*1, -0.14);-----self.minRotTime
				elseif self.turnDirection > 6 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*0.5, -0.12);-----self.minRotTime
                elseif self.turnDirection > 5 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*0.10, -0.10);-----self.minRotTime
				elseif self.turnDirection > 4 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*0.08, -0.08);-----self.minRotTime
				elseif self.turnDirection > 3 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*0.06, -0.06);-----self.minRotTime
                elseif self.turnDirection > 2 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*0.04, -0.04);-----self.minRotTime
				elseif self.turnDirection > 1 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1*self.turnDirection*0.02, -0.02);-----self.minRotTime
                else
                    self.rotatedTime = 0;
                end;

					if self.firstTimeRun then
						WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, acceleration, false, self.requiredDriveMode)
					end;
				
					if self.steering ~= nil then
						setRotation(self.steering, 0, self.rotatedTime*self.steeringSpeed, 0);
					end;

					if self.autoPilotDelayLeft > 700 or self.autoPilotDelayRight > 700 then
						self:stopAutopilot();
                        self.autoPilotEnabled = false;
						
						if not self.isEntered then
							self.allowDrive = false;
						end;						
					end;
					if self.isEntered then
						self.allowDrive = true;
					end;
					
					if allowedToDrive then				
						self.motor.speedLevel = self.speed2Level;		
					else
						self.motor.speedLevel = 0;
					end;
					
					
				else
					self.autoPilotDelayLeft = 0;
					self.autoPilotDelayRight = 0;

				end;	
			end;



 
end;


function Autopilot:onTrafficCollisionTrigger(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
    if onEnter or onLeave then
        if otherId == Player.rootNode then
            if onEnter then
                self.numCollidingVehicles = self.numCollidingVehicles+1;
            elseif onLeave then
                self.numCollidingVehicles = math.max(self.numCollidingVehicles-1, 0);
            end;
        else
            local vehicle = g_currentMission.nodeToVehicle[otherId];
            if vehicle ~= nil and self.trafficCollisionIgnoreList[otherId] == nil then
                if onEnter then
                    self.numCollidingVehicles = self.numCollidingVehicles+1;
                elseif onLeave then
                    self.numCollidingVehicles = math.max(self.numCollidingVehicles-1, 0);
                end;
            end;
        end;
    end;
end;

--function Autopilot:onToolTrafficCollisionTrigger(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
    --if onEnter or onLeave then
      --  if otherId == Player.rootNode then
        --    if onEnter then
          --      self.numToolsCollidingVehicles[triggerId] = self.numToolsCollidingVehicles[triggerId]+1;
          --  elseif onLeave then
          --      self.numToolsCollidingVehicles[triggerId] = math.max(self.numToolsCollidingVehicles[triggerId]-1, 0);
          --  end;
       -- else
       --     local vehicle = g_currentMission.nodeToVehicle[otherId];
        --    if vehicle ~= nil and self.trafficCollisionIgnoreList[otherId] == nil then
        --        if onEnter then
          --          self.numToolsCollidingVehicles[triggerId] = self.numToolsCollidingVehicles[triggerId]+1;
        --        elseif onLeave then
        --            self.numToolsCollidingVehicles[triggerId] = math.max(self.numToolsCollidingVehicles[triggerId]-1, 0);
        --        end;
      --      end;
    --    end;
 --   end;
--end;

function Autopilot:draw()

	if self.helpPanelActive then	
	    g_currentMission:addExtraPrintText("0: Hide Autopilot Settings");
		self.helpPanelOverlay:render();
		if self.isAutopilotActivated then
		    renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.225, 0.023,"Autopilot off");
		else
		    renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.225, 0.023,"Autopilot on");
		end;
		if self.autopilotId == 0 then
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Mowed Grass");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Grass");	
		end;	
		if self.autopilotId == 1 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Grass");	
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Grass Swath");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Mowed Grass");	
		end;			
		if self.autopilotId == 2 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Mowed Grass");	
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Dry Grass");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Grass Swath");	
		end;		
		if self.autopilotId == 3 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Grass Swath");	
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Dry Grass Swath");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Dry Grass");	
		end;		
		if self.autopilotId == 4 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Dry Grass");	
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Wheat Swath");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Dry Grass Swath");	
		end;
		if self.autopilotId == 5 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Dry Grass Swath");	
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Barley Swath");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Wheat Swath");	
		end;
		if self.autopilotId == 6 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Wheat Swath");	
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Corn Stubble");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Barley Swath");	
		end;	
		if self.autopilotId == 7 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Barley Swath");			 
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Wheat Stubble");	
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Corn Stubble");	
		end;	
		if self.autopilotId == 8 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Corn Stubble");	
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Canola Stubble");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Wheat Stubble");	
		end;	
		if self.autopilotId == 9 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Wheat Swath");	
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Barley Stubble");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Canola Stubble");	
		end;			
		if self.autopilotId == 10 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Canola Stubble");	
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Cultivated Ground");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Barley Stubble");	
		end;			
		if self.autopilotId == 11 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Wheat Swath");			 
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Sunflower Stubble");
                  setTextColor(0.0, 1.0, 0.0, 1.0);
                  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Cultivated Ground");	
		end;
                if self.autopilotId == 12 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Cultivated Ground");	
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: soybean Stubble");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: sunflower Stubble");	
		end;
                if self.autopilotId == 13 then
                  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Sunflower Stubble");	
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: soybean Stubble");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Sugarbeet Stubble");	
		end;
                if self.autopilotId == 14 then
                  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Sugarbeet Stubble");	
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Rice Stubble");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Soybean Stubble");	
		end;	
  		if self.autopilotId == 15 then
                  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Soybean Stubble");	
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Potato Stubble");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Rice Stubble");	
		end;	
		if self.autopilotId == 16 then
                  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Rice Stubble");	
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Maizev2 Stubble");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Potato Stubble");	
		end;
		if self.autopilotId == 17 then
                  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Potato Stubble");	
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Cotton Stubble");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Maizev2 Stubble");	
		end;	
                if self.autopilotId == 18 then
                  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Maizev2 Stubble");	
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Maizev2 Swath");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Cotton Stubble");	
		end;	
		if self.autopilotId == 19 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Cotton Stubble");
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Barley");			 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Maizev2 Swath");	
		end;	
                 if self.autopilotId == 20 then
                  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Maizev2 Swath");
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Wheat");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Barley");	
		end;	
		if self.autopilotId == 21 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Barley");	
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Corn");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Wheat");	
		end;			
		if self.autopilotId == 22 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Wheat");	
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Canola");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Corn");	
		end;		
		if self.autopilotId == 23 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Corn");	
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Sunflower");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Canola");	
		end;		
		if self.autopilotId == 24 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Canola");	
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Sugerbeet");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Sunflower");	
		end;
		if self.autopilotId == 25 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Sunflower");	
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Soybean");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Sugerbeet");	
		end;
                if self.autopilotId == 26 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Sugerbeet");	
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Rice");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Soybean");	
		end;	
		if self.autopilotId == 27 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Soybean");	
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Potato");		 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Rice");	
		end;	
		if self.autopilotId == 28 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Rice");			 
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Maizev2");	
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Potato");	
		end;	
				if self.autopilotId == 29 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Potato");
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Cotton");			 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Maizev2");	
		end;		
                     if self.autopilotId == 30 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Maizev2");
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Pea");
          setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Cotton");	
		end;
		if self.autopilotId == 31 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Cotton");
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.325, 0.023, "AP: Sugar Cane");			 
		  setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Pea");	
		end;		
                   if self.autopilotId == 32 then
          renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.275, 0.023, "AP: Pea");
           setTextColor(0.0, 1.0, 0.0, 1.0);
		  renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.3, 0.023, "AP: Sugar Cane");	

		end;								
		setTextColor(1.0, 1.0, 1.0, 1.0);		
		renderText(self.helpPanelTextPosX+0.19, self.helpPanelTextPosY-0.225, 0.023, "Button R");
		renderText(self.helpPanelTextPosX+0.19, self.helpPanelTextPosY-0.275, 0.023, "Num 5");		
		renderText(self.helpPanelTextPosX+0.19, self.helpPanelTextPosY-0.325, 0.023, "Num 2");
		renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.25, 0.023,string.format("Working Width: %0.1fm",self.workWidth));
		renderText(self.helpPanelTextPosX+0.19, self.helpPanelTextPosY-0.35, 0.023, "Num 4 / 6");
		renderText(self.helpPanelTextPosX+0.19, self.helpPanelTextPosY-0.25, 0.023, "Num 1[+] / 3[-]");	
	    if self.autoPilotAreaLeft.active then
			renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.35, 0.023, "Active Side: Left");
		else
		    renderText(self.helpPanelTextPosX, self.helpPanelTextPosY-0.35, 0.023, "Active Side: Right");
		end;
	
	end;
	
end;
