--
-- Worklights
-- LS UK Modteam
--
-- author Henly20
-- date  20/11/2010
--

Worklights = {};

function Worklights.prerequisitesPresent(specializations)
    return true;
end;



function Worklights:load(xmlFile)

	self.setWorkLightsVisibility = SpecializationUtil.callSpecializationsFunction("setWorkLightsVisibility");

      self.workLights = {};
      local i = 0;
      while true do
          local key = string.format("vehicle.workLights.workLight(%d)", i);
          if not hasXMLProperty(xmlFile, key) then
              break;
          end;
          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
          if node ~= nil then
              setVisibility(node, false);
              table.insert(self.workLights, {node=node});
          end;
          i = i + 1;
      end;
	  
	self.workLightsActive = false;
end;

function Worklights:delete()

end;

function Worklights:readStream(streamId, connection)
	self.isLoading = true;
	local visibility = streamReadBool(streamId);
	self:setWorkLightsVisibility(visibility, true);

	
end;

function Worklights:writeStream(streamId, connection)
	streamWriteBool(streamId, self.workLightsActive);

	
end;

function Worklights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Worklights:keyEvent(unicode, sym, modifier, isDown)
end;

function Worklights:update(dt)

      if self:getIsActiveForInput() and self.isClient then
          if InputBinding.hasEvent(InputBinding.FORDWORKLIGHTS) then
              if (not self.toggleLightsSound) then
                  self.toggleLightsSound = createSample("toggleLightsSound");
                  loadSample(self.toggleLightsSound, "dataS2/sounds/switchFlashlight.wav", false);
                  setSamplePitch(self.toggleLightsSound, 0.5);
              end;
              playSample(self.toggleLightsSound, 1, 1.0, 0);
              self:setWorkLightsVisibility(not self.workLightsActive);
          end;
	end;
end;

function Worklights:updateTick(dt)



end;

function Worklights:onLeave()
       self:setWorkLightsVisibility(false, true);
end;

function Worklights:draw()

end;

function Worklights:setWorkLightsVisibility(visibility, noEventSend)
      if visibility ~= self.workLightsActive then
  
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetWorkLightEvent:new(self, visibility), nil, nil, self);
              else
                  g_client:getServerConnection():sendEvent(SetWorkLightEvent:new(self, visibility));
              end;
          end;
  
          self.workLightsActive = visibility;
  
          for _, workLight in pairs(self.workLights) do
             setVisibility(workLight.node, visibility);
          end;
          for _,v in pairs(self.specializations) do
              if v.setWorkLightsVisibility ~= nil then
                 v.setWorkLightsVisibility(self, visibility);
              end;
          end;
      end;
end;