SetDoorRearRotationEvent = {};
SetDoorRearRotationEvent_mt = Class(SetDoorRearRotationEvent, Event);
  
InitEventClass(SetDoorRearRotationEvent, "SetDoorRearRotationEvent");
  
function SetDoorRearRotationEvent:emptyNew()
      local self = Event:new(SetDoorRearRotationEvent_mt);
      self.className="SetDoorRearRotationEvent";
      return self;
 end;

function SetDoorRearRotationEvent:new(object, rotationMax20)
      local self = SetDoorRearRotationEvent:emptyNew()
      self.object = object;
      self.rotationMax20 = rotationMax20;
      return self;
end;
 
function SetDoorRearRotationEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.rotationMax20 = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetDoorRearRotationEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.rotationMax20);
end;
 
function SetDoorRearRotationEvent:run(connection)
      self.object:setRotationMax20(self.rotationMax20, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetDoorRearRotationEvent:new(self.object, self.rotationMax20), nil, connection, self.object);
      end;
end;