﻿Ford8340Event = {};
Ford8340Event_mt = Class(Ford8340Event, Event);

InitEventClass(Ford8340Event, "Ford8340Event");

function Ford8340Event:emptyNew()
    local self = Event:new(Ford8340Event_mt);
    self.className="Ford8340Event";
    return self;
end;

function Ford8340Event:new(vehicle, mode, state)
    local self = Ford8340Event:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
	self.state = state;
    return self;
end;

function Ford8340Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function Ford8340Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt32(streamId, self.mode);
	streamWriteBool(streamId, self.state);
end;

function Ford8340Event:run(connection)
	self.vehicle:OPER(self.mode, self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(Ford8340Event:new(self.vehicle, self.mode, self.state), nil, connection, self.vehicle);
    end;
end;

function Ford8340Event.sendEvent(vehicle, mode, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(Ford8340Event:new(vehicle, mode, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(Ford8340Event:new(vehicle, mode, state));
		end;
	end;
end;