-- StollF71
-- Specialization for StollF71 mod
--
-- @author  kA

StollF71 = {};

function StollF71.prerequisitesPresent(specializations)
    return true;
end;

function StollF71:load(xmlFile)
    self.supportColli = self.components[2].node
		self.entry = {};
		local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animParts.part1#rootNode"));
		self.entry.animCharSet = 0;
		if rootNode ~= nil then
			self.entry.animCharSet = getAnimCharacterSet(rootNode);
			if self.entry.animCharSet ~= 0 then
				local clip = getAnimClipIndex(self.entry.animCharSet, getXMLString(xmlFile, "vehicle.animParts.part1#animationClip"));
				if clip >= 0 then
					assignAnimTrackClip(self.entry.animCharSet, 0, clip);
					setAnimTrackLoopState(self.entry.animCharSet, 0, false);
					self.entry.animDuration = getAnimClipDuration(self.entry.animCharSet, clip);
				end;
			end;
		end;
	self.startAnimTime = 0;
	self.turnLevel = 0;
	self.Support = true;
end;

function StollF71:mouseEvent(posX, posY, isDown, isUp, button)
end;

function StollF71:update(dt)
	if self.attacherVehicle ~= nil then
		setRigidBodyType(self.components[2].node, "NoRigidBody");
        local index1 = 0;
        local index2 = 1;
        local jointIndexStr = '0>2';

        local jointNode = Utils.indexToObject(self.components, jointIndexStr);
        if jointNode ~= nil and jointNode ~= 0 then
        	local x, y, z = getWorldTranslation(jointNode)
        	setTranslation(self.components[2].node, x, y, z)
        	local x, y, z = getWorldRotation(jointNode)
        	setRotation(self.components[2].node, x, y, z)
		end;
	end;
	if self.turnLevel < 1 then 
       self.turnLevel = 0;
	end;
    if self.turnLevel > 2000 then 
      self.turnLevel = 2000;
    end;
	if self.Support then
		self.turnLevel = self.turnLevel -10;
        enableAnimTrack(self.entry.animCharSet, 0);
        setAnimTrackTime(self.entry.animCharSet, 0, self.turnLevel, true);
        disableAnimTrack(self.entry.animCharSet, 0);	
	else
	    self.turnLevel = self.turnLevel +10;
        enableAnimTrack(self.entry.animCharSet, 0);
        setAnimTrackTime(self.entry.animCharSet, 0, self.turnLevel, true);
        disableAnimTrack(self.entry.animCharSet, 0);		
	end;	
	if self.SupportCompAttach then
		local index1 = 0;
		local index2 = 1;
		local jointIndexStr = '0>2';
		local jointNode = Utils.indexToObject(self.components, jointIndexStr);
		if jointNode ~= nil and jointNode ~= 0 then
			local x, y, z = getWorldTranslation(jointNode)
			setTranslation(self.components[2].node, x, y, z)
			local x, y, z = getWorldRotation(jointNode)
			setRotation(self.components[2].node, x, y, z)

			local constr = JointConstructor:new();
			constr:setActors(self.components[index1+1].node, self.components[index2+1].node);
			constr:setJointTransforms(jointNode, jointNode);

			local x, y, z = Utils.getVectorFromString('0 0 0');
			local rotLimits = {};
			rotLimits[1] = math.rad(Utils.getNoNil(x, 0));
			rotLimits[2] = math.rad(Utils.getNoNil(y, 0));
			rotLimits[3] = math.rad(Utils.getNoNil(z, 0));

			local x, y, z = Utils.getVectorFromString('0 0 0');
			local transLimits = {};
			transLimits[1] = Utils.getNoNil(x, 0);
			transLimits[2] = Utils.getNoNil(y, 0);
			transLimits[3] = Utils.getNoNil(z, 0);

			for i=1, 3 do
				local rotLimit = rotLimits[i];
				if rotLimit >= 0 then
					constr:setRotationLimit(i-1, -rotLimit, rotLimit);
				end;

				local transLimit = transLimits[i];
				if transLimit >= 0 then
					constr:setTranslationLimit(i-1, true, -transLimit, transLimit);
				else
					constr:setTranslationLimit(i-1, false, 0, 0);
				end;
			end;
			local jointDesc = {};
			jointDesc.componentIndices = {index1+1, index2+1};
			jointDesc.jointNode = jointNode;
			jointDesc.jointIndex = constr:finalize();
			table.insert(self.componentJoints, jointDesc);
			self.SupportCompAttach = false;
		end;
	end;
end;
	
function StollF71:onDetach()
    setRigidBodyType(self.supportColli, "Dynamic");
	self.SupportCompAttach = true;
	setCenterOfMass(self.components[1].node, 0, -0.2, 2.45);
    self.Support = true;
end;

function StollF71:onAttach(attacherVehicle)
    setRigidBodyType(self.supportColli, "NoRigidBody");
	self.SupportCompAttach = false;
	setCenterOfMass(self.components[1].node, 0, 0, 0);
    self.Support = false;
end;

function StollF71:delete()
end;

function StollF71:mouseEvent(posX, posY, isDown, isUp, button)
end;

function StollF71:keyEvent(unicode, sym, modifier, isDown)
end;

function StollF71:draw()
end;




