-- RabeToucan3000SL1
-- Specialisation for the Rabe Toucan 3000 SL
--
-- @ Autor  Tobias F. (John Deere 6930)
-- @ Last Edit  11/01/2011

RabeToucan3000SL1 = {};

function RabeToucan3000SL1.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function RabeToucan3000SL1:load(xmlFile)	
	self.updateJoint = false;
	self.aiTerrainDetailChannelBackUp1 = nil;
	self.aiTerrainDetailChannelBackUp2 = nil;	
	self.aiLeftMarkerBackUp = self.aiLeftMarker;
    self.aiRightMarkerBackUp = self.aiRightMarker;
    self.aiBackMarkerBackUp = self.aiBackMarker;	
	self.setTerrainDetailChannels = false;
	self.aiActiveSpeedMultiplicator = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.1MoveTime#aiActiveSpeedMultiplicator"), 1);
	self.aiDeactiveSpeedMultiplicator = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.1MoveTime#aiDeactiveSpeedMultiplicator"), 1);
	self.currentLiftSpeed = self.aiDeactiveSpeedMultiplicator;
end;

function RabeToucan3000SL1:delete()
end;

function RabeToucan3000SL1:readStream(streamId, connection)
end;

function RabeToucan3000SL1:writeStream(streamId, connection)	
end;

function RabeToucan3000SL1:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RabeToucan3000SL1:keyEvent(unicode, sym, modifier, isDown)
end;

function RabeToucan3000SL1:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.LIFT_RABETOUCAN_1) then
			if self:getRealAnimationTime("lift1") > 750 then
				self:playAnimation("lift1", -1, nil);
			elseif self:getRealAnimationTime("lift1") < 750 then
				self:playAnimation("lift1", 1, nil);				
			end;
		end;
	end;
	if self:getIsActive() then
		for _, part in pairs(self.movingParts) do
			Cylindered.setDirty(self, part);
		end;
	end;
end;

function RabeToucan3000SL1:updateTick(dt)
	if self.setTerrainDetailChannels then
		if table.getn(self.attachedImplements) > 0 then
			for k,implement in pairs(self.attachedImplements) do
				if implement.object.aiTerrainDetailChannel1 ~= nil and implement.object.aiTerrainDetailChannel2 ~= nil and implement.object.aiLeftMarker ~= nil and implement.object.aiRightMarker ~= nil and implement.object.aiBackMarker ~= nil then
					self.aiTerrainDetailChannelBackUp1 = self.aiTerrainDetailChannel1;
					self.aiTerrainDetailChannelBackUp2 = self.aiTerrainDetailChannel2;
					self.aiTerrainDetailChannel1 = implement.object.aiTerrainDetailChannel1;
					self.aiTerrainDetailChannel2 = implement.object.aiTerrainDetailChannel2;
					self.aiLeftMarker = implement.object.aiLeftMarker;
					self.aiRightMarker = implement.object.aiRightMarker;
					self.aiBackMarker = implement.object.aiBackMarker;
				end;
			end;
		else
			if self.aiTerrainDetailChannelBackUp1 ~= nil and self.aiTerrainDetailChannelBackUp2 ~= nil and self.aiLeftMarkerBackUp ~= nil and self.aiRightMarkerBackUp ~= nil and self.aiBackMarkerBackUp ~= nil then
				self.aiTerrainDetailChannel1 = self.aiTerrainDetailChannelBackUp1;
				self.aiTerrainDetailChannel2 = self.aiTerrainDetailChannelBackUp2;
				self.aiTerrainDetailChannelBackUp1 = nil;
				self.aiTerrainDetailChannelBackUp2 = nil;
				self.aiLeftMarker = self.aiLeftMarkerBackUp;
				self.aiRightMarker = self.aiRightMarkerBackUp;
				self.aiBackMarker = self.aiBackMarkerBackUp;
			end;
		end;
		self.setTerrainDetailChannels = false;
	end;
	if self:getIsActive() then
		self.currentLiftSpeed = self.aiDeactiveSpeedMultiplicator;
		self.updateJoint = true;
		if self.attacherVehicle ~= nil then
			if self.attacherVehicle.isHired ~= nil then
				self.currentLiftSpeed = self.aiActiveSpeedMultiplicator;
			end;
			if self.attacherVehicle.isHired and table.getn(self.attachedImplements) > 0 then
				for k, implement in pairs(self.attacherVehicle.attachedImplements) do
					if implement.object == self then
						if self.attacherVehicle.attacherJoints[implement.jointDescIndex].moveDown then
							self:playAnimation("lift1", -1*self.currentLiftSpeed, nil);
						else
							self:playAnimation("lift1", 1*self.currentLiftSpeed, nil);
						end;
					end;
				end;
			end;
		end;		
	end;
end;

function RabeToucan3000SL1:draw()
	if self:getRealAnimationTime("lift1") > 0 then
		g_currentMission:addHelpButtonText(g_i18n:getText("RAISE_RABETOUCAN_1"), InputBinding.LIFT_RABETOUCAN_1);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("LIFT_RABETOUCAN_1"), InputBinding.LIFT_RABETOUCAN_1);
	end;
end;

function RabeToucan3000SL1:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
    return BaseMission.VEHICLE_LOAD_OK;
end;

function RabeToucan3000SL1:getSaveAttributesAndNodes(nodeIdent)
end;

function RabeToucan3000SL1:aiTurnOn()
	self.isTurnedOn = true;
end;

function RabeToucan3000SL1:aiTurnOff()
	self.isTurnedOn = false;
end;

function RabeToucan3000SL1:detachImplement(implementIndex)
	self:playAnimation("lift1", -1*self.currentLiftSpeed, nil);
	self.setTerrainDetailChannels = true;
end;

function RabeToucan3000SL1:attachImplement(implement)
	self:playAnimation("lift1", 1*self.currentLiftSpeed, nil);
	self.setTerrainDetailChannels = true;
end;

function RabeToucan3000SL1:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return false;
end;