--
-- Vaederstad Rollex
-- author: Burner
-- date: 08.10.2011
--

Vaederstad_Rollex = {};

function Vaederstad_Rollex.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cultivator, specializations);
end;

function Vaederstad_Rollex:load(xmlFile)
	self.setIsLowered = SpecializationUtil.callSpecializationsFunction("setIsLowered");
	self.lowerAnim = getXMLString(xmlFile, "vehicle.lowerAnim#name");
	self.implementLowered = false;
end;

function Vaederstad_Rollex:readStream(streamId, connection)
    self:setIsLowered(streamReadBool(streamId), true);
end;

function Vaederstad_Rollex:writeStream(streamId, connection)
    streamWriteBool(streamId, self.implementLowered);
end;

function Vaederstad_Rollex:delete()
end;

function Vaederstad_Rollex:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Vaederstad_Rollex:keyEvent(unicode, sym, modifier, isDown)
end;

function Vaederstad_Rollex:update(dt)
	if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
			self:setIsLowered(not self.implementLowered);
		end;
    end;
	if self.attacherVehicle ~= nil then
		for k, implement in pairs(self.attacherVehicle.attachedImplements) do
			local jointDesc = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
			if k == self.attacherVehicle.selectedImplement  then
				setJointFrame(jointDesc.jointIndex, 1, self.attacherJoint.node);
			end;
		end;
	end;
end;

function Vaederstad_Rollex:updateTick(dt)
	self.cultivatorHasGroundContact = self.implementLowered;
	local hasGroundContact = self.implementLowered;
end;

function Vaederstad_Rollex:draw()
	if self.isClient then
		if self.implementLowered then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Vaederstad_Rollex_RAISE"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Vaederstad_Rollex_LOWER"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
		end;
	end;
end;

function Vaederstad_Rollex:onDetach()
end;

function Vaederstad_Rollex:setIsLowered(lowered, noEventSend)
	SetLoweredEvent.sendEvent(self, lowered, noEventSend)
    self.implementLowered = lowered;
	self.onlyActiveWhenLowered = not self.implementLowered;
	if lowered then
		if self.lowerAnim ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.lowerAnim , 1, nil, true);
		end;
	else
		if self.lowerAnim ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.lowerAnim , -1, nil, true);
		end;
	end;
end;

function Vaederstad_Rollex:aiTurnOn()
	self:setIsLowered(true);
end;

function Vaederstad_Rollex:aiTurnOff()
	self:setIsLowered(false);
end;

function Vaederstad_Rollex:aiLower()
	self:setIsLowered(true);
end;

function Vaederstad_Rollex:aiRaise()
	self:setIsLowered(false);
end;