SetLoweredEvent = {};
SetLoweredEvent_mt = Class(SetLoweredEvent, Event);

InitEventClass(SetLoweredEvent, "SetLoweredEvent");

function SetLoweredEvent:emptyNew()
    local self = Event:new(SetLoweredEvent_mt);
    self.className="SetLoweredEvent";
    return self;
end;

function SetLoweredEvent:new(vehicle, isLoweredState)
    local self = SetLoweredEvent:emptyNew()
    self.vehicle = vehicle;
	self.isLoweredState = isLoweredState;
    return self;
end;

function SetLoweredEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isLoweredState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetLoweredEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isLoweredState);
end;

function SetLoweredEvent:run(connection)   
	self.vehicle:setIsLowered(self.isLoweredState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetLoweredEvent:new(self.vehicle, self.isLoweredState), nil, connection, self.vehicle);
    end;
end;

function SetLoweredEvent.sendEvent(vehicle, isLoweredState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetLoweredEvent:new(vehicle, isLoweredState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetLoweredEvent:new(vehicle, isLoweredState));
		end;
	end;
end;