--
-- DynamicHUD [BETA VERSION]
-- Specialization allowing to have dynamic HUD on attachable implement. This script is still a beta version.
-- @uthor : Bayn - www.tsforum3.com
-- D@te : 05.10.2010
--
-- This script has been made under "OpenSource rules". 
-- That means you can use it without asking authorization, but also without forgetting to quote the author's name.

DynamicHUD = {};

function DynamicHUD.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function DynamicHUD:load(xmlFile)
	-- loading clip --
	self.charIdDynHUD = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.DynamicHUD#Node"));
	self.clipIndexDynHUD = getXMLString(xmlFile, "vehicle.DynamicHUD#animationClip");	
	
	-- HUDs --
	self.numHUDs = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.HUDs#count"), 0);	
	if self.numHUDs ~= nil then
		self.HUDs = {};
		for i=1, self.numHUDs do
			local HUDsnamei = string.format("vehicle.HUDs.HUD" .. "%d", i);
			self.HUDs[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, HUDsnamei .. "#index"));
		end;
	end;
	
end;

function DynamicHUD:delete()
end;

function DynamicHUD:mouseEvent(posX, posY, isDown, isUp, button)
end;

function DynamicHUD:keyEvent(unicode, sym, modifier, isDown)
end;

function DynamicHUD:update(dt)
	if self.attacherVehicle then
		-- Play the animation if farmer is in range.
		local charId = getAnimCharacterSet(self.charIdDynHUD);
		local clipIndex = getAnimClipIndex(charId, self.clipIndexDynHUD);
		if self.inrange or self.inrangeAdjusters or self.inRangeStuckObject then
			assignAnimTrackClip(charId , 0, clipIndex);
			setAnimTrackLoopState(charId, 0, false);
			setAnimTrackSpeedScale(charId, 0, 1);
			enableAnimTrack(charId, 0);
			if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) then
				disableAnimTrack(charId, 0);
			end;
		else
			assignAnimTrackClip(charId , 0, clipIndex);
			setAnimTrackLoopState(charId, 0, false);
			setAnimTrackSpeedScale(charId, 0, -1);
			enableAnimTrack(charId, 0);
			if getAnimTrackTime(charId, 0) <= 0 then
				disableAnimTrack(charId, 0);
			end;
		end;
		-- toggle the right HUD according to the object's proximity --
		-- Support --
		if self.inrange then
			setVisibility(self.HUDs[1],true);
		else
			if getAnimTrackTime(charId, 0) <= 0 then
				setVisibility(self.HUDs[1],false);
			end;
		end;
		-- Adjusters --
		if self.inrangeAdjusters and self.MovingPartsMax then
			setVisibility(self.HUDs[2],true);
		else
			if getAnimTrackTime(charId, 0) <= 0 then
				setVisibility(self.HUDs[2],false);
			end;
		end;
		-- Stuck Object --
		if self.inRangeStuckObject and self.hasObjectStuck then
			setVisibility(self.HUDs[3],true);
		else
			if getAnimTrackTime(charId, 0) <= 0 then
				setVisibility(self.HUDs[3],false);
			end;
		end;
		
	end;
end;

function DynamicHUD:draw()
end;




