--
-- AreaSwitcher
-- Specialization for AreaSwitcher
--
-- @author  	(Flagsystems) Manuel Leithner
-- @version 	v1.0
-- @date  		13/05/11
-- @history:	v1.0 - Initial version
--

AreaSwitcher = {};

function AreaSwitcher.prerequisitesPresent(specializations)
    return true;
end;

function AreaSwitcher:load(xmlFile)

	self.areaBackup = self.cuttingAreas;
	self.cultivatorAreas = {};
	self.sowingAreas = {};
	
	self.cultivatorAreaCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#cultivatorAreaCount") ,0);
	
	for k, area in pairs(self.cuttingAreas) do
		if k <= self.cultivatorAreaCount then
			area.cultivator = true;
			table.insert(self.cultivatorAreas, area);
		else
			table.insert(self.sowingAreas, area);
		end;
	end;
	
	self.runOnce = true;
	self.doSwitchToSowing = true;
end;

function AreaSwitcher:delete()
end;

function AreaSwitcher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AreaSwitcher:keyEvent(unicode, sym, modifier, isDown)
end;

function AreaSwitcher:update(dt)
end;

function AreaSwitcher:updateTick(dt)
	if self.runOnce then
		self.cuttingAreas = self.cultivatorAreas;
		self.runOnce = false;
	end;

	if self:getIsActive() then
		if self.doSwitchToSowing then
			self.cuttingAreas = self.sowingAreas;
		else
			self.cuttingAreas = self.cultivatorAreas;
		end;
		self.doSwitchToSowing = not self.doSwitchToSowing;
	end;
end;

function AreaSwitcher:draw()
end;

function AreaSwitcher:aiTurnOn()
	self.isAIActive = true;
end;

function AreaSwitcher:aiTurnOff()
	self.isAIActive = false;
end;



