
---xyzspain for VR1224 2014
---other scripts fron Agromet-Famarol Z211/2
VR1224 = {};

function VR1224.prerequisitesPresent(specializations)
     return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function VR1224:load(xmlFile)
	---libertad bloques
	self.setJointRotLimit = SpecializationUtil.callSpecializationsFunction("setJointRotLimit");
	self.firstDo = {};
	self.arm = {};
	self.freeLeft=false;
	self.freeRight=false;
		-- desplazamiento de conjuntos
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
		self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		self.hydraulics[i].doScale = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName .. "#doScale"), false);
	end;
	-------------	ruedas que copian rotacion de otras en funcion del contacto o no de estas con el suelo
	self.numWheelLeft1 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.wheelLeft1#count"), 0); 
	self.wheelLeft1 = {}; 
	 for i=1, self.numWheelLeft1 do 
		 local partnamei = string.format("vehicle.wheelLeft1.part" .. "%d", i); 
		 self.wheelLeft1[i] = {}; 
		 self.wheelLeft1[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei.."#index")); 
	   
	 end;
	 self.numWheelLeft2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.wheelLeft2#count"), 0); 
	self.wheelLeft2 = {}; 
	 for i=1, self.numWheelLeft2 do 
		 local partnamei = string.format("vehicle.wheelLeft2.part" .. "%d", i); 
		 self.wheelLeft2[i] = {}; 
		 self.wheelLeft2[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei.."#index")); 
	   
	 end;
	 self.numWheelLeft3 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.wheelLeft3#count"), 0); 
	self.wheelLeft3 = {}; 
	 for i=1, self.numWheelLeft3 do 
		 local partnamei = string.format("vehicle.wheelLeft3.part" .. "%d", i); 
		 self.wheelLeft3[i] = {}; 
		 self.wheelLeft3[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei.."#index")); 
	   
	 end;
	 self.numWheelLeft4 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.wheelLeft4#count"), 0); 
	self.wheelLeft4 = {}; 
	 for i=1, self.numWheelLeft4 do 
		 local partnamei = string.format("vehicle.wheelLeft4.part" .. "%d", i); 
		 self.wheelLeft4[i] = {}; 
		 self.wheelLeft4[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei.."#index")); 
	   
	 end;
	 self.numWheelLeft5 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.wheelLeft5#count"), 0); 
	self.wheelLeft5 = {}; 
	 for i=1, self.numWheelLeft5 do 
		 local partnamei = string.format("vehicle.wheelLeft5.part" .. "%d", i); 
		 self.wheelLeft5[i] = {}; 
		 self.wheelLeft5[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei.."#index")); 
	   
	 end;
	 self.numWheelLeft6 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.wheelLeft6#count"), 0); 
	self.wheelLeft6 = {}; 
	 for i=1, self.numWheelLeft6 do 
		 local partnamei = string.format("vehicle.wheelLeft6.part" .. "%d", i); 
		 self.wheelLeft6[i] = {}; 
		 self.wheelLeft6[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei.."#index")); 
	   
	 end;
	self.numWheelRight1 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.wheelRight1#count"), 0); 
	self.wheelRight1 = {}; 
	 for i=1, self.numWheelRight1 do 
		 local partnamei = string.format("vehicle.wheelRight1.part" .. "%d", i); 
		 self.wheelRight1[i] = {}; 
		 self.wheelRight1[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei.."#index")); 
	   
	 end;	
	self.numWheelRight2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.wheelRight2#count"), 0); 
	self.wheelRight2 = {}; 
	 for i=1, self.numWheelRight2 do 
		 local partnamei = string.format("vehicle.wheelRight2.part" .. "%d", i); 
		 self.wheelRight2[i] = {}; 
		 self.wheelRight2[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei.."#index")); 
	   
	 end;	
self.numWheelRight3 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.wheelRight3#count"), 0); 
	self.wheelRight3 = {}; 
	 for i=1, self.numWheelRight3 do 
		 local partnamei = string.format("vehicle.wheelRight3.part" .. "%d", i); 
		 self.wheelRight3[i] = {}; 
		 self.wheelRight3[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei.."#index")); 
	   
	 end;
self.numWheelRight4 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.wheelRight4#count"), 0); 
	self.wheelRight4 = {}; 
	 for i=1, self.numWheelRight4 do 
		 local partnamei = string.format("vehicle.wheelRight4.part" .. "%d", i); 
		 self.wheelRight4[i] = {}; 
		 self.wheelRight4[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei.."#index")); 
	   
	 end;
self.numWheelRight5 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.wheelRight5#count"), 0); 
	self.wheelRight5 = {}; 
	 for i=1, self.numWheelRight5 do 
		 local partnamei = string.format("vehicle.wheelRight5.part" .. "%d", i); 
		 self.wheelRight5[i] = {}; 
		 self.wheelRight5[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei.."#index")); 
	   
	 end;
self.numWheelRight6 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.wheelRight6#count"), 0); 
	self.wheelRight6 = {}; 
	 for i=1, self.numWheelRight6 do 
		 local partnamei = string.format("vehicle.wheelRight6.part" .. "%d", i); 
		 self.wheelRight6[i] = {}; 
		 self.wheelRight6[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei.."#index")); 
	   
	 end;

	self.objectInRange = VR1224.objectInRange;
	self.extendModeLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.extendModeLeft#index"));
	self.extendModeRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.extendModeRight#index"));

	
	  
	  local numwindrowerCuttingLeftAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.windrowerCuttingLeftAreas#count"), 0);
	self.windrowerCuttingLeftAreas = {}
	self.accumulatedwindrowerCuttingLeftAreaValues = {};
	self.accumulatedWindrowerFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
	for i=1, numwindrowerCuttingLeftAreas do
		local areanamei = string.format("vehicle.windrowerCuttingLeftAreas.windrowerCuttingLeftArea%d", i);
		local cuttingArea = {};
		if self:loadAreaFromXML(cuttingArea, xmlFile, areanamei) then
			table.insert(self.windrowerCuttingLeftAreas, cuttingArea);
		end;
		self.accumulatedwindrowerCuttingLeftAreaValues[i] = 0;
	end;
	
	local numwindrowerDropLeftAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.windrowerDropLeftAreas#count"), 0);
	if numwindrowerDropLeftAreas == 0 then
		print("Warning: No drop areas specified in '"..self.configFileName.."'");
	else
		if numwindrowerDropLeftAreas ~= 1 and numwindrowerDropLeftAreas ~= table.getn(self.windrowerCuttingLeftAreas) then
			print("Warning: Number of cutting areas and drop areas should be equal in '"..self.configFileName.."'");
		end;
	end;
	self.windrowerDropLeftAreas = {}
	for i=1, numwindrowerDropLeftAreas do
		self.windrowerDropLeftAreas[i] = {};
		local areanamei = string.format("vehicle.windrowerDropLeftAreas.windrowerDropLeftArea%d", i);
		self.windrowerDropLeftAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
		self.windrowerDropLeftAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
		self.windrowerDropLeftAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
	end;
	
	self.windrowerParticleLeftSystems = {};
	local i=0;
	while true do
		local baseName = string.format("vehicle.windrowerParticleLeftSystems.windrowerParticleLeftSystem(%d)", i);
		local t = getXMLString(xmlFile, baseName .. "#type");
		if t == nil then
			break;
		end;
		local desc = FruitUtil.fruitTypes[t];
		if desc ~= nil then
			if self.windrowerParticleLeftSystems[desc.index] == nil then
				self.windrowerParticleLeftSystems[desc.index] = {}
			end;
			local ps = Utils.loadParticleSystem(xmlFile, self.windrowerParticleLeftSystems[desc.index], baseName, self.components, false, nil, self.baseDirectory)
		end;
		i = i+1;
	end;
	self.windrowerParticleLeftSystemDisableTime = 0;
	self.windrowerParticleLeftSystemEnabled = false;
	
	
	
	  local numwindrowerCuttingRightAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.windrowerCuttingRightAreas#count"), 0);
	self.windrowerCuttingRightAreas = {}
	self.accumulatedwindrowerCuttingRightAreaValues = {};
	self.accumulatedWindrowerFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
	for i=1, numwindrowerCuttingRightAreas do
		local areanamei = string.format("vehicle.windrowerCuttingRightAreas.windrowerCuttingRightArea%d", i);
		local cuttingArea = {};
		if self:loadAreaFromXML(cuttingArea, xmlFile, areanamei) then
			table.insert(self.windrowerCuttingRightAreas, cuttingArea);
		end;
		self.accumulatedwindrowerCuttingRightAreaValues[i] = 0;
	end;
	
	local numwindrowerDropRightAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.windrowerDropRightAreas#count"), 0);
	if numwindrowerDropRightAreas == 0 then
		print("Warning: No drop areas specified in '"..self.configFileName.."'");
	else
		if numwindrowerDropRightAreas ~= 1 and numwindrowerDropRightAreas ~= table.getn(self.windrowerCuttingRightAreas) then
			print("Warning: Number of cutting areas and drop areas should be equal in '"..self.configFileName.."'");
		end;
	end;
	self.windrowerDropRightAreas = {}
	for i=1, numwindrowerDropRightAreas do
		self.windrowerDropRightAreas[i] = {};
		local areanamei = string.format("vehicle.windrowerDropRightAreas.windrowerDropRightArea%d", i);
		self.windrowerDropRightAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
		self.windrowerDropRightAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
		self.windrowerDropRightAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
	end;
	
	self.windrowerParticleRightSystems = {};
	local i=0;
	while true do
		local baseName = string.format("vehicle.windrowerParticleRightSystems.windrowerParticleRightSystem(%d)", i);
		local t = getXMLString(xmlFile, baseName .. "#type");
		if t == nil then
			break;
		end;
		local desc = FruitUtil.fruitTypes[t];
		if desc ~= nil then
			if self.windrowerParticleRightSystems[desc.index] == nil then
				self.windrowerParticleRightSystems[desc.index] = {}
			end;
			local ps = Utils.loadParticleSystem(xmlFile, self.windrowerParticleRightSystems[desc.index], baseName, self.components, false, nil, self.baseDirectory)
		end;
		i = i+1;
	end;
	self.windrowerParticleRightSystemDisableTime = 0;
	self.windrowerParticleRightSystemEnabled = false;
	
	
	
	
	if self.isClient then
		local workSound = getXMLString(xmlFile, "vehicle.workSound#file");
		if workSound ~= nil and workSound ~= "" then
			workSound = Utils.getFilename(workSound, self.baseDirectory);
			self.workSound = createSample("workSound");
			self.workSoundEnabled = false;
			loadSample(self.workSound, workSound, false);
			self.workSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#pitchOffset"), 1);
			self.workSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#volume"), 1.0);
		end;
	end;
	
	self.wasToFast = false;
	self.currentWindrowerFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
	  
	  
	 
end;



function VR1224:readStream(streamId, connection)
	
end;

function VR1224:writeStream(streamId, connection)	
	
end;

function VR1224:delete()
	for k, ps in pairs(self.windrowerParticleLeftSystems) do
		Utils.deleteParticleSystem(self.windrowerParticleLeftSystems[k]);
	end;
	for k, ps in pairs(self.windrowerParticleRightSystems) do
		Utils.deleteParticleSystem(self.windrowerParticleRightSystems[k]);
	end;
	if self.workSound ~= nil then
		delete(self.workSound);
	end;
end;

function VR1224:mouseEvent(posX, posY, isDown, isUp, button)
end;

function VR1224:keyEvent(unicode, sym, modifier, isDown)
end;

function VR1224:update(dt)


	
	if self:getIsActiveForInput() then
		if InputBinding.isPressed(InputBinding.VR1224_1) then
			self:setAnimationTime(1, self.animationParts[1].currentPosition+(self.animationParts[1].offSet*(dt/10)));
		end;
		
		if InputBinding.isPressed(InputBinding.VR1224_2) then
			self:setAnimationTime(1, self.animationParts[1].currentPosition-(self.animationParts[1].offSet*(dt/10)));
		end;
		if self.animationParts[1].clipEndTime then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("VR1224_2")), InputBinding.VR1224_2);
					self.freeLeft=true;
				else
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("VR1224_1")), InputBinding.VR1224_1);
					self.freeLeft=false;
		end;
		
	if InputBinding.isPressed(InputBinding.VR1224_3) then
			self:setAnimationTime(2, self.animationParts[2].currentPosition+(self.animationParts[2].offSet*(dt/10)));
		end;
		
		if InputBinding.isPressed(InputBinding.VR1224_4) then
			self:setAnimationTime(2, self.animationParts[2].currentPosition-(self.animationParts[2].offSet*(dt/10)));
		end;
		if self.animationParts[2].clipEndTime then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("VR1224_4")), InputBinding.VR1224_4);
					self.freeRight=true;
				else
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("VR1224_3")), InputBinding.VR1224_3);
					self.freeRight=false;
		end;
	end;		
	if self:objectInRange(self.extendModeLeft)  then
	
		if self.freeLeft then
			if InputBinding.isPressed(InputBinding.VR1224_5) then
				self:setAnimationTime(3, self.animationParts[3].currentPosition+(self.animationParts[3].offSet*(dt/10)));
			end;
			
			if InputBinding.isPressed(InputBinding.VR1224_6) then
				self:setAnimationTime(3, self.animationParts[3].currentPosition-(self.animationParts[3].offSet*(dt/10)));
			end;
			if self.animationParts[3].clipEndTime then
						g_currentMission:addHelpButtonText(string.format(g_i18n:getText("VR1224_6")), InputBinding.VR1224_6);
				else
						g_currentMission:addHelpButtonText(string.format(g_i18n:getText("VR1224_5")), InputBinding.VR1224_5);
			end;
		end
	end;	
	if self:objectInRange(self.extendModeRight)  then	
		if self.freeRight then
			if InputBinding.isPressed(InputBinding.VR1224_7) then
				self:setAnimationTime(4, self.animationParts[4].currentPosition+(self.animationParts[4].offSet*(dt/10)));
			end;
			if InputBinding.isPressed(InputBinding.VR1224_8) then
				self:setAnimationTime(4, self.animationParts[4].currentPosition-(self.animationParts[4].offSet*(dt/10)));
			end;
			if self.animationParts[4].clipEndTime then
						g_currentMission:addHelpButtonText(string.format(g_i18n:getText("VR1224_8")), InputBinding.VR1224_8);
				else
						g_currentMission:addHelpButtonText(string.format(g_i18n:getText("VR1224_7")), InputBinding.VR1224_7);
			end;
		end;
	end;
	
	
			for i, jointDesc in pairs(self.componentJoints) do
		setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
		end;
		
		--- asignacion de libertad ejes de rotacion segun condiciones de emsamblage  0 x, 2 z ,1 y
		
		
	  self:setJointRotLimit(self.componentJoints[1],15,0, 1000,self.freeLeft == true , 2,dt);	
	   self:setJointRotLimit(self.componentJoints[2],15,0, 1000,self.freeRight == true , 2,dt);	
end;

function VR1224:updateTick(dt)
	self.wasToFast = false;
	if self:getIsActive() then
		if self.isServer then
            local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 30;
              if not toFast then
			   if self.freeLeft   then
                  		local numDropAreas = table.getn(self.windrowerDropLeftAreas);
						local numAreas = table.getn(self.windrowerCuttingLeftAreas);
						if numDropAreas > 0 and numAreas > 0 then
						local cuttingAreasSend = {};
						local dropAreasSend = {};
						for i=1, numAreas do
							local cuttingArea = self.windrowerCuttingLeftAreas[i];
							if self:getIsAreaActive(cuttingArea) then
								local x,_,z = getWorldTranslation(cuttingArea.start);
								local x1,_,z1 = getWorldTranslation(cuttingArea.width);
								local x2,_,z2 = getWorldTranslation(cuttingArea.height);
								table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
							end;
						end;
						for i=1, numDropAreas do
							local dropArea = self.windrowerDropLeftAreas[i];
							local dx,dy,dz = getWorldTranslation(dropArea.start);
							local dx1,dy1,dz1 = getWorldTranslation(dropArea.width);
							local dx2,dy2,dz2 = getWorldTranslation(dropArea.height);
							table.insert(dropAreasSend, {dx, dz, dx1, dz1, dx2, dz2});
						end;
						if table.getn(cuttingAreasSend) > 0 then
							local cuttingAreasSend, dropAreasSend, fruitType, bitType = WindrowAreaEvent.runLocally(cuttingAreasSend, dropAreasSend, self.accumulatedwindrowerCuttingLeftAreaValues, self.accumulatedWindrowerFruitType);
							if (table.getn(cuttingAreasSend) > 0 or table.getn(dropAreasSend) > 0) and self.lastSpeed*3600 > 3 then
								self.accumulatedWindrowerFruitType = fruitType;
								self.currentWindrowerFruitType = fruitType;
								
								-- enable grass particle system for dryGrass if dryGrass particle system not exists
								if self.currentWindrowerFruitType == FruitUtil.FRUITTYPE_DRYGRASS then
									if self.windrowerParticleLeftSystems[FruitUtil.FRUITTYPE_DRYGRASS] == nil then
										self.currentWindrowerFruitType = FruitUtil.FRUITTYPE_GRASS;
									end;
								end;
								
								self.windrowerParticleLeftSystemDisableTime = self.time + 800;
								self.windrowerParticleLeftSystemEnabled = true;
								
								if self.windrowerParticleLeftSystems[self.currentWindrowerFruitType] ~= nil then
									Utils.setEmittingState(self.windrowerParticleLeftSystems[self.currentWindrowerFruitType], true);
								end;
								if self.isServer then
									g_server:broadcastEvent(WindrowAreaEvent:new(cuttingAreasSend, dropAreasSend, fruitType, bitType));
								end;
							end;
						end;
					end;
				end;
				if self.freeRight   then
                  		local numDropAreas = table.getn(self.windrowerDropRightAreas);
						local numAreas = table.getn(self.windrowerCuttingRightAreas);
						if numDropAreas > 0 and numAreas > 0 then
						local cuttingAreasSend = {};
						local dropAreasSend = {};
						for j=1, numAreas do
							local cuttingArea = self.windrowerCuttingRightAreas[j];
							if self:getIsAreaActive(cuttingArea) then
								local x,_,z = getWorldTranslation(cuttingArea.start);
								local x1,_,z1 = getWorldTranslation(cuttingArea.width);
								local x2,_,z2 = getWorldTranslation(cuttingArea.height);
								table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
							end;
						end;
						for j=1, numDropAreas do
							local dropArea = self.windrowerDropRightAreas[j];
							local dx,dy,dz = getWorldTranslation(dropArea.start);
							local dx1,dy1,dz1 = getWorldTranslation(dropArea.width);
							local dx2,dy2,dz2 = getWorldTranslation(dropArea.height);
							table.insert(dropAreasSend, {dx, dz, dx1, dz1, dx2, dz2});
						end;
						if table.getn(cuttingAreasSend) > 0 then
							local cuttingAreasSend, dropAreasSend, fruitType, bitType = WindrowAreaEvent.runLocally(cuttingAreasSend, dropAreasSend, self.accumulatedwindrowerCuttingRightAreaValues, self.accumulatedWindrowerFruitType);
							if (table.getn(cuttingAreasSend) > 0 or table.getn(dropAreasSend) > 0) and self.lastSpeed*3600 > 3 then
								self.accumulatedWindrowerFruitType = fruitType;
								self.currentWindrowerFruitType = fruitType;
								
								-- enable grass particle system for dryGrass if dryGrass particle system not exists
								if self.currentWindrowerFruitType == FruitUtil.FRUITTYPE_DRYGRASS then
									if self.windrowerParticleRightSystems[FruitUtil.FRUITTYPE_DRYGRASS] == nil then
										self.currentWindrowerFruitType = FruitUtil.FRUITTYPE_GRASS;
									end;
								end;
								
								self.windrowerParticleRightSystemDisableTime = self.time + 800;
								self.windrowerParticleRightSystemEnabled = true;
								
								if self.windrowerParticleRightSystems[self.currentWindrowerFruitType] ~= nil then
									Utils.setEmittingState(self.windrowerParticleRightSystems[self.currentWindrowerFruitType], true);
								end;
								if self.isServer then
									g_server:broadcastEvent(WindrowAreaEvent:new(cuttingAreasSend, dropAreasSend, fruitType, bitType));
								end;
							end;
						end;
					end;
				end;
			end;
			self.wasToFast = toFast;
	end
	
	end;
	-- handling work sound
	if self.isClient then
		if self.freeLeft or self.freeRight then
			 if self.lastSpeed*3600 > 3  then
				if not self.workSoundEnabled and self:getIsActiveForSound() then
					playSample(self.workSound, 0, self.workSoundVolume, 0);
					setSamplePitch(self.workSound, self.workSoundPitchOffset);
					self.workSoundEnabled = true;
				end;
			elseif self.workSoundEnabled then
				stopSample(self.workSound);
				self.workSoundEnabled = false;
			end;
		elseif self.workSoundEnabled then
			stopSample(self.workSound);
			self.workSoundEnabled = false;
		end;
	end;
	
	-- handling particle systems
	
	for k, ps in pairs(self.windrowerParticleLeftSystems) do
		if k == self.currentWindrowerFruitType then
			if self.time > self.windrowerParticleLeftSystemDisableTime then
				self.windrowerParticleLeftSystemEnabled = false;
				Utils.setEmittingState(self.windrowerParticleLeftSystems[k], false);
			end;
		else
			Utils.setEmittingState(self.windrowerParticleLeftSystems[k], false);
		end
	end;
	for k, ps in pairs(self.windrowerParticleRightSystems) do
		if k == self.currentWindrowerFruitType then
			if self.time > self.windrowerParticleRightSystemDisableTime then
				self.windrowerParticleRightSystemEnabled = false;
				Utils.setEmittingState(self.windrowerParticleRightSystems[k], false);
			end;
		else
			Utils.setEmittingState(self.windrowerParticleRightSystems[k], false);
		end
	end;
	
	
			local x1,y1,z1 = getRotation(self.wheels[3].repr);
				for i=1, self.numWheelLeft1 do 
				 setRotation(self.wheelLeft1[i].index,x1/4, y1, z1);
				end;  
		local x2,y2,z2 = getRotation(self.wheels[4].repr);
				for i=1, self.numWheelLeft2 do 
				 setRotation(self.wheelLeft2[i].index,x2/4, y2, z2);
				end;  
		local x3,y3,z3 = getRotation(self.wheels[5].repr);
				for i=1, self.numWheelLeft3 do 
				 setRotation(self.wheelLeft3[i].index,x3/4, y3, z3);
				end;  
			local x4,y4,z4 = getRotation(self.wheels[6].repr);
				for i=1, self.numWheelLeft4 do 
				 setRotation(self.wheelLeft4[i].index,x4/4, y4, z4);
				end;  
			local x5,y5,z5 = getRotation(self.wheels[7].repr);
				for i=1, self.numWheelLeft5 do 
				 setRotation(self.wheelLeft5[i].index,x5/4, y5, z5);
				end;  
			local x6,y6,z6 = getRotation(self.wheels[8].repr);
				for i=1, self.numWheelLeft6 do 
				 setRotation(self.wheelLeft6[i].index,x6/4, y6, z6);
				end;  
		
		
			local x7,y7,z7 = getRotation(self.wheels[9].repr);
				for i=1, self.numWheelRight1 do 
				 setRotation(self.wheelRight1[i].index,x7/4, y7, z7);
				end;  
		local x8,y8,z8 = getRotation(self.wheels[10].repr);
				for i=1, self.numWheelRight2 do 
				 setRotation(self.wheelRight2[i].index,x8/4, y8, z8);
				end;  
		local x9,y9,z9 = getRotation(self.wheels[11].repr);
				for i=1, self.numWheelRight3 do 
				 setRotation(self.wheelRight3[i].index,x9/4, y9, z9);
				end;  	
		local x10,y10,z10 = getRotation(self.wheels[12].repr);
				for i=1, self.numWheelRight4 do 
				 setRotation(self.wheelRight4[i].index,x10/4, y10, z10);
				end;  
		local x11,y11,z11 = getRotation(self.wheels[13].repr);
				for i=1, self.numWheelRight5 do 
				 setRotation(self.wheelRight5[i].index,x11/4, y11, z11);
				end;  		
		local x12,y12,z12 = getRotation(self.wheels[14].repr);
				for i=1, self.numWheelRight6 do 
				 setRotation(self.wheelRight6[i].index,x12/4, y12, z12);
				end;  		
				
		
				
	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
		
		setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.hydraulics[i].doScale then
			local xScale, yScale, zScale = getScale(self.hydraulics[i].node);
			local newScale = yScale * (distance / self.hydraulics[i].punchDistance);
			setScale(self.hydraulics[i].node, 1, 1, newScale);
		else
			if self.hydraulics[i].punch ~= nil then
				setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
			end;
		end;
	
	end;
	
end;

function VR1224:draw()
	if self.wasToFast then
		g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "2"), 0.07+0.022, 0.019+0.029);
	end;
	g_currentMission:addExtraPrintText(g_i18n:getText("VR1224_FunctionsInfo"));

end;
function VR1224:objectInRange(object)
	if g_currentMission.player ~= nil and object ~= nil then
		local nearestDistance =1.5;
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local px, py, pz = getWorldTranslation(object); 
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			return true;
		else
			return false;
		end;
	else
		return false;
	end;
end;
function VR1224:onDetach()
	if self.deactivateOnDetach then
		VR1224.onDeactivate(self);
	else
		VR1224.onDeactivateSounds(self)
	end;
end;

function VR1224:onLeave()
	if self.deactivateOnLeave then
		VR1224.onDeactivate(self);
	else
		VR1224.onDeactivateSounds(self)
	end;
end;

function VR1224:onDeactivate()
	VR1224.onDeactivateSounds(self)
end;

function VR1224:onDeactivateSounds()
	if self.workSoundEnabled then
		stopSample(self.workSound);
		self.workSoundEnabled = false;
	end;
end;
function VR1224:setJointRotLimit(nodei, up, down, speed, value, axle, dt)

	if not self.firstDo[nodei] then
		self.firstDo[nodei] = true;
		self.arm[nodei] = {0}; 
	end; 
	x, y, z = getRotation(nodei);
	rot = {x,y,z};	
	newRotLimit = {}; 
	newRotLimit[nodei] = {0,0,0};
	newRotLimit[nodei] = Utils.getMovedLimitedValues(self.arm[nodei], {down}, {up}, 1, speed * 2, dt, value);
	if math.abs(newRotLimit[nodei][1] - self.arm[nodei][1]) > 0.001 then
		local joint = nodei;
		setJointRotationLimit(joint.jointIndex, axle, true, Utils.degToRad(-newRotLimit[nodei][1]), Utils.degToRad(newRotLimit[nodei][1]));
	end;
	self.arm[nodei] = newRotLimit[nodei];			
end;