--
-- Show/Hide Trailer Parts
-- 
--
-- @author SndGrdn
-- @date  08/12/2012
-- 
-- 

TrailerParts = {};

function TrailerParts.prerequisitesPresent(specializations)
	return true;
end;

function TrailerParts:load(xmlFile)
	self.setTPloc = SpecializationUtil.callSpecializationsFunction("setTPloc");
	self.TPloc = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.FrontRail#index"));
	self.TPCloc = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.FrontRailCollision#index"));
	self.TPlocActive = true;
	setVisibility(self.TPloc, true);
end;

function TrailerParts:delete()
end;

function TrailerParts:keyEvent(unicode, sym, modifier, isDown)
end;

function TrailerParts:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TrailerParts:readStream(streamId, connection)
	local state = streamReadBool(streamId);
	self:setTPloc(state,true);
end;
	
function TrailerParts:writeStream(streamId, connection)
	streamWriteBool(streamId, self.TPlocActive);
end;

function TrailerParts:update(dt)
	if self:getIsActive() then
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.TOGGLE_TrailerParts) then
				self:setTPloc(not self.TPlocActive); 
			end;
		end;
	end;	
end;

function TrailerParts:draw()
    -- Draws HUD Text
	--if g_currentMission.showHelpText then
		--g_currentMission:addHelpButtonText(g_i18n:getText("ToggleFrontRail"), InputBinding.TOGGLE_TrailerParts);
	--end;
end;

function TrailerParts:onDetach()
	if self.TPlocActive then
		self:setTPloc(true); 
	end;
end;

function TrailerParts:setTPloc(state,noEventSend)
	self.TPlocActive = state;
	if self.TPlocActive then
		setVisibility(self.TPloc, true);
		setRigidBodyType(self.TPCloc,"Kinematic");
		-- do true stuff here
	else
		setVisibility(self.TPloc, false);
		setRigidBodyType(self.TPCloc,"NoRigidBody");
		-- do false stuff here 
	end;
	setTPlocEvent.sendEvent(self,state,noEventSend);
end;


-- Event --
setTPlocEvent = {};
setTPlocEvent_mt = Class(setTPlocEvent, Event);
InitEventClass(setTPlocEvent, "setTPlocEvent");

function setTPlocEvent:emptyNew()
    local self = Event:new(setTPlocEvent_mt);
    self.className="setTPlocEvent";
    return self;
end;

function setTPlocEvent:new(object, state)
	local self = setTPlocEvent:emptyNew()
	self.object = object;
	self.state = state;
	return self;
end;

function setTPlocEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.state = streamReadBool(streamId);
    self:run(connection);
end;

function setTPlocEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
end;

function setTPlocEvent:run(connection)
	self.object:setTPloc(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(setTPlocEvent:new(self.object, self.state), nil, connection, self.object);
	end;	
end;

function setTPlocEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(setTPlocEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(setTPlocEvent:new(vehicle, state));
		end;
	end;
end;