--
-- Henly20 (Ls_uk Modteam)
-- 23.08.2010
--
-- > www.LS-UK.info

Doors = {};

function Doors.prerequisitesPresent(specializations)

    return true;
end;

function Doors:load(xmlFile)
     self.setRotationMax12 = SpecializationUtil.callSpecializationsFunction("setRotationMax12");
     self.setRotationMax13 = SpecializationUtil.callSpecializationsFunction("setRotationMax13");
	 self.setRotationMax14 = SpecializationUtil.callSpecializationsFunction("setRotationMax14");
     self.setRotationMax15 = SpecializationUtil.callSpecializationsFunction("setRotationMax15");
	
	local rotationPartNode12 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart12#index"));
    if rotationPartNode12 ~= nil then
        self.rotationPart12 = {};
        self.rotationPart12.node = rotationPartNode12;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart12#minRot"));
        self.rotationPart12.minRot = {};
        self.rotationPart12.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart12.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart12.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart12#maxRot"));
        self.rotationPart12.maxRot = {};
        self.rotationPart12.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart12.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart12.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart12.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart12#rotTime"), 2)*1000;
        self.rotationPart12.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart12#touchRotLimit"), 10));
    end;
	local rotationPartNode13 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart13#index"));
    if rotationPartNode13 ~= nil then
        self.rotationPart13 = {};
        self.rotationPart13.node = rotationPartNode13;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart13#minRot"));
        self.rotationPart13.minRot = {};
        self.rotationPart13.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart13.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart13.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart13#maxRot"));
        self.rotationPart13.maxRot = {};
        self.rotationPart13.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart13.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart13.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart13.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart13#rotTime"), 2)*1000;
        self.rotationPart13.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart13#touchRotLimit"), 10));
    end;
    local rotationPartNode14 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart14#index"));
    if rotationPartNode14 ~= nil then
        self.rotationPart14 = {};
        self.rotationPart14.node = rotationPartNode14;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart14#minRot"));
        self.rotationPart14.minRot = {};
        self.rotationPart14.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart14.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart14.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart14#maxRot"));
        self.rotationPart14.maxRot = {};
        self.rotationPart14.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart14.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart14.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart14.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart14#rotTime"), 2)*1000;
        self.rotationPart14.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart14#touchRotLimit"), 10));
    end;
	local rotationPartNode15 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart15#index"));
    if rotationPartNode15 ~= nil then
        self.rotationPart15 = {};
        self.rotationPart15.node = rotationPartNode15;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart15#minRot"));
        self.rotationPart15.minRot = {};
        self.rotationPart15.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart15.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart15.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart15#maxRot"));
        self.rotationPart15.maxRot = {};
        self.rotationPart15.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart15.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart15.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart15.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart15#rotTime"), 2)*1000;
        self.rotationPart15.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart15#touchRotLimit"), 10));
    end;
	
		self.rotationMax12 = false;
		self.rotationMax13 = false;
        self.rotationMax14 = false;
		self.rotationMax15 = false;
end;

function Doors:readStream(streamId, connection)
     self.rotateMax = streamReadBool(streamId);
     if self.rotationPart12 ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
         setRotation(self.rotationPart12.node, x, y, z);
      end;
     if self.rotationPart13 ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
         setRotation(self.rotationPart13.node, x, y, z);
      end;
     if self.rotationPart14 ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
         setRotation(self.rotationPart14.node, x, y, z);
      end;
     if self.rotationPart15 ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
         setRotation(self.rotationPart15.node, x, y, z);
      end;
end;
  
function Doors:writeStream(streamId, connection)
      streamWriteBool(streamId, self.rotateMax);
		if self.rotationPart12 ~= nil then
          local x, y, z = getRotation(self.rotationPart12.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
		if self.rotationPart13 ~= nil then
          local x, y, z = getRotation(self.rotationPart13.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
        if self.rotationPart14 ~= nil then
          local x, y, z = getRotation(self.rotationPart14.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
		if self.rotationPart15 ~= nil then
          local x, y, z = getRotation(self.rotationPart15.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
end;

function Doors:delete()

end;

function Doors:keyEvent(unicode, sym, modifier, isDown)


end;

function Doors:update(dt)
      if self:getIsActiveForInput() then
          if InputBinding.hasEvent(InputBinding.DOORLEFT) then
				self:setRotationMax12(not self.rotationMax12);
          end;
          if InputBinding.hasEvent(InputBinding.DOORRIGHT) then
				self:setRotationMax13(not self.rotationMax13);
          end;
		  if InputBinding.hasEvent(InputBinding.WINDOW) then
				self:setRotationMax14(not self.rotationMax14);
          end;
          if InputBinding.hasEvent(InputBinding.ROOF) then
				self:setRotationMax15(not self.rotationMax15);
          end;
     end;
end;

function Doors:updateTick(dt)
	if self:getIsActive() and self.isClient then
			if self.rotationPart12 ~= nil then
				local x, y, z = getRotation(self.rotationPart12.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart12.maxRot, self.rotationPart12.minRot, 3, self.rotationPart12.rotTime, dt, not self.rotationMax12);
				setRotation(self.rotationPart12.node, unpack(newRot));
			end;
			if self.rotationPart13 ~= nil then
				local x, y, z = getRotation(self.rotationPart13.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart13.maxRot, self.rotationPart13.minRot, 3, self.rotationPart13.rotTime, dt, not self.rotationMax13);
				setRotation(self.rotationPart13.node, unpack(newRot));
			end;
		    if self.rotationPart14 ~= nil then
				local x, y, z = getRotation(self.rotationPart14.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart14.maxRot, self.rotationPart14.minRot, 3, self.rotationPart14.rotTime, dt, not self.rotationMax14);
				setRotation(self.rotationPart14.node, unpack(newRot));
			end;
			if self.rotationPart15 ~= nil then
				local x, y, z = getRotation(self.rotationPart15.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart15.maxRot, self.rotationPart15.minRot, 3, self.rotationPart15.rotTime, dt, not self.rotationMax15);
				setRotation(self.rotationPart15.node, unpack(newRot));
			end;
	end;		
end;

function Doors:draw()

  
end;


function Doors:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Doors:setRotationMax12(rotationMax12, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
              g_server:broadcastEvent(SetDoorLeftRotationEvent:new(self, rotationMax12), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetDoorLeftRotationEvent:new(self, rotationMax12));
          end;
      end;
      self.rotationMax12 = rotationMax12;
end;

function Doors:setRotationMax13(rotationMax13, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
			  g_server:broadcastEvent(SetDoorRightRotationEvent:new(self, rotationMax13), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetDoorRightRotationEvent:new(self, rotationMax13));
          end;
      end;
      self.rotationMax13 = rotationMax13;
end;

function Doors:setRotationMax14(rotationMax14, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
			  g_server:broadcastEvent(SetDoorRightRotationEvent:new(self, rotationMax14), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetDoorRightRotationEvent:new(self, rotationMax14));
          end;
      end;
      self.rotationMax14 = rotationMax14;
end;

function Doors:setRotationMax15(rotationMax15, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
			  g_server:broadcastEvent(SetDoorRightRotationEvent:new(self, rotationMax15), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetDoorRightRotationEvent:new(self, rotationMax15));
          end;
      end;
      self.rotationMax15 = rotationMax15;
end;