 
-- Copyright by Ufolec & Lechu

Vehicle.registerJointType("attachableFrontloader");

Z8602 = {};

function Z8602.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Z8602:load(xmlFile)
    local zaczep = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.zaczep#index"));
	if zaczep ~= nil then
	    self.zaczep = zaczep;
	end;
	
	local obrotomierzNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.obrotomierz#index"));
		if obrotomierzNode ~= nil then
        self.obrotomierz = {};
        self.obrotomierz.node = obrotomierzNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.obrotomierz#minRot"));
        self.obrotomierz.minRot = {};
        self.obrotomierz.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.obrotomierz.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.obrotomierz.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.obrotomierz#maxRot"));
        self.obrotomierz.maxRot = {};
        self.obrotomierz.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.obrotomierz.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.obrotomierz.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.obrotomierz.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.obrotomierz#rotTime"), 2)*1000;
        self.obrotomierz.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.obrotomierz#touchRotLimit"), 10));
    end;
	local rotationPartNodeDrehzahl1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tahometr#index"));
    if rotationPartNodeDrehzahl1 ~= nil then
        self.tahometr = {};
        self.tahometr.node = rotationPartNodeDrehzahl1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tahometr#minRot"));
        self.tahometr.minRot = {};
        self.tahometr.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tahometr.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tahometr.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tahometr#maxRot"));
        self.tahometr.maxRot = {};
        self.tahometr.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tahometr.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tahometr.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
    end;
	local rotationPartNodepedalgazu = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.pedal_gazu#index"));
    if rotationPartNodepedalgazu ~= nil then
        self.rotationPartpedalgazu = {};
        self.rotationPartpedalgazu.node = rotationPartNodepedalgazu;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.pedal_gazu#minRot"));
        self.rotationPartpedalgazu.minRot = {};
        self.rotationPartpedalgazu.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartpedalgazu.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartpedalgazu.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.pedal_gazu#maxRot"));
        self.rotationPartpedalgazu.maxRot = {};
        self.rotationPartpedalgazu.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartpedalgazu.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartpedalgazu.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartpedalgazu.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.pedal_gazu#rotTime"), 2)*1000;
        self.rotationPartpedalgazu.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.pedal_gazu#touchRotLimit"), 10));
    end;

    self.serwo1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.serwo1#index"));
	self.serwo2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.serwo2#index"));
    if self.serwo1 ~= nil then
        self.steeringSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.serwo1#rotationSpeed"), 0);
    end;
	if self.serwo2 ~= nil then
        self.steeringSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.serwo2#rotationSpeed"), 0);
    end;
	
	local rotationPartNode3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart3#index"));
		if rotationPartNode3 ~= nil then
        self.rotationPart3 = {};
        self.rotationPart3.node = rotationPartNode3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#minRot"));
        self.rotationPart3.minRot = {};
        self.rotationPart3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#maxRot"));
        self.rotationPart3.maxRot = {};
        self.rotationPart3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#rotTime"), 2)*1000;
        self.rotationPart3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#touchRotLimit"), 10));
    end;

	local rotationPartNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart2#index"));
    if rotationPartNode2 ~= nil then
        self.rotationPart2 = {};
        self.rotationPart2.node = rotationPartNode2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#minRot"));
        self.rotationPart2.minRot = {};
        self.rotationPart2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#maxRot"));
        self.rotationPart2.maxRot = {};
        self.rotationPart2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#rotTime"), 2)*1000;
        self.rotationPart2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#touchRotLimit"), 10));
    end;
	local rotationPartNode5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart5#index"));
    if rotationPartNode5 ~= nil then
        self.rotationPart5 = {};
        self.rotationPart5.node = rotationPartNode5;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart5#minRot"));
        self.rotationPart5.minRot = {};
        self.rotationPart5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart5#maxRot"));
        self.rotationPart5.maxRot = {};
        self.rotationPart5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart5#rotTime"), 2)*1000;
        self.rotationPart5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart5#touchRotLimit"), 10));
    end;

	local rotationPartNode4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart4#index"));
    if rotationPartNode4 ~= nil then
        self.rotationPart4 = {};
        self.rotationPart4.node = rotationPartNode4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#minRot"));
        self.rotationPart4.minRot = {};
        self.rotationPart4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#maxRot"));
        self.rotationPart4.maxRot = {};
        self.rotationPart4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#rotTime"), 2)*1000;
        self.rotationPart4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#touchRotLimit"), 10));
    end;
	local rotationNodeEchellePanel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationEchellePanel#index"));
    if rotationNodeEchellePanel ~= nil then
        self.rotationEchellePanel = {};
        self.rotationEchellePanel.node = rotationNodeEchellePanel;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationEchellePanel#minRot"));
        self.rotationEchellePanel.minRot = {};
        self.rotationEchellePanel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationEchellePanel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationEchellePanel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationEchellePanel#maxRot"));
        self.rotationEchellePanel.maxRot = {};
        self.rotationEchellePanel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationEchellePanel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationEchellePanel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationEchellePanel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationEchellePanel#rotTime"), 2)*1000;
        self.rotationEchellePanel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationEchellePanel#touchRotLimit"), 10));
    end;


	local rotationPartNodeprzelacznikprawo = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.przelacznikprawo#index"));
    if rotationPartNodeprzelacznikprawo ~= nil then
        self.rotationPartprzelacznikprawo = {};
        self.rotationPartprzelacznikprawo.node = rotationPartNodeprzelacznikprawo;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartprzelacznikprawo#minRot"));
        self.rotationPartprzelacznikprawo.minRot = {};
        self.rotationPartprzelacznikprawo.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartprzelacznikprawo.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartprzelacznikprawo.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.przelacznikprawo#maxRot"));
        self.rotationPartprzelacznikprawo.maxRot = {};
        self.rotationPartprzelacznikprawo.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartprzelacznikprawo.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartprzelacznikprawo.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartprzelacznikprawo.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.przelacznikprawo#rotTime"), 2)*1000;
        self.rotationPartprzelacznikprawo.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.przelacznikprawo#touchRotLimit"), 10));
    end;
	local rotationPartNodeprzelaczniklewo = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.przelaczniklewo#index"));
    if rotationPartNodeprzelaczniklewo ~= nil then
        self.rotationPartprzelaczniklewo = {};
        self.rotationPartprzelaczniklewo.node = rotationPartNodeprzelaczniklewo;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartprzelaczniklewo#minRot"));
        self.rotationPartprzelaczniklewo.minRot = {};
        self.rotationPartprzelaczniklewo.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartprzelaczniklewo.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartprzelaczniklewo.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.przelaczniklewo#maxRot"));
        self.rotationPartprzelaczniklewo.maxRot = {};
        self.rotationPartprzelaczniklewo.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartprzelaczniklewo.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartprzelaczniklewo.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartprzelaczniklewo.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.przelaczniklewo#rotTime"), 2)*1000;
        self.rotationPartprzelaczniklewo.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.przelaczniklewo#touchRotLimit"), 10));
    end;
	self.zaczep = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zaczep#index"));
	self.key = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.key#index"));

	self.minAutoRotateSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wheels#minAutoRotateBackSpeed"), self.autoRotateBackSpeed);
	self.maxAutoRotateSpeed = self.autoRotateBackSpeed;
	self.maxSpeed = getXMLFloat(xmlFile, "vehicle.wheels#maxSpeed");
	self.rotationMax3Active = false;
	self.rotationMax2Active = false;
	self.rotationMax4Active = false;
	self.rotationMax5Active = false;
	setVisibility(self.tur1, true);
	setVisibility(self.tur2, true);
	setVisibility(self.tur3, true);
	setVisibility(self.tur4, false);
end;

function Z8602:delete()
end;

function Z8602:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Z8602:keyEvent(unicode, sym, modifier, isDown)
end;

function Z8602:update(dt)	
	local doRotate = self.rotationEchellePanelMax or self.rotationEchellePanelMin 
	if self.rotationEchellePanel ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationEchellePanel.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationEchellePanel.maxRot, self.rotationEchellePanel.minRot, 3, self.rotationEchellePanel.rotTime, dt, not self.rotationEchellePanelMax);
        setRotation(self.rotationEchellePanel.node, unpack(newRot));
    end;

	--local doRotate = self.rotationSafetyBoomMax or self.rotationSafetyBoomMin
	if self.rotationSafetyBoomHolder ~= nil then
		local ax, ay, az = getWorldTranslation(self.safetyBoomHolderIndicator.node);
		local bx, by, bz = getWorldTranslation(self.rotationSafetyBoomHolder.node);

		local x, y, z = worldDirectionToLocal(getParent(self.rotationSafetyBoomHolder.node), bx-ax, by-ay, bz-az);
		setDirection(self.rotationSafetyBoomHolder.node, x, y, z, 0, 1, 0);
		
		--local x2,y2,z2 = getRotation(self.rotationSafetyBoomHolder.node);
		--setRotation(self.rotationSafetyBoomHolder.node,Utils.degToRad(22.5)+x2,0,0);
    end;

	local doRotate = self.rotationSafetyBoomMax or self.rotationSafetyBoomMin
	if self.rotationSafetyBoom ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationSafetyBoom.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationSafetyBoom.maxRot, self.rotationSafetyBoom.minRot, 3, self.rotationSafetyBoom.rotTime, dt, not self.rotationSafetyBoomMax);
        setRotation(self.rotationSafetyBoom.node, unpack(newRot));
    end;
	
	-- Panels Movements --
	
	if self.Panels then

		self.rotationEchellePanelMax = true;
		self.rotationEchellePanelMin = false;
		--self.AuthorizeBreakdown = false;
	else
		self.rotationEchellePanelMax = false;
		self.rotationEchellePanelMin = true;
	end;
	if self.zaczepMode == 0  then
		if self.zaczep ~= nil then
			setTranslation(self.zaczep, 0, Utils.degToRad(0), 0);
		end;
	elseif self.zaczepMode == 1 then
		if self.zaczep ~= nil then
			setTranslation(self.zaczep, 0, Utils.degToRad(3.6), 0);
		end;
	elseif self.zaczepMode == 2 then
		if self.zaczep ~= nil then
			setTranslation(self.zaczep, 0, Utils.degToRad(7.2), 0);
		end;
	elseif self.zaczepMode == 3 then
		if self.zaczep ~= nil then
			setTranslation(self.zaczep, 0, Utils.degToRad(10.8), 0);
		end;
	end;

	if self.isMotorStarted then
		if Input.isKeyPressed(Input.KEY_w) or Input.isKeyPressed(Input.KEY_s) then
			self.rotationMaxpedalgazu = true;
		else
			self.rotationMaxpedalgazu = false;
	    end;
	end;	
if self.rotationPartprzelaczniklewo ~= nil then
		local x, y, z = getRotation(self.rotationPartprzelaczniklewo.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartprzelaczniklewo.maxRot, self.rotationPartprzelaczniklewo.minRot, 3, self.rotationPartprzelaczniklewo.rotTime, dt, not self.rotationMaxprzelaczniklewo);
		setRotation(self.rotationPartprzelaczniklewo.node, unpack(newRot));
   end;
if self.rotationPartprzelacznikprawo ~= nil then
		local x, y, z = getRotation(self.rotationPartprzelacznikprawo.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartprzelacznikprawo.maxRot, self.rotationPartprzelacznikprawo.minRot, 3, self.rotationPartprzelacznikprawo.rotTime, dt, not self.rotationMaxprzelacznikprawo);
		setRotation(self.rotationPartprzelacznikprawo.node, unpack(newRot));
   end;
    if self:getIsActive() then
        if self.serwo1 ~= nil then
            setRotation(self.serwo1, 0, 0, -self.rotatedTime*self.steeringSpeed);
        end;
		if self.serwo2 ~= nil then
            setRotation(self.serwo2, 0, 0, -self.rotatedTime*self.steeringSpeed);
        end;
    end;	
	if self:getIsActive() then
	inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

	if InputBinding.isAxisZero(inputAxisY) then
        inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
    end;
		if self.isEntered ~= nil then
			if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then		
				self.rotationMax3Active = true;
				self.rotationMax2Active = true;
			else
				self.rotationMax3Active = false;
				self.rotationMax2Active = false;
			end;
		end;
		if self.rotationPart5 ~= nil then
			local x, y, z = getRotation(self.rotationPart5.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart5.maxRot, self.rotationPart5.minRot, 3, self.rotationPart5.rotTime, dt, not self.rotationMax5Active);
			setRotation(self.rotationPart5.node, unpack(newRot));
		end;
		if self.rotationPart4 ~= nil then
			local x, y, z = getRotation(self.rotationPart4.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart4.maxRot, self.rotationPart4.minRot, 3, self.rotationPart4.rotTime, dt, not self.rotationMax4Active);
			setRotation(self.rotationPart4.node, unpack(newRot));
		end;
		if self.rotationPart3 ~= nil then
			local x, y, z = getRotation(self.rotationPart3.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart3.maxRot, self.rotationPart3.minRot, 3, self.rotationPart3.rotTime, dt, not self.rotationMax3Active);
			setRotation(self.rotationPart3.node, unpack(newRot));
		end;
		if self.rotationPart2 ~= nil then
			local x, y, z = getRotation(self.rotationPart2.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart2.maxRot, self.rotationPart2.minRot, 3, self.rotationPart2.rotTime, dt, not self.rotationMax2Active);
			setRotation(self.rotationPart2.node, unpack(newRot));
		end;
	if self.rotationPartpedalgazu ~= nil then
		local x, y, z = getRotation(self.rotationPartpedalgazu.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartpedalgazu.maxRot, self.rotationPartpedalgazu.minRot, 3, self.rotationPartpedalgazu.rotTime, dt, not self.rotationMaxpedalgazu);
		setRotation(self.rotationPartpedalgazu.node, unpack(newRot));
	end;		
	end;
function Z8602:updateTick(dt)
end;

function Z8602:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

function Z8602:rotateNeedle(object, percent, min, max) 
    angle = min + (max - min) * percent;
    setRotation(object, self.PI, angle, self.PI_2);
end;

function Z8602:onEnter()
end;

function Z8602:draw()

function Z8602:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;
	
	if jointType == Vehicle.JOINTTYPE_ATTACHABLEFRONTLOADER then
		if jointIndex == 2 then
			setVisibility(self.tur1, false);
			setVisibility(self.tur2, false);
			setVisibility(self.tur3, false);
			setVisibility(self.tur4, true);
		end;
	end;
	self.updateJoint = true;
end;

function Z8602:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;

	if jointIndex == 2 then
			setVisibility(self.tur1, true);
			setVisibility(self.tur2, true);
			setVisibility(self.tur3, true);
			setVisibility(self.tur4, false);
	end;
end;

function Z8602:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return false;
end;
end;
end;	