
gasLimiter = {};

function gasLimiter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function gasLimiter:load(xmlFile)

end;

function gasLimiter:delete()
end;

function gasLimiter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function gasLimiter:keyEvent(unicode, sym, modifier, isDown)
end;

function gasLimiter:update(dt)
    if self:getIsActiveForInput() then
        if InputBinding.isPressed(InputBinding.MORERPM) then
		    self.motor.minRpm = self.motor.minRpm - 100;
		elseif InputBinding.isPressed(InputBinding.LESSRPM) then
		    self.motor.minRpm = self.motor.minRpm + 100;
	    end;
    end;

    if self.isEntered then
		if self.motor.minRpm < -1600 then
			self.motor.minRpm = -1600;
		elseif self.motor.minRpm > 200 then
			self.motor.minRpm = 200;
		end;
	end;
end;

function gasLimiter:stopMotor()
    self.motor.minRpm = 200;
end;
	
function gasLimiter:onLeave()
    self.motor.minRpm = 200;
end;

function gasLimiter:draw()
	if self.isMotorStarted then
        g_currentMission:addExtraPrintText(string.format("Taste %s/%s: %s", InputBinding.getButtonKeyName(InputBinding.MORERPM), InputBinding.getButtonKeyName(InputBinding.LESSRPM), g_i18n:getText("Gas")));
	end;
end;

